/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.report.constants.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.report.convert.entity.DgPerformOrderItemConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.report.dto.settlement.BookAccountsReqDto;
import com.yunxi.dg.base.center.report.dto.settlement.SaleOrderItemVo;
import com.yunxi.dg.base.center.report.dto.trade.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgPerformOrderItemDetailRespDto;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.report.service.entity.IDgPerformOrderItemService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderItemServiceImpl
extends BaseServiceImpl<DgPerformOrderItemDto, DgPerformOrderItemEo, IDgPerformOrderItemDomain>
implements IDgPerformOrderItemService {
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;

    public DgPerformOrderItemServiceImpl(IDgPerformOrderItemDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPerformOrderItemDto, DgPerformOrderItemEo> converter() {
        return DgPerformOrderItemConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<Long>> querySaleOrderDeliveryIds(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).querySaleOrderDeliveryIds(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<SaleOrderItemVo>> queryDeliveryItemsByOrderIds(List<Long> orderIds) {
        if (CollectionUtils.isEmpty(orderIds) || orderIds.size() > 2000) {
            return new RestResponse();
        }
        List saleOrderItemVos = ((IDgPerformOrderItemDomain)this.domain).queryDeliveryItemsByOrderIds(orderIds);
        return new RestResponse((Object)saleOrderItemVos);
    }

    @Override
    public RestResponse<List<SaleOrderItemVo>> queryInvoiceItemsByOrderIds(List<Long> orderIds) {
        if (CollectionUtils.isEmpty(orderIds) || orderIds.size() > 2000) {
            return new RestResponse();
        }
        List saleOrderItemVos = ((IDgPerformOrderItemDomain)this.domain).queryInvoiceItemsByOrderIds(orderIds);
        return new RestResponse((Object)saleOrderItemVos);
    }

    @Override
    public RestResponse<PageInfo<Long>> queryAfterSaleDeliveryIds(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).queryAfterSaleDeliveryIds(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<SaleOrderItemVo>> queryDeliveryItemsByAfterSaleIds(List<Long> orderIds) {
        if (CollectionUtils.isEmpty(orderIds) || orderIds.size() > 2000) {
            return new RestResponse();
        }
        List saleOrderItemVos = ((IDgPerformOrderItemDomain)this.domain).queryDeliveryItemsByAfterSaleIds(orderIds);
        return new RestResponse((Object)saleOrderItemVos);
    }

    @Override
    public RestResponse<PageInfo<Long>> queryFreightDeliveryIds(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).queryFreightDeliveryIds(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<SaleOrderItemVo>> queryFreightDeliveryItemsByOrderIds(List<Long> orderIds) {
        if (CollectionUtils.isEmpty(orderIds) || orderIds.size() > 2000) {
            return new RestResponse();
        }
        List saleOrderItemVos = ((IDgPerformOrderItemDomain)this.domain).queryFreightDeliveryItemsByOrderIds(orderIds);
        return new RestResponse((Object)saleOrderItemVos);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> saleOrderDeliveryItemDetails(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).saleOrderDeliveryItemDetails(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> afterSaleDeliveryItemDetails(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).afterSaleDeliveryItemDetails(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> freightDeliveryItemDetails(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).freightDeliveryItemDetails(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> saleOrderInvoiceItemDetails(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IDgPerformOrderItemDomain)this.domain).saleOrderInvoiceItemDetails(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgPerformOrderItemDetailRespDto>> queryPerformItemDetailByOrderId(List<Long> orderIdList) {
        List detailRespDtos = ((IDgPerformOrderItemDomain)this.domain).queryPerformItemDetailByOrderId(orderIdList);
        if (CollectionUtils.isNotEmpty((Collection)detailRespDtos)) {
            List orderLineIds = detailRespDtos.stream().map(DgPerformOrderItemDetailRespDto::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryOrderAmountWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryOrderAmountWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineAmountEo::getOrderLineId, orderLineIds);
            List amountEos = this.dgPerformOrderLineAmountDomain.getMapper().selectList((Wrapper)queryOrderAmountWrapper);
            Map<Long, List<DgPerformOrderLineAmountEo>> orderLineAmountMap = amountEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
            detailRespDtos.forEach(line -> {
                List amountList = (List)orderLineAmountMap.get(line.getId());
                if (CollectionUtils.isNotEmpty((Collection)amountList)) {
                    List payAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
                    BigDecimal payAmount = CollectionUtil.isNotEmpty(payAmountList) ? payAmountList.stream().map(DgPerformOrderLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                    List realPayAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).collect(Collectors.toList());
                    BigDecimal realPayAmount = CollectionUtil.isNotEmpty(realPayAmountList) ? realPayAmountList.stream().map(DgPerformOrderLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                    List costAmountList = amountList.stream().filter(a -> a.getAccountCategory().equals(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode()) && a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toList());
                    BigDecimal costAmount = CollectionUtil.isNotEmpty(costAmountList) ? costAmountList.stream().map(DgPerformOrderLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                    List discountAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).collect(Collectors.toList());
                    BigDecimal discountAmount = CollectionUtil.isNotEmpty(discountAmountList) ? discountAmountList.stream().map(DgPerformOrderLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                    line.setPayAmount(realPayAmount);
                    line.setDiscountAmount(discountAmount);
                    line.setOrderTotalAmount(payAmount);
                    line.setRebateAmount(costAmount);
                    line.setMarketPrice(line.getSalePrice());
                    line.setPrice(BigDecimalUtils.divide((BigDecimal)realPayAmount, (BigDecimal)line.getItemNum(), (int)2, (RoundingMode)RoundingMode.HALF_UP));
                }
            });
        }
        return new RestResponse((Object)detailRespDtos);
    }
}

