/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DgPushKeepAccountsConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgPushKeepAccountsDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgPushKeepAccountsDto;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountEnRouteInventoryDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountEnRouteInventoryReqDto;
import com.yunxi.dg.base.center.report.eo.DgPushKeepAccountsEo;
import com.yunxi.dg.base.center.report.service.entity.IDgPushKeepAccountsService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPushKeepAccountsServiceImpl
extends BaseServiceImpl<DgPushKeepAccountsDto, DgPushKeepAccountsEo, IDgPushKeepAccountsDomain>
implements IDgPushKeepAccountsService {
    private static final Logger logger = LoggerFactory.getLogger(DgPushKeepAccountsServiceImpl.class);

    public DgPushKeepAccountsServiceImpl(IDgPushKeepAccountsDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPushKeepAccountsDto, DgPushKeepAccountsEo> converter() {
        return DgPushKeepAccountsConverter.INSTANCE;
    }

    @Override
    public PageInfo<KeepAccountEnRouteInventoryDetailDto> queryKeepAccountEnRouteInventoryDetail(KeepAccountEnRouteInventoryReqDto reqDto) {
        logger.info("\u67e5\u8be2\u8bb0\u8d26\u5728\u9014\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.requestDataBuild(reqDto);
        PageInfo pageInfo = ((IDgPushKeepAccountsDomain)this.domain).queryKeepAccountEnRouteInventoryDetail(reqDto);
        return pageInfo;
    }

    @Override
    public List<KeepAccountEnRouteInventoryDetailDto> queryKeepAccountEnRouteInventoryDetailList(KeepAccountEnRouteInventoryReqDto reqDto) {
        logger.info("\u67e5\u8be2\u8bb0\u8d26\u5728\u9014\u660e\u7ec6\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.requestDataBuild(reqDto);
        return ((IDgPushKeepAccountsDomain)this.domain).queryKeepAccountEnRouteInventoryDetailList(reqDto);
    }

    private void requestDataBuild(KeepAccountEnRouteInventoryReqDto reqDto) {
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            if (reqDto.getOrderStatusList().contains("COMPLETE")) {
                reqDto.getOrderStatusList().add("FINISH");
            }
            if (reqDto.getOrderStatusList().contains("DELIVERED")) {
                reqDto.getOrderStatusList().add("dro_delivered");
            }
            if (reqDto.getOrderStatusList().contains("IN_WAREHOUSE")) {
                reqDto.getOrderStatusList().add("rro_received");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getAccountingResultList()) && reqDto.getAccountingResultList().contains("Not")) {
            reqDto.setNotAccount("Not");
        }
    }
}

