/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.FinishProductInStorageReportConverter;
import com.yunxi.dg.base.center.report.domain.entity.IFinishProductInStorageReportDomain;
import com.yunxi.dg.base.center.report.dto.entity.FinishProductInStorageReportDto;
import com.yunxi.dg.base.center.report.dto.entity.FinishProductInStorageReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.eo.FinishProductInStorageReportEo;
import com.yunxi.dg.base.center.report.service.entity.IFinishProductInStorageReportService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinishProductInStorageReportServiceImpl
extends BaseServiceImpl<FinishProductInStorageReportDto, FinishProductInStorageReportEo, IFinishProductInStorageReportDomain>
implements IFinishProductInStorageReportService {
    private static final Logger log = LoggerFactory.getLogger(FinishProductInStorageReportServiceImpl.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public FinishProductInStorageReportServiceImpl(IFinishProductInStorageReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<FinishProductInStorageReportDto, FinishProductInStorageReportEo> converter() {
        return FinishProductInStorageReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> ((IFinishProductInStorageReportDomain)this.domain).getSourceMinUpdateTime());
        dto.syncByStep("\u4ea7\u6210\u54c1\u56de\u4ed3\u660e\u7ec6\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = ((IFinishProductInStorageReportDomain)this.domain).pageSourceByUpdateTime(startTime, endTime, pageNum, pageSize);
            log.info("\u4ea7\u6210\u54c1\u56de\u4ed3\u660e\u7ec6\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            this.doSyncInternal(list);
        } while (hasNextPage);
    }

    private void doSyncInternal(List<FinishProductInStorageReportEo> list) {
        List orderNoList = list.stream().map(FinishProductInStorageReportEo::getOrderNo).distinct().collect(Collectors.toList());
        log.info("\u4ea7\u6210\u54c1\u56de\u4ed3\u660e\u7ec6\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u8ba2\u5355\u7684\u65e7\u6570\u636e {}", orderNoList);
        ((IFinishProductInStorageReportDomain)this.domain).logicDeleteByOrderNoList(orderNoList);
        log.info("\u4ea7\u6210\u54c1\u56de\u4ed3\u660e\u7ec6\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u8ba2\u5355\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        log.info("\u4ea7\u6210\u54c1\u56de\u4ed3\u660e\u7ec6\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e", (Object)list.size());
        ((IFinishProductInStorageReportDomain)this.domain).insertBatch(list);
        log.info("\u4ea7\u6210\u54c1\u56de\u4ed3\u660e\u7ec6\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
    }

    @Override
    public PageInfo<FinishProductInStorageReportDto> page(FinishProductInStorageReportPageReqDto dto) {
        return PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((IFinishProductInStorageReportDomain)this.domain).queryList(dto));
    }

    @Override
    public LocalDateTime getLastOrderUpdateTime() {
        return ((IFinishProductInStorageReportDomain)this.domain).getSourceMinUpdateTime();
    }
}

