/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.OrderCostDetailConverter;
import com.yunxi.dg.base.center.report.dao.das.IOrderCostDetailDas;
import com.yunxi.dg.base.center.report.dao.das.IOrderSkuCostDetailDas;
import com.yunxi.dg.base.center.report.dao.das.transform.TfOrderDas;
import com.yunxi.dg.base.center.report.domain.entity.IOrderCostDetailDomain;
import com.yunxi.dg.base.center.report.dto.entity.OrderCostDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.OrderCostDetailPageReqDto;
import com.yunxi.dg.base.center.report.eo.OrderCostDetailEo;
import com.yunxi.dg.base.center.report.eo.OrderSkuCostDetailEo;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderEo;
import com.yunxi.dg.base.center.report.service.entity.IOrderCostDetailService;
import com.yunxi.dg.base.center.report.utils.MathUtils;
import com.yunxi.dg.base.center.report.utils.PageQueryUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderCostDetailServiceImpl
extends BaseServiceImpl<OrderCostDetailDto, OrderCostDetailEo, IOrderCostDetailDomain>
implements IOrderCostDetailService {
    private static final Logger log = LoggerFactory.getLogger(OrderCostDetailServiceImpl.class);
    @Resource
    private IOrderSkuCostDetailDas orderSkuCostDetailDas;
    @Resource
    private IOrderCostDetailDas orderCostDetailDas;
    @Resource
    private TfOrderDas tfOrderDas;

    public OrderCostDetailServiceImpl(IOrderCostDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<OrderCostDetailDto, OrderCostDetailEo> converter() {
        return OrderCostDetailConverter.INSTANCE;
    }

    @Override
    public void syncWithDates(List<LocalDate> dates) {
        dates = dates.stream().distinct().sorted().collect(Collectors.toList());
        dates.forEach(date -> {
            try {
                this.syncWithDate((LocalDate)date);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65 {} \u7684\u8ba2\u5355\u8d39\u7528\u5206\u644a\u660e\u7ec6\u5931\u8d25", date, (Object)e);
            }
        });
    }

    private void syncWithDate(LocalDate date) {
        LocalDateTime startTime = date.atStartOfDay();
        LocalDateTime endTime = date.atTime(23, 59, 59);
        List<OrderSkuCostDetailEo> list = PageQueryUtils.queryAll(1000, () -> this.orderSkuCostDetailDas.queryByBizTime(startTime, endTime));
        this.syncWithDate(date, list);
    }

    @Override
    public void syncWithDate(LocalDate date, List<OrderSkuCostDetailEo> list) {
        log.info("\u540c\u6b65\u8ba2\u5355\u8d39\u7528\u5206\u644a\u660e\u7ec6\u5f00\u59cb: date={}", (Object)date);
        LocalDateTime startTime = date.atStartOfDay();
        LocalDateTime endTime = date.atTime(23, 59, 59);
        Map<String, List<OrderSkuCostDetailEo>> group = list.stream().collect(Collectors.groupingBy(k -> k.getSourceType() + "_" + k.getSourceId()));
        ArrayList<OrderCostDetailEo> details = new ArrayList<OrderCostDetailEo>();
        group.forEach((key, values) -> {
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal saleAmount = BigDecimal.ZERO;
            BigDecimal budgetCostAmount = BigDecimal.ZERO;
            BigDecimal actualCostAmount = BigDecimal.ZERO;
            BigDecimal taxCostAmount = BigDecimal.ZERO;
            HashSet<String> uniqueIds = new HashSet<String>();
            for (OrderSkuCostDetailEo value : values) {
                String uniqueId = String.format("%s_%s_%s", value.getSourceId(), value.getSourceType(), value.getSkuCode());
                if (!uniqueIds.contains(uniqueId)) {
                    uniqueIds.add(uniqueId);
                    if (value.isSaleOrder()) {
                        paidAmount = paidAmount.add(Optional.ofNullable(value.getSkuRealPayAmount()).orElse(BigDecimal.ZERO));
                        taxCostAmount = taxCostAmount.add(Optional.ofNullable(value.getSkuTaxCostAmount()).orElse(BigDecimal.ZERO));
                    } else {
                        refundAmount = refundAmount.add(Optional.ofNullable(value.getSkuRefundAmount()).orElse(BigDecimal.ZERO));
                    }
                }
                budgetCostAmount = budgetCostAmount.add(Optional.ofNullable(value.getBudgetCostAmount()).orElse(BigDecimal.ZERO));
                actualCostAmount = actualCostAmount.add(Optional.ofNullable(value.getActualCostAmount()).orElse(BigDecimal.ZERO));
            }
            saleAmount = paidAmount.subtract(refundAmount);
            OrderSkuCostDetailEo o = (OrderSkuCostDetailEo)values.get(0);
            OrderCostDetailEo eo = new OrderCostDetailEo();
            eo.setBizTime(o.getBizTime()).setSourceType(o.getSourceType()).setSourceId(o.getSourceId()).setPlatformOrderNo(o.getPlatformOrderNo()).setCovertOrderStatus(o.getCovertOrderStatus()).setAfterSaleOrderNo(o.getAfterSaleOrderNo()).setAfterSaleStatus(o.getAfterSaleStatus()).setOrderPayTime(o.getOrderPayTime()).setAfterSaleTime(o.getAfterSaleTime()).setShopId(o.getShopId()).setShopCode(o.getShopCode()).setShopName(o.getShopName()).setShopWebsiteId(o.getShopWebsiteId()).setShopWebsiteCode(o.getShopWebsiteCode()).setShopWebsiteName(o.getShopWebsiteName()).setPaidAmount(paidAmount).setRefundAmount(refundAmount).setSaleAmount(saleAmount).setBudgetCostAmount(budgetCostAmount).setBudgetCostRate(MathUtils.rate(budgetCostAmount, saleAmount)).setActualCostAmount(actualCostAmount).setActualCostRate(MathUtils.rate(actualCostAmount, saleAmount)).setTaxCostAmount(taxCostAmount).setGrossProfitAmount(saleAmount.subtract(taxCostAmount)).setGrossProfitRate(MathUtils.rate(eo.getGrossProfitAmount(), saleAmount)).setProfitAmount(eo.getGrossProfitAmount().subtract(actualCostAmount)).setProfitRate(MathUtils.rate(eo.getProfitAmount(), saleAmount)).setBudgetActualDiffAmount(eo.getBudgetCostAmount().subtract(eo.getActualCostAmount())).setBudgetActualDiffRate(Optional.ofNullable(eo.getBudgetCostRate()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(eo.getActualCostRate()).orElse(BigDecimal.ZERO)));
            details.add(eo);
        });
        details.sort(Comparator.comparing(OrderCostDetailEo::getBizTime));
        this.orderCostDetailDas.physicalDeleteByBizTime(startTime, endTime);
        this.orderCostDetailDas.insertBatch(details);
        log.info("\u540c\u6b65\u8ba2\u5355\u8d39\u7528\u5206\u644a\u660e\u7ec6\u5b8c\u6210: date={}", (Object)date);
    }

    @Override
    public PageInfo<OrderCostDetailDto> page(OrderCostDetailPageReqDto dto) {
        PageInfo page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> this.orderCostDetailDas.queryList(dto));
        ArrayList platformOrderList = new ArrayList();
        HashSet platformOrderNoSet = new HashSet();
        page.getList().forEach(e -> {
            MathUtils.setScale(e, Lists.newArrayList((Object[])new Function[]{OrderCostDetailDto::getPaidAmount, OrderCostDetailDto::getRefundAmount, OrderCostDetailDto::getSaleAmount, OrderCostDetailDto::getBudgetCostAmount, OrderCostDetailDto::getActualCostAmount, OrderCostDetailDto::getGrossProfitAmount, OrderCostDetailDto::getProfitAmount, OrderCostDetailDto::getBudgetActualDiffAmount}), Lists.newArrayList((Object[])new BiConsumer[]{OrderCostDetailDto::setPaidAmount, OrderCostDetailDto::setRefundAmount, OrderCostDetailDto::setSaleAmount, OrderCostDetailDto::setBudgetCostAmount, OrderCostDetailDto::setActualCostAmount, OrderCostDetailDto::setGrossProfitAmount, OrderCostDetailDto::setProfitAmount, OrderCostDetailDto::setBudgetActualDiffAmount}), 2);
            switch (e.getSourceType()) {
                case 1: {
                    e.setPlatformOrderRedirectType(Integer.valueOf(1));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    platformOrderNoSet.add(e.getPlatformOrderNo());
                    platformOrderList.add(e);
                }
            }
        });
        if (!platformOrderNoSet.isEmpty()) {
            List orders = this.tfOrderDas.queryByPlatformOrderNos(platformOrderNoSet);
            Set exists = orders.stream().map(TfOrderEo::getPlatformOrderNo).collect(Collectors.toSet());
            platformOrderList.forEach(e -> {
                if (exists.contains(e.getPlatformOrderNo())) {
                    e.setPlatformOrderRedirectType(Integer.valueOf(1));
                } else if (Objects.equals(e.getSourceType(), 4)) {
                    e.setPlatformOrderRedirectType(Integer.valueOf(2));
                } else {
                    e.setPlatformOrderRedirectType(Integer.valueOf(0));
                }
            });
        }
        return page;
    }
}

