/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleAllocTypeEnum;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleStatusEnum;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleTypeEnum;
import com.yunxi.dg.base.center.report.constants.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.report.convert.entity.OrderSkuCostDetailConverter;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderLineAmountDas;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderLineDas;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderPaymentDas;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderSnapshotDas;
import com.yunxi.dg.base.center.report.dao.das.IOrderLabelItemDas;
import com.yunxi.dg.base.center.report.dao.das.IOrderSkuCostDetailDas;
import com.yunxi.dg.base.center.report.dao.das.trade.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.report.dao.das.trade.IDgAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.report.dao.das.trade.IDgOrderLabelRecordDas;
import com.yunxi.dg.base.center.report.dao.das.transform.ITfOrderAfterSaleItemDas;
import com.yunxi.dg.base.center.report.dao.das.transform.TfOrderDas;
import com.yunxi.dg.base.center.report.dao.das.transform.TfOrderItemDas;
import com.yunxi.dg.base.center.report.dao.das.transform.TfOrderRefundDas;
import com.yunxi.dg.base.center.report.dao.das.transform.TfOrderReturnRefundDas;
import com.yunxi.dg.base.center.report.domain.entity.IOrderSkuCostDetailDomain;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleCalcDto;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.OrderSkuCostAsyncResultDto;
import com.yunxi.dg.base.center.report.dto.entity.OrderSkuCostDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuCostDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuInfoDto;
import com.yunxi.dg.base.center.report.dto.entity.StepConsumeDto;
import com.yunxi.dg.base.center.report.dto.shop.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.report.dto.shop.response.DgShopRespDto;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.report.eo.OrderSkuCostDetailEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderAfterSaleItemEo;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderEo;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderItemEo;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderRefundEo;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderReturnRefundEo;
import com.yunxi.dg.base.center.report.service.entity.IActualCostAllocRuleService;
import com.yunxi.dg.base.center.report.service.entity.IBudgetCostAllocRuleService;
import com.yunxi.dg.base.center.report.service.entity.ICostOverviewDetailService;
import com.yunxi.dg.base.center.report.service.entity.IDgShopService;
import com.yunxi.dg.base.center.report.service.entity.IOrderCostDetailService;
import com.yunxi.dg.base.center.report.service.entity.IOrderSkuCostDetailService;
import com.yunxi.dg.base.center.report.service.entity.IShopArchiveCostDetailService;
import com.yunxi.dg.base.center.report.service.entity.IShopSkuCostDetailService;
import com.yunxi.dg.base.center.report.service.entity.ISkuCostService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgService;
import com.yunxi.dg.base.center.report.utils.PageQueryUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class OrderSkuCostDetailServiceImpl
extends BaseServiceImpl<OrderSkuCostDetailDto, OrderSkuCostDetailEo, IOrderSkuCostDetailDomain>
implements IOrderSkuCostDetailService {
    private static final Logger log = LoggerFactory.getLogger(OrderSkuCostDetailServiceImpl.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final ThreadLocal<Map<String, Object>> cache = new ThreadLocal();
    private static final String CACHE_KEY_RULES = "rules";
    private static final String CACHE_KEY_USED_RULES = "used_rules";
    private static final String CACHE_KEY_SKUS = "skus";
    private static final String CACHE_KEY_SKU_COSTS = "sku_costs";
    private static final String CACHE_KEY_SHOPS = "shops";
    @Resource
    private IOrderSkuCostDetailDas orderSkuCostDetailDas;
    @Resource
    private TfOrderDas tfOrderDas;
    @Resource
    private TfOrderItemDas tfOrderItemDas;
    @Resource
    private TfOrderRefundDas tfOrderRefundDas;
    @Resource
    private ITfOrderAfterSaleItemDas tfOrderAfterSaleItemDas;
    @Resource
    private IDgAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private TfOrderReturnRefundDas tfOrderReturnRefundDas;
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private ISkuCostService skuCostService;
    @Resource
    private IActualCostAllocRuleService actualCostAllocRuleService;
    @Resource
    private IBudgetCostAllocRuleService budgetCostAllocRuleService;
    @Resource
    private IOrderCostDetailService orderCostDetailService;
    @Resource
    private IShopSkuCostDetailService shopSkuCostDetailService;
    @Resource
    private IShopArchiveCostDetailService shopArchiveCostDetailService;
    @Resource
    private ICostOverviewDetailService costOverviewDetailService;
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IDgPerformOrderLineDas performOrderLineDas;
    @Resource
    private IDgPerformOrderPaymentDas performOrderPaymentDas;
    @Resource
    private IDgPerformOrderSnapshotDas performOrderSnapshotDas;
    @Resource
    private IDgOrderLabelRecordDas orderLabelRecordDas;
    @Resource
    private IOrderLabelItemDas orderLabelItemDas;
    @Resource
    private IDgPerformOrderLineAmountDas performOrderLineAmountDas;
    @Resource
    private IDgAfterSaleOrderItemDas afterSaleOrderItemDas;
    @Resource(name="statisticsExecutor")
    private Executor executor;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDgShopService shopService;

    public OrderSkuCostDetailServiceImpl(IOrderSkuCostDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<OrderSkuCostDetailDto, OrderSkuCostDetailEo> converter() {
        return OrderSkuCostDetailConverter.INSTANCE;
    }

    @Override
    public String syncWithParams(ReportSyncReqDto dto) {
        OrderSkuCostAsyncResultDto task = this.newTask().cache();
        return this.syncWithParams(dto, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncWithParams(ReportSyncReqDto dto, OrderSkuCostAsyncResultDto task) {
        try {
            cache.set(new HashMap());
            task.setStatus("running");
            task.setStartTime(new Date());
            task.cache();
            log.info("\u7ecf\u8425\u5206\u6790\u62a5\u8868\u540c\u6b65\u5f00\u59cb\uff1ataskId={}, dto={}", (Object)task.getTaskId(), JSONObject.toJSON((Object)dto));
            LocalDateTime defaultTime = LocalDateTime.of(2024, 1, 1, 0, 0, 0);
            LocalDateTime startTimeBak = dto.getStartTime();
            LocalDateTime yesterdayEnd = LocalDate.now().plusDays(-1L).atTime(23, 59, 59);
            if (dto.getEndTime() == null) {
                dto.setEndTime(yesterdayEnd);
            }
            if (dto.getEndTime().isAfter(yesterdayEnd)) {
                log.info("\u7ed3\u675f\u65f6\u95f4\u4fee\u6b63\u4e3a: {}", (Object)yesterdayEnd);
                dto.setEndTime(yesterdayEnd);
            }
            ArrayList ruleStatus = Lists.newArrayList((Object[])new String[]{CostAllocRuleStatusEnum.RUNNING.getCode(), CostAllocRuleStatusEnum.END.getCode()});
            LocalDateTime startTime = Optional.ofNullable(dto.getStartTime()).orElse(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
            LocalDateTime endTime = Optional.ofNullable(dto.getEndTime()).orElse(LocalDateTime.now());
            List<CostAllocRuleDto> rules = this.actualCostAllocRuleService.getRules(ruleStatus);
            List<CostAllocRuleDto> budgetRules = this.budgetCostAllocRuleService.getRules(ruleStatus);
            rules.addAll(budgetRules);
            cache.get().put(CACHE_KEY_RULES, rules);
            cache.get().put(CACHE_KEY_USED_RULES, new HashMap());
            cache.get().put(CACHE_KEY_SKUS, new HashMap());
            cache.get().put(CACHE_KEY_SKU_COSTS, new HashMap());
            cache.get().put(CACHE_KEY_SHOPS, new HashMap());
            dto.setStartTime(startTimeBak);
            dto.paramsCheck(() -> Optional.ofNullable(Optional.ofNullable(((IOrderSkuCostDetailDomain)this.domain).getMaxSourceUpdateTime(1)).orElse(this.tfOrderDas.getMinUpdateTimeWithoutDr())).orElse(defaultTime));
            dto.syncByStep("\u7ecf\u8425\u5206\u6790-\u5e73\u53f0\u9500\u552e\u8ba2\u5355", this::doSyncPlatformOrders);
            dto.setStartTime(startTimeBak);
            dto.paramsCheck(() -> Optional.ofNullable(Optional.ofNullable(((IOrderSkuCostDetailDomain)this.domain).getMaxSourceUpdateTime(2)).orElse(this.tfOrderRefundDas.getMinUpdateTimeWithoutDr())).orElse(defaultTime));
            dto.syncByStep("\u7ecf\u8425\u5206\u6790-\u5e73\u53f0\u552e\u540e-\u4ec5\u9000\u6b3e", this::doSyncRefunds);
            dto.setStartTime(startTimeBak);
            dto.paramsCheck(() -> Optional.ofNullable(Optional.ofNullable(((IOrderSkuCostDetailDomain)this.domain).getMaxSourceUpdateTime(3)).orElse(this.tfOrderReturnRefundDas.getMinUpdateTimeWithoutDr())).orElse(defaultTime));
            dto.syncByStep("\u7ecf\u8425\u5206\u6790-\u5e73\u53f0\u552e\u540e-\u9000\u8d27\u9000\u6b3e", this::doSyncReturnRefunds);
            dto.setStartTime(startTimeBak);
            dto.paramsCheck(() -> Optional.ofNullable(Optional.ofNullable(((IOrderSkuCostDetailDomain)this.domain).getMaxSourceUpdateTime(4)).orElse(this.performOrderInfoDas.getMinUpdateTimeWithoutDr())).orElse(defaultTime));
            dto.syncByStep("\u7ecf\u8425\u5206\u6790-\u624b\u5de5\u5355", this::doSyncManualOrders);
            dto.setStartTime(startTimeBak);
            dto.paramsCheck(() -> Optional.ofNullable(Optional.ofNullable(((IOrderSkuCostDetailDomain)this.domain).getMaxSourceUpdateTime(5)).orElse(this.afterSaleOrderDas.getMinUpdateTimeWithoutDr())).orElse(defaultTime));
            dto.syncByStep("\u7ecf\u8425\u5206\u6790-\u552e\u540e\u8ba2\u5355-\u624b\u5de5", this::doSyncAfterManualSaleOrders);
            Map<CostAllocRuleDto, Set<LocalDate>> usedRuleMap = this.getUsedRuleCache();
            usedRuleMap.forEach(this::reCalculateRule);
            List<LocalDate> dates = usedRuleMap.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
            dates.forEach(date -> {
                LocalDateTime startTime2 = date.atStartOfDay();
                LocalDateTime endTime2 = date.atTime(23, 59, 59);
                String dateStr = this.dateFormatter.format((TemporalAccessor)date);
                StepConsumeDto step = task.startStep("\u67e5\u8be2\u660e\u7ec6-" + dateStr);
                List<OrderSkuCostDetailEo> list = PageQueryUtils.queryAll(1000, () -> this.orderSkuCostDetailDas.queryByBizTime(startTime2, endTime2));
                step.finish();
                step = task.startStep("\u8ba2\u5355\u660e\u7ec6-" + dateStr);
                this.orderCostDetailService.syncWithDate((LocalDate)date, list);
                step.finish();
                step = task.startStep("\u5e97\u94fa\u660e\u7ec6-" + dateStr);
                this.shopSkuCostDetailService.syncDateOnly((LocalDate)date, list);
                step.finish();
                step = task.startStep("\u8d39\u7528\u6863\u6848\u660e\u7ec6-" + dateStr);
                this.shopArchiveCostDetailService.syncDateOnly((LocalDate)date, list);
                step.finish();
                step = task.startStep("\u6982\u8981-" + dateStr);
                this.costOverviewDetailService.syncDateOnly((LocalDate)date, list);
                step.finish();
            });
            task.cache();
            StepConsumeDto step = task.startStep("\u5e97\u94fa\u6708&\u5b63\u5ea6&\u5e74-" + dates.size());
            this.shopSkuCostDetailService.syncAfterAllDateOnly(dates);
            step.finish();
            task.cache();
            step = task.startStep("\u8d39\u7528\u6863\u6848\u6708&\u5b63\u5ea6&\u5e74-" + dates.size());
            this.shopArchiveCostDetailService.syncAfterAllDateOnly(dates);
            step.finish();
            task.cache();
            step = task.startStep("\u6982\u8981\u6708&\u5b63\u5ea6&\u5e74-" + dates.size());
            List<StepConsumeDto> sts = this.costOverviewDetailService.syncAfterAllDateOnly(dates);
            step.setChildren(sts);
            step.finish();
            log.info("\u7ecf\u8425\u5206\u6790\u62a5\u8868\u540c\u6b65\u5b8c\u6210\uff1ataskId={}, dto={}", (Object)task.getTaskId(), JSONObject.toJSON((Object)dto));
            task.setStatus("success");
            task.setEndTime(new Date());
            task.finish();
        }
        catch (Exception e) {
            task.setStatus("failure");
            task.setMsg(e.getMessage());
            task.setEndTime(new Date());
            task.finish();
            log.info("\u7ecf\u8425\u5206\u6790\u62a5\u8868\u540c\u6b65\u5f02\u5e38\uff1ataskId={}, dto={}", new Object[]{task.getTaskId(), JSONObject.toJSON((Object)dto), e});
        }
        finally {
            cache.get().clear();
            cache.remove();
        }
        return task.getTaskId();
    }

    private OrderSkuCostAsyncResultDto newTask() {
        return OrderSkuCostAsyncResultDto.builder().cacheService(this.cacheService).taskId(IdWorker.getId() + "").status("init").startTime(new Date()).stepConsumes(new ArrayList()).build();
    }

    private Map<CostAllocRuleDto, Set<LocalDate>> getUsedRuleCache() {
        return (Map)cache.get().get(CACHE_KEY_USED_RULES);
    }

    private void reCalculateRule(CostAllocRuleDto rule, Set<LocalDate> dates) {
        dates.forEach(date -> {
            try {
                this.reCalculateRule(rule, (LocalDate)date);
            }
            catch (Exception e) {
                log.error("\u91cd\u7b97\u89c4\u5219\u5931\u8d25\uff1aruleType={}, ruleId={}, date={}, json={}", new Object[]{rule.getRuleType(), rule.getRuleId(), date, JacksonUtil.toJson((Object)rule), e});
            }
        });
    }

    private void reCalculateRule(CostAllocRuleDto rule, LocalDate date) {
        log.info("\u5f00\u59cb\u91cd\u7b97\uff1aruleType={}, ruleId={}, date={}, json={}", new Object[]{rule.getRuleType(), rule.getRuleId(), date, JacksonUtil.toJson((Object)rule)});
        CostAllocRuleTypeEnum ruleType = CostAllocRuleTypeEnum.fromCode((Integer)rule.getRuleType());
        if (ruleType.equals((Object)CostAllocRuleTypeEnum.ACTUAL)) {
            this.reCalculateActualRule(rule, date);
        } else if (ruleType.equals((Object)CostAllocRuleTypeEnum.BUDGET)) {
            this.reCalculateBudgetRule(rule, date);
        }
        log.info("\u91cd\u7b97\u5b8c\u6210\uff1aruleType={}, ruleId={}, date={}", new Object[]{rule.getRuleType(), rule.getRuleId(), date});
    }

    private void doSyncRefunds(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = this.tfOrderRefundDas.pageByUpdateTimeWithoutDr(startTime, endTime, pageNum, pageSize);
            log.info("\u7ecf\u8425\u5206\u6790-\u5e73\u53f0\u552e\u540e-\u4ec5\u9000\u6b3e: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            this.doSyncRefunds(list);
        } while (hasNextPage);
    }

    private void doSyncRefunds(List<TfOrderRefundEo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList tfAfterSaleOrderIds = new ArrayList();
        HashMap tfOrderRefundMap = new HashMap();
        HashSet<String> shopCodes = new HashSet<String>();
        HashSet platformOrderNos = new HashSet();
        list.forEach(refund -> {
            tfAfterSaleOrderIds.add(refund.getId());
            tfOrderRefundMap.put(refund.getPlatformRefundOrderSn(), refund);
            shopCodes.add(refund.getShopCode());
            platformOrderNos.add(refund.getPlatformOrderNo());
        });
        List tfOrders = this.tfOrderDas.queryByPlatformOrderNos(platformOrderNos);
        Map<String, TfOrderEo> tfOrderMap = tfOrders.stream().collect(Collectors.toMap(TfOrderEo::getPlatformOrderNo, v -> v, (a, b) -> b));
        List allItems = this.tfOrderAfterSaleItemDas.queryByAfterSaleOrderIds(tfAfterSaleOrderIds);
        HashMap<Long, List> group = new HashMap<Long, List>();
        HashSet<String> skuCodes = new HashSet<String>();
        for (TfOrderAfterSaleItemEo item : allItems) {
            List tmp = group.computeIfAbsent(item.getAfterOrderId(), k -> new ArrayList());
            tmp.add(item);
            skuCodes.add(item.getSkuCode());
        }
        this.cacheSkuInfo(skuCodes);
        this.cacheSkuCost(skuCodes);
        this.cacheShop(shopCodes);
        List<CostAllocRuleDto> rules = this.getRuleCache();
        List details = list.stream().flatMap(afterSaleOrder -> {
            TfOrderRefundEo order = (TfOrderRefundEo)tfOrderRefundMap.get(afterSaleOrder.getPlatformRefundOrderSn());
            if (order == null) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u4ec5\u9000\u6b3e\u8ba2\u5355 {} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e73\u53f0\u8ba2\u5355", (Object)afterSaleOrder.getPlatformRefundOrderSn());
                return Stream.empty();
            }
            if (order.getPlatformCreated() == null) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u4ec5\u9000\u6b3e\u8ba2\u5355 {} \u627e\u4e0d\u5230\u5e73\u53f0\u521b\u5efa\u65f6\u95f4", (Object)afterSaleOrder.getPlatformRefundOrderSn());
                return Stream.empty();
            }
            TfOrderEo tfOrder = (TfOrderEo)tfOrderMap.get(order.getPlatformOrderNo());
            List items = group.getOrDefault(order.getId(), Collections.emptyList());
            List<CostAllocRuleDto> selectedRules = this.selectRules(rules, order.getShopCode(), afterSaleOrder.getPlatformCreated());
            if (selectedRules.isEmpty()) {
                return Stream.empty();
            }
            return selectedRules.stream().flatMap(k -> this.toOrderSkuCostDetails(order, (List<TfOrderAfterSaleItemEo>)items, (CostAllocRuleDto)k, tfOrder).stream());
        }).collect(Collectors.toList());
        this.orderSkuCostDetailDas.physicalDeleteBySourceIds(2, tfAfterSaleOrderIds);
        if (!details.isEmpty()) {
            ((IOrderSkuCostDetailDomain)this.domain).insertBatch(OrderSkuCostDetailConverter.INSTANCE.toEoList(details));
        }
    }

    private <T extends BaseEo> Map<Long, BigDecimal> allocNullAmount(@NonNull BigDecimal totalAmount, List<T> items, Function<T, BigDecimal> getAmount) {
        BigDecimal usedAmount = BigDecimal.ZERO;
        ArrayList<BaseEo> nullItems = new ArrayList<BaseEo>();
        HashMap<Long, BigDecimal> itemAmountMap = new HashMap<Long, BigDecimal>();
        for (BaseEo item : items) {
            BigDecimal amount = getAmount.apply(item);
            if (amount == null) {
                nullItems.add(item);
                continue;
            }
            usedAmount = usedAmount.add(amount);
            itemAmountMap.put(item.getId(), amount);
        }
        if (!nullItems.isEmpty()) {
            BigDecimal totalAllocAmount = totalAmount.subtract(usedAmount);
            BigDecimal unitAmount = totalAllocAmount.divide(new BigDecimal(nullItems.size()), 2, RoundingMode.HALF_UP);
            for (BaseEo nullItem : nullItems) {
                itemAmountMap.put(nullItem.getId(), unitAmount);
            }
            itemAmountMap.put(((BaseEo)nullItems.get(nullItems.size() - 1)).getId(), totalAllocAmount.subtract(unitAmount.multiply(new BigDecimal(nullItems.size() - 1))));
        }
        return itemAmountMap;
    }

    private List<OrderSkuCostDetailDto> toOrderSkuCostDetails(TfOrderRefundEo order, List<TfOrderAfterSaleItemEo> items, CostAllocRuleDto rule, TfOrderEo tfOrder) {
        if (tfOrder != null && Objects.equals(tfOrder.getCovertOrderStatus(), "CANCEL")) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getPlatformCreated()).toLocalDate());
            return Collections.emptyList();
        }
        if (!order.getDr().equals(0) || !"SUCCEED".equals(order.getAfterSaleStatus())) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getPlatformCreated()).toLocalDate());
            return Collections.emptyList();
        }
        Map<Long, BigDecimal> refundReeMap = this.allocNullAmount(Optional.ofNullable(order.getRefundFee()).orElse(BigDecimal.ZERO), items, TfOrderAfterSaleItemEo::getRefundFee);
        return items.stream().map(item -> {
            DgShopRespDto shop;
            OrderSkuCostDetailDto dto = new OrderSkuCostDetailDto();
            dto.setBizTime(order.getPlatformCreated()).setSourceType(Integer.valueOf(2)).setSourceId(order.getId()).setArchiveCode(rule.getArchiveCode()).setArchiveName(rule.getArchiveName()).setCategoryCode(rule.getCategoryCode()).setCategoryName(rule.getCategoryName()).setRuleType(rule.getRuleType()).setRuleCode(rule.getRuleCode()).setRuleName(rule.getRuleName()).setBizAmount(((BigDecimal)refundReeMap.get(item.getId())).negate()).setPlatformOrderNo(Optional.ofNullable(order.getPlatformOrderNo()).orElse("")).setPlatformRefundOrderSn(order.getPlatformRefundOrderSn()).setCovertOrderStatus((String)Optional.ofNullable(tfOrder).map(TfOrderEo::getCovertOrderStatus).orElse(null)).setAfterSaleOrderNo(order.getPlatformRefundOrderSn()).setAfterSaleStatus(order.getAfterSaleStatus()).setShopId(order.getShopId()).setShopCode(order.getShopCode()).setShopName(order.getShopName()).setShopWebsiteId(order.getShopWebsiteId()).setShopWebsiteCode(order.getShopWebsiteCode()).setShopWebsiteName(order.getShopWebsite()).setItemId(item.getItemId()).setItemCode(item.getItemCode()).setItemName(item.getItemName()).setItemNum(item.getNum()).setSkuId(item.getSkuId()).setSkuCode(item.getSkuCode()).setSkuName(item.getSkuName()).setGift(item.getGift()).setSkuDiscountAmount(BigDecimal.ZERO).setSkuPaymentAmount(BigDecimal.ZERO).setSkuRealPayAmount(BigDecimal.ZERO).setSkuRefundAmount((BigDecimal)refundReeMap.get(item.getId())).setSkuTaxCostPrice(this.getSkuTaxCostPrice(item.getSkuCode())).setSkuTaxCostAmount(dto.getSkuTaxCostPrice().multiply(BigDecimal.valueOf(Optional.ofNullable(dto.getItemNum()).orElse(1).intValue()))).setAfterSaleTime(order.getPlatformCreated()).setRefundTime(order.getPlatformCreated()).setSourceUpdateTime(order.getUpdateTime());
            SkuInfoDto sku = this.getSkuInfo(item.getSkuCode());
            if (sku != null) {
                dto.setDirId(sku.getDirId()).setDirCode(sku.getDirCode()).setDirName(sku.getDirName()).setSkuId(sku.getId()).setSkuName(sku.getSkuName());
            }
            if ((shop = this.getShop(dto.getShopCode())) != null) {
                dto.setShopName(shop.getStoreName()).setShopWebsiteId(shop.getChannelId()).setShopWebsiteCode(shop.getChannelCode()).setShopWebsiteName(shop.getChannelName());
            }
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)dto.getBizTime()).toLocalDate());
            return dto;
        }).collect(Collectors.toList());
    }

    private DgShopRespDto getShop(String shopCode) {
        return this.getShopCache().get(shopCode);
    }

    private void doSyncReturnRefunds(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = this.tfOrderReturnRefundDas.pageByUpdateTimeWithoutDr(startTime, endTime, pageNum, pageSize);
            log.info("\u7ecf\u8425\u5206\u6790-\u5e73\u53f0\u552e\u540e-\u9000\u8d27\u9000\u6b3e: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            this.doSyncReturnRefunds(list);
        } while (hasNextPage);
    }

    private void doSyncReturnRefunds(List<TfOrderReturnRefundEo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList tfAfterSaleOrderIds = new ArrayList();
        HashSet<String> shopCodes = new HashSet<String>();
        HashSet platformOrderNos = new HashSet();
        list.forEach(refund -> {
            tfAfterSaleOrderIds.add(refund.getId());
            shopCodes.add(refund.getShopCode());
            platformOrderNos.add(refund.getPlatformOrderNo());
        });
        List tfOrders = this.tfOrderDas.queryByPlatformOrderNos(platformOrderNos);
        Map<String, TfOrderEo> tfOrderMap = tfOrders.stream().collect(Collectors.toMap(TfOrderEo::getPlatformOrderNo, v -> v, (a, b) -> b));
        List allItems = this.tfOrderAfterSaleItemDas.queryByAfterSaleOrderIds(tfAfterSaleOrderIds);
        HashMap<Long, List> group = new HashMap<Long, List>();
        HashSet<String> skuCodes = new HashSet<String>();
        for (TfOrderAfterSaleItemEo item : allItems) {
            List tmp = group.computeIfAbsent(item.getAfterOrderId(), k -> new ArrayList());
            tmp.add(item);
            skuCodes.add(item.getSkuCode());
        }
        this.cacheSkuInfo(skuCodes);
        this.cacheSkuCost(skuCodes);
        this.cacheShop(shopCodes);
        List<CostAllocRuleDto> rules = this.getRuleCache();
        List details = list.stream().flatMap(order -> {
            if (order.getPlatformCreated() == null) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u4ec5\u9000\u6b3e\u8ba2\u5355 {} \u627e\u4e0d\u5230\u5e73\u53f0\u521b\u5efa\u65f6\u95f4", (Object)order.getPlatformRefundOrderSn());
                return Stream.empty();
            }
            TfOrderEo tfOrder = (TfOrderEo)tfOrderMap.get(order.getPlatformOrderNo());
            List items = group.getOrDefault(order.getId(), Collections.emptyList());
            List<CostAllocRuleDto> selectedRules = this.selectRules(rules, order.getShopCode(), order.getPlatformCreated());
            if (selectedRules.isEmpty()) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u9000\u8d27\u9000\u6b3e\u8ba2\u5355 {} \u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u5206\u644a\u89c4\u5219\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58", (Object)order.getPlatformRefundOrderSn());
                return Stream.empty();
            }
            log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u9000\u8d27\u9000\u6b3e\u8ba2\u5355 {} \u5339\u914d\u5230\u4ee5\u4e0b\u5206\u644a\u89c4\u5219\uff1a{}", (Object)order.getPlatformRefundOrderSn(), (Object)JacksonUtil.toJson(selectedRules));
            return selectedRules.stream().flatMap(k -> this.toOrderSkuCostDetails((TfOrderReturnRefundEo)order, (List<TfOrderAfterSaleItemEo>)items, (CostAllocRuleDto)k, tfOrder).stream());
        }).collect(Collectors.toList());
        this.orderSkuCostDetailDas.physicalDeleteBySourceIds(3, tfAfterSaleOrderIds);
        if (!details.isEmpty()) {
            ((IOrderSkuCostDetailDomain)this.domain).insertBatch(OrderSkuCostDetailConverter.INSTANCE.toEoList(details));
        }
    }

    private List<OrderSkuCostDetailDto> toOrderSkuCostDetails(TfOrderReturnRefundEo order, List<TfOrderAfterSaleItemEo> items, CostAllocRuleDto rule, TfOrderEo tfOrder) {
        if (tfOrder != null && Objects.equals(tfOrder.getCovertOrderStatus(), "CANCEL")) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getPlatformCreated()).toLocalDate());
            return Collections.emptyList();
        }
        if (!order.getDr().equals(0) || !"SUCCEED".equals(order.getAfterSaleStatus())) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getPlatformCreated()).toLocalDate());
            return Collections.emptyList();
        }
        Map<Long, BigDecimal> refundReeMap = this.allocNullAmount(Optional.ofNullable(order.getRefundFee()).orElse(BigDecimal.ZERO), items, TfOrderAfterSaleItemEo::getRefundFee);
        return items.stream().map(item -> {
            DgShopRespDto shop;
            OrderSkuCostDetailDto dto = new OrderSkuCostDetailDto();
            dto.setBizTime(order.getPlatformCreated()).setSourceType(Integer.valueOf(3)).setSourceId(order.getId()).setArchiveCode(rule.getArchiveCode()).setArchiveName(rule.getArchiveName()).setCategoryCode(rule.getCategoryCode()).setCategoryName(rule.getCategoryName()).setRuleType(rule.getRuleType()).setRuleCode(rule.getRuleCode()).setRuleName(rule.getRuleName()).setBizAmount(((BigDecimal)refundReeMap.get(item.getId())).negate()).setPlatformOrderNo(Optional.ofNullable(order.getPlatformOrderNo()).orElse("")).setPlatformRefundOrderSn(order.getPlatformRefundOrderSn()).setCovertOrderStatus((String)Optional.ofNullable(tfOrder).map(TfOrderEo::getCovertOrderStatus).orElse(null)).setAfterSaleOrderNo(order.getPlatformRefundOrderSn()).setAfterSaleStatus(order.getAfterSaleStatus()).setShopId(order.getShopId()).setShopCode(order.getShopCode()).setShopName(order.getShopName()).setShopWebsiteId(order.getShopWebsiteId()).setShopWebsiteCode(order.getShopWebsiteCode()).setShopWebsiteName(order.getShopWebsite()).setItemId(item.getItemId()).setItemCode(item.getItemCode()).setItemName(item.getItemName()).setItemNum(item.getNum()).setSkuId(item.getSkuId()).setSkuCode(item.getSkuCode()).setSkuName(item.getSkuName()).setGift(item.getGift()).setSkuDiscountAmount(BigDecimal.ZERO).setSkuPaymentAmount(BigDecimal.ZERO).setSkuRealPayAmount(BigDecimal.ZERO).setSkuRefundAmount((BigDecimal)refundReeMap.get(item.getId())).setSkuTaxCostPrice(this.getSkuTaxCostPrice(item.getSkuCode())).setSkuTaxCostAmount(dto.getSkuTaxCostPrice().multiply(BigDecimal.valueOf(Optional.ofNullable(dto.getItemNum()).orElse(1).intValue()))).setAfterSaleTime(order.getPlatformCreated()).setReturnRefundTime(order.getPlatformCreated()).setSourceUpdateTime(order.getUpdateTime());
            SkuInfoDto sku = this.getSkuInfo(item.getSkuCode());
            if (sku != null) {
                dto.setDirId(sku.getDirId()).setDirCode(sku.getDirCode()).setDirName(sku.getDirName()).setSkuId(sku.getId()).setSkuName(sku.getSkuName());
            }
            if ((shop = this.getShop(dto.getShopCode())) != null) {
                dto.setShopName(shop.getStoreName()).setShopWebsiteId(shop.getChannelId()).setShopWebsiteCode(shop.getChannelCode()).setShopWebsiteName(shop.getChannelName());
            }
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)dto.getBizTime()).toLocalDate());
            return dto;
        }).collect(Collectors.toList());
    }

    private void reCalculateActualRule(CostAllocRuleDto rule, LocalDate date) {
        CostAllocRuleCalcDto dto = this.getCalcDto(rule, date);
        CostAllocRuleAllocTypeEnum allocType = CostAllocRuleAllocTypeEnum.fromCode((Integer)rule.getRuleType(), (String)rule.getAllocType());
        if (allocType.equals((Object)CostAllocRuleAllocTypeEnum.BY_RATIO)) {
            if (rule.getProportion() == null) {
                throw new BizException("\u672a\u8bbe\u7f6e\u6bd4\u4f8b");
            }
            dto.setProportion(rule.getProportion());
            this.orderSkuCostDetailDas.updateActualCostAmountByProportion(dto);
        } else if (allocType.equals((Object)CostAllocRuleAllocTypeEnum.BY_FIXED)) {
            BigDecimal fixedCost = (BigDecimal)rule.getActualFixedCostMap().get(date);
            if (fixedCost == null) {
                throw new BizException("\u672a\u8bbe\u7f6e\u56fa\u5b9a\u91d1\u989d");
            }
            dto.setFixedCost(fixedCost);
            this.orderSkuCostDetailDas.updateActualCostAmountByFixedCost(dto);
        } else if (allocType.equals((Object)CostAllocRuleAllocTypeEnum.BY_GIFT)) {
            this.orderSkuCostDetailDas.updateActualCostAmountByGift(dto);
        } else {
            throw new BizException("\u4e0d\u652f\u6301\u7684\u5206\u644a\u7c7b\u578b");
        }
    }

    private void reCalculateBudgetRule(CostAllocRuleDto rule, LocalDate date) {
        CostAllocRuleCalcDto dto = this.getCalcDto(rule, date);
        CostAllocRuleAllocTypeEnum allocType = CostAllocRuleAllocTypeEnum.fromCode((Integer)rule.getRuleType(), (String)rule.getAllocType());
        if (allocType.equals((Object)CostAllocRuleAllocTypeEnum.BY_RATIO)) {
            Map proportionMap = rule.getBudgetProportionCostMap().entrySet().stream().filter(k -> k.getValue() != null).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
            proportionMap.forEach((proportion, shopCodes) -> {
                dto.setShopCodes(shopCodes);
                dto.setProportion(proportion);
                this.orderSkuCostDetailDas.updateBudgetCostAmountByProportion(dto);
            });
        } else if (allocType.equals((Object)CostAllocRuleAllocTypeEnum.BY_FIXED)) {
            Map fixedCostMap = rule.getBudgetFixedCostMap().entrySet().stream().filter(k -> k.getValue() != null).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
            fixedCostMap.forEach((fixedCost, shopCodes) -> {
                dto.setShopCodes(shopCodes);
                dto.setFixedCost(fixedCost);
                this.orderSkuCostDetailDas.updateBudgetCostAmountByFixedCost(dto);
            });
        } else {
            throw new BizException("\u4e0d\u652f\u6301\u7684\u5206\u644a\u7c7b\u578b");
        }
    }

    private CostAllocRuleCalcDto getCalcDto(CostAllocRuleDto rule, LocalDate date) {
        CostAllocRuleCalcDto dto = new CostAllocRuleCalcDto(rule);
        dto.setStartTime(date.atStartOfDay());
        dto.setEndTime(date.atTime(23, 59, 59));
        BigDecimal totalSalesAmountOfDay = this.orderSkuCostDetailDas.sumBizAmount(dto);
        dto.setTotalSalesAmountOfDay(totalSalesAmountOfDay);
        return dto;
    }

    private void doSyncPlatformOrders(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = this.tfOrderDas.pageByUpdateTimeWithoutDr(startTime, endTime, pageNum, pageSize);
            log.info("\u7ecf\u8425\u5206\u6790-\u5e73\u53f0\u8ba2\u5355\u5546\u54c1\u9500\u552e/\u552e\u540e\u8d39\u7528\u5206\u644a\u660e\u7ec6-\u5e73\u53f0\u9500\u552e\u8ba2\u5355: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            this.doSyncPlatformOrders(list, false);
        } while (hasNextPage);
    }

    private void doSyncPlatformOrders(List<TfOrderEo> list, boolean ignoreCancel) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList trOrderIds = new ArrayList();
        HashSet<String> shopCodes = new HashSet<String>();
        list.forEach(eo -> {
            trOrderIds.add(eo.getId());
            shopCodes.add(eo.getShopCode());
        });
        List allItems = this.tfOrderItemDas.queryByOrderIds(trOrderIds);
        HashMap<Long, List> group = new HashMap<Long, List>();
        HashSet<String> skuCodes = new HashSet<String>();
        for (TfOrderItemEo item : allItems) {
            List tmp = group.computeIfAbsent(item.getOrderId(), k -> new ArrayList());
            tmp.add(item);
            skuCodes.add(item.getSkuCode());
        }
        this.cacheSkuInfo(skuCodes);
        this.cacheSkuCost(skuCodes);
        this.cacheShop(shopCodes);
        List<CostAllocRuleDto> rules = this.getRuleCache();
        List details = list.stream().flatMap(order -> {
            if (order.getPayTime() == null) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u8ba2\u5355 {} \u627e\u4e0d\u5230\u652f\u4ed8\u65f6\u95f4", (Object)order.getPlatformOrderNo());
            }
            List items = group.getOrDefault(order.getId(), Collections.emptyList());
            List<CostAllocRuleDto> selectedRules = this.selectRules(rules, order.getShopCode(), order.getPayTime());
            if (selectedRules.isEmpty()) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u8ba2\u5355 {} \u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u5206\u644a\u89c4\u5219\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58", (Object)order.getPlatformOrderNo());
                return Stream.empty();
            }
            log.info("\u7ecf\u8425\u5206\u6790\uff1a\u5e73\u53f0\u8ba2\u5355 {} \u5339\u914d\u5230\u4ee5\u4e0b\u5206\u644a\u89c4\u5219\uff1a{}", (Object)order.getPlatformOrderNo(), (Object)JacksonUtil.toJson(selectedRules));
            return selectedRules.stream().flatMap(k -> this.toOrderSkuCostDetails((TfOrderEo)order, items, (CostAllocRuleDto)k, ignoreCancel).stream());
        }).collect(Collectors.toList());
        this.orderSkuCostDetailDas.physicalDeleteBySourceIds(1, trOrderIds);
        if (!details.isEmpty()) {
            ((IOrderSkuCostDetailDomain)this.domain).insertBatch(OrderSkuCostDetailConverter.INSTANCE.toEoList(details));
        }
    }

    private void cacheShop(Set<String> shopCodes) {
        Map<String, DgShopRespDto> map = this.getShopCache();
        HashSet<String> allKeys = new HashSet<String>(shopCodes);
        allKeys.removeAll(map.keySet());
        if (allKeys.isEmpty()) {
            return;
        }
        DgShopQueryReqDto req = new DgShopQueryReqDto();
        req.setStoreCodeList(new ArrayList<String>(allKeys));
        List<DgShopRespDto> list = this.shopService.queryListShop(req);
        Map<String, DgShopRespDto> shopMap = list.stream().collect(Collectors.toMap(k -> k.getStoreCode(), v -> v));
        map.putAll(shopMap);
    }

    private Map<String, DgShopRespDto> getShopCache() {
        return (Map)cache.get().get(CACHE_KEY_SHOPS);
    }

    private List<CostAllocRuleDto> getRuleCache() {
        return (List)cache.get().get(CACHE_KEY_RULES);
    }

    private void doSyncManualOrders(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = this.performOrderInfoDas.pageByUpdateTimeWithoutDr(startTime, endTime, pageNum, pageSize);
            log.info("\u7ecf\u8425\u5206\u6790-\u624b\u5de5\u5355: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List<DgPerformOrderInfoEo> list = page.getList();
            List orderIds = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            List manualOrderIds = Lists.partition(orderIds, (int)1000).stream().flatMap(once -> {
                List tmp = this.orderLabelRecordDas.queryManualOrderIds(once);
                return tmp.stream();
            }).collect(Collectors.toList());
            list = list.stream().filter(s -> manualOrderIds.contains(s.getId())).collect(Collectors.toList());
            this.doSyncManualOrders(list);
        } while (hasNextPage);
    }

    private void doSyncManualOrders(List<DgPerformOrderInfoEo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList orderIds = new ArrayList(list.size());
        HashSet platformOrderNos = new HashSet();
        list.forEach(o -> {
            orderIds.add(o.getId());
            if (StrUtil.isNotBlank((CharSequence)o.getPlatformOrderNo())) {
                platformOrderNos.add(o.getPlatformOrderNo());
            }
        });
        List allItems = this.performOrderLineDas.selectByOrderIds(orderIds);
        HashMap<Long, List> group = new HashMap<Long, List>();
        HashSet<String> skuCodes = new HashSet<String>();
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (DgPerformOrderLineEo item : allItems) {
            List tmp = group.computeIfAbsent(item.getOrderId(), k -> new ArrayList());
            tmp.add(item);
            skuCodes.add(item.getSkuCode());
            itemIds.add(item.getId());
        }
        List giftItemIds = this.orderLabelItemDas.queryGiftItemIds(itemIds);
        List snapshots = this.performOrderSnapshotDas.queryByOrderIds(orderIds);
        Set<String> shopCodes = snapshots.stream().map(DgPerformOrderSnapshotEo::getShopCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, DgPerformOrderSnapshotEo> snapshotMap = snapshots.stream().collect(Collectors.toMap(DgPerformOrderSnapshotEo::getOrderId, v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684Snapshot: orderId={}, a.id={}, b.id={}", new Object[]{a.getOrderId(), a.getId(), b.getId()});
            return b;
        }));
        List payments = this.performOrderPaymentDas.queryByOrderIds(orderIds);
        Map<Long, DgPerformOrderPaymentEo> paymentMap = payments.stream().collect(Collectors.toMap(DgPerformOrderPaymentEo::getOrderId, v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684Payment: orderId={}, a.id={}, b.id={}", new Object[]{a.getOrderId(), a.getId(), b.getId()});
            return b;
        }));
        List lineAmounts = this.performOrderLineAmountDas.selectByOrderIds(orderIds);
        Map<Long, List<DgPerformOrderLineAmountEo>> lineAmountMap = lineAmounts.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
        List tfOrders = this.tfOrderDas.queryByPlatformOrderNos(platformOrderNos);
        Map<String, TfOrderEo> tfOrderMap = tfOrders.stream().collect(Collectors.toMap(TfOrderEo::getPlatformOrderNo, v -> v, (a, b) -> b));
        this.cacheSkuInfo(skuCodes);
        this.cacheSkuCost(skuCodes);
        this.cacheShop(shopCodes);
        List<CostAllocRuleDto> rules = this.getRuleCache();
        List details = list.stream().flatMap(order -> {
            DgPerformOrderSnapshotEo snapshot = (DgPerformOrderSnapshotEo)snapshotMap.get(order.getId());
            if (snapshot == null) {
                log.warn("\u7ecf\u8425\u5206\u6790\uff1a\u624b\u5de5\u5355 {} \u6ca1\u6709\u5bf9\u5e94\u7684snapshot", (Object)order.getId());
                return Stream.empty();
            }
            DgPerformOrderPaymentEo payment = (DgPerformOrderPaymentEo)paymentMap.get(order.getId());
            if (payment == null) {
                log.warn("\u7ecf\u8425\u5206\u6790\uff1a\u624b\u5de5\u5355 {} \u6ca1\u6709\u5bf9\u5e94\u7684Payment", (Object)order.getId());
                return Stream.empty();
            }
            if (payment.getPayTime() == null) {
                log.warn("\u7ecf\u8425\u5206\u6790\uff1a\u624b\u5de5\u5355 {} \u627e\u4e0d\u5230\u652f\u4ed8\u65f6\u95f4", (Object)order.getId());
                return Stream.empty();
            }
            TfOrderEo tfOrder = (TfOrderEo)tfOrderMap.get(order.getPlatformOrderNo());
            List items = group.getOrDefault(order.getId(), Collections.emptyList());
            List<CostAllocRuleDto> selectedRules = this.selectRules(rules, snapshot.getShopCode(), payment.getPayTime());
            if (selectedRules.isEmpty()) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u624b\u5de5\u5355 {} \u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u5206\u644a\u89c4\u5219\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58", (Object)order.getId());
                return Stream.empty();
            }
            log.info("\u7ecf\u8425\u5206\u6790\uff1a\u624b\u5de5\u5355 {} \u5339\u914d\u5230\u4ee5\u4e0b\u5206\u644a\u89c4\u5219\uff1a{}", (Object)order.getPlatformOrderNo(), (Object)JacksonUtil.toJson(selectedRules));
            return selectedRules.stream().flatMap(k -> this.toOrderSkuCostDetails((DgPerformOrderInfoEo)order, snapshot, payment, items, giftItemIds, lineAmountMap, (CostAllocRuleDto)k, tfOrder).stream());
        }).collect(Collectors.toList());
        this.orderSkuCostDetailDas.physicalDeleteBySourceIds(4, orderIds);
        if (!details.isEmpty()) {
            ((IOrderSkuCostDetailDomain)this.domain).insertBatch(OrderSkuCostDetailConverter.INSTANCE.toEoList(details));
        }
    }

    private List<OrderSkuCostDetailDto> toOrderSkuCostDetails(DgPerformOrderInfoEo order, DgPerformOrderSnapshotEo snapshot, DgPerformOrderPaymentEo payment, List<DgPerformOrderLineEo> items, List<Long> giftItemIds, Map<Long, List<DgPerformOrderLineAmountEo>> lineAmountMap, CostAllocRuleDto rule, TfOrderEo tfOrder) {
        if (!order.getDr().equals(0) || "CANCEL".equals(order.getCovertOrderStatus()) || "OBSOLETE".equals(order.getCovertOrderStatus())) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)payment.getPayTime()).toLocalDate());
            return Collections.emptyList();
        }
        return items.stream().map(item -> {
            DgShopRespDto shop;
            List amounts = lineAmountMap.getOrDefault(item.getId(), Collections.emptyList());
            BigDecimal realPayAmount = amounts.stream().filter(s -> DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode().equals(s.getAccountType())).findAny().map(DgPerformOrderLineAmountEo::getAmount).orElse(BigDecimal.ZERO);
            OrderSkuCostDetailDto dto = new OrderSkuCostDetailDto();
            dto.setBizTime(payment.getPayTime()).setSourceType(Integer.valueOf(4)).setSourceId(order.getId()).setArchiveCode(rule.getArchiveCode()).setArchiveName(rule.getArchiveName()).setCategoryCode(rule.getCategoryCode()).setCategoryName(rule.getCategoryName()).setRuleType(rule.getRuleType()).setRuleCode(rule.getRuleCode()).setRuleName(rule.getRuleName()).setBizAmount(realPayAmount).setPlatformOrderNo(Optional.ofNullable(order.getPlatformOrderNo()).orElse("")).setCovertOrderStatus((String)Optional.ofNullable(tfOrder).map(TfOrderEo::getCovertOrderStatus).orElse(null)).setShopId(snapshot.getShopId()).setShopCode(snapshot.getShopCode()).setShopName(snapshot.getShopName()).setShopWebsiteId(snapshot.getSiteId()).setShopWebsiteCode(snapshot.getSiteCode()).setShopWebsiteName(snapshot.getSiteName()).setItemId(item.getItemId()).setItemCode(item.getItemCode()).setItemName(item.getItemName()).setItemNum(Integer.valueOf(item.getItemNum().intValue())).setSkuId(item.getSkuId()).setSkuCode(item.getSkuCode()).setSkuName(item.getSkuName()).setGift(Integer.valueOf(giftItemIds.contains(item.getId()) ? 1 : 0)).setOrderGoodsTotalAmount(order.getGoodsTotalAmount()).setOrderDiscountTotalAmount(order.getDiscountAmount()).setOrderMerchantReceivableAmount(order.getMerchantReceivableAmount()).setSkuPaymentAmount(realPayAmount).setSkuDiscountAmount(Optional.ofNullable(item.getCouponDiscountAmount()).orElse(BigDecimal.ZERO)).setSkuRealPayAmount(realPayAmount).setSkuRefundAmount(BigDecimal.ZERO).setSkuTaxCostPrice(this.getSkuTaxCostPrice(item.getSkuCode())).setSkuTaxCostAmount(dto.getSkuTaxCostPrice().multiply(BigDecimal.valueOf(Optional.ofNullable(dto.getItemNum()).orElse(1).intValue()))).setOrderPayTime(payment.getPayTime()).setSourceUpdateTime(order.getUpdateTime());
            SkuInfoDto sku = this.getSkuInfo(item.getSkuCode());
            if (sku != null) {
                dto.setDirId(sku.getDirId()).setDirCode(sku.getDirCode()).setDirName(sku.getDirName()).setSkuId(sku.getId()).setSkuName(sku.getSkuName());
            }
            if ((shop = this.getShop(dto.getShopCode())) != null) {
                dto.setShopName(shop.getStoreName()).setShopWebsiteId(shop.getChannelId()).setShopWebsiteCode(shop.getChannelCode()).setShopWebsiteName(shop.getChannelName());
            }
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)dto.getBizTime()).toLocalDate());
            return dto;
        }).collect(Collectors.toList());
    }

    private void cacheSkuCost(Set<String> skuCodes) {
        Map<String, SkuCostDto> map = this.getSkuCostCache();
        HashSet<String> allKeys = new HashSet<String>(skuCodes);
        allKeys.removeAll(map.keySet());
        if (allKeys.isEmpty()) {
            return;
        }
        Map<String, SkuCostDto> skuMap = this.skuCostService.getSkuCostMap(allKeys);
        map.putAll(skuMap);
    }

    private Map<String, SkuCostDto> getSkuCostCache() {
        return (Map)cache.get().get(CACHE_KEY_SKU_COSTS);
    }

    private BigDecimal getSkuTaxCostPrice(String skuCode) {
        SkuCostDto dto = this.getSkuCostCache().get(skuCode);
        if (dto == null || dto.getCostPrice() == null) {
            return BigDecimal.ZERO;
        }
        return dto.getCostPrice();
    }

    private SkuInfoDto getSkuInfo(String skuCode) {
        return this.getSkuCache().get(skuCode);
    }

    private Map<String, SkuInfoDto> getSkuCache() {
        return (Map)cache.get().get(CACHE_KEY_SKUS);
    }

    private void cacheSkuInfo(Set<String> skuCodes) {
        Map<String, SkuInfoDto> map = this.getSkuCache();
        HashSet<String> allKeys = new HashSet<String>(skuCodes);
        allKeys.removeAll(map.keySet());
        if (allKeys.isEmpty()) {
            return;
        }
        Map<String, SkuInfoDto> skuMap = this.itemSkuDgService.getSkuInfoMap(allKeys);
        map.putAll(skuMap);
    }

    private List<OrderSkuCostDetailDto> toOrderSkuCostDetails(TfOrderEo order, List<TfOrderItemEo> items, CostAllocRuleDto rule, boolean ignoreCancel) {
        if (!ignoreCancel && (!order.getDr().equals(0) || "UNPAID".equals(order.getCovertOrderStatus()) || "CANCEL".equals(order.getCovertOrderStatus()))) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getPayTime()).toLocalDate());
            return Collections.emptyList();
        }
        return items.stream().map(item -> {
            DgShopRespDto shop;
            OrderSkuCostDetailDto dto = new OrderSkuCostDetailDto();
            dto.setBizTime(order.getPayTime()).setSourceType(Integer.valueOf(1)).setSourceId(order.getId()).setArchiveCode(rule.getArchiveCode()).setArchiveName(rule.getArchiveName()).setCategoryCode(rule.getCategoryCode()).setCategoryName(rule.getCategoryName()).setRuleType(rule.getRuleType()).setRuleCode(rule.getRuleCode()).setRuleName(rule.getRuleName()).setBizAmount(item.getRealPayAmount()).setPlatformOrderNo(Optional.ofNullable(order.getPlatformOrderNo()).orElse("")).setCovertOrderStatus(order.getCovertOrderStatus()).setShopId(order.getShopId()).setShopCode(order.getShopCode()).setShopName(order.getShopName()).setShopWebsiteId(order.getShopWebsiteId()).setShopWebsiteCode(order.getShopWebsiteCode()).setShopWebsiteName(order.getShopWebsite()).setItemId(item.getItemId()).setItemCode(item.getItemCode()).setItemName(item.getItemName()).setItemNum(item.getItemNum()).setSkuId(item.getSkuId()).setSkuCode(item.getSkuCode()).setSkuName(item.getSkuName()).setGift(item.getGift()).setOrderGoodsTotalAmount(order.getGoodsTotalAmount()).setOrderDiscountTotalAmount(order.getDiscountTotalAmount()).setOrderMerchantReceivableAmount(order.getMerchantReceivableAmount()).setSkuPaymentAmount(item.getPaymentAmount()).setSkuDiscountAmount(item.getDiscountAmount()).setSkuRealPayAmount(item.getRealPayAmount()).setSkuRefundAmount(BigDecimal.ZERO).setSkuTaxCostPrice(this.getSkuTaxCostPrice(item.getSkuCode())).setSkuTaxCostAmount(dto.getSkuTaxCostPrice().multiply(BigDecimal.valueOf(Optional.ofNullable(dto.getItemNum()).orElse(1).intValue()))).setOrderPayTime(order.getPayTime()).setSourceUpdateTime(order.getUpdateTime());
            SkuInfoDto sku = this.getSkuInfo(item.getSkuCode());
            if (sku != null) {
                dto.setDirId(sku.getDirId()).setDirCode(sku.getDirCode()).setDirName(sku.getDirName()).setSkuId(sku.getId()).setSkuName(sku.getSkuName());
            }
            if ((shop = this.getShop(dto.getShopCode())) != null) {
                dto.setShopName(shop.getStoreName()).setShopWebsiteId(shop.getChannelId()).setShopWebsiteCode(shop.getChannelCode()).setShopWebsiteName(shop.getChannelName());
            }
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)dto.getBizTime()).toLocalDate());
            return dto;
        }).collect(Collectors.toList());
    }

    private void doSyncAfterManualSaleOrders(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        int pageNum = 1;
        int pageSize = 1000;
        ArrayList afterSaleOrderTypes = Lists.newArrayList((Object[])new String[]{"JTK", "FHHTK", "THTK"});
        String bizModel = "B2C";
        do {
            PageInfo page = this.afterSaleOrderDas.pageByUpdateTimeWithoutDr(startTime, endTime, pageNum, pageSize);
            log.info("\u7ecf\u8425\u5206\u6790-\u552e\u540e\u8ba2\u5355: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List<DgAfterSaleOrderEo> list = page.getList().stream().filter(eo -> bizModel.equals(eo.getBizModel()) && afterSaleOrderTypes.contains(eo.getAfterSaleOrderType()) && Objects.equals(eo.getOrderSource(), 0)).collect(Collectors.toList());
            this.doSyncAfterManualSaleOrders(list);
        } while (hasNextPage);
    }

    private void doSyncAfterManualSaleOrders(List<DgAfterSaleOrderEo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<Long> orderIds = new ArrayList<Long>();
        HashSet<String> snSet = new HashSet<String>();
        HashSet<String> shopCodes = new HashSet<String>();
        HashSet<String> platformOrderNos = new HashSet<String>();
        for (DgAfterSaleOrderEo eo : list) {
            orderIds.add(eo.getId());
            if (StringUtils.isNotBlank((CharSequence)eo.getPlatformRefundOrderSn())) {
                snSet.add(eo.getPlatformRefundOrderSn());
            }
            platformOrderNos.add(eo.getPlatformOrderNo());
            shopCodes.add(eo.getShopCode());
        }
        List allItems = this.afterSaleOrderItemDas.selectByAfterOrderIds(orderIds);
        HashMap<Long, List> group = new HashMap<Long, List>();
        HashSet<String> skuCodes = new HashSet<String>();
        for (DgAfterSaleOrderItemEo item : allItems) {
            List tmp = group.computeIfAbsent(item.getAfterSaleOrderId(), k -> new ArrayList());
            tmp.add(item);
            skuCodes.add(item.getSkuCode());
        }
        this.cacheSkuInfo(skuCodes);
        this.cacheSkuCost(skuCodes);
        this.cacheShop(shopCodes);
        List<CostAllocRuleDto> rules = this.getRuleCache();
        List tfOrders = this.tfOrderDas.queryByPlatformOrderNos(platformOrderNos);
        Map<String, TfOrderEo> tfOrderMap = tfOrders.stream().collect(Collectors.toMap(TfOrderEo::getPlatformOrderNo, v -> v, (a, b) -> b));
        List details = list.stream().flatMap(afterSaleOrder -> {
            if (afterSaleOrder.getCreateTime() == null) {
                log.warn("\u7ecf\u8425\u5206\u6790\uff1a\u552e\u540e\u624b\u5de5\u5355 {} \u627e\u4e0d\u5230\u652f\u4ed8\u65f6\u95f4", (Object)afterSaleOrder.getAfterSaleOrderNo());
                return Stream.empty();
            }
            TfOrderEo tfOrder = (TfOrderEo)tfOrderMap.get(afterSaleOrder.getPlatformOrderNo());
            List items = group.getOrDefault(afterSaleOrder.getId(), Collections.emptyList());
            List<CostAllocRuleDto> selectedRules = this.selectRules(rules, afterSaleOrder.getShopCode(), afterSaleOrder.getCreateTime());
            if (selectedRules.isEmpty()) {
                log.info("\u7ecf\u8425\u5206\u6790\uff1a\u552e\u540e\u624b\u5de5\u5355 {} \u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u5206\u644a\u89c4\u5219\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58", (Object)afterSaleOrder.getAfterSaleOrderNo());
                return Stream.empty();
            }
            log.info("\u7ecf\u8425\u5206\u6790\uff1a\u552e\u540e\u624b\u5de5\u5355 {} \u5339\u914d\u5230\u4ee5\u4e0b\u5206\u644a\u89c4\u5219\uff1a{}", (Object)afterSaleOrder.getAfterSaleOrderNo(), (Object)JacksonUtil.toJson(selectedRules));
            return selectedRules.stream().flatMap(k -> this.toOrderSkuCostDetails((DgAfterSaleOrderEo)afterSaleOrder, items, (CostAllocRuleDto)k, tfOrder).stream());
        }).collect(Collectors.toList());
        this.orderSkuCostDetailDas.physicalDeleteBySourceIds(5, orderIds);
        if (!details.isEmpty()) {
            ((IOrderSkuCostDetailDomain)this.domain).insertBatch(OrderSkuCostDetailConverter.INSTANCE.toEoList(details));
        }
    }

    private Map<String, String> getRefundStatusMap(Set<String> snSet) {
        HashMap<String, String> refundStatusMap = new HashMap<String, String>();
        if (snSet.isEmpty()) {
            return refundStatusMap;
        }
        ArrayList<String> snList = new ArrayList<String>(snSet);
        List tfOrderRefunds = this.tfOrderRefundDas.queryByPlatformRefundOrderSnList(snList);
        List tfOrderReturnRefunds = this.tfOrderReturnRefundDas.queryByPlatformRefundOrderSnList(snList);
        for (TfOrderRefundEo refund : tfOrderRefunds) {
            if (!StringUtils.isNotBlank((CharSequence)refund.getPlatformRefundOrderSn())) continue;
            refundStatusMap.put(refund.getPlatformRefundOrderSn(), refund.getRefundStatus());
        }
        for (TfOrderRefundEo refund : tfOrderReturnRefunds) {
            if (!StringUtils.isNotBlank((CharSequence)refund.getPlatformRefundOrderSn())) continue;
            refundStatusMap.put(refund.getPlatformRefundOrderSn(), refund.getRefundStatus());
        }
        return refundStatusMap;
    }

    private List<OrderSkuCostDetailDto> toOrderSkuCostDetails(DgAfterSaleOrderEo order, List<DgAfterSaleOrderItemEo> items, CostAllocRuleDto rule, TfOrderEo tfOrder) {
        if (tfOrder != null && Objects.equals(tfOrder.getCovertOrderStatus(), "CANCEL")) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getPlatformCreated()).toLocalDate());
            return Collections.emptyList();
        }
        if (!order.getDr().equals(0) || !"3".equals(order.getRefundStatus())) {
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)order.getCreateTime()).toLocalDate());
            return Collections.emptyList();
        }
        return items.stream().map(item -> {
            DgShopRespDto shop;
            OrderSkuCostDetailDto dto = new OrderSkuCostDetailDto();
            dto.setBizTime(order.getCreateTime()).setSourceType(Integer.valueOf(5)).setSourceId(order.getId()).setArchiveCode(rule.getArchiveCode()).setArchiveName(rule.getArchiveName()).setCategoryCode(rule.getCategoryCode()).setCategoryName(rule.getCategoryName()).setRuleType(rule.getRuleType()).setRuleCode(rule.getRuleCode()).setRuleName(rule.getRuleName()).setBizAmount(Optional.ofNullable(item.getRefundAmount()).orElse(BigDecimal.ZERO).negate()).setPlatformOrderNo(Optional.ofNullable(order.getPlatformOrderNo()).orElse("")).setPlatformRefundOrderSn(order.getPlatformRefundOrderSn()).setCovertOrderStatus((String)Optional.ofNullable(tfOrder).map(TfOrderEo::getCovertOrderStatus).orElse(null)).setAfterSaleOrderNo(order.getAfterSaleOrderNo()).setAfterSaleStatus(order.getStatus()).setShopId(order.getShopId()).setShopCode(order.getShopCode()).setShopName(order.getShopName()).setShopWebsiteId(order.getShopWebsiteId()).setShopWebsiteCode(order.getShopWebsiteCode()).setShopWebsiteName(order.getShopWebsite()).setItemId(item.getItemId()).setItemCode(item.getItemCode()).setItemName(item.getItemName()).setItemNum(Integer.valueOf(item.getItemNum().intValue())).setSkuId(item.getSkuId()).setSkuCode(item.getSkuCode()).setSkuName(item.getSkuName()).setGift(item.getGift()).setSkuDiscountAmount(BigDecimal.ZERO).setSkuPaymentAmount(item.getPayAmount()).setSkuRealPayAmount(item.getRealPayAmount()).setSkuRefundAmount(item.getRefundAmount()).setSkuTaxCostPrice(this.getSkuTaxCostPrice(item.getSkuCode())).setSkuTaxCostAmount(dto.getSkuTaxCostPrice().multiply(BigDecimal.valueOf(Optional.ofNullable(dto.getItemNum()).orElse(1).intValue()))).setAfterSaleTime(order.getCompleteDate()).setRefundTime(order.getCompleteDate()).setSourceUpdateTime(order.getUpdateTime());
            SkuInfoDto sku = this.getSkuInfo(item.getSkuCode());
            if (sku != null) {
                dto.setDirId(sku.getDirId()).setDirCode(sku.getDirCode()).setDirName(sku.getDirName()).setSkuId(sku.getId()).setSkuName(sku.getSkuName());
            }
            if ((shop = this.getShop(dto.getShopCode())) != null) {
                dto.setShopName(shop.getStoreName()).setShopWebsiteId(shop.getChannelId()).setShopWebsiteCode(shop.getChannelCode()).setShopWebsiteName(shop.getChannelName());
            }
            this.cacheDate(rule, DateUtil.toLocalDateTime((Date)dto.getBizTime()).toLocalDate());
            return dto;
        }).collect(Collectors.toList());
    }

    private List<CostAllocRuleDto> selectRules(List<CostAllocRuleDto> rules, String shopCode, Date time) {
        return rules.stream().filter(s -> s.match(shopCode, time)).collect(Collectors.toList());
    }

    private void cacheDate(CostAllocRuleDto rule, LocalDate date) {
        Set set = this.getUsedRuleCache().computeIfAbsent(rule, k -> new HashSet());
        set.add(date);
    }

    @Override
    public String syncWithParamsByAsync(ReportSyncReqDto dto) {
        OrderSkuCostAsyncResultDto task = this.newTask().cache();
        String reqId = Optional.ofNullable(ServiceContext.getContext().getRequestId()).orElse(RequestId.createReqId());
        this.executor.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            this.syncWithParams(dto, task);
        });
        return task.getTaskId();
    }

    @Override
    public OrderSkuCostAsyncResultDto getTaskInfo(String taskId) {
        String cacheKey = OrderSkuCostAsyncResultDto.getCacheKey((String)taskId);
        return (OrderSkuCostAsyncResultDto)this.cacheService.getCache(cacheKey, OrderSkuCostAsyncResultDto.class);
    }
}

