/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockCountDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockReportDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockTypeDto;
import com.yunxi.dg.base.center.report.service.entity.IPurchaseSaleStockReportService;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import com.yunxi.dg.base.poi.utils.SystemConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_purchase_sale_stock_report")
public class PurchaseSaleStockReportFileService
extends AbstractBaseFileOperationCommonService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSaleStockReportFileService.class);
    @Resource
    private IPurchaseSaleStockReportService service;

    public void afterPropertiesSet() throws Exception {
        String key = "purchase_sale_stock_report";
        PoiFileModeMap.importTemplateMap.put((Object)key, ImportBaseModeDto.class);
        PoiFileModeMap.importTemplateMap.put((Object)key, (Object)1);
        PoiFileModeMap.importTemplateMap.put((Object)key, (Object)"\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868");
        PoiFileModeMap.exportTemplateMap.put((Object)key, ExportBaseModeDto.class);
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)2);
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)"\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868");
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)"\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa");
    }

    public String uploadExportDataFile(ExportQueryParamsReqDto exportQueryParamsReqDto, String fileName, Class<? extends ExportBaseModeDto> exportTemplate) {
        int RETRY_MAX_COUNT = Integer.parseInt(SystemConfig.getProperty((String)"base.mgmt.export.retry.max.count", (String)"3"));
        PurchaseSaleStockReportPageReqDto req = (PurchaseSaleStockReportPageReqDto)JSONUtil.toBean((String)exportQueryParamsReqDto.getFilter(), PurchaseSaleStockReportPageReqDto.class);
        ArrayList<PurchaseSaleStockReportDto> list = new ArrayList<PurchaseSaleStockReportDto>();
        int pageNum = 1;
        req.setPageSize(Integer.valueOf(1000));
        boolean hasNextPage = false;
        do {
            int count = 0;
            req.setPageNum(Integer.valueOf(pageNum));
            while (count < RETRY_MAX_COUNT) {
                try {
                    PageInfo<PurchaseSaleStockReportDto> page = this.service.pageWithoutAlign(req);
                    log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875\uff0c\u91cd\u8bd5\u6b21\u6570 {}", new Object[]{pageNum, page.getSize(), page.getPages(), count});
                    if (page.getList() != null && !page.getList().isEmpty()) {
                        list.addAll(page.getList());
                    }
                    hasNextPage = page.isHasNextPage();
                    count = RETRY_MAX_COUNT + 1;
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u8fdb\u884c\u91cd\u8bd5\uff0c\u76ee\u524d\u91cd\u8bd5\u7684\u6b21\u6570={}", (Object)(++count), (Object)e);
                    if (count < RETRY_MAX_COUNT) continue;
                    throw new BizException("\u62c9\u53d6\u6570\u636e\u5931\u8d25\u4e86");
                }
            }
            ++pageNum;
        } while (!CollectionUtil.isEmpty(list) && hasNextPage);
        if (list.isEmpty()) {
            return null;
        }
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u5f00\u59cb\u5bf9\u9f50\u8fdb\u9500\u5b58\u7c7b\u578b");
        this.service.alignTypes(list);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u5bf9\u9f50\u8fdb\u9500\u5b58\u7c7b\u578b\u5b8c\u6210\uff0c\u51c6\u5907\u8f6c\u6210 Workbook");
        Workbook workbook = this.getWorkbook(list);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u8f6c\u6210 Workbook \u5b8c\u6210\uff0c\u51c6\u5907\u4e0a\u5230\u5bf9\u8c61\u5b58\u50a8");
        try {
            log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u5f00\u59cb\u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8");
            String url = EasyPoiExportUtil.getLoadWorkbookUrl((Workbook)workbook, (String)exportQueryParamsReqDto.getExportFileName());
            log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8\u6210\u529f\uff0curl={}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private Workbook getWorkbook(List<PurchaseSaleStockReportDto> list) {
        ExcelWriter writer = ExcelUtil.getBigWriter();
        ArrayList primaryTitles = Lists.newArrayList((Object[])new String[]{"\u65f6\u95f4\u8303\u56f4", "\u5e8f\u53f7", "\u6cd5\u4eba", "\u4ea7\u54c1\u7ebf", "\u578b\u53f7", "\u7269\u6599\u7c7b\u578b", "\u903b\u8f91\u4ed3"});
        LinkedHashMap<String, List> secondTitleMap = new LinkedHashMap<String, List>();
        secondTitleMap.put("\u671f\u521d", Lists.newArrayList((Object[])new String[]{"\u6570\u91cf", "\u51fa\u5382\u4ef7", "\u91d1\u989d"}));
        List<PurchaseSaleStockTypeDto> typeList = this.service.getPurchaseSaleStockTypeList();
        Map<String, List<PurchaseSaleStockTypeDto>> group = typeList.stream().collect(Collectors.groupingBy(PurchaseSaleStockTypeDto::getOrderType));
        List inTypes = group.getOrDefault("in", new ArrayList(0));
        List inTitles = inTypes.stream().map(PurchaseSaleStockTypeDto::getName).collect(Collectors.toList());
        inTitles.add("\u5165\u5e93\u5408\u8ba1");
        secondTitleMap.put("\u5165\u5e93", inTitles);
        List outTypes = group.getOrDefault("out", new ArrayList(0));
        List outTitles = outTypes.stream().map(PurchaseSaleStockTypeDto::getName).collect(Collectors.toList());
        outTitles.add("\u51fa\u5e93\u5408\u8ba1");
        secondTitleMap.put("\u51fa\u5e93", outTitles);
        secondTitleMap.put("\u671f\u672b", Lists.newArrayList((Object[])new String[]{"\u6570\u91cf", "\u51fa\u5382\u4ef7", "\u91d1\u989d"}));
        AtomicInteger col = new AtomicInteger(0);
        primaryTitles.forEach(title -> {
            int firstColumn = col.get();
            int lastColumn = col.addAndGet(1) - 1;
            writer.merge(0, 1, firstColumn, lastColumn, title, true);
        });
        ArrayList secondTitles = new ArrayList();
        secondTitleMap.forEach((title, values) -> {
            writer.merge(0, 0, col.get(), col.addAndGet(values.size()) - 1, title, true);
            secondTitles.addAll(values);
        });
        writer.setCurrentRow(1);
        writer.writeSecHeadRow(secondTitles);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u5199\u5165\u6807\u9898\u5230 Workbook \u5b8c\u6210\uff0c\u51c6\u5907\u5199\u5165 {} \u6761\u6570\u636e", (Object)list.size());
        AtomicInteger index = new AtomicInteger(0);
        list.forEach(item -> {
            ArrayList row = Lists.newArrayList((Object[])new Object[]{this.toEmpty(item.getBusinessDateRange()), index.addAndGet(1), this.toEmpty(item.getSalesCompanyName()), this.toEmpty(item.getSerialName()), this.toEmpty(item.getSkuCode()), this.toEmpty(item.getItemClassName()), this.toEmpty(item.getWarehouseName())});
            row.add(this.plan(item.getOpeningStorageQty()));
            row.add(this.plan(item.getRetailPrice()));
            row.add(this.plan(item.getOpeningStorageAmt()));
            row.addAll(this.typesToCells(item.getInList(), inTypes));
            row.add(this.plan(item.getInTotalQty()));
            row.addAll(this.typesToCells(item.getOutList(), outTypes));
            row.add(this.plan(item.getOutTotalQty()));
            row.add(this.plan(item.getEndStorageQty()));
            row.add(this.plan(item.getRetailPrice()));
            row.add(this.plan(item.getEndStorageAmt()));
            writer.writeRow((Iterable)row);
        });
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa: \u5199\u5165 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
        return writer.getWorkbook();
    }

    private List<String> typesToCells(List<PurchaseSaleStockCountDto> inList, List<PurchaseSaleStockTypeDto> types) {
        Map<String, PurchaseSaleStockCountDto> map = inList.stream().collect(Collectors.toMap(k -> k.getType(), v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684\u8fdb\u9500\u5b58\u7f16\u7801\uff1aa={}, b={}", a, b);
            return b;
        }));
        return types.stream().map(type -> {
            PurchaseSaleStockCountDto count = (PurchaseSaleStockCountDto)map.get(type.getCode());
            return this.plan(count != null ? count.getQuantity() : BigDecimal.ZERO);
        }).collect(Collectors.toList());
    }

    private String toEmpty(String value) {
        return value == null ? "" : value;
    }

    private String plan(BigDecimal value) {
        if (value == null) {
            return "";
        }
        return value.stripTrailingZeros().toPlainString();
    }
}

