/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.SkuSaleStatisticsReportConverter;
import com.yunxi.dg.base.center.report.domain.entity.ISkuSaleStatisticsReportDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuSaleStatisticsReportDto;
import com.yunxi.dg.base.center.report.eo.SkuSaleStatisticsReportEo;
import com.yunxi.dg.base.center.report.eo.item.ItemSkuDgEo;
import com.yunxi.dg.base.center.report.service.entity.ISkuSaleStatisticsReportService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SkuSaleStatisticsReportServiceImpl
extends BaseServiceImpl<SkuSaleStatisticsReportDto, SkuSaleStatisticsReportEo, ISkuSaleStatisticsReportDomain>
implements ISkuSaleStatisticsReportService {
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    private static final int PAGE_SIZE = 1000;

    public SkuSaleStatisticsReportServiceImpl(ISkuSaleStatisticsReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SkuSaleStatisticsReportDto, SkuSaleStatisticsReportEo> converter() {
        return SkuSaleStatisticsReportConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddSkuSaleStatisticsReport(List<DgOrderDetailReportDto> orderDetailReportDtoList) {
        Set ids;
        List statisticsReportEoList;
        SkuSaleStatisticsReportEo statisticsReportEo = new SkuSaleStatisticsReportEo();
        statisticsReportEo.setDr(0);
        int page = 1;
        ArrayList statisticsReportEos = Lists.newArrayList();
        while (!CollUtil.isEmpty((Collection)(statisticsReportEoList = ((ISkuSaleStatisticsReportDomain)this.domain).selectList((BaseEo)statisticsReportEo, Integer.valueOf(page), Integer.valueOf(1000))))) {
            ++page;
            statisticsReportEos.addAll(statisticsReportEoList);
        }
        if (CollectionUtil.isNotEmpty((Collection)statisticsReportEos) && CollectionUtil.isNotEmpty(ids = statisticsReportEos.stream().map(BaseEo::getId).collect(Collectors.toSet()))) {
            ((ISkuSaleStatisticsReportDomain)this.domain).batchDelete((List)Lists.newArrayList(ids));
        }
        Set skuCodeList = orderDetailReportDtoList.stream().map(DgOrderDetailReportDto::getSkuCode).collect(Collectors.toSet());
        List itemSkuDgEoList = this.itemSkuDgDomain.selectByCodes(skuCodeList);
        Map itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (v1, v2) -> v1));
        ArrayList skuSaleStatisticsReportEoList = Lists.newArrayList();
        for (DgOrderDetailReportDto dgOrderDetailReportDto : orderDetailReportDtoList) {
            SkuSaleStatisticsReportEo skuSaleStatisticsReportEo = new SkuSaleStatisticsReportEo();
            skuSaleStatisticsReportEo.setSkuCode(dgOrderDetailReportDto.getSkuCode());
            skuSaleStatisticsReportEo.setShopId(dgOrderDetailReportDto.getShopId());
            skuSaleStatisticsReportEo.setShopCode(dgOrderDetailReportDto.getShopCode());
            skuSaleStatisticsReportEo.setSalesStatistics(dgOrderDetailReportDto.getDeliveredNum());
            if (itemSkuDgEoMap.containsKey(dgOrderDetailReportDto.getSkuCode())) {
                skuSaleStatisticsReportEo.setSkuId(((ItemSkuDgEo)itemSkuDgEoMap.get(dgOrderDetailReportDto.getSkuCode())).getId());
                skuSaleStatisticsReportEo.setItemId(((ItemSkuDgEo)itemSkuDgEoMap.get(dgOrderDetailReportDto.getSkuCode())).getItemId());
            }
            skuSaleStatisticsReportEoList.add(skuSaleStatisticsReportEo);
        }
        ((ISkuSaleStatisticsReportDomain)this.domain).insertBatch((List)skuSaleStatisticsReportEoList);
    }
}

