/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgLogicInventoryConverter;
import com.yunxi.dg.base.center.report.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.report.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicInventoryDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgAllInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgAllInventoryReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgAllWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryBatchMonthPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryBatchMonthQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventorySumDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventorySumQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgQueryLogicInventoryPreemptReportDetailPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgQueryLogicInventoryPreemptReportPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgQueryLogicInventoryPreemptReportQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgReferBatchMonthInventoryRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgReferInventoryQueryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgReferInventoryRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.RelInventoryBatchTagDto;
import com.yunxi.dg.base.center.report.dto.item.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicInventoryEo;
import com.yunxi.dg.base.center.report.service.enums.ProductStatusEnum;
import com.yunxi.dg.base.center.report.service.enums.WarehouseTypeEnum;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicInventoryService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgLogicInventoryServiceImpl
extends BaseServiceImpl<DgLogicInventoryDto, DgLogicInventoryEo, IDgLogicInventoryDomain>
implements IDgLogicInventoryService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgLogicInventoryServiceImpl.class);
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    String tableName = "cs_logic_inventory";
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;

    public DgLogicInventoryServiceImpl(IDgLogicInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgLogicInventoryDto, DgLogicInventoryEo> converter() {
        return DgLogicInventoryConverter.INSTANCE;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }

    @Override
    public RestResponse<List<DgLogicInventoryDto>> queryList(DgLogicInventoryListReqDto reqDto) {
        List logicInventoryDtoList = ((IDgLogicInventoryDomain)this.domain).queryList(reqDto);
        List<Long> inventoryBatchIdList = Optional.ofNullable(logicInventoryDtoList.stream().map(DgLogicInventoryDto::getInventoryBatchId).collect(Collectors.toList())).orElse(Arrays.asList(new Long[0]));
        List relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().in(CollectionUtils.isNotEmpty(inventoryBatchIdList), (Object)"inventory_batch_id", inventoryBatchIdList)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        List relInventoryBatchTagDtoList = BeanUtil.copyToList((Collection)relInventoryBatchTagEoList, RelInventoryBatchTagDto.class);
        Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryDtoList)) {
            logicInventoryDtoList.forEach(o -> {
                if (relInventoryBatchTagEoMap.containsKey(o.getInventoryBatchId())) {
                    o.setExpiryDateTagList((List)relInventoryBatchTagEoMap.get(o.getInventoryBatchId()));
                }
                if (ObjectUtils.isNotEmpty((Object)o.getExpireTime())) {
                    o.setExpired(DgLogicInventoryServiceImpl.expiredDay(o.getExpireTime()));
                }
            });
        }
        return new RestResponse((Object)logicInventoryDtoList);
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventoryDto>> queryBomPage(DgLogicInventoryListReqDto reqDto) {
        Assert.isTrue((reqDto.getLogicWarehouseCode() != null ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new RestResponse((Object)new PageInfo(((IDgLogicInventoryDomain)this.domain).queryBomList(reqDto)));
    }

    @Override
    public RestResponse<List<String>> queryBatchList(String warehouseCode, String skuCode) {
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).queryBatchList(warehouseCode, skuCode));
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventoryDto>> queryPage(DgLogicInventoryListReqDto filter) {
        PageInfo dgLogicInventoryDtoPageInfo;
        log.info("queryPageFilter\uff1a{}", (Object)JSON.toJSONString((Object)filter));
        if (StringUtils.isNotEmpty((CharSequence)filter.getSpecModel())) {
            ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
            itemDgReqDto.setSpecModel(filter.getSpecModel());
            List skuItemList = this.itemSkuDgDomain.queryList(itemDgReqDto);
            if (CollectionUtils.isEmpty((Collection)skuItemList)) {
                return new RestResponse((Object)new PageInfo());
            }
            List<String> querySkuCodes = Optional.ofNullable(skuItemList.stream().map(DgItemSkuRespVo::getSkuCode).collect(Collectors.toList())).orElse(Arrays.asList(new String[0]));
            if (CollectionUtils.isEmpty((Collection)filter.getSkuCodeList())) {
                filter.setSkuCodeList(querySkuCodes);
            } else {
                List queryList = filter.getSkuCodeList();
                queryList.addAll(querySkuCodes);
                filter.setSkuCodeList(queryList);
            }
        }
        PageHelper.startPage((int)filter.getPageNum(), (int)filter.getPageSize());
        filter.setSkuSubStatus(Optional.ofNullable(filter.getSkuSubStatus()).orElse(1));
        if (Objects.equals("summary", filter.getType())) {
            log.info("queryCountList");
            dgLogicInventoryDtoPageInfo = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryCountList(filter));
        } else if (Objects.equals(filter.getBatchType(), Boolean.FALSE)) {
            log.info("queryNoBatchList");
            dgLogicInventoryDtoPageInfo = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryNoBatchList(filter));
        } else {
            log.info("queryList");
            dgLogicInventoryDtoPageInfo = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryList(filter));
        }
        List<Long> inventoryBatchIdList = Optional.ofNullable(dgLogicInventoryDtoPageInfo.getList().stream().map(DgLogicInventoryDto::getInventoryBatchId).collect(Collectors.toList())).orElse(Arrays.asList(new Long[0]));
        List relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().in(CollectionUtils.isNotEmpty(inventoryBatchIdList), (Object)"inventory_batch_id", inventoryBatchIdList)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        List relInventoryBatchTagDtoList = BeanUtil.copyToList((Collection)relInventoryBatchTagEoList, RelInventoryBatchTagDto.class);
        Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
        List<String> skuCodeList = Optional.ofNullable(dgLogicInventoryDtoPageInfo.getList().stream().map(DgLogicInventoryDto::getSkuCode).collect(Collectors.toList())).orElse(Arrays.asList(new String[0]));
        ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
        itemDgReqDto.setSkuCodes(skuCodeList);
        List skuDgEos = this.itemSkuDgDomain.queryList(itemDgReqDto);
        Map<String, DgItemSkuRespVo> itemSkuDgEoMap = this.getItemSkuMap(skuDgEos);
        if (CollectionUtils.isNotEmpty((Collection)dgLogicInventoryDtoPageInfo.getList())) {
            dgLogicInventoryDtoPageInfo.getList().forEach(o -> {
                if (relInventoryBatchTagEoMap.containsKey(o.getInventoryBatchId())) {
                    o.setExpiryDateTagList((List)relInventoryBatchTagEoMap.get(o.getInventoryBatchId()));
                }
                if (ObjectUtils.isNotEmpty((Object)o.getExpireTime())) {
                    o.setExpired(DgLogicInventoryServiceImpl.expiredDay(o.getExpireTime()));
                }
                this.setScale((DgLogicInventoryDto)o);
                DgItemSkuRespVo itemSkuRespVo = (DgItemSkuRespVo)itemSkuDgEoMap.get(o.getSkuCode());
                if (itemSkuRespVo != null) {
                    o.setSkuName(itemSkuRespVo.getSkuName());
                    o.setSpecModel(itemSkuRespVo.getSpecModel());
                    o.setVolume(itemSkuRespVo.getVolume());
                    o.setVolumeUnit(itemSkuRespVo.getVolumeUnit());
                }
            });
        }
        return new RestResponse((Object)dgLogicInventoryDtoPageInfo);
    }

    private Map<String, DgItemSkuRespVo> getItemSkuMap(List<DgItemSkuRespVo> skuDgEos) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(skuDgEos)) {
            return map;
        }
        return skuDgEos.stream().collect(Collectors.toMap(DgItemSkuRespVo::getSkuCode, Function.identity(), (k1, k2) -> k2));
    }

    @Override
    public RestResponse<DgReferInventoryRespDto> queryReferInventory(DgReferInventoryQueryDto queryDto) {
        return null;
    }

    @Override
    public RestResponse<List<DgReferBatchMonthInventoryRespDto>> queryBatchMonthReferInventory(DgReferInventoryQueryDto queryDto) {
        return null;
    }

    @Override
    public RestResponse<List<DgLogicInventorySumDto>> querySumList(DgLogicInventorySumQueryDto reqDto) {
        return null;
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventorySumDto>> querySumPage(DgLogicInventorySumQueryDto reqDto) {
        return null;
    }

    @Override
    public RestResponse<PageInfo<DgLogicInventoryBatchMonthPageDto>> queryBatchMonthPage(DgLogicInventoryBatchMonthQueryDto reqDto) {
        return null;
    }

    @Override
    public RestResponse<PageInfo<DgQueryLogicInventoryPreemptReportPageDto>> queryLogicInventoryPreemptReport(DgQueryLogicInventoryPreemptReportQueryDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new RestResponse((Object)new PageInfo(((IDgLogicInventoryDomain)this.domain).queryLogicInventoryPreemptReport(reqDto)));
    }

    @Override
    public RestResponse<PageInfo<DgQueryLogicInventoryPreemptReportDetailPageDto>> queryLogicInventoryPreemptReportDetails(DgQueryLogicInventoryPreemptReportQueryDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        org.springframework.util.Assert.notNull((Object)reqDto.getType(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        org.springframework.util.Assert.notNull((Object)reqDto.getWarehouseCode(), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        org.springframework.util.Assert.notNull((Object)reqDto.getSkuCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo list = new PageInfo();
        switch (reqDto.getType()) {
            case "1": {
                list = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryDeliveryOrderPreemptWaitDetails(reqDto));
                break;
            }
            case "2": {
                list = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryDeliveryOrderPreemptAlreadyDetails(reqDto));
                break;
            }
            case "3": {
                list = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryReserveOrderPreemptDetails(reqDto));
                break;
            }
            case "4": {
                list = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryOtherOrderPreemptDetails(reqDto));
                break;
            }
            case "5": {
                list = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryTransferOrderPreemptDetails(reqDto));
                break;
            }
            case "6": {
                list = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryOtherStorageOrderPreemptDetails(reqDto));
                break;
            }
            default: {
                log.info("\u65e0\u6cd5\u5339\u914d\u7c7b\u578b");
            }
        }
        return new RestResponse((Object)list);
    }

    private static Integer expiredDay(Date expireTime) {
        if (Objects.isNull(expireTime)) {
            return null;
        }
        int day = DateUtil.getDifferDay((String)DateUtil.format((Date)expireTime), (String)DateUtil.format((Date)new Date()));
        if (day > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public RestResponse<PageInfo<DgAllInventoryDto>> queryAllPage(DgAllInventoryReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        PageInfo dgAllInventoryDtoPageInfo = new PageInfo(((IDgLogicInventoryDomain)this.domain).queryAllList(reqDto));
        List<Long> inventoryBatchIdList = Optional.ofNullable(dgAllInventoryDtoPageInfo.getList().stream().map(DgAllInventoryDto::getInventoryBatchId).collect(Collectors.toList())).orElse(Arrays.asList(new Long[0]));
        List relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().in(CollectionUtils.isNotEmpty(inventoryBatchIdList), (Object)"inventory_batch_id", inventoryBatchIdList)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        List relInventoryBatchTagDtoList = BeanUtil.copyToList((Collection)relInventoryBatchTagEoList, RelInventoryBatchTagDto.class);
        Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
        if (CollectionUtils.isNotEmpty((Collection)dgAllInventoryDtoPageInfo.getList())) {
            dgAllInventoryDtoPageInfo.getList().forEach(o -> {
                if (relInventoryBatchTagEoMap.containsKey(o.getInventoryBatchId())) {
                    o.setExpiryDateTagList((List)relInventoryBatchTagEoMap.get(o.getInventoryBatchId()));
                }
                o.setInventoryProperty(ProductStatusEnum.getNameByCode(o.getInventoryProperty()));
                if (ObjectUtils.isNotEmpty((Object)o.getExpireTime())) {
                    o.setExpired(DgLogicInventoryServiceImpl.expiredDay(o.getExpireTime()));
                }
                this.setScale((DgAllInventoryDto)o);
                this.setPieces((DgAllInventoryDto)o);
            });
        }
        return new RestResponse((Object)dgAllInventoryDtoPageInfo);
    }

    private void setPieces(DgAllInventoryDto o) {
        o.setBalancePieces(ObjectUtil.isNull((Object)o.getPackageNum()) ? null : BigDecimalUtils.divide((BigDecimal)o.getBalance(), (BigDecimal)BigDecimal.valueOf(o.getPackageNum().intValue()), (int)2));
        o.setAvailablePieces(ObjectUtil.isNull((Object)o.getPackageNum()) ? null : BigDecimalUtils.divide((BigDecimal)o.getAvailable(), (BigDecimal)BigDecimal.valueOf(o.getPackageNum().intValue()), (int)2));
        o.setPreemptPieces(ObjectUtil.isNull((Object)o.getPackageNum()) ? null : BigDecimalUtils.divide((BigDecimal)o.getPreempt(), (BigDecimal)BigDecimal.valueOf(o.getPackageNum().intValue()), (int)2));
        o.setFutureInPieces(ObjectUtil.isNull((Object)o.getPackageNum()) ? null : BigDecimalUtils.divide((BigDecimal)o.getFutureIn(), (BigDecimal)BigDecimal.valueOf(o.getPackageNum().intValue()), (int)2));
        o.setIntransitPieces(ObjectUtil.isNull((Object)o.getPackageNum()) ? null : BigDecimalUtils.divide((BigDecimal)o.getIntransit(), (BigDecimal)BigDecimal.valueOf(o.getPackageNum().intValue()), (int)2));
        o.setLockPieces(ObjectUtil.isNull((Object)o.getPackageNum()) ? null : BigDecimalUtils.divide((BigDecimal)o.getLockInventory(), (BigDecimal)BigDecimal.valueOf(o.getPackageNum().intValue()), (int)2));
    }

    private void setScale(DgAllInventoryDto o) {
        o.setBalance(ObjectUtil.isNull((Object)o.getBalance()) ? BigDecimal.ZERO : o.getBalance().setScale(0, 1));
        o.setPreempt(ObjectUtil.isNull((Object)o.getPreempt()) ? BigDecimal.ZERO : o.getPreempt().setScale(0, 1));
        o.setIntransit(ObjectUtil.isNull((Object)o.getIntransit()) ? BigDecimal.ZERO : o.getIntransit().setScale(0, 1));
        o.setFutureIn(ObjectUtil.isNull((Object)o.getFutureIn()) ? BigDecimal.ZERO : o.getFutureIn().setScale(0, 1));
        o.setAvailable(ObjectUtil.isNull((Object)o.getAvailable()) ? BigDecimal.ZERO : o.getAvailable().setScale(0, 1));
        o.setLockInventory(ObjectUtil.isNull((Object)o.getLockInventory()) ? BigDecimal.ZERO : o.getLockInventory().setScale(0, 1));
    }

    private void setScale(DgLogicInventoryDto o) {
        o.setBalance(ObjectUtil.isNull((Object)o.getBalance()) ? BigDecimal.ZERO : o.getBalance().setScale(0, 1));
        o.setPreempt(ObjectUtil.isNull((Object)o.getPreempt()) ? BigDecimal.ZERO : o.getPreempt().setScale(0, 1));
        o.setIntransit(ObjectUtil.isNull((Object)o.getIntransit()) ? BigDecimal.ZERO : o.getIntransit().setScale(0, 1));
        o.setFutureIn(ObjectUtil.isNull((Object)o.getFutureIn()) ? BigDecimal.ZERO : o.getFutureIn().setScale(0, 1));
        o.setAvailable(ObjectUtil.isNull((Object)o.getAvailable()) ? BigDecimal.ZERO : o.getAvailable().setScale(0, 1));
        o.setLockInventory(ObjectUtil.isNull((Object)o.getLockInventory()) ? BigDecimal.ZERO : o.getLockInventory().setScale(0, 1));
    }

    @Override
    public RestResponse<PageInfo<DgAllInventoryDto>> queryAllPageMain(DgAllInventoryReqDto reqDto) {
        if (this.esQuery.booleanValue()) {
            return this.getdgDgAllInventoryDtoPageEsList(reqDto);
        }
        return this.queryAllPage(reqDto);
    }

    @Override
    public RestResponse<List<DgAllWarehouseDto>> queryAllWarehouseList(DgAllWarehouseDto reqDto) {
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).queryAllWarehouseList(reqDto));
    }

    @Override
    public RestResponse<List<DgAllInventoryDto>> queryCompanyCodeList(DgAllInventoryReqDto reqDto) {
        return new RestResponse((Object)((IDgLogicInventoryDomain)this.domain).queryCompanyCodeList(reqDto));
    }

    @Override
    public RestResponse<PageInfo<DgAllWarehouseDto>> queryAllWarehousePage(DgAllWarehouseDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new RestResponse((Object)new PageInfo(((IDgLogicInventoryDomain)this.domain).queryAllWarehouseList(reqDto)));
    }

    @Override
    public RestResponse<List<DgLogicInventoryDto>> queryAll(DgLogicInventorySumQueryDto queryDto) {
        log.info("\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2queryAll\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        List logicInventoryEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgLogicInventoryDomain)this.domain).filter().in((Object)"warehouse_code", (Collection)queryDto.getLogicWarehouseCodeList())).in((Object)"sku_code", (Collection)queryDto.getSkuCodeList())).list();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryEoList)) {
            List dgLogicInventoryDtoList = BeanUtil.copyToList((Collection)logicInventoryEoList, DgLogicInventoryDto.class);
            return new RestResponse((Object)dgLogicInventoryDtoList);
        }
        return new RestResponse(new ArrayList());
    }

    private RestResponse<PageInfo<DgAllInventoryDto>> getdgDgAllInventoryDtoPageEsList(DgAllInventoryReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List allInventoryDtoList = searchResultVo.getDocValues(docValue -> {
                DgAllInventoryDto allInventoryDto = (DgAllInventoryDto)BeanUtil.copyProperties((Object)docValue, DgAllInventoryDto.class, (String[])new String[0]);
                allInventoryDto.setInventoryProperty(ProductStatusEnum.getNameByCode(allInventoryDto.getInventoryProperty()));
                allInventoryDto.setWarehouseType(WarehouseTypeEnum.getNameByCode(allInventoryDto.getWarehouseType()));
                return allInventoryDto;
            });
            pageInfo.setList(allInventoryDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return new RestResponse((Object)pageInfo);
    }

    private OSSearchVo initSearchVo(DgAllInventoryReqDto dto) throws Exception {
        String codeByName;
        FilterFieldVo filter;
        log.info("ES\u67e5\u91c7\u8d2d\u5355\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)dto);
        if (Objects.nonNull(dto.getSkuCode())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"skuCode", (String)dto.getSkuCode(), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"skuDisplayName", (String)dto.getSkuDisplayName(), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getSpuCode())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"spuCode", (String)dto.getSpuCode(), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getBatch())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"batch", (String)dto.getBatch(), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getWarehouseType())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            codeByName = WarehouseTypeEnum.getCodeByName(dto.getWarehouseType());
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"warehouseType", (String)codeByName, (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getInventoryProperty())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            codeByName = ProductStatusEnum.getCodeByName(dto.getInventoryProperty());
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"inventoryProperty", (String)codeByName, (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getWarehouseId())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"warehouseId", (String)(dto.getWarehouseId() + ""), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getWarehouseName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"warehouseName", (String)(dto.getWarehouseName() + ""), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getOrganizationName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"organizationName", (String)dto.getOrganizationName(), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getIsInventoryThanZero()) && dto.getIsInventoryThanZero().booleanValue()) {
            queryVo.addNonEqualFilter("preempt", "0");
            queryVo.addNonEqualFilter("balance", "0");
            queryVo.addNonEqualFilter("available", "0");
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u53c2\u6570\u5c01\u88c5\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }
}

