/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.entity.InventoryTakeStockOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IInventoryTakeStockOrderDomain;
import com.yunxi.dg.base.center.report.dto.adjustment.AdjustmentOrderDto;
import com.yunxi.dg.base.center.report.dto.agg.DgBasisOrderRelOrderInfoRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgRelOrderReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryTakeStockOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryTakeStockOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.item.UnitDgReqDto;
import com.yunxi.dg.base.center.report.dto.item.UnitDgRespDto;
import com.yunxi.dg.base.center.report.enums.InventoryTakeStockOrderBizTypeEnum;
import com.yunxi.dg.base.center.report.enums.InventoryTakeStockOrderItemTakeStockTypeEnum;
import com.yunxi.dg.base.center.report.enums.InventoryTakeStockOrderStatusEnum;
import com.yunxi.dg.base.center.report.eo.inventory.InventoryTakeStockOrderEo;
import com.yunxi.dg.base.center.report.service.adjustment.IAdjustmentOrderService;
import com.yunxi.dg.base.center.report.service.entity.IUnitDgService;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IInventoryTakeStockOrderService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InventoryTakeStockOrderServiceImpl
extends BaseServiceImpl<InventoryTakeStockOrderDto, InventoryTakeStockOrderEo, IInventoryTakeStockOrderDomain>
implements IInventoryTakeStockOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(InventoryTakeStockOrderServiceImpl.class);
    String inventoryTakeStockOrderTableName = "in_inventory_take_stock_order";
    String inventoryTakeStockOrderDetailTableName = "in_inventory_take_stock_order_item";
    private static final String[] ORDER_NOS = new String[]{"orderNo", "externalOrderNo"};
    @Resource
    private IAdjustmentOrderService adjustmentOrderService;
    @Resource
    private IUnitDgService unitDgService;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IAdjustmentOrderDomain adjustmentOrderDomain;

    public InventoryTakeStockOrderServiceImpl(IInventoryTakeStockOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryTakeStockOrderDto, InventoryTakeStockOrderEo> converter() {
        return InventoryTakeStockOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> queryByPage(InventoryTakeStockOrderPageReqDto dto) {
        PageInfo inventoryTakeStockOrderDtoPageInfo = new PageInfo();
        inventoryTakeStockOrderDtoPageInfo = this.esQuery != false ? this.getInventoryTakeStockOrderEsList(dto) : ((IInventoryTakeStockOrderDomain)this.domain).queryByPage(dto);
        this.setEnumDesc((PageInfo<InventoryTakeStockOrderDto>)inventoryTakeStockOrderDtoPageInfo);
        return new RestResponse((Object)inventoryTakeStockOrderDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> queryByItemPage(InventoryTakeStockOrderPageReqDto dto) {
        PageInfo inventoryTakeStockOrderDtoPageInfo = new PageInfo();
        inventoryTakeStockOrderDtoPageInfo = this.esQuery != false ? this.getInventoryTakeStockOrderDetailEsList(dto) : ((IInventoryTakeStockOrderDomain)this.domain).queryByItemPage(dto);
        this.setEnumDesc((PageInfo<InventoryTakeStockOrderDto>)inventoryTakeStockOrderDtoPageInfo);
        return new RestResponse((Object)inventoryTakeStockOrderDtoPageInfo);
    }

    @Override
    public RestResponse<List<DgBasisOrderRelOrderInfoRespDto>> connectedAdjustmentOrder(DgRelOrderReqDto dto) {
        List adjustmentOrderEos = ((ExtQueryChainWrapper)this.adjustmentOrderDomain.filter().eq((Object)"external_order_no", (Object)dto.getRelevanceNo())).list();
        return new RestResponse(adjustmentOrderEos.stream().map(adjustmentOrderEo -> {
            DgBasisOrderRelOrderInfoRespDto respDto = new DgBasisOrderRelOrderInfoRespDto();
            BeanUtil.copyProperties((Object)adjustmentOrderEo, (Object)respDto, (String[])new String[0]);
            respDto.setOrderNo(adjustmentOrderEo.getAdjustmentNo());
            respDto.setDocumentNo(adjustmentOrderEo.getAdjustmentNo());
            respDto.setOrderType("inventory_adjustment_order");
            respDto.setBusinessType(adjustmentOrderEo.getBusinessType());
            respDto.setOrderStatus(adjustmentOrderEo.getOrderStatus());
            respDto.setRelevanceNo(adjustmentOrderEo.getExternalOrderNo());
            respDto.setBizDate(DateUtil.format((Date)adjustmentOrderEo.getBizDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            return respDto;
        }).collect(Collectors.toList()));
    }

    private void setEnumDesc(PageInfo<InventoryTakeStockOrderDto> inventoryTakeStockOrderDtoPageInfo) {
        if (ObjectUtils.isNotEmpty(inventoryTakeStockOrderDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)inventoryTakeStockOrderDtoPageInfo.getList())) {
            List<String> orderNos = inventoryTakeStockOrderDtoPageInfo.getList().stream().map(InventoryTakeStockOrderDto::getOrderNo).distinct().collect(Collectors.toList());
            List<Object> adjustmentOrderDtos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(orderNos)) {
                adjustmentOrderDtos = this.adjustmentOrderService.queryByExternalOrderNos(orderNos);
            }
            List unitDgRespDtos = (List)RestResponseHelper.extractData(this.unitDgService.queryList(new UnitDgReqDto()));
            for (InventoryTakeStockOrderDto dto : inventoryTakeStockOrderDtoPageInfo.getList()) {
                UnitDgRespDto unitDgRespDto;
                AdjustmentOrderDto adjustmentOrderDto = adjustmentOrderDtos.stream().filter(o -> StringUtils.equals((CharSequence)o.getExternalOrderNo(), (CharSequence)dto.getOrderNo())).findFirst().orElse(null);
                if (ObjectUtils.isNotEmpty((Object)adjustmentOrderDto)) {
                    dto.setAdjustmentStatus(adjustmentOrderDto.getOrderStatus());
                    dto.setAdjustmentNo(adjustmentOrderDto.getAdjustmentNo());
                }
                if (CollectionUtils.isNotEmpty((Collection)unitDgRespDtos) && ObjectUtils.isNotEmpty((Object)(unitDgRespDto = (UnitDgRespDto)unitDgRespDtos.stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)dto.getUnit())).findFirst().orElse(null)))) {
                    dto.setUnitName(unitDgRespDto.getName());
                }
                dto.setBizTypeDesc(InventoryTakeStockOrderBizTypeEnum.getDescByCode((Integer)dto.getBizType()));
                dto.setOrderStatusDesc(InventoryTakeStockOrderStatusEnum.getDescByCode((String)dto.getOrderStatus()));
                dto.setTakeStockTypeDesc(InventoryTakeStockOrderItemTakeStockTypeEnum.getDescByCode((Integer)dto.getTakeStockType()));
            }
        }
    }

    private PageInfo<InventoryTakeStockOrderDto> getInventoryTakeStockOrderEsList(InventoryTakeStockOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inventoryTakeStockOrderTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                InventoryTakeStockOrderDto orderItemPageDto = (InventoryTakeStockOrderDto)BeanUtil.copyProperties((Object)docValue, InventoryTakeStockOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(InventoryTakeStockOrderPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u76d8\u70b9\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCodeList", (List)reqDto.getSkuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSpuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCodeList", (List)reqDto.getSpuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBatchs())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batchList", (List)reqDto.getBatchs())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInventoryPropertyList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"inventoryPropertyList", (List)reqDto.getInventoryPropertyList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(reqDto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayNameList", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u76d8\u70b9\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private PageInfo<InventoryTakeStockOrderDto> getInventoryTakeStockOrderDetailEsList(InventoryTakeStockOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inventoryTakeStockOrderDetailTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initDetailSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                InventoryTakeStockOrderDto orderItemPageDto = (InventoryTakeStockOrderDto)BeanUtil.copyProperties((Object)docValue, InventoryTakeStockOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initDetailSearchVo(InventoryTakeStockOrderPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u6536\u53d1\u5dee\u5f02\u5355\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCode", (List)reqDto.getSkuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSpuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCode", (List)reqDto.getSpuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBatchs())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batch", (List)reqDto.getBatchs())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInventoryPropertyList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"inventoryProperty", (List)reqDto.getInventoryPropertyList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(reqDto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayName", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u6536\u53d1\u5dee\u5f02\u5355\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

