/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DefaultConstants;
import com.yunxi.dg.base.center.report.dao.common.select.MultipartSelectGeneric;
import com.yunxi.dg.base.center.report.dto.agg.DgBusinessGoodsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.BaseQueryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPlanOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPlanOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryStatisticsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.utils.OrderUnitConverterDto;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.AbstractReportDataSearchServiceImpl;
import com.yunxi.dg.base.center.report.service.impl.inventory.utils.UnitConverUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="purchaseReportDataSearchService")
public class PurchaseReportDataSearchServiceImpl
extends AbstractReportDataSearchServiceImpl<DgPlanOrderPageReqDto, DgPlanOrderDetailDto> {
    private String[] overStatus = new String[]{"completed", "finish"};

    public PurchaseReportDataSearchServiceImpl() {
        this("in_plan_order", "m");
    }

    public PurchaseReportDataSearchServiceImpl(String tableName, String alias) {
        super(tableName, alias);
    }

    @Override
    public void wrap(List<DgPlanOrderDetailDto> resultList) {
        super.wrap(resultList);
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        Set<String> orderNos = resultList.stream().filter(x -> !StrUtil.equalsAny((CharSequence)x.getOrderStatus(), (CharSequence[])this.overStatus)).map(DgPlanOrderDetailDto::getOrderNo).collect(Collectors.toSet());
        Map<Long, InventoryStatisticsRespDto> processingQuantityOfTheDocumentMap = this.getProcessingQuantityOfTheDocument(orderNos, "dro_delivered", "rro_received");
        ArrayList convertList = new ArrayList();
        resultList.forEach(o -> {
            String extension = o.getExtension();
            JSONObject jsonObject = null;
            if (StringUtils.isNotEmpty((CharSequence)extension) && Objects.nonNull(jsonObject = JSONObject.parseObject((String)extension))) {
                o.setAuditRemark(jsonObject.getString("auditRemark"));
                o.setBuyRequisitionNo(jsonObject.getString("buyRequisitionNo"));
                o.setReserveOrderNo(jsonObject.getString("reserveOrderNo"));
                o.setPreProductionOrderNo(jsonObject.getString("preProductionOrderNo"));
            }
            if (StrUtil.equalsAny((CharSequence)o.getOrderStatus(), (CharSequence[])this.overStatus)) {
                o.setWaitQuantity(BigDecimal.ZERO);
            } else if (DefaultConstants.STATIC_STATUS_LIST.contains(o.getOrderStatus())) {
                o.setWaitQuantity(o.getPlanQuantity());
            } else {
                InventoryStatisticsRespDto detailEo = processingQuantityOfTheDocumentMap.getOrDefault(o.getId(), new InventoryStatisticsRespDto());
                OrderUnitConverterDto converDto = new OrderUnitConverterDto();
                BeanUtil.copyProperties((Object)o, (Object)converDto, (String[])new String[0]);
                converDto.setConvedUnit(true);
                converDto.setDocumentCode(o.getOrderNo());
                converDto.setPlanQuantity(null);
                converDto.setDoneQuantity(detailEo.getDoneQuantity());
                converDto.setConsumer(ver -> {
                    o.setDoneQuantity(ver.getDoneQuantity());
                    o.setWaitQuantity(BigDecimalUtils.subtract((BigDecimal)o.getPlanQuantity(), (BigDecimal)ver.getDoneQuantity()));
                });
                convertList.add(converDto);
            }
        });
        UnitConverUtils.unitConvertBatch(new ArrayList(convertList));
    }

    @Override
    public List<String> getExtFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("m.order_no as orderNo");
        fields.add("m.biz_date as bizDate");
        fields.add("m.business_type as businessType");
        fields.add("m.audit_remark as auditRemark");
        fields.add("m.external_order_no as externalOrderNo");
        fields.add("m.logic_warehouse_code as logicWarehouseCode");
        fields.add("m.logic_warehouse_name as logicWarehouseName");
        fields.add("m.physics_warehouse_code as physicsWarehouseCode");
        fields.add("m.physics_warehouse_name as physicsWarehouseName");
        fields.add("m.logistics_company_code as logisticsCompanyCode");
        fields.add("m.logistics_company_name as logisticsCompanyName");
        fields.add("m.operation_type as operationType");
        fields.add("m.order_status as orderStatus");
        fields.add("m.order_type as orderType");
        fields.add("m.organization_code as organizationCode");
        fields.add("m.organization_name as organizationName");
        fields.add("m.remark");
        fields.add("m.supplier_code as supplierCode");
        fields.add("m.supplier_name as supplierName");
        fields.add("m.supplier_id as supplierId");
        fields.add("m.create_person as createPerson");
        fields.add("m.create_time as createTime");
        fields.add("m.update_person as updatePerson");
        fields.add("m.update_time as updateTime");
        fields.add("m.pre_order_no");
        fields.add("m.erp_purchase_order_no");
        fields.add("md.inventory_property as inventoryProperty");
        fields.add("md.unit");
        fields.add("md.volume");
        fields.add("md.weight");
        fields.add("md.id AS id");
        fields.add("md.sku_code AS skuCode");
        fields.add("md.sku_name AS skuName");
        fields.add("md.batch AS batch");
        fields.add("md.plan_quantity AS planQuantity");
        fields.add("md.cancel_quantity AS cancelQuantity");
        fields.add("md.done_quantity AS doneQuantity");
        fields.add("md.extension");
        fields.add("cboa.contacts AS consignee");
        fields.add("cboa.province_code AS provinceCode");
        fields.add("cboa.province AS provinceName");
        fields.add("cboa.city_code AS cityCode");
        fields.add("cboa.city AS cityName");
        fields.add("cboa.district_code AS areaCode");
        fields.add("cboa.district AS areaName");
        fields.add("cboa.detail_address AS detailAddress");
        fields.add("cboa.phone AS phone");
        return fields;
    }

    @Override
    public void setLeftJoinOn(MultipartSelectGeneric generic) {
        generic.addLeftJoin("in_plan_order_detail", "md", "m.order_no = md.order_no");
        generic.addLeftJoin("cs_base_order_address", "cboa", "m.order_no = cboa.document_no and cboa.contacts_type = \"consignee\" ");
        super.setLeftJoinOn(generic);
    }

    @Override
    public void setWhere(MultipartSelectGeneric generic, DgPlanOrderPageReqDto reqDto) {
        ArrayList<String> fields;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderType())) {
            generic.equalsWhere("m.order_type", (Object)reqDto.getOrderType());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            HashMap<String, String> orMap = new HashMap<String, String>();
            orMap.put("m.order_no", reqDto.getCompoundOrderNo());
            orMap.put("m.external_order_no", reqDto.getCompoundOrderNo());
            orMap.put("m.pre_order_no", reqDto.getCompoundOrderNo());
            orMap.put("m.erp_purchase_order_no", reqDto.getCompoundOrderNo());
            generic.or(orMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNoList())) {
            fields = new ArrayList<String>();
            fields.add("m.order_no");
            fields.add("m.external_order_no");
            generic.inOr(fields, reqDto.getOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCompoundOrderNoList())) {
            fields = new ArrayList();
            fields.add("m.order_no");
            fields.add("m.external_order_no");
            fields.add("m.pre_order_no");
            fields.add("m.erp_purchase_order_no");
            generic.inOr(fields, reqDto.getCompoundOrderNoList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSkuDisplayName())) {
            generic.like("iisd.display_name", reqDto.getSkuDisplayName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderStatus())) {
            generic.equalsWhere("m.order_status", (Object)reqDto.getOrderStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getConsignee())) {
            generic.equalsWhere("cboa.contacts", (Object)reqDto.getConsignee());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getPhone())) {
            generic.equalsWhere("cboa.phone", (Object)reqDto.getPhone());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            generic.in("m.order_status", reqDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInventoryPropertyList())) {
            generic.in("md.inventory_property", reqDto.getInventoryPropertyList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBusinessTypeList())) {
            generic.in("m.business_type", reqDto.getBusinessTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLogicWarehouseCodeList())) {
            generic.in("m.logic_warehouse_code", reqDto.getLogicWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodeList())) {
            generic.in("m.physics_warehouse_code", reqDto.getPhysicsWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBatchList())) {
            generic.in("md.batch", reqDto.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            generic.in("md.sku_code", reqDto.getSkuCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSpuCodeList())) {
            generic.in("iig.code", reqDto.getSpuCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSupplierCodeList())) {
            generic.in("m.supplier_code", reqDto.getSupplierCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCargoOrganizationCodeList())) {
            generic.in("m.organization_code", reqDto.getCargoOrganizationCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            generic.equalsWhere("m.order_no", (Object)reqDto.getOrderNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOperationType())) {
            generic.equalsWhere("m.operation_type", (Object)reqDto.getOperationType());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLogisticsCompanyCodeList())) {
            generic.in("m.logistics_company_code", reqDto.getLogisticsCompanyCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCreatePerson())) {
            generic.like("m.create_person", reqDto.getCreatePerson());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUpdatePerson())) {
            generic.like("m.update_person", reqDto.getUpdatePerson());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCreatePersonList())) {
            generic.in("m.create_person", reqDto.getCreatePersonList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getUpdatePersonList())) {
            generic.in("m.update_person", reqDto.getCreatePersonList());
        }
        if (reqDto.getStartBizDate() != null) {
            generic.greaterThanEqualWhere("m.biz_date", (Object)reqDto.getStartBizDate());
        }
        if (reqDto.getEndBizDate() != null) {
            generic.lessThanEqualWhere("m.biz_date", (Object)reqDto.getEndBizDate());
        }
        if (reqDto.getStartCreateTime() != null) {
            generic.greaterThanEqualWhere("m.create_time", (Object)reqDto.getStartCreateTime());
        }
        if (reqDto.getEndCreateTime() != null) {
            generic.lessThanEqualWhere("m.create_time", (Object)reqDto.getEndCreateTime());
        }
        if (reqDto.getStartUpdateTime() != null) {
            generic.greaterThanEqualWhere("m.update_time", (Object)reqDto.getStartUpdateTime());
        }
        if (reqDto.getEndUpdateTime() != null) {
            generic.lessThanEqualWhere("m.update_time", (Object)reqDto.getEndUpdateTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSpecModel())) {
            generic.like("iisd.spec_model", reqDto.getSpecModel());
        }
        super.setWhere(generic, reqDto);
    }

    @Override
    protected DgPlanOrderPageReqDto convert2ReqDto(BaseQueryPageReqDto queryPageReqDto) {
        DgPlanOrderPageReqDto reqDto = new DgPlanOrderPageReqDto();
        BeanUtil.copyProperties((Object)queryPageReqDto, (Object)reqDto, (String[])new String[0]);
        return reqDto;
    }

    @Override
    protected PageInfo<DgBusinessGoodsRespDto> convert2RespDto(PageInfo<DgPlanOrderDetailDto> pageInfo) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (DgPlanOrderDetailDto dto : pageInfo.getList()) {
            results.add(BeanUtil.copyProperties((Object)dto, DgBusinessGoodsRespDto.class, (String[])new String[0]));
        }
        return new PageInfo(results);
    }
}

