/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.yunxi.dg.base.center.report.dao.common.select.MultipartSelectGeneric;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryStatisticsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.TransferOrderSearchDto;
import com.yunxi.dg.base.center.report.dto.inventory.utils.OrderUnitConverterDto;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.AbstractReportDataSearchServiceImpl;
import com.yunxi.dg.base.center.report.service.impl.inventory.utils.UnitConverUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="transferReportDataSearchService")
public class TransferReportDataSearchServiceImpl
extends AbstractReportDataSearchServiceImpl<TransferOrderSearchDto, TransferOrderItemPageDto> {
    private String[] overStatus = new String[]{"COMPLETED", "END"};

    public TransferReportDataSearchServiceImpl() {
        this("cs_transfer_order", "m");
    }

    public TransferReportDataSearchServiceImpl(String tableName, String alias) {
        super(tableName, alias);
    }

    @Override
    public void setLeftJoinOn(MultipartSelectGeneric generic) {
        generic.addLeftJoin("cs_transfer_order_detail", "md", "m.transfer_order_no = md.transfer_order_no");
        generic.addLeftJoin("sh_transfer_goods_order", "stgo", "m.transfer_order_no = stgo.pre_order_no");
        super.setLeftJoinOn(generic);
    }

    @Override
    public void setWhere(MultipartSelectGeneric generic, TransferOrderSearchDto searchDto) {
        ArrayList<String> fields;
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getTransferOrderNo())) {
            generic.like("m.transfer_order_no", searchDto.getTransferOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getIds())) {
            generic.in("m.id", searchDto.getIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getSkuDisplayName())) {
            generic.like("iisd.display_name", searchDto.getSkuDisplayName());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getOrderNo())) {
            HashMap<String, String> orMap = new HashMap<String, String>();
            orMap.put("m.transfer_order_no", searchDto.getOrderNo());
            orMap.put("m.external_order_no", searchDto.getOrderNo());
            orMap.put("stgo.order_no", searchDto.getOrderNo());
            orMap.put("m.pre_order_no", searchDto.getOrderNo());
            generic.or(orMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getOrderNoList())) {
            fields = new ArrayList<String>();
            fields.add("m.transfer_order_no");
            fields.add("m.external_order_no");
            fields.add("m.pre_order_no");
            generic.inOr(fields, searchDto.getOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getTransferOrderNoList())) {
            fields = new ArrayList();
            fields.add("m.transfer_order_no");
            fields.add("m.external_order_no");
            fields.add("m.pre_order_no");
            generic.inOr(fields, searchDto.getTransferOrderNoList());
        }
        if (searchDto.getIsVirtual() != null) {
            generic.equalsWhere("m.is_virtual", (Object)searchDto.getIsVirtual());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getTransferOrderNoList())) {
            generic.in("m.transfer_order_no", searchDto.getTransferOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getOrderStatusList())) {
            generic.in("m.order_status", searchDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getSourceTypeList())) {
            generic.in("m.source_type", searchDto.getSourceTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getTypeList())) {
            generic.in("m.type", searchDto.getTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getOutLogicWarehouseCodeList())) {
            generic.in("m.out_logic_warehouse_code", searchDto.getOutLogicWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getInLogicWarehouseCodeList())) {
            generic.in("m.in_logic_warehouse_code", searchDto.getInLogicWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getOutOrganizationIdList())) {
            generic.in("m.out_organization_id", searchDto.getOutOrganizationIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getOutOrganizationCodeList())) {
            generic.in("m.out_organization_code", searchDto.getOutOrganizationCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getInOrganizationIdList())) {
            generic.in("m.in_organization_id", searchDto.getInOrganizationIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getInOrganizationCodeList())) {
            generic.in("m.in_organization_code", searchDto.getInOrganizationCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getExternalProcessStates())) {
            generic.in("m.external_process_state", searchDto.getExternalProcessStates());
        }
        if (searchDto.getIsBorrow() != null && searchDto.getIsBorrow() == 0) {
            generic.isNull("stgo.order_no");
        }
        if (searchDto.getIsBorrow() != null && searchDto.getIsBorrow() == 1) {
            generic.nonNull("stgo.order_no");
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getOutPhysicsWarehouseCodeList())) {
            generic.in("m.out_physics_warehouse_code", searchDto.getOutPhysicsWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getInPhysicsWarehouseCodeList())) {
            generic.in("m.in_physics_warehouse_code", searchDto.getInPhysicsWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getDispatcherStatusList())) {
            generic.in("m.dispatcher_status", searchDto.getDispatcherStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getDispatcherHandleStatusList())) {
            generic.in("m.dispatcher_handle_status", searchDto.getDispatcherHandleStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getBatchList())) {
            generic.in("md.batch", searchDto.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getInventoryPropertyList())) {
            generic.in("md.inventory_property", searchDto.getInventoryPropertyList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getSkuCodeList())) {
            generic.in("md.sku_code", searchDto.getSkuCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getSpuCodeList())) {
            generic.in("iig.code", searchDto.getSpuCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getCustomerCodeList())) {
            generic.in("m.customer_code", searchDto.getCustomerCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getSpecModel())) {
            generic.like("iisd.spec_model", searchDto.getSpecModel());
        }
        if (searchDto.getBizDateStart() != null) {
            generic.greaterThanEqualWhere("m.biz_date", (Object)searchDto.getBizDateStart());
        }
        if (searchDto.getBizDateEnd() != null) {
            generic.lessThanEqualWhere("m.biz_date", (Object)searchDto.getBizDateEnd());
        }
        if (searchDto.getCreateTimeStart() != null) {
            generic.greaterThanEqualWhere("m.create_time", (Object)searchDto.getCreateTimeStart());
        }
        if (searchDto.getCreateTimeEnd() != null) {
            generic.lessThanEqualWhere("m.create_time", (Object)searchDto.getCreateTimeEnd());
        }
        if (searchDto.getUpdateTimeStart() != null) {
            generic.greaterThanEqualWhere("m.update_time", (Object)searchDto.getUpdateTimeStart());
        }
        if (searchDto.getUpdateTimeEnd() != null) {
            generic.lessThanEqualWhere("m.update_time", (Object)searchDto.getUpdateTimeEnd());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getCreatePerson())) {
            generic.like("m.create_person", searchDto.getCreatePerson());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getUpdatePerson())) {
            generic.like("m.update_person", searchDto.getUpdatePerson());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getOrderType())) {
            generic.like("m.order_type", searchDto.getOrderType());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchDto.getTransferOrderDetailIdList())) {
            generic.in("md.id", searchDto.getTransferOrderDetailIdList());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getBatch())) {
            generic.like("md.batch", searchDto.getBatch());
        }
        super.setWhere(generic, searchDto);
    }

    @Override
    public void setOrderBy(MultipartSelectGeneric generic) {
        super.setOrderBy(generic);
        generic.orderBy("md.id", "ASC");
    }

    @Override
    public List<String> getExtFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("m.transfer_order_no AS transferOrderNo");
        fields.add("m.order_status AS orderStatus");
        fields.add("m.type");
        fields.add("m.is_virtual as isVirtual");
        fields.add("m.shipment_status as deliveryStatus");
        fields.add("m.delivery_status as receiveStatus");
        fields.add("m.external_order_no AS externalOrderNo");
        fields.add("m.out_logic_warehouse_code AS outLogicWarehouseCode");
        fields.add("m.out_logic_warehouse_name AS outLogicWarehouseName");
        fields.add("m.in_logic_warehouse_code AS inLogicWarehouseCode");
        fields.add("m.in_logic_warehouse_name AS inLogicWarehouseName");
        fields.add("m.out_physics_warehouse_code as outPhysicsWarehouseCode");
        fields.add("m.out_physics_warehouse_name as outPhysicsWarehouseName");
        fields.add("m.in_physics_warehouse_code as inPhysicsWarehouseCode");
        fields.add("m.in_physics_warehouse_name as inPhysicsWarehouseName");
        fields.add("source_type");
        fields.add("external_purchase_order_no");
        fields.add("external_sale_order_no");
        fields.add("m.customer_name AS customerName");
        fields.add("m.customer_code AS customerCode");
        fields.add("m.contact");
        fields.add("m.contact_phone AS contactPhone");
        fields.add("CONCAT(m.province,m.city,m.area,m.street,m.address) AS deliveryAddress");
        fields.add("m.province");
        fields.add("m.city");
        fields.add("m.area");
        fields.add("m.street");
        fields.add("m.address");
        fields.add("m.shipment_enterprise_code AS shipmentEnterpriseCode");
        fields.add("m.shipment_enterprise_name AS shipmentEnterpriseName");
        fields.add("m.pre_order_no as preOrderNo");
        fields.add("m.dispatcher_status AS dispatcherStatus");
        fields.add("m.dispatcher_handle_status as dispatcherHandleStatus");
        fields.add("m.out_organization as outOrganization");
        fields.add("m.out_organization as outOrganizationName");
        fields.add("m.out_organization_id as outOrganizationId");
        fields.add("m.in_organization as inOrganization");
        fields.add("m.in_organization as inOrganizationName");
        fields.add("m.in_organization_id as  inOrganizationId");
        fields.add("m.biz_date as bizDate");
        fields.add("m.in_organization_code as inOrganizationCode");
        fields.add("m.out_organization_code as outOrganizationCode");
        fields.add("m.remark");
        fields.add("m.order_src as orderSrc");
        fields.add("JSON_UNQUOTE(JSON_EXTRACT(m.extension,'$.transportTypeCode')) AS transportTypeCode");
        fields.add("JSON_UNQUOTE(JSON_EXTRACT(m.extension,'$.transportTypeName')) AS transportTypeName");
        fields.add("JSON_UNQUOTE(JSON_EXTRACT(m.extension,'$.lineCode')) AS lineCode");
        fields.add("JSON_UNQUOTE(JSON_EXTRACT(m.extension,'$.lineName')) AS lineName");
        fields.add("m.order_type AS orderType");
        fields.add("m.external_process_state externalProcessState");
        fields.add("md.id");
        fields.add("md.sku_code AS skuCode");
        fields.add("md.sku_name AS skuName");
        fields.add("md.batch");
        fields.add("md.quantity");
        fields.add("md.wait_in_quantity AS waitInQuantity");
        fields.add("md.wait_out_quantity AS waitOutQuantity");
        fields.add("md.done_in_quantity AS doneInQuantity");
        fields.add("md.done_out_quantity AS doneOutQuantity");
        fields.add("md.dispatcher_quantity AS receiveDeliveryDifferenceQuantity");
        fields.add("md.dispatcher_less_quantity AS dispatcherLessQuantity");
        fields.add("md.storage_condition_name AS storageConditionName");
        fields.add("md.unit");
        fields.add("md.volume");
        fields.add("md.weight");
        fields.add("md.unit_name as unitName");
        fields.add("md.specification");
        fields.add("md.create_person as createPerson");
        fields.add("md.create_time as createTime");
        fields.add("md.update_time as updateTime");
        fields.add("md.update_person as updatePerson");
        fields.add("md.dispatcher_status as itemDispatcherStatus");
        fields.add("md.inventory_property AS inventoryProperty");
        fields.add("md.extension AS extension");
        fields.add("md.minimum_packing_quantity AS minimumPackingQuantity");
        return fields;
    }

    @Override
    public void wrap(List<TransferOrderItemPageDto> resultList) {
        Set<String> orderNos = resultList.stream().filter(x -> !StrUtil.equalsAny((CharSequence)x.getOrderStatus(), (CharSequence[])this.overStatus)).map(TransferOrderItemPageDto::getTransferOrderNo).collect(Collectors.toSet());
        Map<Long, InventoryStatisticsRespDto> outQuantityOfTheDocumentMap = this.getOutQuantityOfTheDocument(orderNos, "out");
        Map<Long, InventoryStatisticsRespDto> intQuantityOfTheDocumentMap = this.getProcessingQuantityOfTheDocument(orderNos, "rro_received");
        ArrayList convertList = new ArrayList();
        resultList.forEach(o -> {
            if (!StrUtil.equalsAny((CharSequence)o.getOrderStatus(), (CharSequence[])this.overStatus)) {
                OrderUnitConverterDto converDto = new OrderUnitConverterDto();
                BeanUtil.copyProperties((Object)o, (Object)converDto, (String[])new String[0]);
                converDto.setConvedUnit(true);
                converDto.setDocumentCode(o.getTransferOrderNo());
                converDto.setPlanQuantity(null);
                converDto.setDoneQuantity(outQuantityOfTheDocumentMap.getOrDefault(o.getId(), new InventoryStatisticsRespDto()).getDoneQuantity());
                converDto.setDoneInQuantity(intQuantityOfTheDocumentMap.getOrDefault(o.getId(), new InventoryStatisticsRespDto()).getDoneQuantity());
                converDto.setConsumer(ver -> {
                    o.setDoneOutQuantity(ver.getDoneQuantity());
                    o.setDoneInQuantity(ver.getDoneInQuantity());
                });
                convertList.add(converDto);
            }
        });
        UnitConverUtils.unitConvertBatch(new ArrayList(convertList));
    }
}

