/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.inventory.dispatcher.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.LogicInventorySnapshotConverter;
import com.yunxi.dg.base.center.report.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicInventoryDomain;
import com.yunxi.dg.base.center.report.domain.inventory.ILogicInventorySnapshotDomain;
import com.yunxi.dg.base.center.report.dto.entity.LogicInventorySnapshotDto;
import com.yunxi.dg.base.center.report.dto.entity.LogicInventorySnapshotPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsInventoryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.RelInventoryBatchTagDto;
import com.yunxi.dg.base.center.report.eo.LogicInventorySnapshotEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicInventoryEo;
import com.yunxi.dg.base.center.report.service.inventory.ILogicInventorySnapshotService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicInventorySnapshotServiceImpl
extends BaseServiceImpl<LogicInventorySnapshotDto, LogicInventorySnapshotEo, ILogicInventorySnapshotDomain>
implements ILogicInventorySnapshotService {
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;
    @Autowired
    private IDgLogicInventoryDomain iDgLogicInventoryDomain;
    @Resource
    private ILogicInventorySnapshotDomain iLogicInventorySnapshotDomain;

    public LogicInventorySnapshotServiceImpl(ILogicInventorySnapshotDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogicInventorySnapshotDto, LogicInventorySnapshotEo> converter() {
        return LogicInventorySnapshotConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<LogicInventorySnapshotDto>> page(LogicInventorySnapshotPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo dgLogicInventoryDtoPageInfo = Objects.equals("summary", dto.getType()) ? new PageInfo(((ILogicInventorySnapshotDomain)this.domain).queryCountList(dto)) : new PageInfo(((ILogicInventorySnapshotDomain)this.domain).page(dto));
        List<Long> inventoryBatchIdList = Optional.ofNullable(dgLogicInventoryDtoPageInfo.getList().stream().map(LogicInventorySnapshotDto::getInventoryBatchId).collect(Collectors.toList())).orElse(Arrays.asList(new Long[0]));
        List relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().in(CollectionUtils.isNotEmpty(inventoryBatchIdList), (Object)"inventory_batch_id", inventoryBatchIdList)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        List relInventoryBatchTagDtoList = BeanUtil.copyToList((Collection)relInventoryBatchTagEoList, RelInventoryBatchTagDto.class);
        Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
        if (CollectionUtils.isNotEmpty((Collection)dgLogicInventoryDtoPageInfo.getList())) {
            dgLogicInventoryDtoPageInfo.getList().forEach(o -> {
                if (relInventoryBatchTagEoMap.containsKey(o.getInventoryBatchId())) {
                    o.setExpiryDateTagList((List)relInventoryBatchTagEoMap.get(o.getInventoryBatchId()));
                }
                if (ObjectUtils.isNotEmpty((Object)o.getExpireTime())) {
                    o.setExpired(LogicInventorySnapshotServiceImpl.expiredDay(o.getExpireTime()));
                }
            });
        }
        return new RestResponse((Object)dgLogicInventoryDtoPageInfo);
    }

    @Override
    public RestResponse<List<LogicInventorySnapshotDto>> queryList(LogicInventorySnapshotPageReqDto dto) {
        ArrayList snapshotDtos = Lists.newArrayList();
        ExtQueryChainWrapper sqlFilters = ((ILogicInventorySnapshotDomain)this.domain).filter();
        if (Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getSnapshotDate())) {
            sqlFilters.eq((Object)"snapshot_date", (Object)dto.getSnapshotDate());
        }
        List snapshotEos = sqlFilters.list();
        CubeBeanUtils.copyCollection((Collection)snapshotDtos, (Collection)snapshotEos, LogicInventorySnapshotDto.class);
        return new RestResponse((Object)snapshotDtos);
    }

    @Override
    public List<LogicInventorySnapshotDto> queryByList(LogicInventorySnapshotPageReqDto dto) {
        return (List)this.queryList(dto).getData();
    }

    @Override
    public PageInfo<LogicInventorySnapshotDto> queryByPage(LogicInventorySnapshotPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List logicInventorySnapshotDtos = this.iLogicInventorySnapshotDomain.queryByList(dto);
        return new PageInfo(logicInventorySnapshotDtos);
    }

    @Override
    public RestResponse<PageInfo<DgPhysicsInventoryDto>> queryPhysicalInventory(DgPhysicsInventoryPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (Objects.equals("summary", dto.getType())) {
            List dgPhysicsInventoryDtos = ((ILogicInventorySnapshotDomain)this.domain).querySummaryList(dto);
            return new RestResponse((Object)new PageInfo(dgPhysicsInventoryDtos));
        }
        List dgPhysicsInventoryDtos = ((ILogicInventorySnapshotDomain)this.domain).queryPhysicalInventory(dto);
        return new RestResponse((Object)new PageInfo(dgPhysicsInventoryDtos));
    }

    @Override
    public void save(String snapshotDate) {
        String currentDate = snapshotDate;
        if (StringUtils.isEmpty((CharSequence)snapshotDate)) {
            currentDate = DateUtil.formatDate((Date)new Date());
        }
        LogicInventorySnapshotEo logicInventorySnapshotEo = new LogicInventorySnapshotEo();
        logicInventorySnapshotEo.setSnapshotDate(currentDate);
        ((ILogicInventorySnapshotDomain)this.domain).logicDelete((BaseEo)logicInventorySnapshotEo);
        List logicInventoryEos = this.iDgLogicInventoryDomain.filter().list();
        ArrayList logicInventorySnapshotEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryEos)) {
            for (DgLogicInventoryEo logicInventoryEo : logicInventoryEos) {
                LogicInventorySnapshotEo inventorySnapshotEo = new LogicInventorySnapshotEo();
                BeanUtils.copyProperties((Object)logicInventoryEo, (Object)inventorySnapshotEo);
                inventorySnapshotEo.setSnapshotDate(currentDate);
                logicInventorySnapshotEos.add(inventorySnapshotEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)logicInventorySnapshotEos)) {
            List logicInventorySnapshotEoList = CollUtil.split((Collection)logicInventorySnapshotEos, (int)500);
            logicInventorySnapshotEoList.forEach(eoList -> ((ILogicInventorySnapshotDomain)this.domain).insertBatch(eoList));
        }
    }

    private static Integer expiredDay(Date expireTime) {
        if (Objects.isNull(expireTime)) {
            return null;
        }
        int day = com.dtyunxi.util.DateUtil.getDifferDay((String)com.dtyunxi.util.DateUtil.format((Date)expireTime), (String)com.dtyunxi.util.DateUtil.format((Date)new Date()));
        if (day > 0) {
            return 1;
        }
        return 0;
    }
}

