/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.rule;

import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceRule;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationDifferenceFactory {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDifferenceFactory.class);
    @Resource
    Map<String, ReconciliationDifferenceRule> interFaceMap = new ConcurrentHashMap<String, ReconciliationDifferenceRule>();

    public ReconciliationDifferenceRule getServiceByType(String code) {
        String implementName = ReconciliationDifferenceRuleEnum.getImplementByCode(code);
        ReconciliationDifferenceRule bean = this.interFaceMap.get(implementName);
        if (bean == null) {
            log.error("\u7b56\u7565\u5de5\u5382bean\u5f02\u5e38:{} bean is null", (Object)implementName);
            throw new RuntimeException("bean is null");
        }
        return bean;
    }

    public static enum ReconciliationDifferenceRuleEnum {
        RECONCILIATION_DIFFERENCE_ERP("RECONCILIATION_DIFFERENCE_ERP", "ErpReconciliationDifferenceRule", "\u751f\u6210\u4e2d\u53f0\u4e0eU9\u5e93\u5b58\u5bf9\u8d26\u6d41\u6c34"),
        RECONCILIATION_DIFFERENCE_WMS("RECONCILIATION_DIFFERENCE_WMS", "WmsReconciliationDifferenceRule", "\u751f\u6210\u4e2d\u53f0\u4e0eWMS\u5e93\u5b58\u5bf9\u8d26\u6d41\u6c34");

        public String code;
        public String implement;
        public String desc;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getImplement() {
            return this.implement;
        }

        public void setImplement(String implement) {
            this.implement = implement;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        private ReconciliationDifferenceRuleEnum(String code, String implement, String desc) {
            this.code = code;
            this.implement = implement;
            this.desc = desc;
        }

        public static String getImplementByCode(String code) {
            for (ReconciliationDifferenceRuleEnum value : ReconciliationDifferenceRuleEnum.values()) {
                if (!value.getCode().equals(code)) continue;
                return value.getImplement();
            }
            return null;
        }
    }
}

