/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MathUtils {
    public static BigDecimal rate(BigDecimal a, BigDecimal b) {
        return MathUtils.divide(a, b, 4);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b, int scale) {
        if (a == null || b == null || b.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return a.divide(b, scale, RoundingMode.HALF_UP);
    }

    public static <T> void setScales(List<T> list, List<Function<T, BigDecimal>> getters, List<BiConsumer<T, BigDecimal>> setters, int scale) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (getters.size() != setters.size()) {
            throw new BizException("getters\u548csetters\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        for (T t : list) {
            MathUtils.setScale(t, getters, setters, scale);
        }
    }

    public static <T> void setScale(T item, List<Function<T, BigDecimal>> getters, List<BiConsumer<T, BigDecimal>> setters, int scale) {
        if (item == null) {
            return;
        }
        if (getters.size() != setters.size()) {
            throw new BizException("getters\u548csetters\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        for (int i = 0; i < getters.size(); ++i) {
            Function<T, BigDecimal> getter = getters.get(i);
            BiConsumer<T, BigDecimal> setter = setters.get(i);
            MathUtils.setScale(item, getter, setter, scale);
        }
    }

    public static <T> void setScale(T t, Function<T, BigDecimal> getter, BiConsumer<T, BigDecimal> setter, int scale) {
        if (t == null) {
            return;
        }
        BigDecimal value = getter.apply(t);
        if (value != null) {
            value = value.setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros();
            setter.accept(t, value);
        }
    }
}

