/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleStatusEnum;
import com.yunxi.dg.base.center.report.convert.entity.ActualCostAllocRuleConverter;
import com.yunxi.dg.base.center.report.domain.entity.IActualCostAllocRuleDomain;
import com.yunxi.dg.base.center.report.domain.entity.IActualCostAllocRuleFixedDomain;
import com.yunxi.dg.base.center.report.domain.entity.IActualCostAllocRuleScopeDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICostAllocRuleArchiveDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICostArchiveDomain;
import com.yunxi.dg.base.center.report.dto.entity.ActualCostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.ActualCostAllocRulePageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.ActualCostAllocRulePageRespDto;
import com.yunxi.dg.base.center.report.dto.entity.AggActualCostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchiveDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchivePageReqDto;
import com.yunxi.dg.base.center.report.eo.ActualCostAllocRuleEo;
import com.yunxi.dg.base.center.report.eo.ActualCostAllocRuleFixedEo;
import com.yunxi.dg.base.center.report.eo.ActualCostAllocRuleScopeEo;
import com.yunxi.dg.base.center.report.eo.CostAllocRuleArchiveEo;
import com.yunxi.dg.base.center.report.eo.CostArchiveEo;
import com.yunxi.dg.base.center.report.service.entity.IActualCostAllocRuleFixedService;
import com.yunxi.dg.base.center.report.service.entity.IActualCostAllocRuleScopeService;
import com.yunxi.dg.base.center.report.service.entity.IActualCostAllocRuleService;
import com.yunxi.dg.base.center.report.service.entity.ICostAllocRuleArchiveService;
import com.yunxi.dg.base.center.report.service.entity.ICostArchiveService;
import com.yunxi.dg.base.center.report.service.utils.BeanConvertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActualCostAllocRuleServiceImpl
extends BaseServiceImpl<ActualCostAllocRuleDto, ActualCostAllocRuleEo, IActualCostAllocRuleDomain>
implements IActualCostAllocRuleService {
    private static final Logger log = LoggerFactory.getLogger(ActualCostAllocRuleServiceImpl.class);
    @Resource
    private ICostAllocRuleArchiveService iCostAllocRuleArchiveService;
    @Resource
    private IActualCostAllocRuleFixedService iActualCostAllocRuleFixedService;
    @Resource
    private IActualCostAllocRuleScopeService iActualCostAllocRuleScopeService;
    @Resource
    private ICostArchiveService iCostArchiveService;
    @Resource
    private ICostArchiveDomain iCostArchiveDomain;
    @Resource
    private ICostAllocRuleArchiveDomain iCostAllocRuleArchiveDomain;
    @Resource
    private IActualCostAllocRuleFixedDomain iActualCostAllocRuleFixedDomain;
    @Resource
    private IActualCostAllocRuleScopeDomain iActualCostAllocRuleScopeDomain;

    public ActualCostAllocRuleServiceImpl(IActualCostAllocRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ActualCostAllocRuleDto, ActualCostAllocRuleEo> converter() {
        return ActualCostAllocRuleConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertRuleInfo(AggActualCostAllocRuleDto dto) {
        this.verifyInsertParam(dto);
        ActualCostAllocRuleEo actualCostAllocRuleEo = (ActualCostAllocRuleEo)BeanConvertUtil.toBean((Object)dto, ActualCostAllocRuleEo.class);
        ((IActualCostAllocRuleDomain)this.domain).saveOrUpdate((BaseEo)actualCostAllocRuleEo);
        dto.setId(actualCostAllocRuleEo.getId());
        this.insertCostAllocRuleArchive(dto);
        this.insertActualCostAllocRuleFixed(dto);
        this.insertEffectiveScope(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRuleInfo(AggActualCostAllocRuleDto dto) {
        ActualCostAllocRuleEo eo = this.verifyParam((ActualCostAllocRuleDto)dto);
        dto.setStatus(eo.getStatus());
        this.deleteSlaveData(dto.getId());
        this.insertRuleInfo(dto);
    }

    @Override
    public AggActualCostAllocRuleDto getAggRule(Long id) {
        AggActualCostAllocRuleDto aggActualCostAllocRuleDto = (AggActualCostAllocRuleDto)BeanConvertUtil.toBean((Object)((IActualCostAllocRuleDomain)this.domain).selectByPrimaryKey(id), AggActualCostAllocRuleDto.class);
        AssertUtils.notNull((Object)aggActualCostAllocRuleDto, (String)"\u975e\u6cd5\u5165\u53c2");
        aggActualCostAllocRuleDto.setArchiveDtoList(this.iCostAllocRuleArchiveService.queryByRuleId(id, 1));
        aggActualCostAllocRuleDto.setScopeList(this.iActualCostAllocRuleScopeService.queryByRuleId(id));
        aggActualCostAllocRuleDto.setCostRuleFixedList(this.iActualCostAllocRuleFixedService.queryByRuleId(id));
        return aggActualCostAllocRuleDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> logicDelete(Long id) {
        ActualCostAllocRuleEo actualCostAllocRuleEo = (ActualCostAllocRuleEo)((IActualCostAllocRuleDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.notNull((Object)actualCostAllocRuleEo, (String)"\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728\u4e86\u6216\u8005\u88ab\u5220\u9664\u4e86");
        AssertUtils.isTrue((!actualCostAllocRuleEo.getStatus().equals("running") ? 1 : 0) != 0, (String)"\u6267\u884c\u4e2d\u7684\u6570\u636e\u4e0d\u53ef\u5220\u9664");
        this.deleteSlaveData(id);
        return super.logicDelete(id);
    }

    @Override
    public PageInfo<ActualCostAllocRulePageRespDto> page(ActualCostAllocRulePageReqDto pageReqDto) {
        if (!this.listCostArchiveInfo(pageReqDto).booleanValue()) {
            return new PageInfo();
        }
        PageInfo pageInfo = ((IActualCostAllocRuleDomain)this.domain).selectPage((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActualCostAllocRuleEo.class).eq(StrUtil.isNotBlank((CharSequence)pageReqDto.getCode()), ActualCostAllocRuleEo::getCode, (Object)pageReqDto.getCode())).like(StrUtil.isNotBlank((CharSequence)pageReqDto.getName()), ActualCostAllocRuleEo::getName, (Object)pageReqDto.getName())).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getStatusList()), ActualCostAllocRuleEo::getStatus, (Collection)pageReqDto.getStatusList())).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getIdList()), BaseEo::getId, (Collection)pageReqDto.getIdList())).orderByDesc(BaseEo::getCreateTime), pageReqDto.getPageNum(), pageReqDto.getPageSize());
        PageInfo<ActualCostAllocRulePageRespDto> dtoPageInfo = BeanConvertUtil.convert(pageInfo, ActualCostAllocRulePageRespDto.class);
        this.setCostAllocRuleNameForCostAllocRulePage(dtoPageInfo);
        return dtoPageInfo;
    }

    @Override
    public void updateStatus(ActualCostAllocRuleDto dto) {
        Date date;
        ActualCostAllocRuleEo actualCostAllocRuleEo = this.verifyParam(dto);
        AssertUtils.notNull((Object)dto.getStatus(), (String)"\u53d8\u66f4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((!actualCostAllocRuleEo.getStatus().equals("end") ? 1 : 0) != 0, (String)"\u5df2\u7ecf\u7ed3\u675f\u5355\u636e\u4e0d\u53ef\u53d8\u66f4\u72b6\u6001");
        actualCostAllocRuleEo.setStatus(dto.getStatus());
        if (dto.getStatus().equals("pending")) {
            date = new Date();
            if (actualCostAllocRuleEo.getStartTime().before(date) && actualCostAllocRuleEo.getEndTime().after(date)) {
                actualCostAllocRuleEo.setStatus("running");
                actualCostAllocRuleEo.setStartTime((Date)DateUtil.beginOfDay((Date)date));
            } else if (actualCostAllocRuleEo.getEndTime().before(date)) {
                actualCostAllocRuleEo.setStatus("end");
                actualCostAllocRuleEo.setEndTime((Date)DateUtil.beginOfSecond((Date)DateUtil.endOfDay((Date)date)));
            }
        }
        if ("end".equals(dto.getStatus())) {
            date = new Date();
            date = date.before(actualCostAllocRuleEo.getEndTime()) ? date : actualCostAllocRuleEo.getEndTime();
            actualCostAllocRuleEo.setEndTime((Date)DateUtil.beginOfSecond((Date)DateUtil.endOfDay((Date)date)));
        }
        ((IActualCostAllocRuleDomain)this.domain).updateSelective((BaseEo)actualCostAllocRuleEo);
    }

    @Override
    public void actualCostAllocRuleStatus() {
        List actualCostAllocRuleEos = ((IActualCostAllocRuleDomain)this.domain).selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(ActualCostAllocRuleEo.class).in(ActualCostAllocRuleEo::getStatus, new Object[]{CostAllocRuleStatusEnum.UNSTART.getCode(), CostAllocRuleStatusEnum.PENDING.getCode(), CostAllocRuleStatusEnum.RUNNING.getCode()}));
        if (CollectionUtil.isEmpty((Collection)actualCostAllocRuleEos)) {
            log.info("\u6ca1\u6709\u9700\u8981\u53d8\u66f4\u72b6\u6001");
            return;
        }
        for (ActualCostAllocRuleEo actualCostAllocRuleEo : actualCostAllocRuleEos) {
            Date date = new Date();
            if (CostAllocRuleStatusEnum.UNSTART.getCode().equals(actualCostAllocRuleEo.getStatus())) {
                if (!actualCostAllocRuleEo.getEndTime().before(date)) continue;
                actualCostAllocRuleEo.setStatus(CostAllocRuleStatusEnum.ABOLISHED.getCode());
                ((IActualCostAllocRuleDomain)this.domain).updateSelective((BaseEo)actualCostAllocRuleEo);
                continue;
            }
            if (actualCostAllocRuleEo.getStartTime().before(date) && actualCostAllocRuleEo.getEndTime().after(date)) {
                if ("running".equals(actualCostAllocRuleEo.getStatus())) continue;
                actualCostAllocRuleEo.setStatus("running");
                actualCostAllocRuleEo.setStartTime((Date)DateUtil.beginOfDay((Date)date));
                ((IActualCostAllocRuleDomain)this.domain).updateSelective((BaseEo)actualCostAllocRuleEo);
                continue;
            }
            if (!actualCostAllocRuleEo.getEndTime().before(date)) continue;
            actualCostAllocRuleEo.setStatus("end");
            ((IActualCostAllocRuleDomain)this.domain).updateSelective((BaseEo)actualCostAllocRuleEo);
        }
    }

    private void deleteSlaveData(Long id) {
        this.iCostAllocRuleArchiveDomain.delete((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CostAllocRuleArchiveEo.class).eq(CostAllocRuleArchiveEo::getType, (Object)1)).eq(CostAllocRuleArchiveEo::getRuleId, (Object)id));
        this.iActualCostAllocRuleFixedDomain.delete((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActualCostAllocRuleFixedEo.class).eq(ActualCostAllocRuleFixedEo::getRuleId, (Object)id));
        this.iActualCostAllocRuleScopeDomain.delete((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActualCostAllocRuleScopeEo.class).eq(ActualCostAllocRuleScopeEo::getRuleId, (Object)id));
    }

    private ActualCostAllocRuleEo verifyParam(ActualCostAllocRuleDto dto) {
        boolean isAbolished;
        AssertUtils.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5165\u53c2id\u4e0d\u80fd\u4e3a\u7a7a");
        ActualCostAllocRuleEo actualCostAllocRuleEo = (ActualCostAllocRuleEo)((IActualCostAllocRuleDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)actualCostAllocRuleEo, (String)"\u975e\u6cd5\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setCode(actualCostAllocRuleEo.getCode());
        Date endTime = dto.getEndTime() != null ? dto.getEndTime() : actualCostAllocRuleEo.getEndTime();
        boolean bl = isAbolished = CostAllocRuleStatusEnum.UNSTART.getCode().equals(actualCostAllocRuleEo.getStatus()) && endTime.before(new Date());
        if (isAbolished) {
            dto.setStatus(CostAllocRuleStatusEnum.ABOLISHED.getCode());
        }
        return actualCostAllocRuleEo;
    }

    private void setCostAllocRuleNameForCostAllocRulePage(PageInfo<ActualCostAllocRulePageRespDto> pageInfo) {
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        List<Long> ruleIds = ((List)Optional.ofNullable(pageInfo.getList()).orElse(new ArrayList())).stream().map(BaseDto::getId).collect(Collectors.toList());
        List<CostAllocRuleArchiveEo> costAllocRuleArchiveEos = this.listCostAllocRuleArchiveEos(null, ruleIds);
        Map ruleIdMap = costAllocRuleArchiveEos.stream().collect(Collectors.groupingBy(CostAllocRuleArchiveEo::getRuleId, Collectors.mapping(CostAllocRuleArchiveEo::getArchiveId, Collectors.toList())));
        List costArchiveEos = this.iCostArchiveDomain.selectByIds(costAllocRuleArchiveEos.stream().map(CostAllocRuleArchiveEo::getArchiveId).collect(Collectors.toList()));
        Map costArchiveEoMap = costArchiveEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (ActualCostAllocRulePageRespDto respDto : pageInfo.getList()) {
            List archiveIds = ruleIdMap.getOrDefault(respDto.getId(), Collections.emptyList());
            for (Long archiveId : archiveIds) {
                if (StrUtil.isNotBlank((CharSequence)respDto.getArchiveName())) {
                    respDto.setArchiveName(respDto.getArchiveName() + "," + ((CostArchiveEo)costArchiveEoMap.get(archiveId)).getName());
                    continue;
                }
                respDto.setArchiveName(((CostArchiveEo)costArchiveEoMap.get(archiveId)).getName());
            }
        }
    }

    private List<CostAllocRuleArchiveEo> listCostAllocRuleArchiveEos(List<Long> archiveIdList, List<Long> roleIds) {
        List costAllocRuleArchiveEos = this.iCostAllocRuleArchiveDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostAllocRuleArchiveEo.class).eq(CostAllocRuleArchiveEo::getType, (Object)1)).in(CollectionUtil.isNotEmpty(archiveIdList), CostAllocRuleArchiveEo::getArchiveId, archiveIdList)).in(CollectionUtil.isNotEmpty(roleIds), CostAllocRuleArchiveEo::getRuleId, roleIds));
        return costAllocRuleArchiveEos;
    }

    private Boolean listCostArchiveInfo(ActualCostAllocRulePageReqDto pageReqDto) {
        if (StrUtil.isNotBlank((CharSequence)pageReqDto.getArchiveName())) {
            CostArchivePageReqDto archivePageReqDto = new CostArchivePageReqDto();
            archivePageReqDto.setName(pageReqDto.getArchiveName());
            List<CostArchiveDto> costArchiveDtos = this.iCostArchiveService.queryList(archivePageReqDto);
            if (CollectionUtil.isEmpty(costArchiveDtos)) {
                return false;
            }
            List<Long> archiveIdList = ((List)Optional.ofNullable(costArchiveDtos).orElse(new ArrayList())).stream().map(BaseDto::getId).collect(Collectors.toList());
            List<CostAllocRuleArchiveEo> costAllocRuleArchiveEos = this.listCostAllocRuleArchiveEos(archiveIdList, null);
            if (CollectionUtil.isEmpty(costAllocRuleArchiveEos)) {
                return false;
            }
            List ruleIds = costAllocRuleArchiveEos.stream().map(CostAllocRuleArchiveEo::getRuleId).collect(Collectors.toList());
            pageReqDto.setIdList(ruleIds);
            return true;
        }
        return true;
    }

    private void insertEffectiveScope(AggActualCostAllocRuleDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getScopeList())) {
            return;
        }
        dto.getScopeList().forEach(e -> {
            e.setRuleId(dto.getId());
            e.setId(null);
        });
        this.iActualCostAllocRuleScopeDomain.saveOrUpdateBatch(BeanConvertUtil.copyToList((Collection)dto.getScopeList(), ActualCostAllocRuleScopeEo.class));
    }

    private void insertActualCostAllocRuleFixed(AggActualCostAllocRuleDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getCostRuleFixedList())) {
            return;
        }
        dto.getCostRuleFixedList().forEach(e -> {
            e.setRuleId(dto.getId());
            e.setId(null);
        });
        this.iActualCostAllocRuleFixedDomain.saveOrUpdateBatch(BeanConvertUtil.copyToList((Collection)dto.getCostRuleFixedList(), ActualCostAllocRuleFixedEo.class));
    }

    private void insertCostAllocRuleArchive(AggActualCostAllocRuleDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getArchiveDtoList())) {
            return;
        }
        dto.getArchiveDtoList().forEach(e -> {
            e.setRuleId(dto.getId());
            e.setType(Integer.valueOf(1));
            e.setId(null);
        });
        this.iCostAllocRuleArchiveDomain.saveOrUpdateBatch(BeanConvertUtil.copyToList((Collection)dto.getArchiveDtoList(), CostAllocRuleArchiveEo.class));
    }

    private void verifyInsertParam(AggActualCostAllocRuleDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getName(), (String)"\u5206\u644a\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getStartTime(), (String)"\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getEndTime(), (String)"\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getAllocType(), (String)"\u5206\u644a\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getAfterSaleDeductCost(), (String)"\u62b5\u5145\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getEffectiveScope(), (String)"\u5206\u644a\u89c4\u5219\u751f\u6548\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)dto.getArchiveDtoList(), (String)"\u9002\u7528\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        if (dto.getAllocType().equals("byFixed")) {
            AssertUtils.notEmpty((Collection)dto.getCostRuleFixedList(), (String)"\u5206\u644a\u89c4\u5219\u751f\u6548\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!dto.getEffectiveScope().equals("all")) {
            AssertUtils.notEmpty((Collection)dto.getScopeList(), (String)"\u5206\u644a\u89c4\u5219\u751f\u6548\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)dto.getStatus())) {
            dto.setStatus("unstart");
        }
        if (StrUtil.isBlank((CharSequence)dto.getCode())) {
            dto.setCode(String.format("AC%s", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")));
        }
    }

    @Override
    public List<CostAllocRuleDto> getRules(List<String> statusList) {
        return ((IActualCostAllocRuleDomain)this.domain).getRules(statusList);
    }
}

