/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.tag.RecordLlinkOptTypeEnum;
import com.yunxi.dg.base.center.report.constants.tag.RecordSourceModelEnum;
import com.yunxi.dg.base.center.report.convert.entity.BizTagRecordConverter;
import com.yunxi.dg.base.center.report.dao.mapper.BizTagRecordMapper;
import com.yunxi.dg.base.center.report.domain.entity.IBizTagDomain;
import com.yunxi.dg.base.center.report.domain.entity.IBizTagRecordDomain;
import com.yunxi.dg.base.center.report.dto.entity.BizTagDto;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordChangeRespDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordDelReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordLinkPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordReqExtDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordRespDto;
import com.yunxi.dg.base.center.report.dto.tag.SearchTagRecordLinkDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkInfoDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkReqDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkReqExtDto;
import com.yunxi.dg.base.center.report.eo.BizTagEo;
import com.yunxi.dg.base.center.report.eo.BizTagRecordEo;
import com.yunxi.dg.base.center.report.service.entity.IBizTagRecordService;
import com.yunxi.dg.base.center.report.service.entity.IBizTagService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizTagRecordServiceImpl
extends BaseServiceImpl<BizTagRecordDto, BizTagRecordEo, IBizTagRecordDomain>
implements IBizTagRecordService {
    private static final Logger log = LoggerFactory.getLogger(BizTagRecordServiceImpl.class);
    private static Logger logger = LoggerFactory.getLogger(BizTagRecordServiceImpl.class);
    private static final String TAG_RECORD_KEY = "TAG_RECORD_KEY";
    @Resource
    private IBizTagDomain bizTagDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private IBizTagService iBizTagService;
    @Resource
    private BizTagRecordMapper mapper;
    @Resource
    private ICacheService cacheService;

    public BizTagRecordServiceImpl(IBizTagRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BizTagRecordDto, BizTagRecordEo> converter() {
        return BizTagRecordConverter.INSTANCE;
    }

    @Override
    public void batchInsert(List<ReBizTagRecordReqDto> dtoList) {
        this.cacheService.delCache("yunxi-dg-base-center-report", "tagRecordKey");
        List<Mutex> mutexes = null;
        try {
            mutexes = this.getLocks(this.toLockKeys(dtoList));
            List<BizTagRecordEo> recordEoList = this.insertRcordEoList(dtoList);
            if (CollectionUtils.isEmpty(recordEoList)) {
                return;
            }
            ((IBizTagRecordDomain)this.domain).batchInsert(recordEoList);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u6253\u6807\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(dtoList), (Object)e);
            throw new BizException("\u6279\u91cf\u6253\u6807\u5931\u8d25");
        }
        finally {
            this.unlocks(mutexes);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchReplace(List<ReBizTagRecordReqDto> dtoList) {
        this.cacheService.delCache("yunxi-dg-base-center-report", "tagRecordKey");
        List<Mutex> mutexes = null;
        try {
            mutexes = this.getLocks(this.toLockKeys(dtoList));
            for (ReBizTagRecordReqDto reqDto : dtoList) {
                AssertUtils.notEmpty((Collection)reqDto.getRecordLinkList(), (String)"\u6253\u6807\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getRecordSourceModel(), (String)"\u6807\u7b7e\u8bb0\u5f55\u6765\u6e90\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getRecordLinkOptType(), (String)"\u6807\u7b7e\u8bb0\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                Set parentIds = reqDto.getRecordLinkList().stream().filter(t -> Objects.nonNull(t.getRecordLinkParentId())).map(TagRecordLinkReqDto::getRecordLinkParentId).collect(Collectors.toSet());
                LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
                lqw.in(BizTagRecordEo::getRecordLinkId, (Collection)reqDto.getRecordLinkList().stream().map(TagRecordLinkReqDto::getRecordLinkId).collect(Collectors.toSet()));
                lqw.eq(BizTagRecordEo::getRecordSourceModel, (Object)reqDto.getRecordSourceModel());
                lqw.eq(BaseEo::getDr, (Object)0);
                lqw.eq(BizTagRecordEo::getRecordLinkOptType, (Object)reqDto.getRecordLinkOptType());
                lqw.in(CollectionUtils.isNotEmpty(parentIds), BizTagRecordEo::getRecordLinkParentId, parentIds);
                BizTagRecordEo recordEo = new BizTagRecordEo();
                recordEo.setDr(1);
                ((IBizTagRecordDomain)this.domain).getMapper().update((Object)recordEo, (Wrapper)lqw);
            }
            List<BizTagRecordEo> recordEoList = this.insertRcordEoList(dtoList);
            if (CollectionUtils.isEmpty(recordEoList)) {
                return;
            }
            ((IBizTagRecordDomain)this.domain).batchInsert(recordEoList);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66ff\u6362\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(dtoList), (Object)e);
            throw new BizException("\u6279\u91cf\u66ff\u6362\u5931\u8d25");
        }
        finally {
            this.unlocks(mutexes);
        }
    }

    @Override
    public void businessLabelCoverage(List<ReBizTagRecordReqExtDto> dtoList) {
        this.cacheService.delCache("yunxi-dg-base-center-report", "tagRecordKey");
        List collectTagCodeList = dtoList.stream().filter(o -> CollectionUtils.isNotEmpty((Collection)o.getTagCodeList())).map(ReBizTagRecordReqExtDto::getTagCodeList).flatMap(list -> list.stream()).distinct().collect(Collectors.toList());
        List linkList = dtoList.stream().map(ReBizTagRecordReqExtDto::getRecordLinkId).collect(Collectors.toList());
        QueryWrapper bizTagRecordEoQueryWrapper = new QueryWrapper();
        bizTagRecordEoQueryWrapper.in((Object)"record_link_id", linkList);
        bizTagRecordEoQueryWrapper.eq(Objects.nonNull(dtoList.get(0).getRecordSourceModel()), (Object)"record_source_model", (Object)dtoList.get(0).getRecordSourceModel());
        List bizTagRecordEos = this.mapper.selectList((Wrapper)bizTagRecordEoQueryWrapper);
        for (BizTagRecordEo bizTagRecordEo : bizTagRecordEos) {
            bizTagRecordEo.setDr(1);
            ((IBizTagRecordDomain)this.domain).updateSelective((BaseEo)bizTagRecordEo);
        }
        if (CollectionUtils.isEmpty(new ArrayList(collectTagCodeList))) {
            return;
        }
        List bizTagEos = ((ExtQueryChainWrapper)this.bizTagDomain.filter().in((Object)"tag_code", collectTagCodeList)).list();
        ArrayList<BizTagRecordEo> recordEos = new ArrayList<BizTagRecordEo>();
        for (ReBizTagRecordReqExtDto reBizTagRecordReqExtDto : dtoList) {
            for (BizTagEo bizTagEo : bizTagEos) {
                BizTagRecordEo bizTagRecordEo = new BizTagRecordEo();
                CubeBeanUtils.copyProperties((Object)bizTagRecordEo, (Object)reBizTagRecordReqExtDto, (String[])new String[0]);
                bizTagRecordEo.setDr(0);
                bizTagRecordEo.setTagCode(bizTagEo.getTagCode());
                bizTagRecordEo.setTagGroupCode(bizTagEo.getTagGroupCode());
                bizTagRecordEo.setTagId(bizTagEo.getId());
                bizTagRecordEo.setTagType(bizTagEo.getTagType());
                recordEos.add(bizTagRecordEo);
            }
        }
        ((IBizTagRecordDomain)this.domain).insertBatch(recordEos);
    }

    @Override
    public PageInfo<ReBizTagRecordRespDto> queryByPage(ReBizTagRecordPageReqDto pageDto) {
        PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize());
        return new PageInfo(((IBizTagRecordDomain)this.domain).queryList(pageDto));
    }

    @Override
    public List<ReBizTagRecordRespDto> findAll(ReBizTagRecordPageReqDto pageDto) {
        return ((IBizTagRecordDomain)this.domain).queryList(pageDto);
    }

    @Override
    public ReBizTagRecordRespDto findOne(String tagCode, Long recordLinkId) {
        ReBizTagRecordPageReqDto paramDto = new ReBizTagRecordPageReqDto();
        paramDto.setTagCode(tagCode);
        paramDto.setRecordLinkId(recordLinkId);
        List list = ((IBizTagRecordDomain)this.domain).queryList(paramDto);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (ReBizTagRecordRespDto)list.get(0);
    }

    @Override
    public void logicDel(ReBizTagRecordDelReqDto param) {
        this.cacheService.delCache("yunxi-dg-base-center-report", "tagRecordKey");
        List<Mutex> mutexes = null;
        try {
            mutexes = this.getLocks(param.getRecordLinkIdList().stream().sorted().collect(Collectors.toList()));
            ((IBizTagRecordDomain)this.domain).logicDel(param);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8bb0\u5f55\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)e);
            throw new BizException("\u5220\u9664\u8bb0\u5f55\u5931\u8d25");
        }
        finally {
            this.unlocks(mutexes);
        }
    }

    @Override
    public RestResponse<ReBizTagRecordChangeRespDto> recordExchange(ReBizTagRecordLinkPageReqDto pageDto) {
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pageDto));
        this.cacheService.delCache("yunxi-dg-base-center-report", "tagRecordKey");
        List<Mutex> mutexes = null;
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = new ReBizTagRecordChangeRespDto();
        try {
            ArrayList<Long> recordLinkIds = new ArrayList<Long>();
            recordLinkIds.add(pageDto.getRecordLinkId());
            mutexes = this.getLocks(recordLinkIds);
            List recordChangeCode = pageDto.getRecordChangeCode();
            ReBizTagPageReqDto reBizTagPageReqDto = new ReBizTagPageReqDto();
            reBizTagPageReqDto.setTagCodes(recordChangeCode);
            List<BizTagDto> all = this.iBizTagService.findAll(reBizTagPageReqDto);
            Map<Long, BizTagDto> collectBizTagDto = all.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
            Set<Long> longs = collectBizTagDto.keySet();
            ReBizTagRecordPageReqDto reBizTagRecordPageReqDto = new ReBizTagRecordPageReqDto();
            reBizTagRecordPageReqDto.setRecordLinkId(pageDto.getRecordLinkId());
            List reBizTagRecordRespDtos = ((IBizTagRecordDomain)this.domain).queryList(reBizTagRecordPageReqDto);
            ArrayList<ReBizTagRecordRespDto> insertList = new ArrayList<ReBizTagRecordRespDto>();
            ArrayList<ReBizTagRecordRespDto> updateList = new ArrayList<ReBizTagRecordRespDto>();
            ArrayList deleteList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)reBizTagRecordRespDtos)) {
                List deleteRecodeList = reBizTagRecordRespDtos.stream().filter(e -> e.getRecordLinkOptType().equals(RecordLlinkOptTypeEnum.SYSTEM_AUTO.getCode()) && e.getRecordSourceModel().equals(RecordSourceModelEnum.LABEL_STRATEGY.getCode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(deleteRecodeList)) {
                    List collect = deleteRecodeList.stream().map(BaseDto::getId).collect(Collectors.toList());
                    ((IBizTagRecordDomain)this.domain).logicDeleteByIds(collect);
                    CubeBeanUtils.copyCollection(deleteList, deleteRecodeList, ReBizTagRecordRespDto.class);
                }
                Map collectMap = reBizTagRecordRespDtos.stream().collect(Collectors.toMap(BizTagRecordDto::getTagId, Function.identity()));
                for (Long aLong : longs) {
                    BizTagDto bizTagDto = collectBizTagDto.get(aLong);
                    ReBizTagRecordRespDto reBizTagRecordRespDto = (ReBizTagRecordRespDto)collectMap.get(aLong);
                    ReBizTagRecordRespDto insert = new ReBizTagRecordRespDto();
                    CubeBeanUtils.copyProperties((Object)insert, (Object)bizTagDto, (String[])new String[0]);
                    insert.setId(null);
                    insert.setTagId(bizTagDto.getId());
                    insert.setRecordLinkId(pageDto.getRecordLinkId());
                    insert.setRecordLinkOptType(RecordLlinkOptTypeEnum.SYSTEM_AUTO.getCode());
                    insert.setRecordSourceModel(pageDto.getRecordSourceModel());
                    insertList.add(insert);
                }
                this.extractedInsertAndUpdateRecord(insertList, updateList);
            } else {
                this.extractedInsertRecord(pageDto, collectBizTagDto, insertList);
            }
            reBizTagRecordChangeRespDto.setInsertList(insertList);
            reBizTagRecordChangeRespDto.setDeleteList(deleteList);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BizException("\u6807\u7b7e\u8f6c\u6362\u8bb0\u5f55\u5931\u8d25");
        }
        finally {
            this.unlocks(mutexes);
        }
        return new RestResponse((Object)reBizTagRecordChangeRespDto);
    }

    private void extractedInsertAndUpdateRecord(ArrayList<ReBizTagRecordRespDto> insertList, ArrayList<ReBizTagRecordRespDto> updateList) {
        ArrayList bizTagRecordEos;
        if (!CollectionUtils.isEmpty(insertList)) {
            bizTagRecordEos = new ArrayList();
            CubeBeanUtils.copyCollection(bizTagRecordEos, insertList, BizTagRecordEo.class);
            ((IBizTagRecordDomain)this.domain).insertBatch(bizTagRecordEos);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            bizTagRecordEos = new ArrayList();
            CubeBeanUtils.copyCollection(bizTagRecordEos, updateList, BizTagRecordEo.class);
            for (BizTagRecordEo bizTagRecordEo : bizTagRecordEos) {
                ((IBizTagRecordDomain)this.domain).updateSelective((BaseEo)bizTagRecordEo);
            }
        }
    }

    private void extractedInsertRecord(ReBizTagRecordLinkPageReqDto pageDto, Map<Long, BizTagDto> collectBizTagDto, ArrayList<ReBizTagRecordRespDto> insertList) {
        ArrayList bizTagRecordEos = new ArrayList();
        collectBizTagDto.forEach((k, v) -> {
            BizTagRecordEo bizTagRecordEo = new BizTagRecordEo();
            CubeBeanUtils.copyProperties((Object)bizTagRecordEo, (Object)v, (String[])new String[0]);
            bizTagRecordEo.setId(null);
            bizTagRecordEo.setTagId(v.getId());
            bizTagRecordEo.setRecordLinkId(pageDto.getRecordLinkId());
            bizTagRecordEo.setRecordLinkOptType(RecordLlinkOptTypeEnum.SYSTEM_AUTO.getCode());
            bizTagRecordEo.setRecordSourceModel(pageDto.getRecordSourceModel());
            bizTagRecordEos.add(bizTagRecordEo);
        });
        ((IBizTagRecordDomain)this.domain).insertBatch(bizTagRecordEos);
        Collection<BizTagDto> values = collectBizTagDto.values();
        CubeBeanUtils.copyCollection(insertList, values, ReBizTagRecordRespDto.class);
    }

    private List<Long> toLockKeys(List<ReBizTagRecordReqDto> dtoList) {
        Stream<Long> linkParentIds = dtoList.stream().flatMap(en -> en.getRecordLinkList().stream().map(TagRecordLinkReqDto::getRecordLinkParentId)).filter(Objects::nonNull).sorted();
        Stream<Long> linkIds = dtoList.stream().flatMap(en -> en.getRecordLinkList().stream().map(TagRecordLinkReqDto::getRecordLinkId)).filter(Objects::nonNull).sorted();
        return Stream.concat(linkParentIds, linkIds).collect(Collectors.toList());
    }

    private List<Mutex> getLocks(List<Long> recordLinkIdLists) {
        ArrayList<Mutex> mutexs = new ArrayList<Mutex>();
        try {
            for (Long linkId : recordLinkIdLists) {
                mutexs.add(this.lockService.lock(TAG_RECORD_KEY, linkId.toString(), 20, this.lockService.getMaxKeepTimeout(), TimeUnit.MILLISECONDS));
            }
            return mutexs;
        }
        catch (Exception e) {
            log.error("\u6807\u7b7e\u52a0\u9501\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(mutexs), (Object)e);
            this.unlocks(mutexs);
            throw new BizException("\u6807\u7b7e\u52a0\u9501\u5931\u8d25");
        }
    }

    private void unlocks(List<Mutex> mutexs) {
        if (CollectionUtils.isEmpty(mutexs)) {
            return;
        }
        mutexs.forEach(en -> this.lockService.unlock(en));
    }

    private BizTagRecordEo createBizTagRecordEo(ReBizTagRecordReqDto tagRecord, TagRecordLinkReqDto tagRecordLink, BizTagEo tagEo) {
        BizTagRecordEo eo = new BizTagRecordEo();
        eo.setRecordLinkId(tagRecordLink.getRecordLinkId());
        eo.setRecordLinkParentId(tagRecordLink.getRecordLinkParentId());
        eo.setRecordLinkOptType(tagRecord.getRecordLinkOptType());
        eo.setRecordSourceModel(tagRecord.getRecordSourceModel());
        eo.setTagId(tagEo.getId());
        eo.setTagCode(tagEo.getTagCode());
        eo.setTagGroupCode(tagEo.getTagGroupCode());
        eo.setTagType(tagEo.getTagType());
        return eo;
    }

    private List<BizTagRecordEo> insertRcordEoList(List<ReBizTagRecordReqDto> dtoList) {
        HashSet linkIds = new HashSet();
        Set<Object> recordLinkParentId = new HashSet();
        HashSet tagCodes = Sets.newHashSet();
        for (ReBizTagRecordReqDto reqDto : dtoList) {
            linkIds.addAll(reqDto.getRecordLinkList().stream().map(TagRecordLinkReqDto::getRecordLinkId).collect(Collectors.toSet()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqDto.getTagCode()})) {
                tagCodes.add(reqDto.getTagCode());
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getTagCodeList())) {
                tagCodes.addAll(reqDto.getTagCodeList());
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getRecordLinkList())) {
                recordLinkParentId = reqDto.getRecordLinkList().stream().map(TagRecordLinkReqDto::getRecordLinkParentId).collect(Collectors.toSet());
                continue;
            }
            throw new BizException("\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List tagEoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)tagCodes) && CollectionUtils.isEmpty(tagEoList = this.bizTagDomain.listByTagCodes((Set)tagCodes))) {
            throw new BizException("\u6807\u7b7e\u4e0d\u5b58\u5728\uff1a" + JSON.toJSONString((Object)tagCodes));
        }
        List recordEoList = ((IBizTagRecordDomain)this.domain).listByTagCodesLinkIds((Set)tagCodes, linkIds, recordLinkParentId);
        HashSet<String> codeLinks = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)recordEoList)) {
            for (BizTagRecordEo bizTagRecordEo : recordEoList) {
                if (Objects.nonNull(bizTagRecordEo.getRecordLinkParentId())) {
                    codeLinks.add(bizTagRecordEo.getTagCode().concat(bizTagRecordEo.getRecordLinkId().toString()).concat(bizTagRecordEo.getRecordLinkParentId().toString()));
                    continue;
                }
                codeLinks.add(bizTagRecordEo.getTagCode().concat(bizTagRecordEo.getRecordLinkId().toString()));
            }
        }
        Map tagMaps = tagEoList.stream().collect(Collectors.toMap(BizTagEo::getTagCode, Function.identity(), (v1, v2) -> v1));
        ArrayList<BizTagRecordEo> tagRecordEoList = new ArrayList<BizTagRecordEo>();
        dtoList.forEach(en -> {
            String tagCode = en.getTagCode();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tagCode})) {
                en.setTagCodeList((List)Lists.newArrayList((Object[])new String[]{tagCode}));
            }
            for (String tc : en.getTagCodeList()) {
                this.dealWithTagRecordEo(tagMaps, tc, (Set<String>)codeLinks, (List<BizTagRecordEo>)tagRecordEoList, (ReBizTagRecordReqDto)en);
            }
        });
        return tagRecordEoList;
    }

    private void dealWithTagRecordEo(Map<String, BizTagEo> tagMaps, String tagCode, Set<String> codeLinks, List<BizTagRecordEo> tagRecordEoList, ReBizTagRecordReqDto en) {
        BizTagEo tagEo = tagMaps.get(tagCode);
        if (tagEo == null) {
            throw new BizException("\u6807\u7b7e\u4e0d\u5b58\u5728\uff1a" + tagCode);
        }
        List addRecordLinkList = en.getRecordLinkList().stream().filter(rn -> {
            String match = Objects.isNull(rn.getRecordLinkParentId()) ? tagCode.concat(rn.getRecordLinkId().toString()) : tagCode.concat(rn.getRecordLinkId().toString()).concat(rn.getRecordLinkParentId().toString());
            return !codeLinks.contains(match);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(addRecordLinkList)) {
            return;
        }
        tagRecordEoList.addAll(addRecordLinkList.stream().map(rn -> this.createBizTagRecordEo(en, (TagRecordLinkReqDto)rn, tagEo)).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddBizTagRecord(TagRecordLinkInfoDto dto) {
        ArrayList bizTagRecordEoList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)dto.getBatchAddTagRecordLink())) {
            Set tagCodes = dto.getBatchAddTagRecordLink().stream().map(TagRecordLinkReqExtDto::getTagCode).collect(Collectors.toSet());
            List tagEoList = this.bizTagDomain.listByTagCodes(tagCodes);
            AssertUtils.notEmpty((Collection)tagEoList, (String)"\u6807\u7b7e\u641c\u7d22\u4e0d\u5230");
            Map bizTagEoMap = tagEoList.stream().collect(Collectors.toMap(BizTagEo::getTagCode, Function.identity(), (v1, v2) -> v2));
            for (TagRecordLinkReqExtDto tagRecordLinkReqExtDto : dto.getBatchAddTagRecordLink()) {
                AssertUtils.notEmpty((String)tagRecordLinkReqExtDto.getTagCode(), (String)"\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notEmpty((Object)tagRecordLinkReqExtDto.getRecordLinkId(), (String)"\u6807\u7b7e\u8bb0\u5f55\u5173\u8054\u5b9e\u4f53id\u4e0d\u80fd\u4e3a\u7a7a");
                tagCodes.add(tagRecordLinkReqExtDto.getTagCode());
                BizTagEo bizTagEo = (BizTagEo)bizTagEoMap.get(tagRecordLinkReqExtDto.getTagCode());
                AssertUtils.notNull((Object)bizTagEo, (String)"\u6807\u7b7e\u641c\u7d22\u4e0d\u5230");
                ReBizTagRecordReqDto tagRecord = new ReBizTagRecordReqDto();
                tagRecord.setRecordLinkOptType(tagRecordLinkReqExtDto.getRecordLinkOptType());
                tagRecord.setRecordSourceModel(tagRecordLinkReqExtDto.getRecordSourceModel());
                TagRecordLinkReqDto tagRecordLink = new TagRecordLinkReqDto();
                tagRecordLink.setRecordLinkId(tagRecordLinkReqExtDto.getRecordLinkId());
                tagRecordLink.setRecordLinkParentId(tagRecordLinkReqExtDto.getRecordLinkParentId());
                BizTagRecordEo bizTagRecordEo = this.createBizTagRecordEo(tagRecord, tagRecordLink, bizTagEo);
                bizTagRecordEoList.add(bizTagRecordEo);
            }
            ((IBizTagRecordDomain)this.domain).batchInsert((List)bizTagRecordEoList);
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getBatchDeleteIds())) {
            ((IBizTagRecordDomain)this.domain).logicDeleteByIds(dto.getBatchDeleteIds());
        }
    }

    @Override
    public PageInfo<BizTagRecordDto> findParams(SearchTagRecordLinkDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List bizTagRecordEoList = ((IBizTagRecordDomain)this.domain).findParams(reqDto);
        List bizTagRecordDtoList = BeanUtil.copyToList((Collection)bizTagRecordEoList, BizTagRecordDto.class);
        return new PageInfo(bizTagRecordDtoList);
    }
}

