/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.ItemAttrEnum;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOrderAuditDomain;
import com.yunxi.dg.base.center.report.domain.es.IEsPerformOrderDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgOrderAmountDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgOrderItemAmountDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderAfterReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDeliveryReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDetailReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.report.dto.entity.ItemPromotionDto;
import com.yunxi.dg.base.center.report.dto.trade.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgEsPerformOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsPerformOrderRespDto;
import com.yunxi.dg.base.center.report.enums.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.report.eo.OrderAuditEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.report.eo.trade.DgOrderItemAmountEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.report.eo.trade.DgRefundEo;
import com.yunxi.dg.base.center.report.service.entity.IDgOrderOrderReportService;
import com.yunxi.dg.base.center.report.service.enums.GiftEnum;
import com.yunxi.dg.base.center.report.service.utils.TaxAmountUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOrderOrderReportServiceImpl
implements IDgOrderOrderReportService {
    private static final Logger logger = LoggerFactory.getLogger(DgOrderOrderReportServiceImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgOrderItemAmountDomain dgOrderItemAmountDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgOrderAmountDomain iDgOrderAmountDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IOrderAuditDomain orderAuditDomain;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IEsPerformOrderDomain esPerformOrderDomain;

    @Override
    public RestResponse<PageInfo<DgOrderDetailReportDto>> pageOrderDetailParam(DgOrderDetailReportPageReqDto copy, Integer pageNum, Integer pageSize) {
        logger.info("\u8ba2\u5355\u62a5\u8868\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)copy));
        PageInfo queryIdsDto = this.dgPerformOrderInfoDomain.pageOrderDetailParam(copy, pageNum, pageSize);
        List list = queryIdsDto.getList();
        if (list.isEmpty()) {
            return new RestResponse((Object)new PageInfo());
        }
        List ids = list.stream().map(DgOrderDetailReportDto::getOriginOrderId).collect(Collectors.toList());
        List itemIds = list.stream().map(DgOrderDetailReportDto::getOrderItemId).flatMap(Collection::stream).collect(Collectors.toList());
        List snapshotIds = list.stream().map(DgOrderDetailReportDto::getOrderSnapshotId).collect(Collectors.toList());
        List orderAdderIds = list.stream().map(DgOrderDetailReportDto::getOrderAddrId).collect(Collectors.toList());
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.selectByIds(ids);
        Map dgPerformOrderInfoEoMap = dgPerformOrderInfoEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        Map<Object, Object> orderPayEoMap = new HashMap();
        List orderPayEos = ((ExtQueryChainWrapper)this.dgPerformOrderPaymentDomain.filter().in((Object)"order_id", ids)).list();
        List orderNoList = dgPerformOrderInfoEos.stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList());
        if (CollUtil.isNotEmpty((Collection)orderPayEos)) {
            orderPayEoMap = orderPayEos.stream().collect(Collectors.toMap(DgPerformOrderPaymentEo::getOrderId, Function.identity(), (k1, k2) -> k1));
        }
        List dgOrderAmountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgOrderAmountDomain.filter().in((Object)"order_no", orderNoList)).eq((Object)"amount_type", (Object)DgOrderAmountTypeEnum.TOTAL_DISCOUNT_AMOUNT.getCode())).list();
        Map amountEoMap = ((List)Optional.ofNullable(dgOrderAmountEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List dgPerformOrderLineEos = this.dgPerformOrderLineDomain.selectByIds(itemIds);
        Map dgPerformOrderItemEoMap = dgPerformOrderLineEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        List dgPerformOrderItemLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"order_line_id", itemIds)).list();
        Map<Long, List<DgPerformOrderItemLineEo>> dgPerformOrderItemLineEoMap = dgPerformOrderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        List dgPerformOrderSnapshotEos = this.dgPerformOrderSnapshotDomain.selectByIds(snapshotIds);
        Map performOrderSnapshotEoMap = dgPerformOrderSnapshotEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        List dgPerformOrderAddrEos = this.dgPerformOrderAddrDomain.selectByIds(orderAdderIds);
        Map dgPerformOrderAddrEoMap = dgPerformOrderAddrEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        List orderLineAmountEoList = ((ExtQueryChainWrapper)this.dgPerformOrderLineAmountDomain.filter().in((Object)"order_line_id", itemIds)).list();
        Map dgPerformOrderLineAmountMap = orderLineAmountEoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId, Collectors.toMap(DgPerformOrderLineAmountEo::getAccountType, Function.identity(), (k1, k2) -> k2)));
        ArrayList<DgOrderDetailReportDto> dgOrderDetailReportDtos = new ArrayList<DgOrderDetailReportDto>();
        for (DgOrderDetailReportDto dgOrderDetailReportDto : list) {
            Long originOrderId = dgOrderDetailReportDto.getOriginOrderId();
            Long orderAddrId = dgOrderDetailReportDto.getOrderAddrId();
            Long orderSnapshotId = dgOrderDetailReportDto.getOrderSnapshotId();
            List orderItemId = dgOrderDetailReportDto.getOrderItemId();
            DgOrderDetailReportDto respTempDto = new DgOrderDetailReportDto();
            DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)dgPerformOrderInfoEoMap.get(originOrderId);
            CubeBeanUtils.copyProperties((Object)respTempDto, (Object)dgPerformOrderInfoEo, (String[])new String[0]);
            respTempDto.setPlatformOrderNo(dgPerformOrderInfoEo.getSaleOrderNo());
            respTempDto.setOrderType(dgPerformOrderInfoEo.getBizType());
            if (performOrderSnapshotEoMap.containsKey(orderSnapshotId)) {
                DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = (DgPerformOrderSnapshotEo)performOrderSnapshotEoMap.get(orderSnapshotId);
                CubeBeanUtils.copyProperties((Object)respTempDto, (Object)dgPerformOrderSnapshotEo, (String[])new String[0]);
                respTempDto.setCustomerName(dgPerformOrderSnapshotEo.getCustomerName());
                respTempDto.setSaleCompany(dgPerformOrderSnapshotEo.getEnterpriseName());
            }
            if (dgPerformOrderAddrEoMap.containsKey(orderAddrId)) {
                DgPerformOrderAddrEo dgPerformOrderAddrEo = (DgPerformOrderAddrEo)dgPerformOrderAddrEoMap.get(orderAddrId);
                CubeBeanUtils.copyProperties((Object)respTempDto, (Object)dgPerformOrderAddrEo, (String[])new String[0]);
            }
            for (Long aLong : orderItemId) {
                if (!Objects.isNull(dgPerformOrderItemEoMap.get(aLong))) {
                    this.setKneadAmount(respTempDto, (DgPerformOrderLineEo)dgPerformOrderItemEoMap.get(aLong));
                }
                DgOrderDetailReportDto respDto = new DgOrderDetailReportDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)respTempDto, (String[])new String[0]);
                DgPerformOrderLineEo dgPerformOrderLineEo = (DgPerformOrderLineEo)dgPerformOrderItemEoMap.get(aLong);
                CubeBeanUtils.copyProperties((Object)respDto, (Object)dgPerformOrderLineEo, (String[])new String[0]);
                DgPerformOrderPaymentEo dgPerformOrderPaymentEo = (DgPerformOrderPaymentEo)orderPayEoMap.get(dgOrderDetailReportDto.getOriginOrderId());
                if (Objects.nonNull(dgPerformOrderPaymentEo)) {
                    dgOrderDetailReportDto.setPayTime(dgPerformOrderPaymentEo.getPayTime());
                    respDto.setPayTime(dgPerformOrderPaymentEo.getPayTime());
                    respDto.setPayStatus(dgPerformOrderPaymentEo.getPayStatus());
                }
                respDto.setRealPayAmount(dgPerformOrderLineEo.getPayAmount());
                respDto.setTransactionAmount(BigDecimal.ZERO);
                respDto.setPayAmount(BigDecimal.ZERO);
                if (BigDecimalUtils.gtZero((BigDecimal)dgPerformOrderLineEo.getItemNum()).booleanValue()) {
                    Optional.ofNullable(dgPerformOrderLineEo.getPayAmount()).ifPresent(e -> respDto.setPrice(e.divide(dgPerformOrderLineEo.getItemNum(), 6, 1)));
                    Optional.ofNullable(dgPerformOrderLineEo.getTransactionAmount()).ifPresent(e -> respDto.setOrigPrice(e.divide(dgPerformOrderLineEo.getItemNum(), 6, 1)));
                }
                respDto.setSalePrice(dgPerformOrderLineEo.getSalePrice());
                respDto.setPromotionPrice(dgPerformOrderLineEo.getPromotionPrice());
                List<DgPerformOrderItemLineEo> eos = dgPerformOrderItemLineEoMap.get(aLong);
                if (!CollectionUtils.isEmpty(eos)) {
                    BigDecimal reduce = eos.stream().filter(e -> e.getDeliveryStatus() == 0).map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    respDto.setDeliveredNum(reduce);
                    respDto.setNotDeliveredNum(dgPerformOrderLineEo.getItemNum().subtract(reduce));
                    BigDecimal cancelReduce = eos.stream().filter(e -> e.getCancelStatus() == 1).map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    respDto.setRefundedItemNum(cancelReduce);
                }
                respDto.setSaleAmount(BigDecimal.ZERO);
                respDto.setGoodsDiscountAmount(dgPerformOrderLineEo.getPromotionDiscountAmount());
                respDto.setSpuCode((String)Optional.ofNullable(dgPerformOrderLineEo.getItemCode()).orElse(null));
                respDto.setSpuName((String)Optional.ofNullable(dgPerformOrderLineEo.getItemName()).orElse(null));
                respDto.setOrderItemUnit((String)Optional.ofNullable(dgPerformOrderLineEo.getOrderItemUnit()).orElse(null));
                respDto.setOrderItemUnitName((String)Optional.ofNullable(dgPerformOrderLineEo.getOrderItemUnitName()).orElse(null));
                respDto.setSkuDesc((String)Optional.ofNullable(dgPerformOrderLineEo.getItemAttribute()).orElse(null));
                if (ObjectUtil.isNotEmpty((Object)respDto.getItemNum()) && ObjectUtil.isNotEmpty((Object)respDto.getDeliveredNum())) {
                    respDto.setNotDeliveredNum(respDto.getItemNum().subtract(respDto.getDeliveredNum()));
                }
                respDto.setOriginOrderId(originOrderId);
                Integer giftFlag = Optional.ofNullable(dgPerformOrderLineEo.getGiftFlag()).orElse(0);
                respDto.setGiftFlag(giftFlag);
                if (null != dgPerformOrderLineEo.getPromotionDiscountDetails()) {
                    String promotionDiscountDetails = dgPerformOrderLineEo.getPromotionDiscountDetails();
                    List itemPromotionDtos = JSON.parseArray((String)promotionDiscountDetails, ItemPromotionDto.class);
                    if (!CollectionUtils.isEmpty((Collection)itemPromotionDtos)) {
                        ItemPromotionDto itemPromotionDto = (ItemPromotionDto)itemPromotionDtos.get(0);
                        respDto.setPromotionType(itemPromotionDto.getPromotionType());
                    }
                } else {
                    respDto.setPromotionType("-");
                }
                String bizType = dgPerformOrderInfoEo.getBizType();
                respDto.setOrderType(bizType);
                if (StringUtils.isEmpty((CharSequence)respDto.getOrderType())) {
                    respDto.setOrderType("-");
                }
                respDto.setConfirmReceiveTime(dgPerformOrderInfoEo.getConfirmReceiveTime());
                if (dgPerformOrderLineAmountMap.containsKey(aLong)) {
                    Map lineAmountEoMap = dgPerformOrderLineAmountMap.get(aLong);
                    DgPerformOrderLineAmountEo itemLineSaleTotal = (DgPerformOrderLineAmountEo)lineAmountEoMap.get("LINE_SALE_TOTAL");
                    Optional.ofNullable(itemLineSaleTotal).ifPresent(e -> respDto.setSaleAmount(e.getAmount()));
                    DgPerformOrderLineAmountEo lineOrigPrice = (DgPerformOrderLineAmountEo)lineAmountEoMap.get("LINE_ORIG_PRICE");
                    Optional.ofNullable(lineOrigPrice).ifPresent(e -> respDto.setTransactionAmount(e.getAmount()));
                    DgPerformOrderLineAmountEo lineSettlementAmount = (DgPerformOrderLineAmountEo)lineAmountEoMap.get("LINE_SETTLEMENT_AMOUNT");
                    Optional.ofNullable(lineSettlementAmount).ifPresent(e -> respDto.setPayAmount(e.getAmount()));
                }
                dgOrderDetailReportDtos.add(respDto);
            }
        }
        queryIdsDto.setList(dgOrderDetailReportDtos);
        return new RestResponse((Object)queryIdsDto);
    }

    private Map<Long, Map<Long, List<DgOrderItemAmountEo>>> getOrderItemAmountEos(List<Long> ids) {
        Map<Long, Map<Long, List<Object>>> amountMap = new HashMap<Long, Map<Long, List<DgOrderItemAmountEo>>>();
        List orderItemAmountEos = ((ExtQueryChainWrapper)this.dgOrderItemAmountDomain.filter().in((Object)"order_id", ids)).list();
        if (CollectionUtil.isNotEmpty((Collection)orderItemAmountEos)) {
            amountMap = orderItemAmountEos.stream().filter(e -> null != e.getOrderId() && null != e.getOrderItemId()).collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderId, TreeMap::new, Collectors.groupingBy(DgOrderItemAmountEo::getOrderItemId, Collectors.toList())));
        }
        return amountMap;
    }

    private void setKneadAmount(DgOrderDetailReportDto kneadRespDto, DgPerformOrderLineEo e) {
        if (e.getKneadLaterTotal() != null && e.getKneadLaterTotal().compareTo(BigDecimal.ZERO) > 0) {
            kneadRespDto.setPromotionKneadTotal(e.getPromotionKneadeAmount());
            kneadRespDto.setCostKneadTotal(e.getCostKneadeAmount());
            kneadRespDto.setKneadTotal(e.getKneadeAmount());
            kneadRespDto.setKneadPrice(e.getKneadeAmount().divide(e.getItemNum(), 6, 1));
            if (GiftEnum.GIFT.getType().equals(e.getGiftFlag())) {
                if (e.getKneadLaterTotal() == null) {
                    kneadRespDto.setKneadLaterTotal(e.getSaleAmount().subtract(e.getKneadeAmount()));
                } else {
                    kneadRespDto.setKneadLaterTotal(e.getKneadLaterTotal());
                }
                kneadRespDto.setKneadLaterPrice(kneadRespDto.getKneadLaterTotal().divide(e.getItemNum(), 6, 1));
                if (e.getRate() != null && e.getRate().compareTo(BigDecimal.ZERO) > 0) {
                    kneadRespDto.setKneadLaterTax(TaxAmountUtil.taxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                    kneadRespDto.setKneadLaterTotalNotTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                }
            }
            if (GiftEnum.NOT_GIFT.getType().equals(e.getGiftFlag())) {
                if (e.getKneadLaterTotal() == null) {
                    BigDecimal kneadLaterTotal = e.getSaleAmount().subtract(e.getPromotionDiscountAmount()).subtract(e.getKneadeAmount());
                    kneadRespDto.setKneadLaterTotal(kneadLaterTotal);
                } else {
                    kneadRespDto.setKneadLaterTotal(e.getKneadLaterTotal());
                }
                kneadRespDto.setKneadLaterPrice(kneadRespDto.getKneadLaterTotal().divide(e.getItemNum(), 6, 1));
                if (e.getRate() != null && e.getRate().compareTo(BigDecimal.ZERO) > 0) {
                    kneadRespDto.setKneadLaterTax(TaxAmountUtil.taxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                    kneadRespDto.setKneadLaterTotalNotTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                }
            }
        }
    }

    @Override
    public RestResponse<PageInfo<DgOrderAfterReportDto>> pageOrderAfterParam(DgOrderAfterReportDto copy, Integer pageNum, Integer pageSize) {
        PageInfo dgOrderAfterReportDtos;
        List list;
        if (StringUtils.isBlank((CharSequence)copy.getBizModel())) {
            copy.setBizModel("F2B");
        }
        if ((list = (dgOrderAfterReportDtos = this.dgAfterSaleOrderDomain.pageOrderAfterParam(copy, pageNum, pageSize)).getList()).isEmpty()) {
            return new RestResponse((Object)new PageInfo());
        }
        List ids = list.stream().map(DgOrderAfterReportDto::getId).collect(Collectors.toList());
        List itemIds = list.stream().map(DgOrderAfterReportDto::getItemId).flatMap(Collection::stream).collect(Collectors.toList());
        List dgAfterSaleOrderEos = this.dgAfterSaleOrderDomain.selectByIds(ids);
        Map dgAfterSaleOrderEoMap = dgAfterSaleOrderEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List dgAfterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.selectByIds(itemIds);
        Map dgAfterSaleOrderItemEoMap = dgAfterSaleOrderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List afterSaleOrderEos = dgAfterSaleOrderEos.stream().map(DgAfterSaleOrderEo::getAfterSaleOrderNo).collect(Collectors.toList());
        List orderAuditEoList = ((ExtQueryChainWrapper)this.orderAuditDomain.filter().in((Object)"trade_no", afterSaleOrderEos)).list();
        Map orderAuditEoMap = orderAuditEoList.stream().collect(Collectors.toMap(OrderAuditEo::getTradeNo, Function.identity(), (v1, v2) -> v2));
        List dgRefundEos = this.dgAfterSaleOrderDomain.queryRefundList(ids);
        Map refundEoMap = Optional.ofNullable(dgRefundEos).map(refund -> refund.stream().collect(Collectors.toMap(DgRefundEo::getBizOrderId, Function.identity(), (v1, v2) -> v1))).orElse(new HashMap());
        ArrayList<DgOrderAfterReportDto> dgOrderAfterRespDtos = new ArrayList<DgOrderAfterReportDto>();
        for (DgOrderAfterReportDto dgOrderAfterReportDto : list) {
            OrderAuditEo orderAuditEo;
            Long id = dgOrderAfterReportDto.getId();
            DgOrderAfterReportDto afterReportDto = new DgOrderAfterReportDto();
            DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)dgAfterSaleOrderEoMap.get(id);
            CubeBeanUtils.copyProperties((Object)afterReportDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
            afterReportDto.setReturnStatus(dgAfterSaleOrderEo.getStatus());
            afterReportDto.setReturnRecipientNum(dgAfterSaleOrderEo.getReturnRecipientPhone());
            afterReportDto.setReceiveAddress(dgAfterSaleOrderEo.getReturnAddress());
            afterReportDto.setOrderAfterRemark(dgAfterSaleOrderEo.getRemark());
            if (null != dgAfterSaleOrderEo.getOrderSource()) {
                afterReportDto.setOrderSource(dgAfterSaleOrderEo.getOrderSource() == 0 ? "\u624b\u5de5\u521b\u5efa" : "\u5e73\u53f0\u63a8\u9001");
            }
            afterReportDto.setSaleCompanyCode(dgAfterSaleOrderEo.getEnterpriseCode());
            afterReportDto.setSaleCompanyName(dgAfterSaleOrderEo.getEnterpriseName());
            if (ObjectUtil.isNotEmpty(refundEoMap.get(id))) {
                afterReportDto.setReturnTime(((DgRefundEo)refundEoMap.get(id)).getCreateTime());
            }
            if (!Objects.isNull(orderAuditEo = (OrderAuditEo)orderAuditEoMap.get(dgAfterSaleOrderEo.getAfterSaleOrderNo()))) {
                afterReportDto.setAuditPerson(orderAuditEo.getAuditor());
                afterReportDto.setAuditTime(orderAuditEo.getCreateTime());
            }
            List itemReIds = dgOrderAfterReportDto.getItemId();
            for (Long itemReId : itemReIds) {
                DgOrderAfterReportDto dgOrderAfterReportDtoTemp = new DgOrderAfterReportDto();
                CubeBeanUtils.copyProperties((Object)dgOrderAfterReportDtoTemp, (Object)afterReportDto, (String[])new String[0]);
                DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo = (DgAfterSaleOrderItemEo)dgAfterSaleOrderItemEoMap.get(itemReId);
                CubeBeanUtils.copyProperties((Object)dgOrderAfterReportDtoTemp, (Object)dgAfterSaleOrderItemEo, (String[])new String[]{"createTime"});
                dgOrderAfterReportDtoTemp.setSpuCode(dgAfterSaleOrderItemEo.getItemCode());
                dgOrderAfterReportDtoTemp.setSpuName(dgAfterSaleOrderItemEo.getItemName());
                if ("B2C".equals(dgAfterSaleOrderEo.getBizModel())) {
                    dgOrderAfterReportDtoTemp.setItemNum(Optional.ofNullable(dgAfterSaleOrderItemEo.getItemNum()).orElse(BigDecimal.ZERO));
                } else {
                    dgOrderAfterReportDtoTemp.setItemNum(Optional.ofNullable(dgAfterSaleOrderItemEo.getReturnNum()).orElse(BigDecimal.ZERO));
                }
                dgOrderAfterReportDtoTemp.setDeliverNum(Optional.ofNullable(dgAfterSaleOrderItemEo.getActualReturnNum()).orElse(BigDecimal.ZERO));
                dgOrderAfterReportDtoTemp.setItemNumAmount(Optional.ofNullable(dgAfterSaleOrderItemEo.getRefundAmount()).orElse(BigDecimal.ZERO));
                dgOrderAfterReportDtoTemp.setItemOriginPrice(Optional.ofNullable(dgAfterSaleOrderItemEo.getSalePrice()).orElse(BigDecimal.ZERO));
                dgOrderAfterReportDtoTemp.setRefundAmount(Optional.ofNullable(dgAfterSaleOrderItemEo.getActualRefundAmount()).orElse(BigDecimal.ZERO));
                dgOrderAfterReportDtoTemp.setUnit(dgAfterSaleOrderItemEo.getItemUnit());
                dgOrderAfterReportDtoTemp.setRefundFee(Optional.ofNullable(dgAfterSaleOrderItemEo.getRefundPrice()).orElse(BigDecimal.ZERO));
                dgOrderAfterReportDtoTemp.setSkuDesc(ItemAttrEnum.getDescByCode((String)dgAfterSaleOrderItemEo.getItemAttr()));
                Integer integer = Optional.ofNullable(dgAfterSaleOrderItemEo.getGift()).orElse(0);
                dgOrderAfterReportDtoTemp.setGift(integer);
                dgOrderAfterRespDtos.add(dgOrderAfterReportDtoTemp);
            }
        }
        PageInfo dgOrderAfterReportDtoPageInfo = (PageInfo)BeanUtil.copyProperties((Object)dgOrderAfterReportDtos, PageInfo.class, (String[])new String[]{"list"});
        dgOrderAfterReportDtoPageInfo.setList(dgOrderAfterRespDtos);
        return new RestResponse((Object)dgOrderAfterReportDtoPageInfo);
    }

    @Override
    public PageInfo<DgOrderDeliveryReportDto> pageOrderDeliveryParam(DgOrderDeliveryReportPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List list = this.performOrderInfoDas.pageOrderDeliveryParam(dto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List lineIds = list.stream().map(DgOrderDeliveryReportDto::getLineId).collect(Collectors.toList());
            List dgPerformOrderLineEoList = this.dgPerformOrderLineDomain.selectByIds(lineIds);
            Map<Long, DgPerformOrderLineEo> orderLineEoMap = dgPerformOrderLineEoList.stream().collect(Collectors.toMap(BaseEo::getId, orderLineEo -> orderLineEo, (existing, replacement) -> existing));
            List dgPerformOrderItemLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"order_line_id", lineIds)).list();
            Map<Long, List<DgPerformOrderItemLineEo>> itemLineMap = dgPerformOrderItemLineEos.stream().filter(e -> e.getDeliveryStatus() == 1).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
            list.forEach(item -> {
                DgPerformOrderLineEo orderLineEo = (DgPerformOrderLineEo)orderLineEoMap.get(item.getLineId());
                List lineItemEos = (List)itemLineMap.get(item.getLineId());
                if (null != orderLineEo) {
                    this.setDeliveryKneadAmount((DgOrderDeliveryReportDto)item, orderLineEo);
                    BigDecimal bigDecimal = lineItemEos.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal singleKneadLaterTotal = BigDecimal.ZERO;
                    if (null != orderLineEo.getKneadLaterTotal()) {
                        singleKneadLaterTotal = orderLineEo.getKneadLaterTotal().divide(orderLineEo.getItemNum(), 6, 4);
                    }
                    BigDecimal multiply = bigDecimal.multiply(singleKneadLaterTotal);
                    item.setKneadeRealPayAmount(multiply);
                    item.setRealPayAmount(item.getPayAmount());
                    item.setKneadeAmount(multiply);
                    item.setKneadLaterTotal(multiply);
                }
            });
            if (!CollectionUtils.isEmpty((Collection)list)) {
                logger.info("\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u7684\u6570\u91cf list:{}", (Object)list.size());
            }
        }
        return new PageInfo(list);
    }

    @Override
    public List<DgPerformOrderAddrDto> queryOrderAddr(DgPerformOrderInfoDto dto) {
        return this.performOrderInfoDas.queryOrderAddr(dto);
    }

    private void setDeliveryKneadAmount(DgOrderDeliveryReportDto kneadRespDto, DgPerformOrderLineEo e) {
        if (e.getKneadLaterTotal() != null && e.getKneadLaterTotal().compareTo(BigDecimal.ZERO) > 0) {
            kneadRespDto.setPromotionKneadTotal(e.getPromotionKneadeAmount());
            kneadRespDto.setCostKneadTotal(e.getCostKneadeAmount());
            kneadRespDto.setKneadTotal(e.getKneadeAmount());
            kneadRespDto.setKneadPrice(e.getKneadeAmount().divide(e.getItemNum(), 6, 1));
            if (GiftEnum.GIFT.getType().equals(e.getGiftFlag())) {
                if (e.getKneadLaterTotal() == null) {
                    kneadRespDto.setKneadLaterTotal(e.getSaleAmount().subtract(e.getKneadeAmount()));
                } else {
                    kneadRespDto.setKneadLaterTotal(e.getKneadLaterTotal());
                }
                kneadRespDto.setKneadLaterPrice(kneadRespDto.getKneadLaterTotal().divide(e.getItemNum(), 6, 1));
                if (e.getRate() != null && e.getRate().compareTo(BigDecimal.ZERO) > 0) {
                    kneadRespDto.setKneadLaterTax(TaxAmountUtil.taxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                    kneadRespDto.setKneadLaterTotalNotTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                }
            }
            if (GiftEnum.NOT_GIFT.getType().equals(e.getGiftFlag())) {
                if (e.getKneadLaterTotal() == null) {
                    BigDecimal kneadLaterTotal = e.getSaleAmount().subtract(e.getPromotionDiscountAmount()).subtract(e.getKneadeAmount());
                    kneadRespDto.setKneadLaterTotal(kneadLaterTotal);
                } else {
                    kneadRespDto.setKneadLaterTotal(e.getKneadLaterTotal());
                }
                kneadRespDto.setKneadLaterPrice(kneadRespDto.getKneadLaterTotal().divide(e.getItemNum(), 6, 1));
                if (e.getRate() != null && e.getRate().compareTo(BigDecimal.ZERO) > 0) {
                    kneadRespDto.setKneadLaterTax(TaxAmountUtil.taxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                    kneadRespDto.setKneadLaterTotalNotTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                }
            }
        }
    }

    private Map<String, DgOrderItemAmountEo> getOrderItemAmountMap(List<Long> orderIds) {
        HashMap<String, DgOrderItemAmountEo> orderItemMap = new HashMap<String, DgOrderItemAmountEo>();
        List orderItemAmountList = this.dgOrderItemAmountDomain.queryByOrderIds(orderIds);
        if (CollectionUtils.isEmpty((Collection)orderItemAmountList)) {
            return orderItemMap;
        }
        orderItemMap.putAll(orderItemAmountList.stream().collect(Collectors.toMap(en -> en.getOrderId().toString().concat(en.getOrderItemId().toString()), Function.identity(), (v1, v2) -> v1)));
        return orderItemMap;
    }

    private void setOrderItemAmount(DgOrderDetailReportDto respDto, Map<String, DgOrderItemAmountEo> orderItemAmountMap, Long orderId, Long orderItemId) {
        DgOrderItemAmountEo itemAmountEo = orderItemAmountMap.get(orderId.toString().concat(orderItemId.toString()));
        if (itemAmountEo == null) {
            return;
        }
        switch (DgOrderAmountTypeEnum.getForCode((String)itemAmountEo.getAmountType())) {
            case ITEM_ACTUAL_PRICE: {
                respDto.setPrice(itemAmountEo.getAmount());
                break;
            }
            case ITEM_ORIG_PRICE: {
                respDto.setSalePrice(itemAmountEo.getAmount());
                break;
            }
        }
    }

    @Override
    public RestResponse<PageInfo<DgOrderDetailReportDto>> pageOrderDetailForRebate(DgOrderDetailReportPageReqDto copy, Integer pageNum, Integer pageSize) {
        logger.info("\u8ba2\u5355\u8fd4\u5229\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)copy));
        PageInfo queryIdsDto = this.dgPerformOrderInfoDomain.pageOrderDetailParam(copy, pageNum, pageSize);
        List list = queryIdsDto.getList();
        if (list.isEmpty()) {
            return new RestResponse((Object)new PageInfo());
        }
        List ids = list.stream().map(DgOrderDetailReportDto::getOriginOrderId).collect(Collectors.toList());
        List itemIds = list.stream().map(DgOrderDetailReportDto::getOrderItemId).flatMap(Collection::stream).collect(Collectors.toList());
        List snapshotIds = list.stream().map(DgOrderDetailReportDto::getOrderSnapshotId).collect(Collectors.toList());
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.selectByIds(ids);
        Map dgPerformOrderInfoEoMap = dgPerformOrderInfoEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        List dgPerformOrderLineEos = this.dgPerformOrderLineDomain.selectByIds(itemIds);
        Map dgPerformOrderItemEoMap = dgPerformOrderLineEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        List dgPerformOrderItemLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"order_line_id", itemIds)).list();
        Map<Long, List<DgPerformOrderItemLineEo>> dgPerformOrderItemLineEoMap = dgPerformOrderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        List dgPerformOrderSnapshotEos = this.dgPerformOrderSnapshotDomain.selectByIds(snapshotIds);
        Map performOrderSnapshotEoMap = dgPerformOrderSnapshotEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        List orderLineAmountEoList = ((ExtQueryChainWrapper)this.dgPerformOrderLineAmountDomain.filter().in((Object)"order_line_id", itemIds)).list();
        Map dgPerformOrderLineAmountMap = orderLineAmountEoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId, Collectors.toMap(DgPerformOrderLineAmountEo::getAccountType, Function.identity(), (k1, k2) -> k2)));
        ArrayList<DgOrderDetailReportDto> dgOrderDetailReportDtos = new ArrayList<DgOrderDetailReportDto>();
        for (DgOrderDetailReportDto dgOrderDetailReportDto : list) {
            Long originOrderId = dgOrderDetailReportDto.getOriginOrderId();
            Long orderSnapshotId = dgOrderDetailReportDto.getOrderSnapshotId();
            List orderItemId = dgOrderDetailReportDto.getOrderItemId();
            DgOrderDetailReportDto respTempDto = new DgOrderDetailReportDto();
            DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)dgPerformOrderInfoEoMap.get(originOrderId);
            CubeBeanUtils.copyProperties((Object)respTempDto, (Object)dgPerformOrderInfoEo, (String[])new String[0]);
            respTempDto.setPlatformOrderNo(dgPerformOrderInfoEo.getSaleOrderNo());
            if (performOrderSnapshotEoMap.containsKey(orderSnapshotId)) {
                DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = (DgPerformOrderSnapshotEo)performOrderSnapshotEoMap.get(orderSnapshotId);
                CubeBeanUtils.copyProperties((Object)respTempDto, (Object)dgPerformOrderSnapshotEo, (String[])new String[0]);
                respTempDto.setCustomerName(dgPerformOrderSnapshotEo.getCustomerName());
                respTempDto.setCustomerCode(dgPerformOrderSnapshotEo.getCustomerCode());
                respTempDto.setSaleCompany(dgPerformOrderSnapshotEo.getEnterpriseName());
            }
            for (Long aLong : orderItemId) {
                DgOrderDetailReportDto respDto = new DgOrderDetailReportDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)respTempDto, (String[])new String[0]);
                DgPerformOrderLineEo dgPerformOrderLineEo = (DgPerformOrderLineEo)dgPerformOrderItemEoMap.get(aLong);
                CubeBeanUtils.copyProperties((Object)respDto, (Object)dgPerformOrderLineEo, (String[])new String[0]);
                respDto.setRealPayAmount(dgPerformOrderLineEo.getPayAmount());
                respDto.setTransactionAmount(dgPerformOrderLineEo.getTransactionAmount());
                respDto.setPayAmount(dgPerformOrderLineEo.getPayAmount());
                if (BigDecimalUtils.gtZero((BigDecimal)dgPerformOrderLineEo.getItemNum()).booleanValue()) {
                    Optional.ofNullable(dgPerformOrderLineEo.getPayAmount()).ifPresent(e -> respDto.setPrice(e.divide(dgPerformOrderLineEo.getItemNum(), 6, 1)));
                    Optional.ofNullable(dgPerformOrderLineEo.getTransactionAmount()).ifPresent(e -> respDto.setOrigPrice(e.divide(dgPerformOrderLineEo.getItemNum(), 6, 1)));
                }
                respDto.setSalePrice(dgPerformOrderLineEo.getSalePrice());
                respDto.setSaleAmount(Optional.ofNullable(dgPerformOrderLineEo.getSaleAmount()).orElse(BigDecimal.ZERO));
                respDto.setSpuCode((String)Optional.ofNullable(dgPerformOrderLineEo.getItemCode()).orElse(null));
                respDto.setSpuName((String)Optional.ofNullable(dgPerformOrderLineEo.getItemName()).orElse(null));
                respDto.setOrderItemUnit((String)Optional.ofNullable(dgPerformOrderLineEo.getOrderItemUnit()).orElse(null));
                respDto.setOrderItemUnitName((String)Optional.ofNullable(dgPerformOrderLineEo.getOrderItemUnitName()).orElse(null));
                respDto.setSkuDesc((String)Optional.ofNullable(dgPerformOrderLineEo.getItemAttribute()).orElse(null));
                respDto.setOriginOrderId(originOrderId);
                String bizType = dgPerformOrderInfoEo.getBizType();
                respDto.setOrderType(bizType);
                if (StringUtils.isEmpty((CharSequence)respDto.getOrderType())) {
                    respDto.setOrderType("-");
                }
                respDto.setConfirmReceiveTime(dgPerformOrderInfoEo.getConfirmReceiveTime());
                if (dgPerformOrderLineAmountMap.containsKey(aLong)) {
                    Map lineAmountEoMap = dgPerformOrderLineAmountMap.get(aLong);
                    DgPerformOrderLineAmountEo itemLineSaleTotal = (DgPerformOrderLineAmountEo)lineAmountEoMap.get("ITEM_LINE_SALE_TOTAL");
                    Optional.ofNullable(itemLineSaleTotal).ifPresent(e -> respDto.setSaleAmount(e.getAmount()));
                    DgPerformOrderLineAmountEo lineOrigPrice = (DgPerformOrderLineAmountEo)lineAmountEoMap.get("LINE_ORIG_PRICE");
                    Optional.ofNullable(lineOrigPrice).ifPresent(e -> respDto.setTransactionAmount(e.getAmount()));
                    DgPerformOrderLineAmountEo lineSettlementAmount = (DgPerformOrderLineAmountEo)lineAmountEoMap.get("LINE_SETTLEMENT_AMOUNT");
                    Optional.ofNullable(lineSettlementAmount).ifPresent(e -> respDto.setPayAmount(e.getAmount()));
                }
                dgOrderDetailReportDtos.add(respDto);
            }
        }
        queryIdsDto.setList(dgOrderDetailReportDtos);
        return new RestResponse((Object)queryIdsDto);
    }

    @Override
    public PageInfo<DgOrderDeliveryReportDto> queryPerformOrderDetail(DgEsPerformOrderReqDto filter) {
        PageInfo pageInfo = this.esPerformOrderDomain.queryEsByPage(filter);
        List list = pageInfo.getList();
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map orderEoMap = list.stream().collect(Collectors.toMap(DgEsPerformOrderRespDto::getId, Function.identity(), (v1, v2) -> v2));
            List orderIds = list.stream().map(DgEsPerformOrderRespDto::getId).collect(Collectors.toList());
            List lineEoList = this.dgPerformOrderLineDomain.selectByOrderIds(orderIds);
            List performOrderWarehouseInfoEos = ((ExtQueryChainWrapper)this.performOrderWarehouseInfoDomain.filter().in((Object)"order_id", orderIds)).list();
            Map warehouseInfoMap = performOrderWarehouseInfoEos.stream().collect(Collectors.toMap(DgPerformOrderWarehouseInfoEo::getOrderId, Function.identity()));
            for (DgPerformOrderLineEo lineEo : lineEoList) {
                DgOrderDeliveryReportDto respDto = (DgOrderDeliveryReportDto)BeanUtil.copyProperties((Object)lineEo, DgOrderDeliveryReportDto.class, (String[])new String[0]);
                DgPerformOrderWarehouseInfoEo warehouseInfoEo = warehouseInfoMap.getOrDefault(lineEo.getOrderId(), new DgPerformOrderWarehouseInfoEo());
                respDto.setDeliveryLogicWarehouseCode(warehouseInfoEo.getDeliveryLogicalWarehouseCode());
                if (orderEoMap.containsKey(lineEo.getOrderId())) {
                    DgEsPerformOrderRespDto orderRespDto = (DgEsPerformOrderRespDto)orderEoMap.get(lineEo.getOrderId());
                    respDto.setShopCode(orderRespDto.getShopCode());
                    respDto.setSaleOrderNo(orderRespDto.getSaleOrderNo());
                }
                respDto.setUnit(lineEo.getOrderItemUnit());
                respDto.setUnitName(lineEo.getOrderItemUnitName());
                resultList.add(respDto);
            }
        }
        return new PageInfo((List)resultList);
    }
}

