/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.SaleOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgCustomerInfoDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.report.domain.entity.ISaleOrderDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgSaleOrderDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.BillShopInfoDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.SystemSaleBillDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.SystemSaleBillReqDto;
import com.yunxi.dg.base.center.report.dto.settlement.BookAccountsReqDto;
import com.yunxi.dg.base.center.report.dto.settlement.SaleOrderItemVo;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgOrderReceiveResultDetailDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgReceiveDeliverResultRecordDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgReceiveDeliverResultRecordItemDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgSaleOrderDeliverResultDto;
import com.yunxi.dg.base.center.report.eo.DgCustomerInfoEo;
import com.yunxi.dg.base.center.report.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.report.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.report.service.entity.IDgSaleOrderService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderServiceImpl
extends BaseServiceImpl<DgSaleOrderDto, DgSaleOrderEo, ISaleOrderDomain>
implements IDgSaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(DgSaleOrderServiceImpl.class);
    @Resource
    private IDgCustomerInfoDomain dgCustomerInfoDomain;
    @Resource
    private IDgSaleOrderItemDomain dgSaleOrderItemDomain;

    public DgSaleOrderServiceImpl(ISaleOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgSaleOrderDto, DgSaleOrderEo> converter() {
        return SaleOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<BillShopInfoDto>> queryByPlatformOrderNos(List<String> platformOrderNos) {
        List saleOrderDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(platformOrderNos)) {
            saleOrderDtos = ((ISaleOrderDomain)this.domain).queryByPlatformOrderNos(platformOrderNos);
        }
        return new RestResponse((Object)saleOrderDtos);
    }

    @Override
    public RestResponse<PageInfo<SystemSaleBillDto>> sysSaleOrderPage(SystemSaleBillReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setOrderStatus(StringUtils.isBlank((CharSequence)dto.getOrderStatus()) ? "COMPLETE" : dto.getOrderStatus());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).sysSaleOrderList(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SystemSaleBillDto>> sysAfterOrderPage(SystemSaleBillReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setOrderStatus(StringUtils.isBlank((CharSequence)dto.getOrderStatus()) ? "3" : dto.getOrderStatus());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).sysAfterOrderPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> keepAccountPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).keepAccountPage(dto));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            this.getCustomerInfo(pageInfo.getList());
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> freightKeeping(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).freightKeeping(dto));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            this.getCustomerInfo(pageInfo.getList());
        }
        return new RestResponse((Object)pageInfo);
    }

    private void getCustomerInfo(List<SaleOrderItemVo> list) {
        List codes = list.stream().map(SaleOrderItemVo::getCustomerCode).collect(Collectors.toList());
        List customerInfoEos = ((ExtQueryChainWrapper)this.dgCustomerInfoDomain.filter().in((Object)"code", codes)).list();
        for (SaleOrderItemVo saleOrderItemVo : list) {
            for (DgCustomerInfoEo customerInfoEo : customerInfoEos) {
                if (!saleOrderItemVo.getCustomerCode().equals(customerInfoEo.getCode())) continue;
                saleOrderItemVo.setCustomerId(customerInfoEo.getId());
                saleOrderItemVo.setCustomerName(customerInfoEo.getName());
                saleOrderItemVo.setSapCode(customerInfoEo.getSapCode());
            }
        }
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> billingPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).billingPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> selectReturnPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).selectReturnPage(dto));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List codes = pageInfo.getList().stream().map(SaleOrderItemVo::getShopCustomerCode).collect(Collectors.toList());
            List customerInfoEos = ((ExtQueryChainWrapper)this.dgCustomerInfoDomain.filter().in((Object)"code", codes)).list();
            for (SaleOrderItemVo saleOrderItemVo : pageInfo.getList()) {
                for (DgCustomerInfoEo customerInfoEo : customerInfoEos) {
                    if (!saleOrderItemVo.getShopCustomerCode().equals(customerInfoEo.getCode())) continue;
                    saleOrderItemVo.setCustomerId(customerInfoEo.getId());
                    saleOrderItemVo.setCustomerName(customerInfoEo.getName());
                    saleOrderItemVo.setSapCode(customerInfoEo.getSapCode());
                }
            }
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> getWithoutOriginalReturnPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).getWithoutOriginalReturnPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgSaleOrderEo>> getSaleOrderByOrderNos(List<String> saleOrderNos) {
        if (CollectionUtils.isNotEmpty(saleOrderNos)) {
            List saleOrderEos = ((ExtQueryChainWrapper)((ISaleOrderDomain)this.domain).filter().in((Object)"sale_order_no", new Object[0])).list();
            return new RestResponse((Object)saleOrderEos);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<DgSaleOrderEo> getSaleOrderByPlatformOrderNo(String platformNo) {
        DgSaleOrderEo dgSaleOrderEo = null;
        if (StringUtils.isNotBlank((CharSequence)platformNo)) {
            dgSaleOrderEo = (DgSaleOrderEo)((ExtQueryChainWrapper)((ISaleOrderDomain)this.domain).filter().eq((Object)"platform_order_no", (Object)platformNo)).one();
        }
        return new RestResponse(dgSaleOrderEo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> billingReturnOnlyPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).billingReturnOnlyPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> getWithoutOriginalReturnBillingPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).getWithoutOriginalReturnBillingPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> packageMaterialPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).packageMaterialPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> packageMaterialbillingPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).packageMaterialbillingPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderItemVo>> getReceiveReturnSaleOrderItemPage(BookAccountsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).getReceiveReturnSaleOrderItemPage(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgSaleOrderItemEo>> getZxItemCustomerCode(List<Long> saleOrderItemIds) {
        if (CollectionUtils.isNotEmpty(saleOrderItemIds)) {
            List saleOrderItemEos = ((ExtQueryChainWrapper)this.dgSaleOrderItemDomain.filter().in((Object)"id", saleOrderItemIds)).list();
            return new RestResponse((Object)saleOrderItemEos);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<List<DgSaleOrderDto>> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List dgSaleOrderEos = ((ISaleOrderDomain)this.domain).selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)dgSaleOrderEos)) {
            return null;
        }
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dgSaleOrderEos, dtoList, DgSaleOrderDto.class);
        return new RestResponse(dtoList);
    }

    @Override
    public DgSaleOrderDeliverResultDto querySaleOrderReceiveResult(DgSaleOrderDto orderDto) {
        this.logger.info("\u67e5\u8be2\u9500\u552e\u5355\u53d1\u8d27\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderDto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)orderDto.getSaleOrderNo()), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List detailDtoList = ((ISaleOrderDomain)this.domain).querySaleOrderReceiveResult(orderDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)detailDtoList)) {
            return null;
        }
        DgOrderReceiveResultDetailDto detailDto = (DgOrderReceiveResultDetailDto)detailDtoList.get(0);
        DgSaleOrderDeliverResultDto resultDto = (DgSaleOrderDeliverResultDto)BeanCopyUtil.copy((Object)detailDto, DgSaleOrderDeliverResultDto.class);
        ArrayList recordDtoList = new ArrayList();
        Map<String, List<DgOrderReceiveResultDetailDto>> resultCollect = detailDtoList.stream().collect(Collectors.groupingBy(DgOrderReceiveResultDetailDto::getDocumentNo));
        resultCollect.forEach((k, v) -> {
            DgReceiveDeliverResultRecordDto recordDto = (DgReceiveDeliverResultRecordDto)BeanCopyUtil.copy(v.get(0), DgReceiveDeliverResultRecordDto.class);
            List resultRecordItemDtoList = BeanCopyUtil.copyPropertiesForList((List)v, DgReceiveDeliverResultRecordItemDto.class);
            recordDto.setItemDtoList(resultRecordItemDtoList);
            recordDtoList.add(recordDto);
        });
        resultDto.setRecordDtoList(recordDtoList);
        return resultDto;
    }
}

