/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.SkuCostConverter;
import com.yunxi.dg.base.center.report.domain.entity.ISkuCostDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.dto.entity.SkuCostDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuCostPageReqDto;
import com.yunxi.dg.base.center.report.eo.SkuCostEo;
import com.yunxi.dg.base.center.report.eo.item.DirDgEo;
import com.yunxi.dg.base.center.report.service.entity.ISkuCostService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgReportService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SkuCostServiceImpl
extends BaseServiceImpl<SkuCostDto, SkuCostEo, ISkuCostDomain>
implements ISkuCostService {
    private static final Logger log = LoggerFactory.getLogger(SkuCostServiceImpl.class);
    @Resource
    private IDirDgDomain iDirDgDomain;
    @Resource
    private IItemSkuDgReportService iItemSkuDgReportService;

    public SkuCostServiceImpl(ISkuCostDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SkuCostDto, SkuCostEo> converter() {
        return SkuCostConverter.INSTANCE;
    }

    @Override
    public List<SkuCostDto> queryList(SkuCostPageReqDto dto) {
        List skuCostEos = ((ISkuCostDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SkuCostEo.class).like(StrUtil.isNotBlank((CharSequence)dto.getSkuName()), SkuCostEo::getSkuName, (Object)dto.getSkuName())).eq(StrUtil.isNotBlank((CharSequence)dto.getSkuCode()), SkuCostEo::getSkuCode, (Object)dto.getSkuCode())).in(CollectionUtil.isNotEmpty((Collection)dto.getSkuCodeList()), SkuCostEo::getSkuCode, (Collection)dto.getSkuCodeList()));
        return BeanUtil.copyToList((Collection)skuCostEos, SkuCostDto.class);
    }

    public RestResponse<Integer> insertBatch(List<SkuCostDto> dtos) {
        Map<String, Long> countMap = dtos.stream().map(SkuCostDto::getSkuCode).collect(Collectors.groupingBy(k -> k, Collectors.counting()));
        countMap.forEach((skuCode, count) -> AssertUtils.isTrue((count <= 1L ? 1 : 0) != 0, (String)("\u5546\u54c1\u7f16\u7801" + skuCode + "\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5")));
        ((ISkuCostDomain)this.domain).saveOrUpdateBatch(BeanUtil.copyToList(dtos, SkuCostEo.class));
        return RestResponse.createInteger((Integer)1);
    }

    @Override
    public RestResponse<PageInfo<SkuCostDto>> page(SkuCostPageReqDto pageReqDto) {
        this.queryDirIdList(pageReqDto);
        PageInfo pageInfo = ((ISkuCostDomain)this.domain).listSkuCostPage(pageReqDto);
        this.iDirDgDomain.setFullDirName(pageInfo.getList(), SkuCostDto::getDirId, SkuCostDto::setDirName);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<Long> insert(SkuCostDto dto) {
        SkuCostEo skuCostEo = (SkuCostEo)((ISkuCostDomain)this.domain).selectOne((LambdaQueryWrapper)Wrappers.lambdaQuery(SkuCostEo.class).eq(SkuCostEo::getSkuCode, (Object)dto.getSkuCode()));
        AssertUtils.isNull((Object)skuCostEo, (String)"\u8be5sku\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        return super.insert((BaseDto)dto);
    }

    private void queryDirIdList(SkuCostPageReqDto pageReqDto) {
        if (pageReqDto.getDirIdList() == null || pageReqDto.getDirIdList().isEmpty()) {
            return;
        }
        List dirs = this.iDirDgDomain.getDescendants(pageReqDto.getDirIdList());
        List dirIdList = dirs.stream().map(BaseEo::getId).collect(Collectors.toList());
        pageReqDto.setDirIdList(dirIdList);
    }

    private Map<Long, DirDgEo> mapParentByChildDriIds(List<Long> dirIds) {
        if (CollectionUtil.isEmpty(dirIds)) {
            return Collections.emptyMap();
        }
        List dirDgEos = this.iDirDgDomain.selectByIds(dirIds);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dirDgEos)) {
            Set indexPaths = dirDgEos.stream().map(DirDgEo::getIndexPath).collect(Collectors.toSet());
            dirDgEos.addAll(this.iDirDgDomain.queryAllSub(indexPaths));
        }
        return ((List)Optional.ofNullable(dirDgEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
    }

    private void joinDirName(SkuCostDto dto, Map<Long, List<DirDgEo>> parentByChildDriIds) {
        List<DirDgEo> dirDgEos = parentByChildDriIds.get(dto.getDirId());
        if (CollectionUtils.isEmpty(dirDgEos)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = dirDgEos.size() - 1; i >= 0; --i) {
            if (i == 0) {
                sb.append(dirDgEos.get(i).getName());
                continue;
            }
            sb.append(dirDgEos.get(i).getName()).append("/");
        }
        dto.setDirName(sb.toString());
    }

    @Override
    public Map<String, SkuCostDto> getSkuCostMap(Collection<String> skuCodes) {
        List eoList = ((ISkuCostDomain)this.domain).getBySkuCosts(skuCodes);
        return eoList.stream().collect(Collectors.toMap(SkuCostEo::getSkuCode, v -> (SkuCostDto)this.converter().toDto((BaseEo)v), (a, b) -> {
            log.info("\u91cd\u590d\u7f16\u7801\uff1acode={}, a={}, b={}", new Object[]{a.getSkuCode(), a.getId(), b.getId()});
            return b;
        }));
    }
}

