/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.expense.IActivityCostRecordDomain;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostFormDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostFormRecordDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostRecordDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.expense.BudgetObjectInfoDto;
import com.yunxi.dg.base.center.report.eo.expense.ActivityCostRecordEo;
import com.yunxi.dg.base.center.report.service.expense.BudgetUtils;
import com.yunxi.dg.base.center.report.service.expense.IActivityCostFormService;
import com.yunxi.dg.base.center.report.service.expense.IActivityCostRecordService;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityCostRecordServiceImpl
implements IActivityCostRecordService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCostRecordServiceImpl.class);
    @Resource
    private IActivityCostFormService activityCostFormService;
    @Resource
    private IActivityCostRecordDomain activityCostRecordDomain;
    @Resource
    private BudgetUtils budgetUtils;
    @Resource
    private IContext context;

    @Override
    public PageInfo<ActivityCostRecordDto> page(ActivityCostRecordPageReqDto dto) {
        PageInfo pageInfo;
        List activityCostRecordDtoList;
        if (Objects.equals(dto.getSelfCreate(), 1)) {
            dto.setCreatePerson(this.context.userName());
        }
        if (CollectionUtils.isNotEmpty((Collection)(activityCostRecordDtoList = (pageInfo = this.activityCostRecordDomain.page(dto)).getList()))) {
            ArrayList list = Lists.newArrayList();
            list.addAll(activityCostRecordDtoList);
            this.budgetUtils.dealObjectName(list);
        }
        return pageInfo;
    }

    @Override
    public ActivityCostRecordDto getById(Long id) {
        ActivityCostRecordDto activityCostRecordDto = this.activityCostRecordDomain.getById(id);
        this.budgetUtils.dealObjectName(Lists.newArrayList((Object[])new BudgetObjectInfoDto[]{activityCostRecordDto}));
        return activityCostRecordDto;
    }

    @Override
    public ActivityCostFormRecordDto getByActivityCostFormId(Long activityCostFormId) {
        ActivityCostFormDto activityCostFormDto = this.activityCostFormService.getById(activityCostFormId);
        ActivityCostFormRecordDto activityCostRecordDto = new ActivityCostFormRecordDto();
        BeanCopyUtil.copyProperties((Object)activityCostFormDto, (Object)activityCostRecordDto);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ActivityCostRecordEo::getActivityCostFormId, (Object)activityCostFormId);
        List activityCostRecordEos = this.activityCostRecordDomain.getMapper().selectList((Wrapper)lqw);
        if (CollectionUtils.isNotEmpty((Collection)activityCostRecordEos)) {
            List recordList = activityCostRecordEos.stream().map(recordEo -> {
                ActivityCostFormRecordDto.ExecuteRecord record = new ActivityCostFormRecordDto.ExecuteRecord();
                record.setId(recordEo.getId());
                record.setCode(recordEo.getCode());
                record.setPosition(recordEo.getPosition());
                record.setAddress(recordEo.getAddress());
                record.setCreateTime(recordEo.getCreateTime());
                record.setCreatePerson(recordEo.getCreatePerson());
                return record;
            }).collect(Collectors.toList());
            activityCostRecordDto.setRecordList(recordList);
        }
        return activityCostRecordDto;
    }
}

