/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.fetch;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum U9OrderTypeEnum {
    STANDARD_SHIP("Ship", "\u6807\u51c6\u51fa\u8d27", "sales_outbound", "delivery"),
    TRANSFER_OUT("TransferOut", "\u8c03\u51fa\u5355", "transfer_order", "delivery"),
    TRANSFER_IN("TransferIn", "\u8c03\u5165\u5355", "transfer_order", "receive"),
    ONE_STEP_TRANSFER("Transfer", "\u8c03\u5165\u5355\uff08\u4e00\u6b65\u5f0f\uff09", "one_transfer_order", "receive"),
    MISC_RECEIVE("MiscRcv", "\u6742\u6536\u5355", "other_in", "receive"),
    MISC_SHIP("MiscShip", "\u6742\u53d1\u5355", "other_out", "delivery"),
    PURCHASE_RECEIVE("PurchaseRcv", "\u91c7\u8d2d\u6536\u8d27\u5355", "PURCHASE", "receive"),
    PURCHASE_RETURN("PurchaseReRcv", "\u91c7\u8d2d\u9000\u8d27\u5355", "PURCHASE_RETURN", "delivery"),
    COMPLETION_REPORT("CompleteRpt", "\u5b8c\u5de5\u62a5\u544a", "wms_production_completion", "receive"),
    RETURN_PROCESS("RMA", "\u9000\u56de\u5904\u7406", "order_sales_refund", "receive"),
    REWORK_ISSUE("Issue", "\u8fd4\u5de5\u9886\u6599", "wms_production_completion", "delivery"),
    SEND_RECEIVE_DIFF("TransferIn", "\u6536\u53d1\u5dee\u5f02\u5165", "send_receive_diff", "receive"),
    ORDINARY_TRANSFER("TransferIn", "\u666e\u901a\u8c03\u62e8", "ORDINARY_TRANSFER", "receive"),
    BORROWING_RETURNING_EQUIPMENT("TransferIn", "\u501f\u673a\u8c03\u62e8", "BORROWING_RETURNING_EQUIPMENT", "receive");

    private String code;
    private String desc;
    private String inventoryType;
    private String orderType;

    private U9OrderTypeEnum(String code, String desc, String inventoryType, String orderType) {
        this.code = code;
        this.desc = desc;
        this.inventoryType = inventoryType;
        this.orderType = orderType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(String inventoryType) {
        this.inventoryType = inventoryType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public static U9OrderTypeEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.stream(U9OrderTypeEnum.values()).filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

    public static U9OrderTypeEnum getByInventoryTypeAndOrderType(String inventoryType, String orderType) {
        if (StringUtils.isBlank((CharSequence)inventoryType)) {
            return null;
        }
        return Arrays.stream(U9OrderTypeEnum.values()).filter(eo -> inventoryType.equals(eo.getInventoryType()) && orderType.equals(eo.getOrderType())).findAny().orElse(null);
    }
}

