/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.fetch.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.IWmsInventoryApi;
import com.yunxi.dg.base.center.inventory.dto.request.WmsDeliveryQueryRequestDto;
import com.yunxi.dg.base.center.inventory.dto.request.WmsInventoryBaseRequestDto;
import com.yunxi.dg.base.center.inventory.dto.request.WmsReceiptQueryRequestDto;
import com.yunxi.dg.base.center.inventory.dto.request.WmsTransferOrderRequestDto;
import com.yunxi.dg.base.center.inventory.dto.response.WmsDeliveryOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.WmsReceiptOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.WmsTransferOrderRespDto;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchStrategy;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgDeliveryResultOrderDas;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgOutResultOrderDas;
import com.yunxi.dg.base.center.report.eo.inventory.DgDeliveryResultOrderEo;
import com.yunxi.dg.base.center.report.service.fetch.WmsInventoryOrderTypeEnum;
import com.yunxi.dg.base.center.report.service.fetch.impl.AbstractDataFetchOverwriteStrategy;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WmsDataFetchStrategy
extends AbstractDataFetchOverwriteStrategy
implements DataFetchStrategy {
    private static final Logger log = LoggerFactory.getLogger(WmsDataFetchStrategy.class);
    final Integer pageSize = 100;
    final Integer initialValue = 1;
    @Resource
    private IWmsInventoryApi wmsInventoryApi;
    @Resource
    private IDgDeliveryResultOrderDas deliveryResultOrderDas;
    @Resource
    private IDgOutResultOrderDas dgOutResultOrderDas;

    public String type() {
        return InventoryReconciliationSourceEnum.WMS.getCode();
    }

    @Override
    public void doFetchAndSaveData(DataFetchBo dataFetchBo) {
        log.info("\u5f00\u59cb\u62c9\u53d6wms\u5355\u636e\u6d41\u6c34,dataFetchBo:{}", (Object)JSON.toJSONString((Object)dataFetchBo));
        String reconciliationDateStr = null;
        reconciliationDateStr = dataFetchBo.getReconciliationDate() == null ? WmsDataFetchStrategy.getDateString(-1) : DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)dataFetchBo.getReconciliationDate());
        Date reconciliationDate = DateUtil.parseDate((String)reconciliationDateStr, (String)"yyyy-MM-dd");
        this.doDelete(ThreeInventoryPostDetailDto.builder().reconciliationTime(reconciliationDate).source(InventoryReconciliationSourceEnum.WMS.getCode()).build());
        String startTime = DateUtil.getDateToString((Date)DateUtil.getDayBegin((Date)reconciliationDate));
        String endTime = DateUtil.getDateToString((Date)DateUtil.getDayEnd((Date)reconciliationDate));
        AtomicInteger pageNum = new AtomicInteger(this.initialValue);
        Lists.newArrayList((Object[])new String[]{"R09"}).forEach(wmsType -> {
            while (true) {
                List listWmsBaseRespDtoResult;
                block4: {
                    WmsInventoryBaseRequestDto<WmsReceiptQueryRequestDto> wmsRReq = this.buildWmsReceiptInventoryBaseRequestDto(this.pageSize, pageNum.getAndAdd(this.initialValue), startTime, endTime, (String)wmsType);
                    try {
                        listWmsBaseRespDtoResult = (List)this.wmsInventoryApi.queryInboundOrderPage(wmsRReq).getData();
                        if (CollectionUtils.isEmpty((Collection)listWmsBaseRespDtoResult)) {
                            pageNum.set(this.initialValue);
                        }
                        break block4;
                    }
                    catch (Exception e) {
                        log.info("\u62c9\u53d6wms\u5355\u636e\u6d41\u6c34\u5931\u8d25", (Throwable)e);
                    }
                    break;
                }
                List<ThreeInventoryPostDetailDto> threeInventoryPostDetailDtos = this.convertReceiptToDto(reconciliationDate, listWmsBaseRespDtoResult);
                if (!CollectionUtils.isNotEmpty(threeInventoryPostDetailDtos)) continue;
                this.doSave(threeInventoryPostDetailDtos);
            }
        });
        pageNum.set(this.initialValue);
        Lists.newArrayList((Object[])new String[]{"C01", "C03"}).forEach(wmsType -> {
            while (true) {
                List deliveryOrderResps;
                block4: {
                    WmsInventoryBaseRequestDto<WmsDeliveryQueryRequestDto> wmsDReq = this.buildWmsInventoryBaseRequestDto(this.pageSize, pageNum.getAndAdd(this.initialValue), startTime, endTime, (String)wmsType);
                    try {
                        deliveryOrderResps = (List)this.wmsInventoryApi.queryOutboundOrderPage(wmsDReq).getData();
                        if (CollectionUtils.isEmpty((Collection)deliveryOrderResps)) {
                            pageNum.set(this.initialValue);
                        }
                        break block4;
                    }
                    catch (Exception e) {
                        log.info("\u62c9\u53d6wms\u5355\u636e\u6d41\u6c34\u5931\u8d25", (Throwable)e);
                    }
                    break;
                }
                List<ThreeInventoryPostDetailDto> threeInventoryPostDetailDtos = this.convertDeliveryToDto(reconciliationDate, deliveryOrderResps);
                if (!CollectionUtils.isNotEmpty(threeInventoryPostDetailDtos)) continue;
                this.doSave(threeInventoryPostDetailDtos);
            }
        });
        pageNum.set(this.initialValue);
        while (true) {
            List deliveryOrderResps;
            block4: {
                WmsInventoryBaseRequestDto<WmsTransferOrderRequestDto> wmsDReq = this.buildWmsTransferOrderRequestDto(this.pageSize, pageNum.getAndAdd(this.initialValue), startTime, endTime);
                try {
                    deliveryOrderResps = (List)this.wmsInventoryApi.queryTransferOrderPage(wmsDReq).getData();
                    if (CollectionUtils.isEmpty((Collection)deliveryOrderResps)) {
                    }
                    break block4;
                }
                catch (Exception e) {
                    log.info("\u62c9\u53d6wms\u5f85\u68c0\u8f6c\u5408\u683c\u8c03\u62e8\u5355\u6d41\u6c34\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            List<ThreeInventoryPostDetailDto> threeInventoryPostDetailDtos = this.convertTransferToDto(reconciliationDate, deliveryOrderResps);
            if (!CollectionUtils.isNotEmpty(threeInventoryPostDetailDtos)) continue;
            this.doSave(threeInventoryPostDetailDtos);
        }
    }

    private List<ThreeInventoryPostDetailDto> convertTransferToDto(Date reconciliationTime, List<WmsTransferOrderRespDto> deliveryOrderResps) {
        ArrayList<ThreeInventoryPostDetailDto> detailDtoList = new ArrayList<ThreeInventoryPostDetailDto>();
        List transferOrderNos = deliveryOrderResps.stream().filter(wmsTransferOrderRespDto -> StringUtils.isNotEmpty((CharSequence)wmsTransferOrderRespDto.getExterno())).map(WmsTransferOrderRespDto::getExterno).collect(Collectors.toList());
        List dgDeliveryResultOrderEos = ((ExtQueryChainWrapper)this.deliveryResultOrderDas.filter().in((Object)"relevance_no", transferOrderNos)).list();
        Map<String, List<DgDeliveryResultOrderEo>> deliveryResultMap = dgDeliveryResultOrderEos.stream().filter(dgDeliveryResultOrderEo -> "un_offset".equals(dgDeliveryResultOrderEo.getOffsetType())).collect(Collectors.groupingBy(DgDeliveryResultOrderEo::getRelevanceNo));
        log.info("wms\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u548c\u4e91\u9500\u8c03\u62e8\u5355\u53f7\uff0cdeliveryResultMap\uff1a{}", (Object)JSON.toJSONString(deliveryResultMap));
        deliveryOrderResps.forEach(wmsTransferOrderRespDto -> {
            String externo = wmsTransferOrderRespDto.getExterno();
            List resultOrderEos = (List)deliveryResultMap.get(externo);
            if (CollectionUtils.isEmpty((Collection)resultOrderEos)) {
                log.info("wms\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u548c\u4e91\u9500\u7ed3\u679c\u5355\u4e3a\u7a7a,externo:{}", (Object)externo);
                return;
            }
            resultOrderEos.forEach(deliveryResultEo -> {
                try {
                    ThreeInventoryPostDetailDto detailDto = new ThreeInventoryPostDetailDto();
                    if ("delivery".equals(deliveryResultEo.getOrderType())) {
                        detailDto.setOrderType("delivery");
                        detailDto.setWarehouseName(wmsTransferOrderRespDto.getFromLocName());
                    } else if ("receive".equals(deliveryResultEo.getOrderType())) {
                        detailDto.setOrderType("receive");
                        detailDto.setWarehouseName(wmsTransferOrderRespDto.getToLocName());
                    }
                    detailDto.setWarehouseCode(wmsTransferOrderRespDto.getWhseId().toLowerCase());
                    detailDto.setOrderNo(deliveryResultEo.getDocumentNo());
                    detailDto.setSource(InventoryReconciliationSourceEnum.WMS.getCode());
                    detailDto.setQuantity(new BigDecimal(wmsTransferOrderRespDto.getQty()));
                    detailDto.setSkuCode(wmsTransferOrderRespDto.getSku());
                    detailDto.setOsBizType(wmsTransferOrderRespDto.getType());
                    detailDto.setOsBizTypeStr(Objects.requireNonNull(WmsInventoryOrderTypeEnum.getByCode(wmsTransferOrderRespDto.getType())).getDesc());
                    detailDto.setOsOrderType(wmsTransferOrderRespDto.getType());
                    detailDto.setSkuName(wmsTransferOrderRespDto.getDescr());
                    detailDto.setOsBizNo(wmsTransferOrderRespDto.getAllotKey());
                    detailDto.setReconciliationTime(reconciliationTime);
                    detailDto.setInventoryProperty("qualified");
                    detailDto.setExtension(JSON.toJSONString((Object)wmsTransferOrderRespDto));
                    detailDtoList.add(detailDto);
                }
                catch (Exception e) {
                    log.info("wms\u8c03\u62e8\u5355\u8f6c\u6362\u5bf9\u8d26dto\u5931\u8d25\uff0cwmsTransferOrderRespDto:{}", (Object)JSON.toJSONString((Object)wmsTransferOrderRespDto), (Object)e);
                }
            });
        });
        return detailDtoList;
    }

    private List<ThreeInventoryPostDetailDto> convertDeliveryToDto(Date reconciliationTime, List<WmsDeliveryOrderRespDto> deliveryOrderResps) {
        ArrayList<ThreeInventoryPostDetailDto> detailDtoList = new ArrayList<ThreeInventoryPostDetailDto>();
        deliveryOrderResps.forEach(deliveryOrderResp -> deliveryOrderResp.getOrdersDtlMidList().forEach(wmsDeliveryOrderDetail -> {
            try {
                String externo;
                ThreeInventoryPostDetailDto detailDto = new ThreeInventoryPostDetailDto();
                String string = externo = StringUtils.isNotEmpty((CharSequence)deliveryOrderResp.getExterno()) ? deliveryOrderResp.getExterno() : wmsDeliveryOrderDetail.getExterno();
                if (StringUtils.isEmpty((CharSequence)externo)) {
                    log.info("wms\u7684\u548c\u4e91\u9500\u56de\u4f20\u5355\u53f7\u4e3a\u7a7a,wmsDeliveryOrderDetail:{}", (Object)JSONObject.toJSONString((Object)wmsDeliveryOrderDetail));
                    return;
                }
                DgDeliveryResultOrderEo dgDeliveryResultOrderEo = (DgDeliveryResultOrderEo)((ExtQueryChainWrapper)this.deliveryResultOrderDas.filter().eq((Object)"pre_order_no", (Object)externo)).one();
                if (Objects.isNull(dgDeliveryResultOrderEo)) {
                    log.info("\u51fa\u5e93\u7ed3\u679c\u5355\u67e5\u8be2\u53d1\u8d27\u7ed3\u679c\u5355\u4e3a\u7a7a,outResultNo:{}", (Object)deliveryOrderResp.getExterno());
                    return;
                }
                if (!"un_offset".equals(dgDeliveryResultOrderEo.getOffsetType())) {
                    log.info("\u6536\u8d27\u7ed3\u679c\u5355\u5df2\u7ea2\u51b2\u4e0d\u8bb0\u5165\u5bf9\u8d26\uff0cdocumentNo:{}", (Object)dgDeliveryResultOrderEo.getDocumentNo());
                    return;
                }
                JSONObject jsonObject = Optional.ofNullable(JSONObject.parseObject((String)dgDeliveryResultOrderEo.getExtension())).orElse(new JSONObject());
                Integer earlyProductOutbound = jsonObject.getInteger("earlyProductOutbound");
                if (Objects.nonNull(earlyProductOutbound) && earlyProductOutbound == 1) {
                    log.info("\u51fa\u5e93\u7ed3\u679c\u5355\u662f\u63d0\u524d\u51fa\u5e93\u4e0d\u53c2\u4e0e\u5bf9\u8d26,documentNo:{}", (Object)dgDeliveryResultOrderEo.getDocumentNo());
                    return;
                }
                detailDto.setOrderNo(dgDeliveryResultOrderEo.getDocumentNo());
                detailDto.setOrderType("delivery");
                detailDto.setQuantity(new BigDecimal(wmsDeliveryOrderDetail.getShippedQty()));
                detailDto.setSkuCode(wmsDeliveryOrderDetail.getSku());
                detailDto.setReconciliationTime(reconciliationTime);
                detailDto.setSource(InventoryReconciliationSourceEnum.WMS.getCode());
                detailDto.setExtension(JSONObject.toJSONString((Object)wmsDeliveryOrderDetail));
                detailDto.setInventoryProperty("qualified");
                detailDto.setOsBizNo(deliveryOrderResp.getOrderkey());
                detailDto.setOsBizType(deliveryOrderResp.getType());
                detailDto.setOsOrderType(deliveryOrderResp.getType());
                detailDto.setOsBizTypeStr(Objects.requireNonNull(WmsInventoryOrderTypeEnum.getByCode(deliveryOrderResp.getType())).getDesc());
                detailDto.setWarehouseCode(deliveryOrderResp.getWhseid());
                detailDtoList.add(detailDto);
            }
            catch (Exception e) {
                log.info("wms\u53d1\u8d27\u5355\u636e\u8f6c\u6362\u5bf9\u8d26dto\u5931\u8d25\uff0cwmsReceiptOrderDetail:{}", (Object)JSON.toJSONString((Object)wmsDeliveryOrderDetail), (Object)e);
            }
        }));
        return detailDtoList;
    }

    private List<ThreeInventoryPostDetailDto> convertReceiptToDto(Date reconciliationTime, List<WmsReceiptOrderRespDto> listWmsBaseRespDtos) {
        ArrayList<ThreeInventoryPostDetailDto> detailDtoList = new ArrayList<ThreeInventoryPostDetailDto>();
        listWmsBaseRespDtos.forEach(wmsReceiptOrderRespDto -> wmsReceiptOrderRespDto.getReceiptDtlMidList().forEach(wmsReceiptOrderDetail -> {
            try {
                String externo;
                ThreeInventoryPostDetailDto detailDto = new ThreeInventoryPostDetailDto();
                String string = externo = StringUtils.isNotEmpty((CharSequence)wmsReceiptOrderRespDto.getExterno()) ? wmsReceiptOrderRespDto.getExterno() : wmsReceiptOrderDetail.getExterno();
                if (StringUtils.isEmpty((CharSequence)externo)) {
                    log.info("wms\u7684\u548c\u4e91\u9500\u56de\u4f20\u5355\u53f7\u4e3a\u7a7a,wmsDeliveryOrderDetail:{}", (Object)JSONObject.toJSONString((Object)wmsReceiptOrderDetail));
                    return;
                }
                DgDeliveryResultOrderEo dgDeliveryResultOrderEo = (DgDeliveryResultOrderEo)((ExtQueryChainWrapper)this.deliveryResultOrderDas.filter().eq((Object)"pre_order_no", (Object)externo)).one();
                if (Objects.isNull(dgDeliveryResultOrderEo)) {
                    log.info("\u5165\u5e93\u7ed3\u679c\u5355\u67e5\u8be2\u6536\u8d27\u7ed3\u679c\u5355\u4e3a\u7a7a,inResultNo:{}", (Object)wmsReceiptOrderRespDto.getExterno());
                    return;
                }
                if (!"un_offset".equals(dgDeliveryResultOrderEo.getOffsetType())) {
                    log.info("\u6536\u8d27\u7ed3\u679c\u5355\u5df2\u7ea2\u51b2\u4e0d\u8bb0\u5165\u5bf9\u8d26\uff0cdocumentNo:{}", (Object)dgDeliveryResultOrderEo.getDocumentNo());
                    return;
                }
                detailDto.setOrderNo(dgDeliveryResultOrderEo.getDocumentNo());
                detailDto.setOrderType("receive");
                detailDto.setQuantity(new BigDecimal(wmsReceiptOrderDetail.getQtyReceived()));
                detailDto.setSkuCode(wmsReceiptOrderDetail.getSku());
                detailDto.setReconciliationTime(reconciliationTime);
                detailDto.setSource(InventoryReconciliationSourceEnum.WMS.getCode());
                detailDto.setExtension(JSONObject.toJSONString((Object)wmsReceiptOrderDetail));
                detailDto.setInventoryProperty("qualified");
                detailDto.setOsBizNo(wmsReceiptOrderDetail.getReceiptkey());
                detailDto.setOsBizType(wmsReceiptOrderRespDto.getType());
                detailDto.setOsOrderType(wmsReceiptOrderRespDto.getType());
                detailDto.setOsBizTypeStr(Objects.requireNonNull(WmsInventoryOrderTypeEnum.getByCode(wmsReceiptOrderRespDto.getType())).getDesc());
                detailDto.setWarehouseCode(wmsReceiptOrderRespDto.getWhseId());
                detailDtoList.add(detailDto);
            }
            catch (Exception e) {
                log.info("wms\u6536\u8d27\u5355\u636e\u8f6c\u6362\u5bf9\u8d26dto\u5931\u8d25\uff0cwmsReceiptOrderDetail:{}", (Object)JSON.toJSONString((Object)wmsReceiptOrderDetail), (Object)e);
            }
        }));
        return detailDtoList;
    }

    public static String getDateString(int day) {
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate yesterday = LocalDate.now().plusDays(day);
        return yesterday.format(DATE_FORMATTER);
    }

    private WmsInventoryBaseRequestDto<WmsReceiptQueryRequestDto> buildWmsReceiptInventoryBaseRequestDto(Integer pageSize, int pageNum, String startTime, String endTime, String wmsType) {
        WmsInventoryBaseRequestDto.ReconciliationDate date = new WmsInventoryBaseRequestDto.ReconciliationDate();
        date.setStart(startTime);
        date.setEnd(endTime);
        WmsReceiptQueryRequestDto wmsDeliveryQueryRequestDto = new WmsReceiptQueryRequestDto();
        WmsInventoryBaseRequestDto wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto = new WmsInventoryBaseRequestDto();
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setPageNum(pageNum);
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setPageSize(pageSize.intValue());
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setDate(date);
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setModel((Object)wmsDeliveryQueryRequestDto);
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setOp(wmsType);
        return wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto;
    }

    private WmsInventoryBaseRequestDto<WmsDeliveryQueryRequestDto> buildWmsInventoryBaseRequestDto(Integer pageSize, Integer pageNum, String startTime, String endTime, String wmsType) {
        WmsInventoryBaseRequestDto.ReconciliationDate date = new WmsInventoryBaseRequestDto.ReconciliationDate();
        date.setStart(startTime);
        date.setEnd(endTime);
        WmsDeliveryQueryRequestDto wmsDeliveryQueryRequestDto = new WmsDeliveryQueryRequestDto();
        WmsInventoryBaseRequestDto wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto = new WmsInventoryBaseRequestDto();
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setPageNum(pageNum.intValue());
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setPageSize(pageSize.intValue());
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setDate(date);
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setModel((Object)wmsDeliveryQueryRequestDto);
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setOp(wmsType);
        return wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto;
    }

    private WmsInventoryBaseRequestDto<WmsTransferOrderRequestDto> buildWmsTransferOrderRequestDto(Integer pageSize, Integer pageNum, String startTime, String endTime) {
        WmsInventoryBaseRequestDto.ReconciliationDate date = new WmsInventoryBaseRequestDto.ReconciliationDate();
        date.setStart(startTime);
        date.setEnd(endTime);
        WmsInventoryBaseRequestDto wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto = new WmsInventoryBaseRequestDto();
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setDate(date);
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setPageNum(pageNum.intValue());
        wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto.setPageSize(pageSize.intValue());
        return wmsDeliveryQueryRequestDtoWmsInventoryBaseRequestDto;
    }
}

