/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.adjustment;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.entity.AdjustmentOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IAdjustmentOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.report.dto.adjustment.AdjustmentOrderCombDto;
import com.yunxi.dg.base.center.report.dto.adjustment.AdjustmentOrderDto;
import com.yunxi.dg.base.center.report.dto.adjustment.AdjustmentOrderPageReqDto;
import com.yunxi.dg.base.center.report.eo.adjustment.AdjustmentOrderEo;
import com.yunxi.dg.base.center.report.service.adjustment.IAdjustmentOrderService;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AdjustmentOrderServiceImpl
extends BaseServiceImpl<AdjustmentOrderDto, AdjustmentOrderEo, IAdjustmentOrderDomain>
implements IAdjustmentOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentOrderServiceImpl.class);
    String adjustmentOrderTableName = "in_adjustment_order";
    String adjustmentOrderDetailTableName = "in_adjustment_order_detail";
    private static final String[] ORDER_NOS = new String[]{"orderNo", "externalOrderNo", "adjustmentNo"};
    @Resource
    private IAdjustmentOrderDomain adjustmentOrderDomain;
    @Resource
    private IAdjustmentOrderDetailDomain adjustmentOrderDetailDomain;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;

    public AdjustmentOrderServiceImpl(IAdjustmentOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AdjustmentOrderDto, AdjustmentOrderEo> converter() {
        return AdjustmentOrderConverter.INSTANCE;
    }

    @Override
    public PageInfo<AdjustmentOrderCombDto> queryPage(AdjustmentOrderPageReqDto adjustmentOrderPageReqDto) {
        log.info("\u8c03\u6574\u5355\u5206\u9875\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)adjustmentOrderPageReqDto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderPageReqDto.getOrderType()));
        PageInfo<AdjustmentOrderCombDto> pageInfo = this.queryListPage(adjustmentOrderPageReqDto);
        return pageInfo;
    }

    @Override
    public List<AdjustmentOrderDto> queryByExternalOrderNos(List<String> externalOrderNos) {
        List adjustmentOrderEos = ((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().in((Object)"external_order_no", externalOrderNos)).list();
        List adjustmentOrderDtos = this.converter().toDtoList(adjustmentOrderEos);
        return adjustmentOrderDtos;
    }

    private PageInfo<AdjustmentOrderCombDto> queryListPage(AdjustmentOrderPageReqDto adjustmentOrderPageReqDto) {
        PageInfo combDtoList = new PageInfo();
        if ("detail".equals(adjustmentOrderPageReqDto.getDisplay())) {
            if (this.esQuery.booleanValue()) {
                combDtoList = this.getAdjustmentOrderDetailEsList(adjustmentOrderPageReqDto);
            } else {
                PageHelper.startPage((int)adjustmentOrderPageReqDto.getPageNum(), (int)adjustmentOrderPageReqDto.getPageSize());
                combDtoList = new PageInfo(this.adjustmentOrderDetailDomain.queryList(adjustmentOrderPageReqDto));
            }
        } else if (this.esQuery.booleanValue()) {
            combDtoList = this.getAdjustmentOrderEsList(adjustmentOrderPageReqDto);
        } else {
            PageHelper.startPage((int)adjustmentOrderPageReqDto.getPageNum(), (int)adjustmentOrderPageReqDto.getPageSize());
            combDtoList = new PageInfo(this.adjustmentOrderDomain.queryList(adjustmentOrderPageReqDto));
        }
        return combDtoList;
    }

    private PageInfo<AdjustmentOrderCombDto> getAdjustmentOrderEsList(AdjustmentOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.adjustmentOrderTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                AdjustmentOrderCombDto orderItemPageDto = (AdjustmentOrderCombDto)BeanUtil.copyProperties((Object)docValue, AdjustmentOrderCombDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(AdjustmentOrderPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u8c03\u6574\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCodeList", (List)reqDto.getSkuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSpuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCodeList", (List)reqDto.getSpuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatches())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batchList", (List)reqDto.getBatches())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayNameList", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getOrigBatches())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"origBatchList", (List)reqDto.getOrigBatches())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u8c03\u6574\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private PageInfo<AdjustmentOrderCombDto> getAdjustmentOrderDetailEsList(AdjustmentOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.adjustmentOrderDetailTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initDetailSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                AdjustmentOrderCombDto orderItemPageDto = (AdjustmentOrderCombDto)BeanUtil.copyProperties((Object)docValue, AdjustmentOrderCombDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initDetailSearchVo(AdjustmentOrderPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u8c03\u6574\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCode", (List)reqDto.getSkuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSpuCodes())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCode", (List)reqDto.getSpuCodes())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatches())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batch", (List)reqDto.getBatches())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayName", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getOrigBatches())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"origBatch", (List)reqDto.getOrigBatches())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u8c03\u6574\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

