/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.domain.customer.ICsRCustomerBusinessTypeDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgAddressDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgBillInfoDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgContactsInfoDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCompanyInfoDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCustomerCompanyAuditDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCustomerOrgLevelDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.SumCustomerRelationNum;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerAuditQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerQueryExtDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerRelationQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsTransactionCustomerInfoAuditRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsTransactionCustomerInfoRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsTransactionCustomerRelationRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CuCustomerRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CustomerFinancialOrgPlatformRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CustomerPlatformRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCompanyInfoRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerInfoAuditDto;
import com.yunxi.dg.base.center.report.dto.customer.response.OperationTeamRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.RPlatCusRespDto;
import com.yunxi.dg.base.center.report.enums.DgCustomerBusinessTypeEnum;
import com.yunxi.dg.base.center.report.eo.customer.CsRCustomerBusinessTypeEo;
import com.yunxi.dg.base.center.report.eo.customer.DgAddressEo;
import com.yunxi.dg.base.center.report.eo.customer.DgBillInfoEo;
import com.yunxi.dg.base.center.report.eo.customer.DgContactsInfoEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerCompanyAuditEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerOrgLevelEo;
import com.yunxi.dg.base.center.report.service.customer.IDgCustomerInfoQueryService;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerInfoQueryServiceImpl
implements IDgCustomerInfoQueryService {
    private static final Logger log = LoggerFactory.getLogger(DgCustomerInfoQueryServiceImpl.class);
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource
    private IDgCsCompanyInfoDomain iDgCsCompanyInfoDomain;
    @Resource
    private IDgCsCustomerCompanyAuditDomain iDgCsCustomerCompanyAuditDomain;
    @Resource
    private IDgCsOrgCustomerRelationDomain iDgCsOrgCustomerRelationDomain;
    @Resource
    private IDgCsCustomerOrgLevelDomain iDgCsCustomerOrgLevelDomain;
    @Resource
    private IDgContactsInfoDomain iDgContactsInfoDomain;
    @Resource
    private IDgAddressDomain iDgAddressDomain;
    @Resource
    private IDgBillInfoDomain iDgBillInfoDomain;
    @Resource
    private ICsRCustomerBusinessTypeDomain iCsRCustomerBusinessTypeDomain;
    @Resource
    private IUsOrganizationDomain iUsOrganizationDomain;
    @Resource
    private IDgCustomerAreaDomain iDgCustomerAreaDomain;

    @Override
    public PageInfo<CsTransactionCustomerInfoRespDto> queryTransactionCustomerPage(CsTransactionCustomerQueryDto reqDto) {
        List<Integer> businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType());
        if (reqDto.getRootOrganizationId() != null && StrUtil.isNotBlank((CharSequence)RequestUtil.getHeader("Root-Organization-Id"))) {
            String rootOrgId = RequestUtil.getHeader("Root-Organization-Id");
            reqDto.setRootOrganizationId(Long.valueOf(rootOrgId));
        }
        ArrayList<Long> departmentIdList = new ArrayList<Long>();
        if (Objects.nonNull(reqDto.getDepartmentId())) {
            departmentIdList.add(reqDto.getDepartmentId());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getDepartmentIdList())) {
            departmentIdList.addAll(reqDto.getDepartmentIdList());
        }
        if (CollectionUtils.isNotEmpty(departmentIdList)) {
            ArrayList organizationDtoList = new ArrayList();
            this.iUsOrganizationDomain.listChildOrgByOrgIdAndFuncType(departmentIdList, "sales", organizationDtoList);
            if (CollectionUtils.isNotEmpty(organizationDtoList)) {
                reqDto.setDepartmentIdList(organizationDtoList.stream().map(CsOrganizationPageRespDto::getId).collect(Collectors.toList()));
            }
        }
        this.setChildArea(reqDto);
        PageInfo pageInfo = this.iDgCustomerDomain.queryTransactionCustomerPage(reqDto, businessType);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        Map<Long, DgCustomerAreaEo> levelMap = this.mapAreaLevel(pageInfo.getList());
        pageInfo.getList().forEach(dto -> this.setRegionLevelList(levelMap, (CsTransactionCustomerInfoRespDto)dto));
        return pageInfo;
    }

    @Override
    public PageInfo<CsTransactionCustomerInfoAuditRespDto> queryTransactionCustomerAuditPage(CsTransactionCustomerAuditQueryDto reqDto) {
        ExtQueryChainWrapper filter = this.iDgCsCustomerCompanyAuditDomain.filter();
        this.setSqlFilters(reqDto, (ExtQueryChainWrapper<DgCustomerCompanyAuditEo>)filter);
        PageInfo info = filter.page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo pageInfo = (PageInfo)BeanUtil.copyProperties((Object)info, PageInfo.class, (String[])new String[]{"list"});
        pageInfo.setList(this.convertCustomerInfoAudit(info.getList()));
        return pageInfo;
    }

    @Override
    public PageInfo<CsTransactionCustomerRelationRespDto> queryTransactionCustomerRelationPage(CsTransactionCustomerRelationQueryDto reqDto) {
        PageInfo pageInfo = this.iDgCsCompanyInfoDomain.queryTransactionCustomerRelationPage(reqDto);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        List dgCustomerEos = this.iDgCustomerDomain.listCustomerByCompanyIds(pageInfo.getList().stream().map(CsTransactionCustomerRelationRespDto::getCompanyId).collect(Collectors.toSet()));
        this.setCustomerRelationLevelTags(pageInfo.getList(), dgCustomerEos, reqDto.getRootOrganizationId());
        this.sumCompanyCustomerRelationNum(pageInfo.getList(), dgCustomerEos);
        return pageInfo;
    }

    @Override
    public PageInfo<CsTransactionCustomerInfoRespDto> queryCustomerPage(CsTransactionCustomerQueryExtDto reqDto) {
        List<Integer> businessType = reqDto.getBusinessTypeList();
        if (CollectionUtils.isEmpty((Collection)reqDto.getBusinessTypeList())) {
            businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType(), DgCustomerBusinessTypeEnum.TYPE_DSFX.getType(), DgCustomerBusinessTypeEnum.TYPE_ZYKH.getType());
        }
        PageInfo info = this.iDgCustomerDomain.queryCustomerPage(reqDto, (List)businessType);
        this.dealPlatCusList((PageInfo<CsTransactionCustomerInfoRespDto>)info);
        if (CollectionUtils.isEmpty((Collection)info.getList())) {
            return info;
        }
        if (reqDto.getIsOther() == null || reqDto.getIsOther().equals(0)) {
            this.setOtherInfo((PageInfo<CsTransactionCustomerInfoRespDto>)info);
        }
        return info;
    }

    private void dealPlatCusList(PageInfo<CsTransactionCustomerInfoRespDto> info) {
        List<String> customerCodeList = info.getList().stream().map(CsTransactionCustomerInfoRespDto::getCustomerCode).distinct().collect(Collectors.toList());
        Map<String, CuCustomerRespDto> cuCustomerRespDtoMap = this.getCuCustomerRespDto(customerCodeList);
        log.info("\u548c\u4e91\u9500\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(cuCustomerRespDtoMap));
        info.getList().forEach(v -> {
            if (cuCustomerRespDtoMap.containsKey(v.getCustomerCode())) {
                CuCustomerRespDto cuCustomerRespDto = (CuCustomerRespDto)cuCustomerRespDtoMap.get(v.getCustomerCode());
                v.setCuCustomerId(Objects.nonNull(cuCustomerRespDto) ? cuCustomerRespDto.getCustomerId() : null);
            }
        });
        List<Long> customerIds = info.getList().stream().map(CsTransactionCustomerInfoRespDto::getCuCustomerId).distinct().collect(Collectors.toList());
        List<RPlatCusRespDto> platCusRespDtos = this.queryByCustomerIds(customerIds);
        Map<Long, List<RPlatCusRespDto>> platCusRespDtosListMap = platCusRespDtos.stream().collect(Collectors.groupingBy(RPlatCusRespDto::getCustomerId));
        info.getList().forEach(v -> {
            if (platCusRespDtosListMap.containsKey(v.getCuCustomerId())) {
                List platCusRespDtoList = (List)platCusRespDtosListMap.get(v.getCuCustomerId());
                v.setRPlatCusRespDtos(platCusRespDtoList);
            }
        });
    }

    private Map<String, CuCustomerRespDto> getCuCustomerRespDto(List<String> customerCodeList) {
        List cuCustomerRespDtos;
        int length;
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Maps.newHashMap();
        }
        HashMap cuCustomerRespDtoHashMap = Maps.newHashMap();
        int i = 0;
        for (length = customerCodeList.size(); length > 500; length -= 500) {
            cuCustomerRespDtos = this.iDgCustomerDomain.queryCuCustomerIds(customerCodeList.subList(i, i + 500));
            if (CollectionUtils.isNotEmpty((Collection)cuCustomerRespDtos)) {
                cuCustomerRespDtoHashMap.putAll(cuCustomerRespDtos.stream().collect(Collectors.toMap(CuCustomerRespDto::getCustomerCode, Function.identity(), (k1, k2) -> k1)));
            }
            i += 500;
        }
        if (length > 0 && CollectionUtils.isNotEmpty((Collection)(cuCustomerRespDtos = this.iDgCustomerDomain.queryCuCustomerIds(customerCodeList.subList(i, i + length))))) {
            cuCustomerRespDtoHashMap.putAll(cuCustomerRespDtos.stream().collect(Collectors.toMap(CuCustomerRespDto::getCustomerCode, Function.identity(), (k1, k2) -> k1)));
        }
        return cuCustomerRespDtoHashMap;
    }

    private List<RPlatCusRespDto> queryByCustomerIds(List<Long> customerIds) {
        Map operatorTeamMap;
        List operationTeamEos;
        Map map;
        List operatorTeamIds;
        List platFormIds;
        List respDtos;
        int length;
        ArrayList platCusRespDtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerIds)) {
            return platCusRespDtos;
        }
        int i = 0;
        for (length = customerIds.size(); length > 500; length -= 500) {
            respDtos = this.iDgCustomerDomain.queryRPlatCusByList(customerIds.subList(i, i + 500));
            if (CollectionUtils.isNotEmpty((Collection)respDtos)) {
                platFormIds = respDtos.stream().map(RPlatCusRespDto::getPlatformId).collect(Collectors.toList());
                operatorTeamIds = respDtos.stream().map(RPlatCusRespDto::getOperatorTeamId).collect(Collectors.toList());
                map = this.iDgCustomerDomain.getFinancialOrgByPlatformIds(platFormIds);
                if (MapUtils.isNotEmpty((Map)map)) {
                    respDtos.forEach(v -> v.setFinancialOrgRespDtos((List)map.get(v.getPlatformId())));
                }
                if (CollectionUtil.isNotEmpty((Collection)(operationTeamEos = this.iDgCustomerDomain.queryOperationTeamEos(operatorTeamIds)))) {
                    operatorTeamMap = operationTeamEos.stream().collect(Collectors.toMap(OperationTeamRespDto::getId, Function.identity(), (k1, k2) -> k1));
                    respDtos.forEach(dto -> {
                        dto.setU9OrgCode(dto.getOrgId() != null ? dto.getOrgId().toString() : null);
                        OperationTeamRespDto operationTeamEo = (OperationTeamRespDto)operatorTeamMap.get(dto.getOperatorTeamId());
                        if (Objects.nonNull(operationTeamEo)) {
                            dto.setOperatorTeamName(operationTeamEo.getTeamName());
                            dto.setOperatorTeamCode(operationTeamEo.getTeamCode());
                            dto.setOrgName(operationTeamEo.getDeptName());
                            dto.setOrgId(operationTeamEo.getDeptId());
                            dto.setOrgCode(operationTeamEo.getOrgCode());
                            dto.setuCode(operationTeamEo.getUCode());
                        }
                    });
                }
                platCusRespDtos.addAll(respDtos);
            }
            i += 500;
        }
        if (length > 0 && CollectionUtils.isNotEmpty((Collection)(respDtos = this.iDgCustomerDomain.queryRPlatCusByList(customerIds.subList(i, i + length))))) {
            platFormIds = respDtos.stream().map(RPlatCusRespDto::getPlatformId).collect(Collectors.toList());
            operatorTeamIds = respDtos.stream().map(RPlatCusRespDto::getOperatorTeamId).collect(Collectors.toList());
            map = this.iDgCustomerDomain.getFinancialOrgByPlatformIds(platFormIds);
            if (MapUtils.isNotEmpty((Map)map)) {
                respDtos.forEach(v -> v.setFinancialOrgRespDtos((List)map.get(v.getPlatformId())));
            }
            if (CollectionUtil.isNotEmpty((Collection)(operationTeamEos = this.iDgCustomerDomain.queryOperationTeamEos(operatorTeamIds)))) {
                operatorTeamMap = operationTeamEos.stream().collect(Collectors.toMap(OperationTeamRespDto::getId, Function.identity(), (k1, k2) -> k1));
                respDtos.forEach(dto -> {
                    dto.setU9OrgCode(dto.getOrgId() != null ? dto.getOrgId().toString() : null);
                    OperationTeamRespDto operationTeamEo = (OperationTeamRespDto)operatorTeamMap.get(dto.getOperatorTeamId());
                    if (Objects.nonNull(operationTeamEo)) {
                        dto.setOperatorTeamName(operationTeamEo.getTeamName());
                        dto.setOperatorTeamCode(operationTeamEo.getTeamCode());
                        dto.setOrgName(operationTeamEo.getDeptName());
                        dto.setOrgId(operationTeamEo.getDeptId());
                        dto.setOrgCode(operationTeamEo.getOrgCode());
                        dto.setuCode(operationTeamEo.getUCode());
                    }
                });
            }
            platCusRespDtos.addAll(respDtos);
        }
        return platCusRespDtos;
    }

    private Map<String, List<CustomerFinancialOrgPlatformRespDto>> customerOrgPlaformList(List<Long> customerIds) {
        List customerFinancialOrgPlatformRespDtos;
        int length;
        if (CollectionUtils.isEmpty(customerIds)) {
            return Maps.newHashMap();
        }
        HashMap financialOrgPlatformRespDtoListMap = Maps.newHashMap();
        int i = 0;
        for (length = customerIds.size(); length > 500; length -= 500) {
            customerFinancialOrgPlatformRespDtos = this.iDgCustomerDomain.queryFinancialOrgPlatformByCustomerId(customerIds.subList(i, i + 500), Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)customerFinancialOrgPlatformRespDtos)) {
                financialOrgPlatformRespDtoListMap.putAll(customerFinancialOrgPlatformRespDtos.stream().collect(Collectors.groupingBy(CustomerPlatformRespDto::getCustomerCode)));
            }
            i += 500;
        }
        if (length > 0 && CollectionUtils.isNotEmpty((Collection)(customerFinancialOrgPlatformRespDtos = this.iDgCustomerDomain.queryFinancialOrgPlatformByCustomerId(customerIds.subList(i, i + length), Integer.valueOf(1))))) {
            financialOrgPlatformRespDtoListMap.putAll(customerFinancialOrgPlatformRespDtos.stream().collect(Collectors.groupingBy(CustomerPlatformRespDto::getCustomerCode)));
        }
        return financialOrgPlatformRespDtoListMap;
    }

    @Override
    public List<CsTransactionCustomerInfoRespDto> queryTransactionCustomerList(CsTransactionCustomerQueryDto reqDto) {
        List<Integer> businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType());
        if (reqDto.getRootOrganizationId() != null && StrUtil.isNotBlank((CharSequence)RequestUtil.getHeader("Root-Organization-Id"))) {
            String rootOrgId = RequestUtil.getHeader("Root-Organization-Id");
            reqDto.setRootOrganizationId(Long.valueOf(rootOrgId));
        }
        return this.iDgCustomerDomain.queryTransactionCustomerList(reqDto, businessType);
    }

    @Override
    public List<CsTransactionCustomerInfoRespDto> queryCustomerList(CsTransactionCustomerQueryExtDto reqDto) {
        List<Integer> businessType = reqDto.getBusinessTypeList();
        if (CollectionUtils.isEmpty((Collection)reqDto.getBusinessTypeList())) {
            businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType(), DgCustomerBusinessTypeEnum.TYPE_DSFX.getType(), DgCustomerBusinessTypeEnum.TYPE_ZYKH.getType());
        }
        List customerInfoRespDtoList = this.iDgCustomerDomain.queryCustomerList(reqDto, (List)businessType);
        return customerInfoRespDtoList;
    }

    @Override
    public Long getCustomerIdByCode(String customerCode) {
        List customerEoList = ((ExtQueryChainWrapper)this.iDgCustomerDomain.filter().eq((Object)"code", (Object)customerCode)).list();
        if (CollectionUtils.isNotEmpty((Collection)customerEoList)) {
            return ((DgCustomerEo)customerEoList.get(0)).getId();
        }
        return null;
    }

    private void sumCompanyCustomerRelationNum(List<CsTransactionCustomerRelationRespDto> list, List<DgCustomerEo> dgCustomerEos) {
        Map<Object, Object> sumUpMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dgCustomerEos)) {
            List relationNums = this.iDgCsOrgCustomerRelationDomain.sumUpCompanyRelationNumByCustomerIds(dgCustomerEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
            sumUpMap = ((List)Optional.ofNullable(relationNums).orElse(new ArrayList())).stream().collect(Collectors.toMap(SumCustomerRelationNum::getCompanyId, SumCustomerRelationNum::getNum));
        }
        Map companyMap = list.stream().collect(Collectors.toMap(CsTransactionCustomerRelationRespDto::getCompanyId, Function.identity()));
        Map<Long, Integer> sumDownMap = ((List)Optional.ofNullable(this.iDgCsOrgCustomerRelationDomain.sumDownCompanyRelationNumByCompanyIds((List)Lists.newArrayList(companyMap.keySet()))).orElse(new ArrayList())).stream().collect(Collectors.toMap(SumCustomerRelationNum::getCompanyId, SumCustomerRelationNum::getNum));
        for (Map.Entry entry : companyMap.entrySet()) {
            ((CsTransactionCustomerRelationRespDto)entry.getValue()).setUpCompanyNum((Integer)sumUpMap.get(entry.getKey()));
            ((CsTransactionCustomerRelationRespDto)entry.getValue()).setDownCompanyNum(sumDownMap.get(entry.getKey()));
        }
    }

    private void setCustomerRelationLevelTags(List<CsTransactionCustomerRelationRespDto> respDtoList, List<DgCustomerEo> dgCustomerEos, Long rootOrgId) {
        if (CollectionUtils.isEmpty(dgCustomerEos)) {
            return;
        }
        Map<Long, List<DgCustomerOrgLevelEo>> mapLevels = this.mapCustomerOrgLevelByOrganizationIdAndCustomerIds(rootOrgId, dgCustomerEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
        for (CsTransactionCustomerRelationRespDto dto : respDtoList) {
            Set levels = ((List)Optional.ofNullable(mapLevels.get(dto.getCompanyId())).orElse(new ArrayList())).stream().map(DgCustomerOrgLevelEo::getLevel).collect(Collectors.toSet());
            if (!CollectionUtils.isNotEmpty(levels)) continue;
            dto.setLevelTags((List)Lists.newArrayList(levels));
        }
    }

    private Map<Long, List<DgCustomerOrgLevelEo>> mapCustomerOrgLevelByOrganizationIdAndCustomerIds(Long rootOrgId, List<Long> customerIds) {
        List customerOrgLevelEos = this.iDgCsCustomerOrgLevelDomain.listCustomerOrgLevelByOrganizationIdAndCustomerIds(rootOrgId, customerIds);
        return ((List)Optional.ofNullable(customerOrgLevelEos).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgCustomerOrgLevelEo::getCompanyId));
    }

    private List<CsTransactionCustomerInfoAuditRespDto> convertCustomerInfoAudit(List<DgCustomerCompanyAuditEo> auditEos) {
        if (CollectionUtils.isEmpty(auditEos)) {
            return Collections.emptyList();
        }
        ArrayList<CsTransactionCustomerInfoAuditRespDto> auditRespDtos = new ArrayList<CsTransactionCustomerInfoAuditRespDto>();
        HashSet<Long> parentCustomerIds = new HashSet<Long>();
        for (DgCustomerCompanyAuditEo dgCustomerCompanyAuditEo : auditEos) {
            DgCompanyInfoRespDto companyInfoAuditDto = (DgCompanyInfoRespDto)JSONUtil.toBean((String)dgCustomerCompanyAuditEo.getCompanyContent(), DgCompanyInfoRespDto.class);
            CsTransactionCustomerInfoAuditRespDto auditRespDto = new CsTransactionCustomerInfoAuditRespDto();
            auditRespDto.setRemark(dgCustomerCompanyAuditEo.getRemark());
            auditRespDto.setAuditor(dgCustomerCompanyAuditEo.getAuditor());
            auditRespDto.setAuditTime(dgCustomerCompanyAuditEo.getAuditTime());
            auditRespDto.setApplyCode(dgCustomerCompanyAuditEo.getApplyCode());
            auditRespDto.setCreditCode(dgCustomerCompanyAuditEo.getCreditCode());
            auditRespDto.setCustomerCode(dgCustomerCompanyAuditEo.getCustomerCode());
            auditRespDto.setCompanyName(companyInfoAuditDto.getCompanyName());
            auditRespDto.setOperationType(dgCustomerCompanyAuditEo.getOperationType());
            auditRespDto.setStatus(dgCustomerCompanyAuditEo.getStatus());
            auditRespDto.setCreatePerson(dgCustomerCompanyAuditEo.getCreatePerson());
            auditRespDto.setCreateTime(dgCustomerCompanyAuditEo.getCreateTime());
            auditRespDto.setId(dgCustomerCompanyAuditEo.getId());
            auditRespDto.setCustomerId(dgCustomerCompanyAuditEo.getCustomerId());
            auditRespDto.setExtension(dgCustomerCompanyAuditEo.getExtension());
            DgCustomerInfoAuditDto customerInfoAuditDto = (DgCustomerInfoAuditDto)JSONUtil.toBean((String)dgCustomerCompanyAuditEo.getCustomerContent(), DgCustomerInfoAuditDto.class);
            auditRespDto.setDomesticForeignCustomer(customerInfoAuditDto.getDomesticForeignCustomer());
            auditRespDto.setCustomerCategory(customerInfoAuditDto.getCustomerCategory());
            auditRespDto.setCustomerName(customerInfoAuditDto.getCustomerName());
            if (Objects.nonNull(customerInfoAuditDto.getParentCustomerId())) {
                parentCustomerIds.add(customerInfoAuditDto.getParentCustomerId());
                auditRespDto.setParentCustomerId(customerInfoAuditDto.getParentCustomerId());
            }
            auditRespDtos.add(auditRespDto);
        }
        if (CollectionUtils.isNotEmpty(parentCustomerIds)) {
            List dgCustomerEos = this.iDgCustomerDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCustomerEo.class).in(BaseEo::getId, parentCustomerIds));
            Map customerEoMap = ((List)Optional.ofNullable(dgCustomerEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
            for (CsTransactionCustomerInfoAuditRespDto auditRespDto : auditRespDtos) {
                DgCustomerEo dgCustomerEo;
                Long parentCustomerId = auditRespDto.getParentCustomerId();
                if (Objects.isNull(parentCustomerId) || Objects.isNull(dgCustomerEo = (DgCustomerEo)customerEoMap.get(parentCustomerId))) continue;
                auditRespDto.setParentCustomerCode(dgCustomerEo.getCode());
                auditRespDto.setParentCustomerName(dgCustomerEo.getName());
                auditRespDto.setParentCustomerExternalCode(dgCustomerEo.getExternalCode());
            }
        }
        return auditRespDtos;
    }

    private void setSqlFilters(CsTransactionCustomerAuditQueryDto reqDto, ExtQueryChainWrapper<DgCustomerCompanyAuditEo> filter) {
        if (Objects.nonNull(reqDto.getCustomerType())) {
            filter.eq((Object)"customer_type", (Object)reqDto.getCustomerType());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getApplyCode())) {
            filter.like((Object)"apply_code", (Object)reqDto.getApplyCode());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCreditCode())) {
            filter.like((Object)"credit_code", (Object)reqDto.getCreditCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getStatusList())) {
            filter.in((Object)"status", (Collection)reqDto.getStatusList());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCreatePerson())) {
            filter.like((Object)"create_person", (Object)reqDto.getCreatePerson());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCompanyName())) {
            filter.like((Object)"company_content", (Object)reqDto.getCompanyName());
        }
        if (reqDto.getOperationType() != null) {
            filter.eq((Object)"operation_type", (Object)reqDto.getOperationType());
        }
        if (reqDto.getCustomerCode() != null) {
            filter.like((Object)"customer_code", (Object)reqDto.getCustomerCode());
        }
        if (reqDto.getRootOrganizationId() != null) {
            filter.eq((Object)"organization_id", (Object)reqDto.getRootOrganizationId());
        } else {
            String rootOrganizationId = RequestUtil.getHeader("Root-Organization-Id");
            filter.eq(StrUtil.isNotBlank((CharSequence)rootOrganizationId), (Object)"organization_id", (Object)rootOrganizationId);
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCompanyName())) {
            filter.like((Object)"company_name", (Object)reqDto.getCompanyName());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getParentCustomerName())) {
            filter.like((Object)"customer_content", (Object)("\"parentCustomerName\":\"%" + reqDto.getParentCustomerName() + "%\""));
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            filter.like((Object)"customer_content", (Object)("\"customerName\":\"%" + reqDto.getCustomerName() + "%\""));
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getParentCustomerExternalCode())) {
            filter.like((Object)"customer_content", (Object)("\"parentCustomerExternalCode\":\"%" + reqDto.getParentCustomerExternalCode() + "%\""));
        }
        if (Objects.nonNull(reqDto.getDomesticForeignCustomer())) {
            filter.like((Object)"customer_content", (Object)("\"domesticForeignCustomer\":" + reqDto.getDomesticForeignCustomer()));
        }
        filter.orderByDesc((Object)"create_time");
    }

    private void setOtherInfo(PageInfo<CsTransactionCustomerInfoRespDto> info) {
        List idList = info.getList().stream().map(BaseDto::getId).collect(Collectors.toList());
        List companyIdList = info.getList().stream().map(CsTransactionCustomerInfoRespDto::getCompanyId).collect(Collectors.toList());
        List dgContactsInfoEos = this.iDgContactsInfoDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgContactsInfoEo.class).in(DgContactsInfoEo::getCustomerId, idList)).orderByAsc(BaseEo::getId));
        Map<Long, List<DgContactsInfoEo>> contactsInfoMap = ((List)Optional.ofNullable(dgContactsInfoEos).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgContactsInfoEo::getCustomerId));
        List addressEoList = this.iDgAddressDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgAddressEo.class).in(DgAddressEo::getOrgInfoId, companyIdList)).in(DgAddressEo::getAddressType, new Object[]{"1"})).orderByAsc(BaseEo::getId));
        Map<Long, List<DgAddressEo>> addressInfoMap = ((List)Optional.ofNullable(addressEoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgAddressEo::getOrgInfoId));
        List dgBillInfoEoList = this.iDgBillInfoDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgBillInfoEo.class).in(DgBillInfoEo::getCompanyId, companyIdList)).orderByAsc(BaseEo::getId));
        Map<Long, List<DgBillInfoEo>> billInfoEoMap = ((List)Optional.ofNullable(dgBillInfoEoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgBillInfoEo::getCompanyId));
        List typeEos = this.iCsRCustomerBusinessTypeDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(CsRCustomerBusinessTypeEo.class).in(CsRCustomerBusinessTypeEo::getCustomerId, idList));
        Map<Long, List<CsRCustomerBusinessTypeEo>> typeMap = ((List)Optional.ofNullable(typeEos).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(CsRCustomerBusinessTypeEo::getCustomerId));
        for (CsTransactionCustomerInfoRespDto respDto : info.getList()) {
            List<CsRCustomerBusinessTypeEo> businessTypeEos;
            List<DgBillInfoEo> list;
            List<DgAddressEo> dgAddressEos;
            List<DgContactsInfoEo> contactsInfoEos = contactsInfoMap.get(respDto.getId());
            if (CollectionUtils.isNotEmpty(contactsInfoEos)) {
                for (DgContactsInfoEo dgContactsInfoEo : contactsInfoEos) {
                    respDto.setIsDefaultContact(Integer.valueOf(dgContactsInfoEo.getDefaultContact() != false ? 1 : 0));
                    respDto.setLinkName(dgContactsInfoEo.getLinkName());
                    respDto.setPhoneNum(dgContactsInfoEo.getPhoneNum());
                    respDto.setTel(dgContactsInfoEo.getTel());
                    respDto.setReserveMobile(dgContactsInfoEo.getReserveMobile());
                    respDto.setEmail(dgContactsInfoEo.getEmail());
                    if (!Objects.equals(dgContactsInfoEo.getDefaultContact(), true)) continue;
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(dgAddressEos = addressInfoMap.get(respDto.getCompanyId()))) {
                for (Object dgAddressEo : dgAddressEos) {
                    respDto.setIsDefaultAddress(dgAddressEo.getIsDefault());
                    respDto.setContact(dgAddressEo.getContact());
                    respDto.setPhone(dgAddressEo.getPhone());
                    respDto.setProvince(dgAddressEo.getProvince());
                    respDto.setCity(dgAddressEo.getCity());
                    respDto.setDistrict(dgAddressEo.getDistrict());
                    respDto.setDetailAddr(dgAddressEo.getDetailAddr());
                    respDto.setAddressType(dgAddressEo.getAddressType());
                    if (!Objects.equals(dgAddressEo.getIsDefault(), 1)) continue;
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(list = billInfoEoMap.get(respDto.getCompanyId()))) {
                Object dgAddressEo;
                dgAddressEo = list.iterator();
                while (dgAddressEo.hasNext()) {
                    DgBillInfoEo dgBillInfoEo = (DgBillInfoEo)dgAddressEo.next();
                    respDto.setIsDefaultInvoice(dgBillInfoEo.getIsDefault());
                    respDto.setInvoiceType(String.valueOf(dgBillInfoEo.getInvoiceType()));
                    respDto.setInvoiceTitle(dgBillInfoEo.getInvoiceTitle());
                    respDto.setDutyNum(dgBillInfoEo.getDutyNum());
                    respDto.setDepositBank(dgBillInfoEo.getDepositBank());
                    respDto.setBankAccount(dgBillInfoEo.getBankAccount());
                    respDto.setInvoiceAddress(dgBillInfoEo.getInvoiceAddress());
                    respDto.setInvoiceTel(dgBillInfoEo.getTel());
                    if (!Objects.equals(dgBillInfoEo.getIsDefault(), 1)) continue;
                    break;
                }
            }
            if (!CollectionUtils.isNotEmpty(businessTypeEos = typeMap.get(respDto.getId()))) continue;
            respDto.setBusinessTypeList(businessTypeEos.stream().map(CsRCustomerBusinessTypeEo::getBusinessType).collect(Collectors.toList()));
        }
    }

    private void setRegionLevelList(Map<Long, DgCustomerAreaEo> levelMap, CsTransactionCustomerInfoRespDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getRegionIndexPath())) {
            return;
        }
        List indexPathIdList = Arrays.stream(dto.getRegionIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(indexPathIdList)) {
            return;
        }
        ArrayList<Object> regionLevelList = new ArrayList<Object>();
        for (Long indexPathId : indexPathIdList) {
            DgCustomerAreaEo dgCustomerAreaEo = levelMap.get(indexPathId);
            if (Objects.isNull(dgCustomerAreaEo)) continue;
            regionLevelList.add(BeanUtil.toBean((Object)dgCustomerAreaEo, DgBusinessAreaLevelDto.class));
        }
        dto.setRegionLevelList(regionLevelList);
    }

    private Map<Long, DgCustomerAreaEo> mapAreaLevel(List<CsTransactionCustomerInfoRespDto> respDtoList) {
        List regionIndexPathList = respDtoList.stream().map(CsTransactionCustomerInfoRespDto::getRegionIndexPath).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(regionIndexPathList)) {
            return Collections.emptyMap();
        }
        List indexPathIdList = regionIndexPathList.stream().map(dto -> Arrays.stream(dto.split(",")).map(Long::valueOf).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return ((List)Optional.ofNullable(this.iDgCustomerAreaDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BaseEo::getId, indexPathIdList))).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
    }

    private void setChildArea(CsTransactionCustomerQueryDto reqDto) {
        List areaIdList = reqDto.getAreaIdList();
        if (CollectionUtils.isEmpty((Collection)areaIdList)) {
            return;
        }
        List areaEos = this.iDgCustomerAreaDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCustomerAreaEo.class).in(BaseEo::getId, (Collection)areaIdList));
        if (CollectionUtils.isEmpty((Collection)areaEos)) {
            return;
        }
        List codes = areaEos.stream().map(DgCustomerAreaEo::getCode).collect(Collectors.toList());
        ArrayList dgCustomerAreaEos = new ArrayList();
        this.iDgCustomerAreaDomain.listChildAreaByCodes(codes, dgCustomerAreaEos);
        if (CollectionUtils.isNotEmpty(dgCustomerAreaEos)) {
            reqDto.setAreaIdList(dgCustomerAreaEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList()));
        }
    }
}

