/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgDeliveryResultOrderConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgDeliveryResultOrderEo;
import com.yunxi.dg.base.center.report.service.agg.IDgBasisOrderRelOrderInfoService;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgDeliveryResultOrderService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgDeliveryResultOrderServiceImpl
extends BaseServiceImpl<DgDeliveryResultOrderDto, DgDeliveryResultOrderEo, IDgDeliveryResultOrderDomain>
implements IDgDeliveryResultOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgDeliveryResultOrderServiceImpl.class);
    String tableName = "cs_delivery_result_order";
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IDgBasisOrderRelOrderInfoService dgBasisOrderRelOrderInfoService;

    public DgDeliveryResultOrderServiceImpl(IDgDeliveryResultOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgDeliveryResultOrderDto, DgDeliveryResultOrderEo> converter() {
        return DgDeliveryResultOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgDeliveryResultOrderDto>> queryList(DgDeliveryResultOrderPageReqDto dto) {
        return new RestResponse((Object)((IDgDeliveryResultOrderDomain)this.domain).queryList(dto));
    }

    @Override
    public RestResponse<PageInfo<DgDeliveryResultOrderDto>> queryPage(DgDeliveryResultOrderPageReqDto dto) {
        PageInfo dgDeliveryNoticeOrderDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            dgDeliveryNoticeOrderDtoPageInfo = this.getDeliveryResultOrderEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            dgDeliveryNoticeOrderDtoPageInfo = new PageInfo(((IDgDeliveryResultOrderDomain)this.domain).queryList(dto));
        }
        return new RestResponse(dgDeliveryNoticeOrderDtoPageInfo);
    }

    @Override
    public RestResponse<DgDeliveryResultOrderDto> queryByDocumentNo(String documentNo) {
        DgDeliveryResultOrderDto dgDeliveryResultOrderDto = ((IDgDeliveryResultOrderDomain)this.domain).queryDocumentNoDetail(documentNo);
        return new RestResponse((Object)dgDeliveryResultOrderDto);
    }

    private PageInfo<DgDeliveryResultOrderDto> getDeliveryResultOrderEsList(DgDeliveryResultOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgDeliveryResultOrderDto orderItemPageDto = (DgDeliveryResultOrderDto)BeanUtil.copyProperties((Object)docValue, DgDeliveryResultOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgDeliveryResultOrderPageReqDto reqDto) throws Exception {
        log.info("ES\u6536\u53d1\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u6536\u53d1\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

