/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.es;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public interface BaseEsServiceInterface {
    public IOpenSearchService getIOpenSearchService();

    default public SearchResultVo searchData(String indexName, OSSearchVo osSearchVo) {
        try {
            osSearchVo.setIndexName(indexName);
            return this.getIOpenSearchService().search(osSearchVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    default public SearchResultVo searchWithScrollId(String scrollId, String keepAlive) {
        return this.getIOpenSearchService().searchWithScrollId(scrollId, keepAlive);
    }

    default public <T> List<T> baseRowMapper(SearchResultVo searchResultVo, final Class<T> valueType) {
        return searchResultVo.getDocValues(new RowMapper<T>(){

            public T mapRow(Map<String, Object> docValue) {
                return JacksonUtil.readValue((String)JacksonUtil.toJson(docValue), (Class)valueType);
            }
        });
    }

    default public <T> PageInfo<T> searchResultPage(SearchResultVo searchResultVo) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        return pageInfo;
    }

    default public String wildcard(String wildcard) {
        if (StringUtils.isBlank((String)wildcard)) {
            return "";
        }
        return String.format("*%s*", wildcard).replaceAll(" ", "");
    }

    default public Date beginTime(String time) {
        return DateUtil.parse((String)(time + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    default public Date endTime(String time) {
        return DateUtil.parse((String)(time + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    default public Date beginTime() {
        return this.beginTime("1970-01-01");
    }

    default public Date endTime() {
        return this.endTime("2050-12-30");
    }

    default public String beginTimeLong(String time) {
        return String.valueOf(this.beginTime(time).getTime());
    }

    default public String endTimeLong(String time) {
        return String.valueOf(this.endTime(time).getTime());
    }

    default public void addWildcardFilter(FilterFieldVo compoundFilter, String[] fieldNames, String likeValue) {
        for (String fieldName : fieldNames) {
            compoundFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)fieldName, (String)likeValue, (LogicalSymbol)LogicalSymbol.OR)});
        }
    }

    default public void addEqualsFilter(FilterFieldVo compoundFilter, String[] fieldNames, String likeValue) {
        for (String fieldName : fieldNames) {
            compoundFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)fieldName, (String)likeValue, (LogicalSymbol)LogicalSymbol.OR)});
        }
    }
}

