/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.query.impl;

import com.yunxi.dg.base.center.report.dao.common.select.MultipartSelectGeneric;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderDetailRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderQueryDto;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.AbstractReportDataSearchServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="assemblyDisassemblyReportDataSearchService")
public class AssemblyDisassemblyReportDataSearchServiceImpl
extends AbstractReportDataSearchServiceImpl<AssemblyDisassemblyOrderQueryDto, AssemblyDisassemblyOrderDetailRespDto> {
    public AssemblyDisassemblyReportDataSearchServiceImpl() {
        this("in_assembly_disassembly_order", "m");
    }

    public AssemblyDisassemblyReportDataSearchServiceImpl(String tableName, String alias) {
        super(tableName, alias);
    }

    @Override
    public void setLeftJoinOn(MultipartSelectGeneric generic) {
        generic.addLeftJoin("in_assembly_disassembly_order_detail", "md", "m.order_no = md.order_no");
        super.setLeftJoinOn(generic);
    }

    @Override
    public void setWhere(MultipartSelectGeneric generic, AssemblyDisassemblyOrderQueryDto reqDto) {
        if (reqDto.getType() != null) {
            generic.equalsWhere("md.type", (Object)reqDto.getType());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBizTypes())) {
            generic.in("m.biz_type", reqDto.getBizTypes());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            generic.in("m.order_status", reqDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLogicWarehouseCodes())) {
            generic.in("m.logic_warehouse_code", reqDto.getLogicWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodes())) {
            generic.in("m.physics_warehouse_code", reqDto.getPhysicsWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrganizationCodes())) {
            generic.in("m.organization_code", reqDto.getOrganizationCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSubSkuCodes())) {
            generic.in("md.sku_code", reqDto.getSubSkuCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCreatePersons())) {
            generic.in("m.create_person", reqDto.getCreatePersons());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getUpdatePersons())) {
            generic.in("m.update_person", reqDto.getUpdatePersons());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCreatePerson())) {
            generic.like("m.create_person", reqDto.getCreatePerson());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUpdatePerson())) {
            generic.like("m.update_person", reqDto.getUpdatePerson());
        }
        if (reqDto.getStartBizTime() != null) {
            generic.greaterThanEqualWhere("m.biz_time", (Object)reqDto.getStartBizTime());
        }
        if (reqDto.getEndBizTime() != null) {
            generic.lessThanEqualWhere("m.biz_time", (Object)reqDto.getEndBizTime());
        }
        if (reqDto.getStartCreateTime() != null) {
            generic.greaterThanEqualWhere("m.create_time", (Object)reqDto.getStartCreateTime());
        }
        if (reqDto.getEndCreateTime() != null) {
            generic.lessThanEqualWhere("m.create_time", (Object)reqDto.getEndCreateTime());
        }
        if (reqDto.getStartUpdateTime() != null) {
            generic.greaterThanEqualWhere("m.update_time", (Object)reqDto.getStartUpdateTime());
        }
        if (reqDto.getEndUpdateTime() != null) {
            generic.lessThanEqualWhere("m.update_time", (Object)reqDto.getEndUpdateTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            HashMap<String, String> orMap = new HashMap<String, String>();
            orMap.put("m.order_no", reqDto.getOrderNo());
            orMap.put("m.external_order_no", reqDto.getOrderNo());
            generic.or(orMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNoList())) {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add("m.order_no");
            fields.add("m.external_order_no");
            generic.inOr(fields, reqDto.getOrderNoList());
        }
        super.setWhere(generic, reqDto);
    }

    @Override
    public List<String> getExtFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("md.id AS id");
        fields.add("m.order_no AS orderNo");
        fields.add("m.order_status AS orderStatus");
        fields.add("m.biz_type AS bizType");
        fields.add("m.external_order_no AS externalOrderNo");
        fields.add("m.logic_warehouse_id AS logicWarehouseId");
        fields.add("m.logic_warehouse_code AS logicWarehouseCode");
        fields.add("m.logic_warehouse_name AS logicWarehouseName");
        fields.add("m.remark AS remark");
        fields.add("m.create_person AS createPerson");
        fields.add("m.create_time AS createTime");
        fields.add("m.biz_time AS bizTime");
        fields.add("m.update_person AS updatePerson");
        fields.add("m.update_time AS updateTime");
        fields.add("m.organization_id AS organizationId");
        fields.add("m.organization_code AS organizationCode");
        fields.add("m.organization_name AS organizationName");
        fields.add("m.physics_warehouse_id AS physicsWarehouseId");
        fields.add("m.physics_warehouse_code AS physicsWarehouseCode");
        fields.add("m.physics_warehouse_name AS physicsWarehouseName");
        fields.add("md.sku_code AS skuCode");
        fields.add("md.sku_name AS skuName");
        fields.add("md.art_no as artNo");
        fields.add("md.art_name as artName");
        fields.add("md.batch as batch");
        fields.add("md.sku_display_name as skuDisplayName");
        fields.add("md.produce_time as produceTime");
        fields.add("md.expire_time as expireTime");
        fields.add("md.mixture_ratio as mixtureRatio");
        fields.add("md.quantity as planQuantity");
        fields.add("md.unit_price");
        fields.add("md.unit");
        fields.add("md.volume");
        fields.add("md.weight");
        fields.add("m.extension");
        return fields;
    }
}

