/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.item;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.ItemTypeDgEnum;
import com.yunxi.dg.base.center.report.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.report.domain.entity.IUnitDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemMediasDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemUnitConversionDgDomain;
import com.yunxi.dg.base.center.report.dto.item.BundleItemDgReqDto;
import com.yunxi.dg.base.center.report.dto.item.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.report.dto.item.DgItemSkuRespDto;
import com.yunxi.dg.base.center.report.dto.item.DirRespDto;
import com.yunxi.dg.base.center.report.dto.item.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.report.dto.item.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.report.dto.item.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.report.dto.item.UnitDgRespDto;
import com.yunxi.dg.base.center.report.eo.UnitDgEo;
import com.yunxi.dg.base.center.report.eo.item.DirDgEo;
import com.yunxi.dg.base.center.report.eo.item.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgCustomerBuyScopeItemService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgReportService;
import com.yunxi.dg.base.center.report.utils.ConvertDgUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemSkuDgReportServiceImpl
implements IItemSkuDgReportService {
    private static Logger logger = LoggerFactory.getLogger(ItemSkuDgReportServiceImpl.class);
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IUnitDgDomain unitDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemMediasDgDomain itemMediasDgDomain;
    @Resource
    private IItemUnitConversionDgDomain iItemUnitConversionDgDomain;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Resource
    private IDgCustomerBuyScopeItemService dgCustomerBuyScopeItemService;

    @Override
    public List<DgItemSkuDetailRespDto> querySkuList(ItemQueryDgReqDto itemDgReqDto) {
        itemDgReqDto.setDirIds((List)(CollectionUtil.isNotEmpty((Collection)itemDgReqDto.getDirIds()) ? this.getChildDirIdList(itemDgReqDto.getDirIds(), itemDgReqDto.getInstanceId(), itemDgReqDto.getTenantId()) : Lists.newArrayList()));
        Map<Long, DgItemSkuDetailRespDto> respDtoMap = ((List)Optional.ofNullable(this.itemSkuDgDomain.queryItemSkuList(itemDgReqDto)).orElse(new ArrayList())).stream().map(e -> (DgItemSkuDetailRespDto)ConvertDgUtil.toBean((Object)e, DgItemSkuDetailRespDto.class)).collect(Collectors.toMap(DgItemSkuRespDto::getId, Function.identity()));
        this.setItemSkuMediasAndUnitConversion(respDtoMap);
        ArrayList dgItemSkuDetailRespDtos = Lists.newArrayList(respDtoMap.values());
        this.listBundleSkus(dgItemSkuDetailRespDtos);
        return dgItemSkuDetailRespDtos;
    }

    private void listBundleSkus(List<? extends DgItemSkuRespDto> list) {
        List<UnitDgRespDto> unitDgRespDtos;
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> unitCodes = new ArrayList<String>();
        Map<Object, Object> unitMap = new HashMap();
        Map<Object, Object> listMap = new HashMap();
        for (DgItemSkuRespDto dgItemSkuRespDto : list) {
            if (ItemTypeDgEnum.BUNDLE.getType().equals(dgItemSkuRespDto.getItemType()) || dgItemSkuRespDto.getItemType().equals(ItemTypeDgEnum.MULTIPLE.getType())) {
                ids.add(dgItemSkuRespDto.getItemId());
            }
            if (Objects.nonNull(dgItemSkuRespDto.getUnit())) {
                unitCodes.add(dgItemSkuRespDto.getUnit());
            }
            if (Objects.nonNull(dgItemSkuRespDto.getPriceUnit())) {
                unitCodes.add(dgItemSkuRespDto.getPriceUnit());
            }
            if (!Objects.nonNull(dgItemSkuRespDto.getSaleUnit())) continue;
            unitCodes.add(dgItemSkuRespDto.getSaleUnit());
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            List<UnitDgRespDto> unitDgRespDtos2;
            logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1{}", ids);
            List dgEos = this.itemBundleRelationDgDomain.selectByItemIdsList(ids);
            if (CollectionUtil.isEmpty((Collection)dgEos)) {
                return;
            }
            ArrayList<BundleItemDgReqDto> arrayList = new ArrayList<BundleItemDgReqDto>();
            List subSkuIds = dgEos.stream().map(ItemBundleRelationDgEo::getSubSkuId).collect(Collectors.toList());
            Map<Long, Object> itemSkuDgVoMap = new HashMap<Long, DgItemSkuRespVo>();
            ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
            reqDto.setSkuIds(subSkuIds);
            List skuDgVos = this.itemSkuDgDomain.queryItemSkuList(reqDto);
            if (CollectionUtil.isNotEmpty((Collection)skuDgVos)) {
                for (DgItemSkuRespVo skuDgVo : skuDgVos) {
                    itemSkuDgVoMap.put(skuDgVo.getId(), skuDgVo);
                    if (!Objects.nonNull(skuDgVo.getUnit())) continue;
                    unitCodes.add(skuDgVo.getUnit());
                }
                itemSkuDgVoMap = skuDgVos.stream().collect(Collectors.toMap(DgItemSkuRespVo::getId, Function.identity(), (k1, k2) -> k2));
            }
            if (CollectionUtil.isNotEmpty(unitCodes) && CollectionUtil.isNotEmpty(unitDgRespDtos2 = this.queryByCodes(unitCodes))) {
                unitMap = unitDgRespDtos2.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (K1, k2) -> k2));
            }
            for (ItemBundleRelationDgEo dgEo : dgEos) {
                DgItemSkuRespVo skuDgVo = (DgItemSkuRespVo)itemSkuDgVoMap.get(dgEo.getSubSkuId());
                BundleItemDgReqDto itemDgReqDto = (BundleItemDgReqDto)ConvertDgUtil.toBean((Object)dgEo, BundleItemDgReqDto.class);
                if (Objects.nonNull(skuDgVo)) {
                    itemDgReqDto.setSubItemCode(skuDgVo.getItemCode());
                    itemDgReqDto.setSubItemName(skuDgVo.getItemName());
                    itemDgReqDto.setUnit(skuDgVo.getUnit());
                    if (Objects.nonNull(unitMap.get(skuDgVo.getUnit()))) {
                        itemDgReqDto.setUnitName(((UnitDgRespDto)unitMap.get(skuDgVo.getUnit())).getName());
                    }
                    itemDgReqDto.setSubSkuCode(skuDgVo.getSkuCode());
                    itemDgReqDto.setSubSkuName(skuDgVo.getSkuName());
                    itemDgReqDto.setSpecOne(skuDgVo.getSpecOne());
                    itemDgReqDto.setSpecTwo(skuDgVo.getSpecTwo());
                }
                arrayList.add(itemDgReqDto);
            }
            listMap = ((List)Optional.ofNullable(arrayList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BundleItemDgReqDto::getItemId));
        } else if (CollectionUtil.isNotEmpty(unitCodes) && CollectionUtil.isNotEmpty(unitDgRespDtos = this.queryByCodes(unitCodes))) {
            unitMap = unitDgRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (K1, k2) -> k2));
        }
        for (DgItemSkuRespDto dgItemSkuRespDto : list) {
            if (Objects.nonNull(dgItemSkuRespDto.getUnit()) && Objects.nonNull(unitMap.get(dgItemSkuRespDto.getUnit()))) {
                dgItemSkuRespDto.setUnitName(((UnitDgRespDto)unitMap.get(dgItemSkuRespDto.getUnit())).getName());
            }
            if (Objects.nonNull(dgItemSkuRespDto.getPriceUnit()) && Objects.nonNull(unitMap.get(dgItemSkuRespDto.getPriceUnit()))) {
                dgItemSkuRespDto.setPriceUnitName(((UnitDgRespDto)unitMap.get(dgItemSkuRespDto.getPriceUnit())).getName());
            }
            if (Objects.nonNull(dgItemSkuRespDto.getSaleUnit()) && Objects.nonNull(unitMap.get(dgItemSkuRespDto.getSaleUnit()))) {
                dgItemSkuRespDto.setSaleUnitName(((UnitDgRespDto)unitMap.get(dgItemSkuRespDto.getSaleUnit())).getName());
            }
            dgItemSkuRespDto.setBundleSkus((List)listMap.get(dgItemSkuRespDto.getItemId()));
        }
    }

    public List<UnitDgRespDto> queryByCodes(List<String> codes) {
        if (CollectionUtil.isNotEmpty(codes)) {
            UnitDgEo selectEo = UnitDgEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"code", codes));
            selectEo.setSqlFilters(sqlFilterList);
            List list = this.unitDgDomain.selectList((BaseEo)selectEo, Integer.valueOf(1), Integer.valueOf(codes.size()));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList<UnitDgRespDto> dtos = new ArrayList<UnitDgRespDto>();
                DtoHelper.eoList2DtoList((Collection)list, dtos, UnitDgRespDto.class);
                return dtos;
            }
        }
        return null;
    }

    private void setItemSkuMediasAndUnitConversion(Map<Long, DgItemSkuDetailRespDto> skuIdMap) {
        if (CollectionUtil.isEmpty(skuIdMap)) {
            return;
        }
        this.setDirNameTree(Lists.newArrayList(skuIdMap.values()));
        Map mapBySkuIds = this.itemMediasDgDomain.mapBySkuIds((List)Lists.newArrayList(skuIdMap.keySet()));
        Map mapUnitBySkuId = this.iItemUnitConversionDgDomain.mapBySkuIds((List)Lists.newArrayList(skuIdMap.keySet()));
        for (Map.Entry<Long, DgItemSkuDetailRespDto> entry : skuIdMap.entrySet()) {
            entry.getValue().setImgUrlList(ConvertDgUtil.copyToList((Collection)((Collection)mapBySkuIds.get(entry.getKey())), ItemMediasDgRespDto.class));
            entry.getValue().setUnitConvertList(ConvertDgUtil.copyToList((Collection)((Collection)mapUnitBySkuId.get(entry.getKey())), ItemUnitConversionDgDto.class));
        }
    }

    private void setDirNameTree(List<? extends DgItemSkuRespDto> skuList) {
        if (CollectionUtils.isEmpty(skuList)) {
            return;
        }
        Set ids = skuList.stream().map(DgItemSkuRespDto::getDirId).collect(Collectors.toSet());
        Map<Long, List<DirDgEo>> parentByChildDriIds = this.getParentByChildDriIds(Lists.newArrayList(ids));
        skuList.forEach(e -> this.joinDirName((DgItemSkuRespDto)e, parentByChildDriIds));
    }

    private void joinDirName(DgItemSkuRespDto dto, Map<Long, List<DirDgEo>> parentByChildDriIds) {
        List<DirDgEo> dirDgEos = parentByChildDriIds.get(dto.getDirId());
        if (CollectionUtils.isEmpty(dirDgEos)) {
            return;
        }
        dto.setDirList(ConvertDgUtil.copyToList(dirDgEos, DirRespDto.class));
        StringBuffer sb = new StringBuffer();
        for (int i = dirDgEos.size() - 1; i >= 0; --i) {
            if (i == 0) {
                sb.append(dirDgEos.get(i).getName());
                continue;
            }
            sb.append(dirDgEos.get(i).getName()).append("/");
        }
        dto.setDirName(sb.toString());
    }

    @Override
    public Map<Long, List<DirDgEo>> getParentByChildDriIds(List<Long> dirIdList) {
        HashMap<Long, List<DirDgEo>> map = new HashMap<Long, List<DirDgEo>>();
        for (Long id : dirIdList) {
            List<DirDgEo> eos = this.dgCustomerBuyScopeItemService.getParentByChildDriId(id);
            map.put(id, eos);
        }
        return map;
    }

    public List<Long> getChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        List<Long> childDirIdList = this.queryChildDirIdList(dirIdList, instanceId, tenantId);
        while (CollectionUtils.isNotEmpty(childDirIdList)) {
            dirIdList.addAll(childDirIdList);
            childDirIdList = this.queryChildDirIdList(childDirIdList, instanceId, tenantId);
        }
        return dirIdList;
    }

    private List<Long> queryChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        ArrayList<Long> childDirIdList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(dirIdList)) {
            return childDirIdList;
        }
        for (Long dirId : dirIdList) {
            DirDgEo dirDgEo = new DirDgEo();
            dirDgEo.setParentId(dirId);
            dirDgEo.setInstanceId(instanceId);
            dirDgEo.setTenantId(tenantId);
            List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
            if (CollectionUtils.isEmpty((Collection)dirDgEoList)) continue;
            for (DirDgEo eo : dirDgEoList) {
                childDirIdList.add(eo.getId());
            }
        }
        return childDirIdList;
    }
}

