/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.share;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.yunxi.dg.base.center.report.service.impl.share.RedisFormulaManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RelWarehouseUtils {
    private static final Logger log = LoggerFactory.getLogger(RelWarehouseUtils.class);
    private ICacheService cacheService;
    protected final Cache<String, List<String>> DATA_CACHE = Caffeine.newBuilder().initialCapacity(500).maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static String group = "yunxi-dg-base-center-share";
    @Value(value="${cube.global.profile:item-dev}")
    public String profile;

    @PostConstruct
    public void construct() {
        group = group + "-" + this.profile;
    }

    @Autowired
    public void setCacheService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    public List<String> getDownRelWarehouseCodes(List<String> warehouseCodes, RedisFormulaManager.FormulaCalcEnum formulaCalcEnum) {
        if (CollectionUtils.isEmpty((Collection)(warehouseCodes = (List)ObjectUtils.defaultIfNull(warehouseCodes, new ArrayList())))) {
            return new ArrayList<String>();
        }
        List<String> resultCodes = this.extract(this.visitor(warehouseCodes, formulaCalcEnum.getWarehouseRelDownKey(), this.getVisitor()));
        if (CollectionUtil.isNotEmpty(resultCodes)) {
            return resultCodes;
        }
        return this.extract(this.visitor(warehouseCodes, formulaCalcEnum.getWarehouseRelDownKey(), this.getVisitor()));
    }

    @NotNull
    private List<String> extract(Map<String, List<String>> map) {
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<String> getSupplyRelWarehouseCodes(List<String> warehouseCodes, RedisFormulaManager.FormulaCalcEnum formulaCalcEnum) {
        if (CollectionUtils.isEmpty((Collection)(warehouseCodes = (List)ObjectUtils.defaultIfNull(warehouseCodes, new ArrayList())))) {
            return new ArrayList<String>();
        }
        List<String> resultCodes = this.extract(this.visitor(warehouseCodes, formulaCalcEnum.getWarehouseRelSupplyKey(), this.getVisitor()));
        if (CollectionUtil.isNotEmpty(resultCodes)) {
            return resultCodes;
        }
        return this.extract(this.visitor(warehouseCodes, formulaCalcEnum.getWarehouseRelSupplyKey(), this.getVisitor()));
    }

    @NotNull
    private IVisitor getVisitor() {
        return codes -> {
            HashMap hashMap = new HashMap();
            codes.forEach(r -> {
                Set<String> set = this.getKey((String)r);
                if (CollectionUtils.isNotEmpty(set)) {
                    hashMap.put(r, new ArrayList<String>(set));
                }
            });
            return hashMap;
        };
    }

    @NotNull
    private Set<String> getKey(String r) {
        return Optional.ofNullable(this.cacheService.hkeys(group, r)).orElse(Sets.newHashSet());
    }

    private Map<String, List<String>> visitor(List<String> copyCodes, String key, IVisitor visitor) {
        Map<String, List<String>> process;
        copyCodes.removeIf(StringUtils::isBlank);
        if (CollectionUtils.isEmpty(copyCodes)) {
            return new HashMap<String, List<String>>();
        }
        copyCodes = copyCodes.stream().map(r -> key + r).collect(Collectors.toList());
        copyCodes.removeIf(StringUtils::isBlank);
        if (CollectionUtils.isEmpty(copyCodes)) {
            return new HashMap<String, List<String>>();
        }
        Map allPresent = this.DATA_CACHE.getAllPresent(copyCodes);
        copyCodes.removeIf(allPresent::containsKey);
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (CollectionUtil.isNotEmpty((Map)allPresent)) {
            resultMap.putAll(allPresent);
        }
        if (CollectionUtils.isNotEmpty(copyCodes) && !(process = visitor.process(copyCodes)).isEmpty()) {
            process.entrySet().stream().filter(r -> CollectionUtils.isNotEmpty((Collection)((Collection)r.getValue()))).forEach(entry -> {
                this.DATA_CACHE.put(entry.getKey(), entry.getValue());
                resultMap.put(((String)entry.getKey()).substring(key.length()), (List<String>)entry.getValue());
            });
        }
        return resultMap;
    }

    @FunctionalInterface
    public static interface IVisitor {
        public Map<String, List<String>> process(List<String> var1);
    }
}

