/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.pulldata.service.component.comparator.InventoryDocumentComparator;
import com.yunxi.dg.base.center.pulldata.service.component.context.InventoryDocumentCompareContext;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.selector.DataFetchStrategySelector;
import com.yunxi.dg.base.center.report.api.constant.DgReportMqConstant;
import com.yunxi.dg.base.center.report.constants.YesNoEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.BaseDispositionEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.FiltrationTypeEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.convert.reconciliation.ReconciliationDifferenceConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuExtDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IBaseDispositionDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IFiltrationDispositionDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReconciliationDifferenceLogDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReconciliationDispositionDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReportReconciliationDifferenceDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailAccountPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailAccountRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.FiltrationDispositionRespDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDifferenceDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDifferencePageReqDto;
import com.yunxi.dg.base.center.report.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.report.eo.item.ItemSkuExtEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.BaseDispositionEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.FiltrationDispositionEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDifferenceEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDifferenceLogEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDispositionEo;
import com.yunxi.dg.base.center.report.service.component.collect.CollectDataStrategySelector;
import com.yunxi.dg.base.center.report.service.entity.IDgOutResultOrderDetailService;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicWarehouseService;
import com.yunxi.dg.base.center.report.service.inventory.IDgPhysicsWarehouseService;
import com.yunxi.dg.base.center.report.service.reconciliation.IReportReconciliationDifferenceService;
import com.yunxi.dg.base.center.report.service.reconciliation.ReconciliationDifferenceBo;
import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceFactory;
import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceRuleReqDto;
import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceRuleRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportReconciliationDifferenceServiceImpl
extends BaseServiceImpl<ReconciliationDifferenceDto, ReconciliationDifferenceEo, IReportReconciliationDifferenceDomain>
implements IReportReconciliationDifferenceService {
    private static final Logger log = LoggerFactory.getLogger(ReportReconciliationDifferenceServiceImpl.class);
    public static final Integer DEFAULT_PAGE = 1;
    public static final Integer DEFAULT_PAGE_SIZE = 1000;
    @Resource
    private IReconciliationDifferenceLogDomain reconciliationDifferenceLogDomain;
    @Resource
    private IDgOutResultOrderDetailService outResultOrderDetailApi;
    @Resource
    private IDgLogicWarehouseService logicWarehouseApi;
    @Resource
    private IBaseDispositionDomain baseDispositionDomain;
    @Resource
    private IFiltrationDispositionDomain filtrationDispositionDomain;
    @Resource
    private ReconciliationDifferenceFactory reconciliationDifferenceFactory;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private IReconciliationDispositionDomain reconciliationDispositionDomain;
    @Resource
    private DataFetchStrategySelector dataFetchStrategySelector;
    @Resource
    private CollectDataStrategySelector collectDataStrategySelector;
    @Resource
    private InventoryDocumentComparator inventoryDocumentComparator;
    @Resource
    private IDgPhysicsWarehouseService physicsWarehouseService;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IItemSkuExtDomain itemSkuExtDomain;

    public ReportReconciliationDifferenceServiceImpl(IReportReconciliationDifferenceDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReconciliationDifferenceDto, ReconciliationDifferenceEo> converter() {
        return ReconciliationDifferenceConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<ReconciliationDifferenceDto>> queryPage(ReconciliationDifferencePageReqDto dto) {
        ExtQueryChainWrapper differenceEoLambdaQueryWrapper = (ExtQueryChainWrapper)((IReportReconciliationDifferenceDomain)this.domain).filter().orderByDesc((Object)"create_time");
        if (ObjectUtils.isNotEmpty((Object)dto.getSource())) {
            differenceEoLambdaQueryWrapper.eq((Object)"source", (Object)dto.getSource());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getDocumentNoList())) {
            differenceEoLambdaQueryWrapper.and(wrapper -> ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"relevance_biz_no", (Collection)dto.getDocumentNoList())).or()).in((Object)"os_order_no", (Collection)dto.getDocumentNoList())).or()).in((Object)"result_order_no", (Collection)dto.getDocumentNoList()));
        }
        if (StringUtils.isNotEmpty((String)dto.getReconciliationTimeStart())) {
            differenceEoLambdaQueryWrapper.ge((Object)"reconciliation_time", (Object)dto.getReconciliationTimeStart());
        }
        if (StringUtils.isNotEmpty((String)dto.getReconciliationTimeEnd())) {
            differenceEoLambdaQueryWrapper.le((Object)"reconciliation_time", (Object)dto.getReconciliationTimeEnd());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getLogicWarehouseCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"logic_warehouse_code", (Collection)dto.getLogicWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getPhysicalWarehouseCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"physical_warehouse_code", (Collection)dto.getPhysicalWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSkuCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"sku_code", (Collection)dto.getSkuCodes());
        }
        if (StringUtils.isNotEmpty((String)dto.getSkuAbbr())) {
            differenceEoLambdaQueryWrapper.like((Object)"sku_abbr", (Object)dto.getSkuAbbr());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSpuCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"spu_code", (Collection)dto.getSpuCodes());
        }
        if (StringUtils.isNotEmpty((String)dto.getResultOrderNo())) {
            differenceEoLambdaQueryWrapper.eq((Object)"result_order_no", (Object)dto.getResultOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBizTypes())) {
            differenceEoLambdaQueryWrapper.in((Object)"biz_type", (Collection)dto.getBizTypes());
        }
        if (StringUtils.isNotEmpty((String)dto.getRelevanceBizNo())) {
            differenceEoLambdaQueryWrapper.eq((Object)"relevance_biz_no", (Object)dto.getRelevanceBizNo());
        }
        if (StringUtils.isNotEmpty((String)dto.getRelevanceOrderType())) {
            differenceEoLambdaQueryWrapper.eq((Object)"relevance_order_type", (Object)dto.getRelevanceOrderType());
        }
        if (StringUtils.isNotEmpty((String)dto.getRelevanceBizType())) {
            differenceEoLambdaQueryWrapper.eq((Object)"relevance_biz_type", (Object)dto.getRelevanceBizType());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getRelevanceBizTypes())) {
            differenceEoLambdaQueryWrapper.in((Object)"relevance_biz_type", (Collection)dto.getRelevanceBizTypes());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getZtStatusList())) {
            differenceEoLambdaQueryWrapper.in((Object)"zt_status", (Collection)dto.getZtStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getZtBatchs())) {
            differenceEoLambdaQueryWrapper.in((Object)"zt_batch", (Collection)dto.getZtBatchs());
        }
        if (StringUtils.isNotEmpty((String)dto.getZtBatch())) {
            differenceEoLambdaQueryWrapper.like((Object)"zt_batch", (Object)dto.getZtBatch());
        }
        if (StringUtils.isNotEmpty((String)dto.getBookingNo())) {
            differenceEoLambdaQueryWrapper.eq((Object)"booking_no", (Object)dto.getBookingNo());
        }
        if (StringUtils.isNotEmpty((String)dto.getBookingType())) {
            differenceEoLambdaQueryWrapper.eq((Object)"booking_type", (Object)dto.getBookingType());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsOrderNo())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_order_no", new Object[]{dto.getOsOrderNo()});
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsOrderType())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_order_type", new Object[]{dto.getOsOrderType()});
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsWarehouseCode())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_warehouse_code", new Object[]{dto.getOsWarehouseCode()});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getOsStatusList())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_status", (Collection)dto.getOsStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBookingTypes())) {
            differenceEoLambdaQueryWrapper.in((Object)"booking_type", (Collection)dto.getBookingTypes());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsBatch())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_batch", new Object[]{dto.getOsBatch()});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getResults())) {
            differenceEoLambdaQueryWrapper.in((Object)"result", (Collection)dto.getResults());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getMarkStatusList())) {
            differenceEoLambdaQueryWrapper.in((Object)"mark_status", (Collection)dto.getMarkStatusList());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getMarkStatus())) {
            differenceEoLambdaQueryWrapper.eq((Object)"mark_status", (Object)dto.getMarkStatus());
        }
        if (StringUtils.isNotEmpty((String)dto.getMarkRemark())) {
            differenceEoLambdaQueryWrapper.eq((Object)"mark_remark", (Object)dto.getMarkRemark());
        }
        if (StringUtils.isNotEmpty((String)dto.getUpdatePerson())) {
            differenceEoLambdaQueryWrapper.eq((Object)"updatePerson", (Object)dto.getUpdatePerson());
        }
        if (StringUtils.isNotEmpty((String)dto.getUpdateTimeStart())) {
            differenceEoLambdaQueryWrapper.gt((Object)"update_time", (Object)dto.getUpdateTimeStart());
        }
        if (StringUtils.isNotEmpty((String)dto.getUpdateTimeEnd())) {
            differenceEoLambdaQueryWrapper.lt((Object)"update_time", (Object)dto.getUpdateTimeEnd());
        }
        if (StringUtils.isNotEmpty((String)dto.getDifferenceReason())) {
            differenceEoLambdaQueryWrapper.eq((Object)"difference_reason", (Object)dto.getDifferenceReason());
        }
        if (StringUtils.isNotEmpty((String)dto.getRemark())) {
            differenceEoLambdaQueryWrapper.like((Object)"remark", (Object)dto.getRemark());
        }
        differenceEoLambdaQueryWrapper.eq((Object)"dr", (Object)0);
        PageInfo pageInfo = differenceEoLambdaQueryWrapper.page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)pageInfo.getList(), ReconciliationDifferenceDto.class);
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<Void> reCreate(String reconciliationTime, String source) {
        this.sendReconciliationDifferenceMq(reconciliationTime, source, "0");
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> updateMarkStatus(ReconciliationDifferenceDto dto) {
        List ids = dto.getIds();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)ids), (String)"\u6807\u8bb0id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)dto.getMarkStatus()), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = dto.getIds().stream().map(e -> {
            ReconciliationDifferenceEo reconciliationDifferenceEo = new ReconciliationDifferenceEo();
            reconciliationDifferenceEo.setMarkStatus(dto.getMarkStatus());
            reconciliationDifferenceEo.setMarkRemark(dto.getMarkRemark());
            reconciliationDifferenceEo.setId(e);
            return reconciliationDifferenceEo;
        }).collect(Collectors.toList());
        int count = ((IReportReconciliationDifferenceDomain)this.domain).getMapper().updateBatchByIds(eos);
        return new RestResponse((Object)count);
    }

    private void addReconciliationDifferenceLog(ReconciliationDifferenceDto dto) {
        ArrayList reconciliationDifferenceLogEos = Lists.newArrayList();
        List ids = dto.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        for (Long id : ids) {
            ReconciliationDifferenceLogEo reconciliationDifferenceLogEo = new ReconciliationDifferenceLogEo();
            reconciliationDifferenceLogEo.setReconciliationDifferenceId(id);
            reconciliationDifferenceLogEo.setRemark(dto.getMarkRemark());
            reconciliationDifferenceLogEo.setType(dto.getMarkStatus());
            reconciliationDifferenceLogEos.add(reconciliationDifferenceLogEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)reconciliationDifferenceLogEos)) {
            this.reconciliationDifferenceLogDomain.insertBatch((List)reconciliationDifferenceLogEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> extract(Date reconciliationTime, String type, Boolean reCreate) {
        log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]-->reconciliationTime:{},type:{},reCreate:{}", new Object[]{reconciliationTime, type, reCreate});
        if (ObjectUtils.isEmpty((Object)reconciliationTime)) {
            return new RestResponse();
        }
        ReconciliationDifferenceRuleReqDto reqDto = new ReconciliationDifferenceRuleReqDto();
        if (reCreate.booleanValue()) {
            LambdaQueryWrapper differenceEoLambdaQueryWrapper = new LambdaQueryWrapper();
            differenceEoLambdaQueryWrapper.ge(ReconciliationDifferenceEo::getReconciliationTime, (Object)DateUtil.getDayBegin((Date)reconciliationTime));
            differenceEoLambdaQueryWrapper.le(ReconciliationDifferenceEo::getReconciliationTime, (Object)DateUtil.getDayEnd((Date)reconciliationTime));
            differenceEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
            List differenceEoList = ((IReportReconciliationDifferenceDomain)this.domain).getMapper().selectList((Wrapper)differenceEoLambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)differenceEoList)) {
                reqDto.setDifferenceEos(differenceEoList);
                List<Long> differenceIds = differenceEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                reqDto.setDifferenceLogEos(this.getReconciliationDifferenceLogEo(differenceIds));
            }
            ReconciliationDifferenceEo delReconciliationDifferenceEo = new ReconciliationDifferenceEo();
            delReconciliationDifferenceEo.setReconciliationTime(DateUtil.getDayBegin((Date)reconciliationTime));
            this.deleteReconciliationDifference(delReconciliationDifferenceEo);
        }
        reqDto.setReCreate(reCreate);
        this.buildReconciliationDifferenceRule(reqDto, type, reconciliationTime, reCreate);
        ReconciliationDifferenceRuleRespDto differenceRuleRespDto = new ReconciliationDifferenceRuleRespDto();
        if (Objects.equals(type, InventoryReconciliationSourceEnum.U9.getCode())) {
            differenceRuleRespDto = this.reconciliationDifferenceFactory.getServiceByType(ReconciliationDifferenceFactory.ReconciliationDifferenceRuleEnum.RECONCILIATION_DIFFERENCE_ERP.getCode()).execute(reqDto);
        } else if (Objects.equals(type, InventoryReconciliationSourceEnum.WMS.getCode())) {
            differenceRuleRespDto = this.reconciliationDifferenceFactory.getServiceByType(ReconciliationDifferenceFactory.ReconciliationDifferenceRuleEnum.RECONCILIATION_DIFFERENCE_WMS.getCode()).execute(reqDto);
        }
        if (CollectionUtils.isNotEmpty(differenceRuleRespDto.getDifferenceEos())) {
            ((IReportReconciliationDifferenceDomain)this.domain).insertBatch(differenceRuleRespDto.getDifferenceEos());
        }
        if (CollectionUtils.isNotEmpty(differenceRuleRespDto.getDifferenceLogEos())) {
            this.reconciliationDifferenceLogDomain.insertBatch(differenceRuleRespDto.getDifferenceLogEos());
        }
        return new RestResponse();
    }

    @Override
    public void pullAndExtract(Long dispositionId, String reconciliationDateStr) {
        log.info("\u62c9\u53d6\u5e76\u6267\u884c\u5355\u636e\u6d41\u6c34dispositionId:{},reconciliationDateStr:{}", (Object)dispositionId, (Object)reconciliationDateStr);
        ReconciliationDifferenceBo bo = this.checkAndQuery(dispositionId, reconciliationDateStr);
        ReconciliationDispositionEo dispositionEo = bo.getDispositionEo();
        List<FiltrationDispositionRespDto> documentList = bo.getDocumentList();
        List<DgLogicWarehouseDto> warehouseList = bo.getWarehouseList();
        String cacheKey = String.format("reconciliationDifferencePullAndExtract_%s_%s", dispositionEo.getReconciliationObject(), reconciliationDateStr);
        log.info("cacheKey:{}", (Object)cacheKey);
        boolean flag = this.cacheService.setIfAbsent(cacheKey, "1", 3600);
        if (!flag) {
            throw new BizException("\u7cfb\u7edf\u7e41\u5fd9\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try {
            this.doExecute(dispositionEo, documentList, warehouseList, reconciliationDateStr);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26error->{},{}", (Throwable)e);
            throw new BizException(String.format("\u751f\u6210\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26error->%s", e.getLocalizedMessage()));
        }
        finally {
            this.cacheService.delCache(cacheKey);
        }
    }

    private void doExecute(ReconciliationDispositionEo dispositionEo, List<FiltrationDispositionRespDto> documentList, List<DgLogicWarehouseDto> warehouseList, String reconciliationDateStr) {
        String reconciliationObject = dispositionEo.getReconciliationObject();
        Date reconciliationDate = DateUtil.parseDate((String)reconciliationDateStr, (String)"yyyy-MM-dd");
        DateTime startOfDay = cn.hutool.core.date.DateUtil.beginOfDay((Date)reconciliationDate);
        DataFetchBo pmsBo = new DataFetchBo();
        pmsBo.setSource(InventoryReconciliationSourceEnum.HYX.getCode());
        pmsBo.setReconciliationDate((Date)startOfDay);
        pmsBo.setExtension(reconciliationObject);
        this.pullData(pmsBo);
        DataFetchBo bo = new DataFetchBo();
        bo.setSource(reconciliationObject);
        bo.setReconciliationDate((Date)startOfDay);
        if (InventoryReconciliationSourceEnum.WMS.getCode().equals(reconciliationObject)) {
            List physicsWarehouseDtos = (List)this.physicsWarehouseService.queryAll().getData();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)physicsWarehouseDtos)) {
                log.info("[\u62c9\u53d6\u5e76\u4e0e\u4e09\u65b9\u5355\u636e\u5dee\u5f02\u5904\u7406]\uff0cwms\u6e20\u9053\u5bf9\u8d26\u83b7\u53d6\u7269\u7406\u4ed3\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            bo.setWarehouseCodeList(physicsWarehouseDtos.stream().filter(item -> YesNoEnum.YES.getCode().toString().equals(item.getInterconnectionFlag())).map(DgPhysicsWarehouseDto::getWarehouseCode).collect(Collectors.toList()));
        }
        this.pullData(bo);
        this.extracted(dispositionEo, documentList, warehouseList, reconciliationDateStr);
    }

    private void extracted(ReconciliationDispositionEo dispositionEo, List<FiltrationDispositionRespDto> documentList, List<DgLogicWarehouseDto> warehouseList, String reconciliationDateStr) {
        String reconciliationInventoryProperty;
        List inventoryProperties;
        String reconciliationObject = dispositionEo.getReconciliationObject();
        Date reconciliationDate = DateUtil.parseDate((String)reconciliationDateStr, (String)"yyyy-MM-dd");
        DateTime startOfDay = cn.hutool.core.date.DateUtil.beginOfDay((Date)reconciliationDate);
        DateTime endOfDay = cn.hutool.core.date.DateUtil.endOfDay((Date)reconciliationDate);
        InventoryDocumentCompareContext compareContext = InventoryDocumentCompareContext.init((Date)startOfDay, (Date)endOfDay, (String)reconciliationObject);
        compareContext.setTargetObject(reconciliationObject);
        compareContext.setReconciliationTime((Date)startOfDay);
        if (CollectionUtils.isNotEmpty(warehouseList)) {
            List warehouses = warehouseList.stream().map(DgLogicWarehouseDto::getWarehouseCode).distinct().collect(Collectors.toList());
            List physicsWarehouseCodes = warehouseList.stream().filter(e -> StringUtils.isNotEmpty((String)e.getPhysicsWarehouseCode())).map(DgLogicWarehouseDto::getPhysicsWarehouseCode).distinct().collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(warehouses)) {
                compareContext.getPmsGeneric().in("logic_warehouse_code", warehouses);
                compareContext.getThreeGeneric().in("warehouse_code", InventoryReconciliationSourceEnum.WMS.getCode().equals(reconciliationObject) ? physicsWarehouseCodes : warehouses);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(inventoryProperties = Arrays.stream((reconciliationInventoryProperty = dispositionEo.getReconciliationInventoryProperty()).split("\u3001")).filter(s -> !s.isEmpty()).collect(Collectors.toList()))) {
            compareContext.getPmsGeneric().in("inventory_property", inventoryProperties);
            compareContext.getThreeGeneric().in("inventory_property", inventoryProperties);
        }
        if (CollectionUtils.isNotEmpty(documentList)) {
            for (FiltrationDispositionRespDto respDto : documentList) {
                List relevanceBizTypes = Arrays.stream(respDto.getBusinessType().split("\u3001")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                List threeBusinessTypes = Arrays.stream(respDto.getThreeBusinessTypeValue().split("\u3001")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                HashMap<String, Object> pmsOrMap = new HashMap<String, Object>();
                pmsOrMap.put("relevance_order_type", respDto.getTypeNo());
                pmsOrMap.put("order_type", respDto.getResultType());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relevanceBizTypes)) {
                    pmsOrMap.put("relevance_biz_type", relevanceBizTypes);
                }
                compareContext.getPmsGeneric().orAnd(pmsOrMap);
                HashMap<String, Object> threeOrMap = new HashMap<String, Object>();
                threeOrMap.put("os_order_type", respDto.getThreeOrderTypeValue());
                threeOrMap.put("order_type", respDto.getResultType());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(threeBusinessTypes)) {
                    threeOrMap.put("os_biz_type", threeBusinessTypes);
                }
                compareContext.getThreeGeneric().orAnd(threeOrMap);
                compareContext.getPmsGeneric().orderBy("m.id", "desc");
                compareContext.getThreeGeneric().orderBy("m.id", "desc");
                respDto.setSource(dispositionEo.getReconciliationObject());
                this.collectDataStrategySelector.select(respDto).collect(compareContext, respDto);
            }
        }
        log.info("compareContext:{}", (Object)JSON.toJSONString((Object)compareContext));
        this.inventoryDocumentComparator.compare(compareContext);
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IReportReconciliationDifferenceDomain)this.domain).filter().eq((Object)"reconciliation_time", (Object)startOfDay)).eq((Object)"source", (Object)reconciliationObject)).list();
        if (CollectionUtils.isNotEmpty((Collection)eos)) {
            Map logicWarehouseDtoMap = warehouseList.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            Map<String, ItemSkuExtEo> itemMap = this.getItemSkuDgEo(eos.stream().map(e -> e.getSkuCode()).distinct().collect(Collectors.toList()));
            eos.forEach(e -> {
                ReconciliationDifferenceEo eo = new ReconciliationDifferenceEo();
                eo.setId(e.getId());
                DgLogicWarehouseDto logicWarehouseDto = (DgLogicWarehouseDto)logicWarehouseDtoMap.get(e.getLogicWarehouseCode());
                if (Objects.nonNull(logicWarehouseDto)) {
                    eo.setPhysicalWarehouseCode(logicWarehouseDto.getPhysicsWarehouseCode());
                    eo.setPhysicalWarehouseName(logicWarehouseDto.getPhysicsWarehouseName());
                    eo.setCargoRightCode(logicWarehouseDto.getOrganizationCode());
                    eo.setCargoRightName(logicWarehouseDto.getOrganizationName());
                    if (StringUtils.isEmpty((String)e.getLogicWarehouseName())) {
                        eo.setLogicWarehouseName(logicWarehouseDto.getWarehouseName());
                    }
                    if (StringUtils.isEmpty((String)e.getOsWarehouseName()) && Objects.equals(eo.getPhysicalWarehouseCode(), e.getOsWarehouseCode())) {
                        eo.setOsWarehouseName(eo.getPhysicalWarehouseName());
                    }
                }
                if (StringUtils.isEmpty((String)e.getOsWarehouseName()) && Objects.equals(e.getLogicWarehouseCode(), e.getOsWarehouseCode())) {
                    eo.setOsWarehouseName(e.getLogicWarehouseName());
                }
                if (Objects.nonNull(itemMap.get(e.getSkuCode())) && StringUtils.isEmpty((String)e.getSkuUnit())) {
                    eo.setSkuUnit(((ItemSkuExtEo)itemMap.get(e.getSkuCode())).getUnit());
                }
                ((IReportReconciliationDifferenceDomain)this.domain).updateSelective((BaseEo)eo);
            });
        }
    }

    @Override
    public void pullData(DataFetchBo bo) {
        log.info("\u62c9\u53d6\u5355\u636e\u6d41\u6c34:{}", (Object)JSON.toJSONString((Object)bo));
        long time = System.currentTimeMillis();
        DataFetchStrategy dataFetchStrategy = (DataFetchStrategy)this.dataFetchStrategySelector.select((Object)bo.getSource());
        dataFetchStrategy.fetchAndSaveData(bo);
        log.info("[\u62c9\u53d6\u4e09\u65b9\u5e93\u5b58\u6d41\u6c34\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void newExtract(Long dispositionId, String reconciliationDateStr) {
        log.info("\u6267\u884c\u5355\u636e\u6d41\u6c34dispositionId:{},reconciliationDateStr:{}", (Object)dispositionId, (Object)reconciliationDateStr);
        ReconciliationDifferenceBo bo = this.checkAndQuery(dispositionId, reconciliationDateStr);
        ReconciliationDispositionEo dispositionEo = bo.getDispositionEo();
        List<FiltrationDispositionRespDto> documentList = bo.getDocumentList();
        List<DgLogicWarehouseDto> warehouseList = bo.getWarehouseList();
        this.extracted(dispositionEo, documentList, warehouseList, reconciliationDateStr);
    }

    public ReconciliationDifferenceBo checkAndQuery(Long dispositionId, String reconciliationDateStr) {
        AssertUtils.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reconciliationDateStr), (String)"\u5bf9\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)Objects.nonNull(dispositionId), (String)"\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
        ReconciliationDispositionEo dispositionEo = (ReconciliationDispositionEo)this.reconciliationDispositionDomain.selectByPrimaryKey(dispositionId);
        if (dispositionEo == null) {
            throw new BizException(String.format("[\u62c9\u53d6\u5e76\u4e0e\u4e09\u65b9\u5355\u636e\u5dee\u5f02\u5904\u7406]\uff0c\u89c4\u5219\u4e3a\u7a7a dispositionId:%s", dispositionId));
        }
        FiltrationDispositionEo queryParam = new FiltrationDispositionEo();
        queryParam.setDispositionNo(dispositionEo.getDispositionNo());
        queryParam.setDispositionId(dispositionEo.getId());
        List filtrationDispositions = this.filtrationDispositionDomain.selectDisposition(queryParam);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)filtrationDispositions)) {
            log.info("\u5bf9\u8d26\u5355\u636e\u3001\u4ed3\u5e93\u4e3a\u7a7a");
            return new ReconciliationDifferenceBo(dispositionEo);
        }
        List<FiltrationDispositionRespDto> documentList = filtrationDispositions.stream().filter(x -> FiltrationTypeEnum.DOCUMENT.getCode().equals(x.getFiltrationType())).collect(Collectors.toList());
        List<DgLogicWarehouseDto> warehouseList = this.filtrationWarehouseCode(filtrationDispositions);
        if (documentList.isEmpty() || warehouseList.isEmpty()) {
            log.info("\u5bf9\u8d26\u5355\u636e\u3001\u4ed3\u5e93\u4e3a\u7a7a");
            return new ReconciliationDifferenceBo(dispositionEo);
        }
        log.info("\u5bf9\u8d26\u5355\u636e\u6570\u91cf\uff1a{}\uff0c \u4ed3\u5e93\u6570\u91cf\uff1a{}", (Object)documentList.size(), (Object)warehouseList.size());
        return new ReconciliationDifferenceBo(dispositionEo, documentList, warehouseList);
    }

    private List<DgLogicWarehouseDto> filtrationWarehouseCode(List<FiltrationDispositionRespDto> filtrationDispositions) {
        List warehouseList = filtrationDispositions.stream().filter(x -> FiltrationTypeEnum.LOGIC.getCode().equals(x.getFiltrationType())).collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseStatus(ValidFlagEnum.ENABLE.getCode());
        List logicWarehouseDtos = this.logicWarehouseDomain.queryList(logicWarehousePageReqDto);
        AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicWarehouseDtos), (String)"\u903b\u8f91\u4ed3\u5e93\u90fd\u4e0d\u5b58\u5728");
        List filtrationWarehouseCodes = warehouseList.stream().map(e -> e.getEncodeNo()).distinct().collect(Collectors.toList());
        List<DgLogicWarehouseDto> dtos = logicWarehouseDtos.stream().filter(e -> !filtrationWarehouseCodes.contains(e.getWarehouseCode())).collect(Collectors.toList());
        return dtos;
    }

    private ReconciliationDifferenceRuleReqDto buildReconciliationDifferenceRule(ReconciliationDifferenceRuleReqDto reqDto, String type, Date reconciliationTime, Boolean reCreate) {
        List dispositionEos = ((ExtQueryChainWrapper)this.baseDispositionDomain.filter().in((Object)"disposition_no", Arrays.asList(BaseDispositionEnum.IS_BATCH.getCode(), BaseDispositionEnum.IS_STATUS.getCode(), BaseDispositionEnum.SALE_IS_COLLECT_CHARGE.getCode(), BaseDispositionEnum.INVENTORY_IS_COLLECT_CHARGE.getCode()))).list();
        if (CollectionUtils.isNotEmpty((Collection)dispositionEos)) {
            BaseDispositionEo inventoryIsCollectCharge;
            Map dispositionEoMap = dispositionEos.stream().collect(Collectors.toMap(o -> o.getDispositionNo(), Function.identity(), (o2, o1) -> o2));
            BaseDispositionEo saleIsCollectCharge = (BaseDispositionEo)dispositionEoMap.get(BaseDispositionEnum.SALE_IS_COLLECT_CHARGE.getCode());
            if (saleIsCollectCharge != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)saleIsCollectCharge.getValue());
                reqDto.setSaleIsCollectCharge(jsonObject.getBoolean("status"));
            }
            if ((inventoryIsCollectCharge = (BaseDispositionEo)dispositionEoMap.get(BaseDispositionEnum.INVENTORY_IS_COLLECT_CHARGE.getCode())) != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)inventoryIsCollectCharge.getValue());
                reqDto.setInventoryIsCollectCharge(jsonObject.getBoolean("status"));
            }
        }
        DgOutResultOrderDetailAccountPageReqDto dto = new DgOutResultOrderDetailAccountPageReqDto();
        ArrayList<String> logicCodes = new ArrayList();
        List filtrationDispositionEos = this.filtrationDispositionDomain.filter().list();
        if (CollectionUtils.isNotEmpty((Collection)filtrationDispositionEos)) {
            List<String> typeNos;
            List<FiltrationDispositionEo> documentList;
            List<FiltrationDispositionEo> omsDocumentList;
            Map<String, List<FiltrationDispositionEo>> dispositionEoMap = filtrationDispositionEos.stream().collect(Collectors.groupingBy(e -> Optional.ofNullable(e.getSource()).orElse("") + e.getFiltrationType()));
            List<FiltrationDispositionEo> logicList = dispositionEoMap.get(InventoryReconciliationSourceEnum.HYX.getCode() + "logic");
            if (CollectionUtils.isNotEmpty(logicList)) {
                logicCodes = logicList.stream().map(FiltrationDispositionEo::getEncodeNo).distinct().collect(Collectors.toList());
                reqDto.setWarehouseCodeList(logicCodes);
            }
            if (CollectionUtils.isNotEmpty(omsDocumentList = dispositionEoMap.get(InventoryReconciliationSourceEnum.HYX.getCode() + "document"))) {
                List encodeNos;
                List typeNos2 = omsDocumentList.stream().map(FiltrationDispositionEo::getTypeNo).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(typeNos2)) {
                    dto.setBusinessTypeList(typeNos2);
                }
                if (CollectionUtils.isNotEmpty(encodeNos = omsDocumentList.stream().map(FiltrationDispositionEo::getBusinessType).distinct().collect(Collectors.toList()))) {
                    dto.setDisplayBusinessTypeList(encodeNos);
                }
            }
            if (CollectionUtils.isNotEmpty(documentList = dispositionEoMap.get(type + "document")) && CollectionUtils.isNotEmpty(typeNos = documentList.stream().map(FiltrationDispositionEo::getTypeNo).distinct().collect(Collectors.toList()))) {
                reqDto.setBusinessTypeList(typeNos);
            }
        }
        String dateFormat = DateUtil.getDateFormat((Date)reconciliationTime, (String)"yyyy-MM-dd") + " 00:00:00";
        Date startDate = reCreate != false ? DateUtils.addHours((Date)DateUtil.parseDate((String)dateFormat, (String)"yyyy-MM-dd HH:mm:ss"), (int)0) : DateUtils.addHours((Date)DateUtil.parseDate((String)dateFormat, (String)"yyyy-MM-dd HH:mm:ss"), (int)-24);
        Date endDate = DateUtil.getDayEnd((Date)startDate);
        dto.setCreateTimeStart(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)startDate));
        dto.setCreateTimeEnd(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)endDate));
        reqDto.setReconciliationTime(reconciliationTime);
        reqDto.setReconciliationTimeStart(dto.getCreateTimeStart());
        reqDto.setReconciliationTimeEnd(dto.getCreateTimeEnd());
        log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]\u67e5\u8be2\u7cfb\u7edf\u7ed3\u679c\u5355\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)dto));
        List<Object> resultRespDtos = this.queryDeliveryResultAndDetailList(dto);
        if (CollectionUtils.isNotEmpty(resultRespDtos) && CollectionUtils.isNotEmpty(logicCodes)) {
            ArrayList<String> finalLogicCodes = logicCodes;
            resultRespDtos = resultRespDtos.stream().filter(v -> !finalLogicCodes.contains(v.getInLogicWarehouseCode()) && !finalLogicCodes.contains(v.getOutLogicWarehouseCode())).collect(Collectors.toList());
            DgLogicWarehousePageReqDto logicWarehouseDto = new DgLogicWarehousePageReqDto();
            List warehouseCodes = resultRespDtos.stream().map(o -> StringUtils.isNotBlank((String)o.getInLogicWarehouseCode()) ? o.getInLogicWarehouseCode() : o.getOutLogicWarehouseCode()).distinct().collect(Collectors.toList());
            logicWarehouseDto.setWarehouseCodes(warehouseCodes);
            logicWarehouseDto.setWarehouseClassify("logic");
            List logicWarehouseList = (List)RestResponseHelper.extractData(this.logicWarehouseApi.queryList(logicWarehouseDto));
            reqDto.setLogicWarehouseList(logicWarehouseList);
        }
        reqDto.setOutResultOrderDetailRespDtos(resultRespDtos);
        return reqDto;
    }

    private void sendReconciliationDifferenceMq(String reconciliationTime, String source, String reCreate) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("reconciliationTime", reconciliationTime);
        map.put("source", source);
        map.put("reCreate", reCreate);
        String data = JSON.toJSONString(map);
        log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]\u53d1\u9001mq  data\uff1a{}", (Object)data);
        this.mqService.sendSingleMessage(DgReportMqConstant.RECONCILIATION_DIFFERENCE_TAG.getCode(), (Object)data);
    }

    private List<ReconciliationDifferenceLogEo> getReconciliationDifferenceLogEo(List<Long> differenceIds) {
        ArrayList differenceLogEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(differenceIds)) {
            List eos;
            int length;
            int i = 0;
            for (length = differenceIds.size(); length > 1000; length -= 1000) {
                eos = ((ExtQueryChainWrapper)this.reconciliationDifferenceLogDomain.filter().in((Object)"reconciliation_difference_id", differenceIds.subList(i, i + 1000))).list();
                differenceLogEos.addAll(eos);
                i += 1000;
            }
            if (length > 0) {
                eos = ((ExtQueryChainWrapper)this.reconciliationDifferenceLogDomain.filter().in((Object)"reconciliation_difference_id", differenceIds.subList(i, i + length))).list();
                differenceLogEos.addAll(eos);
            }
        }
        return differenceLogEos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteReconciliationDifference(ReconciliationDifferenceEo delReconciliationDifferenceEo) {
        ExtQueryChainWrapper sqlFilters = ((IReportReconciliationDifferenceDomain)this.domain).filter();
        sqlFilters.eq((Object)"reconciliation_time", (Object)delReconciliationDifferenceEo.getReconciliationTime());
        Integer pageNum = DEFAULT_PAGE;
        Integer pageSize = DEFAULT_PAGE_SIZE;
        PageInfo pageInfo = sqlFilters.page(pageNum, pageSize);
        log.info("\u67e5\u8be2\u5e93\u5b58\u5bf9\u8d26\u6d41\u6c34\u8868Eo\u5bf9\u8c61pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(pageInfo) ? Integer.valueOf(pageInfo.getPages()) : null);
        if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List ids = pageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            ReconciliationDifferenceEo differenceEo = new ReconciliationDifferenceEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", ids));
            differenceEo.setDr(1);
            differenceEo.setSqlFilters(sqlFilterList);
            ((IReportReconciliationDifferenceDomain)this.domain).updateSelectiveSqlFilter((BaseEo)differenceEo);
        }
        for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), pageSize);
            log.info("\u67e5\u8be2\u5e93\u5b58\u5bf9\u8d26\u6d41\u6c34\u8868Eo\u5bf9\u8c61pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(eoPageInfo) ? Integer.valueOf(eoPageInfo.getPages()) : null);
            if (!Objects.nonNull(eoPageInfo) || !CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) continue;
            List ids = eoPageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            ReconciliationDifferenceEo differenceEo = new ReconciliationDifferenceEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", ids));
            differenceEo.setDr(1);
            differenceEo.setSqlFilters(sqlFilterList);
            ((IReportReconciliationDifferenceDomain)this.domain).updateSelectiveSqlFilter((BaseEo)differenceEo);
        }
    }

    private List<DgOutResultOrderDetailAccountRespDto> queryOutResultAndDetailList(DgOutResultOrderDetailAccountPageReqDto dto) {
        long start = System.currentTimeMillis();
        Integer pageNum = DEFAULT_PAGE;
        Integer pageSize = DEFAULT_PAGE_SIZE;
        ArrayList orderDetailAccountRespDtos = Lists.newArrayList();
        dto.setPageNum(pageNum);
        dto.setPageSize(pageSize);
        PageInfo<DgOutResultOrderDetailAccountRespDto> pageInfo = this.outResultOrderDetailApi.queryOutResultAndDetailPage(dto);
        orderDetailAccountRespDtos.addAll(pageInfo.getList());
        int pageNo = (int)Math.ceil(Double.valueOf(pageInfo.getTotal()) / Double.valueOf(pageSize.intValue()));
        for (int i = 2; i <= pageNo; ++i) {
            dto.setPageNum(Integer.valueOf(i));
            PageInfo<DgOutResultOrderDetailAccountRespDto> dtoPageInfo = this.outResultOrderDetailApi.queryOutResultAndDetailPage(dto);
            orderDetailAccountRespDtos.addAll(dtoPageInfo.getList());
        }
        log.info("\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return orderDetailAccountRespDtos;
    }

    private List<DgOutResultOrderDetailAccountRespDto> queryDeliveryResultAndDetailList(DgOutResultOrderDetailAccountPageReqDto dto) {
        long start = System.currentTimeMillis();
        Integer pageNum = DEFAULT_PAGE;
        Integer pageSize = DEFAULT_PAGE_SIZE;
        ArrayList orderDetailAccountRespDtos = Lists.newArrayList();
        dto.setPageNum(pageNum);
        dto.setPageSize(pageSize);
        PageInfo<DgOutResultOrderDetailAccountRespDto> pageInfo = this.outResultOrderDetailApi.queryDeliveryResultAndDetailPage(dto);
        orderDetailAccountRespDtos.addAll(pageInfo.getList());
        int pageNo = (int)Math.ceil(Double.valueOf(pageInfo.getTotal()) / Double.valueOf(pageSize.intValue()));
        for (int i = 2; i <= pageNo; ++i) {
            dto.setPageNum(Integer.valueOf(i));
            PageInfo<DgOutResultOrderDetailAccountRespDto> dtoPageInfo = this.outResultOrderDetailApi.queryDeliveryResultAndDetailPage(dto);
            orderDetailAccountRespDtos.addAll(dtoPageInfo.getList());
        }
        log.info("\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return orderDetailAccountRespDtos;
    }

    private Map<String, ItemSkuExtEo> getItemSkuDgEo(List<String> skuCodes) {
        ArrayList itemSkuDgEos = Lists.newArrayList();
        try {
            List itemSkuDgEoList;
            int length;
            int i = 0;
            for (length = skuCodes.size(); length > 500; length -= 500) {
                itemSkuDgEoList = ((ExtQueryChainWrapper)this.itemSkuExtDomain.filter().in((Object)"code", skuCodes.subList(i, i + 500))).list();
                itemSkuDgEos.addAll(itemSkuDgEoList);
                i += 500;
            }
            if (length > 0) {
                itemSkuDgEoList = ((ExtQueryChainWrapper)this.itemSkuExtDomain.filter().in((Object)"code", skuCodes.subList(i, i + length))).list();
                itemSkuDgEos.addAll(itemSkuDgEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u5931\u8d25:{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return itemSkuDgEos.stream().collect(Collectors.toMap(ItemSkuExtEo::getCode, Function.identity(), (k1, k2) -> k1));
    }
}

