/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.rule;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.OutResultOrderTypeEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.ReconiliationDifferenceResultEnum;
import com.yunxi.dg.base.center.report.domain.reconciliation.IErpInventoryPostDetailDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailAccountRespDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.ErpInventoryPostDetailEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDifferenceEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDifferenceLogEo;
import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceRule;
import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceRuleReqDto;
import com.yunxi.dg.base.center.report.service.reconciliation.rule.ReconciliationDifferenceRuleRespDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ErpReconciliationDifferenceRule")
public class ErpReconciliationDifferenceRule
implements ReconciliationDifferenceRule {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public ReconciliationDifferenceRuleRespDto execute(ReconciliationDifferenceRuleReqDto reqDto) {
        ReconciliationDifferenceRuleRespDto ruleRespDto = new ReconciliationDifferenceRuleRespDto();
        ArrayList allErpOrderNos = Lists.newArrayList();
        IErpInventoryPostDetailDomain erpInventoryPostDetailDomain = (IErpInventoryPostDetailDomain)SpringBeanUtil.getBean(IErpInventoryPostDetailDomain.class);
        if (CollectionUtils.isNotEmpty(reqDto.getOutResultOrderDetailRespDtos())) {
            List documentNos = reqDto.getOutResultOrderDetailRespDtos().stream().filter(o -> StringUtils.isNotEmpty((String)o.getDocumentNo())).map(DgOutResultOrderDetailAccountRespDto::getDocumentNo).distinct().collect(Collectors.toList());
            List<KeepAccountsDetailEo> keepAccountsDetailEos = null;
            List erpInventoryPostDetailEos = Lists.newArrayList();
            erpInventoryPostDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)erpInventoryPostDetailDomain.filter().ge(Objects.nonNull(reqDto.getReconciliationTimeStart()), (Object)"reconciliation_time", (Object)reqDto.getReconciliationTimeStart())).le(Objects.nonNull(reqDto.getReconciliationTimeEnd()), (Object)"reconciliation_time", (Object)reqDto.getReconciliationTimeEnd())).notIn(CollectionUtil.isNotEmpty(reqDto.getBusinessTypeList()), (Object)"erp_order_type", reqDto.getBusinessTypeList())).notIn(CollectionUtil.isNotEmpty(reqDto.getWarehouseCodeList()), (Object)"erp_warehouse_code", reqDto.getWarehouseCodeList())).list();
            this.contrast(reqDto, erpInventoryPostDetailEos, keepAccountsDetailEos, ruleRespDto);
        }
        this.buildErp(ruleRespDto, allErpOrderNos, erpInventoryPostDetailDomain, reqDto);
        return ruleRespDto;
    }

    ReconciliationDifferenceRuleRespDto contrast(ReconciliationDifferenceRuleReqDto reqDto, List<ErpInventoryPostDetailEo> erpInventoryPostDetailEos, List<KeepAccountsDetailEo> keepAccountsDetailEos, ReconciliationDifferenceRuleRespDto ruleRespDto) {
        try {
            if (CollectionUtils.isEmpty(reqDto.getOutResultOrderDetailRespDtos())) {
                return ruleRespDto;
            }
            Map<Object, Object> keepAccountsDetailEoMap = new HashMap();
            if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
                keepAccountsDetailEoMap = keepAccountsDetailEos.stream().collect(Collectors.toMap(o -> o.getResultOrderNo(), Function.identity(), (o2, o1) -> o2));
            }
            Map inventoryPostDetailEoMap = erpInventoryPostDetailEos.stream().collect(Collectors.toMap(o -> o.getErpWarehouseCode() + o.getSkuCode() + Optional.ofNullable(o.getBookingNo()).orElse(""), Function.identity(), (o2, o1) -> o2));
            Map<Object, Object> differenceMap = new HashMap();
            Map<Object, Object> differenceLogMap = new HashMap();
            Map<Object, Object> logicWarehouseMap = new HashMap();
            if (CollectionUtils.isNotEmpty(reqDto.getDifferenceEos())) {
                differenceMap = reqDto.getDifferenceEos().stream().collect(Collectors.toMap(o -> o.getResultOrderNo() + o.getSkuCode() + Optional.ofNullable(o.getZtStatus()).orElse("") + Optional.ofNullable(o.getBookingNo()).orElse("") + Optional.ofNullable(o.getZtBatch()).orElse(""), Function.identity(), (o2, o1) -> o2));
            }
            if (CollectionUtils.isNotEmpty(reqDto.getDifferenceLogEos())) {
                differenceLogMap = reqDto.getDifferenceLogEos().stream().collect(Collectors.groupingBy(ReconciliationDifferenceLogEo::getReconciliationDifferenceId));
            }
            if (CollectionUtils.isNotEmpty(reqDto.getLogicWarehouseList())) {
                logicWarehouseMap = reqDto.getLogicWarehouseList().stream().collect(Collectors.toMap(e -> Optional.ofNullable(e.getWarehouseCode()).orElse(""), Function.identity(), (o2, o1) -> o2));
            }
            ArrayList reconciliationDifferenceEos = Lists.newArrayList();
            ArrayList differenceLogEos = Lists.newArrayList();
            for (DgOutResultOrderDetailAccountRespDto outResultOrderDetail : reqDto.getOutResultOrderDetailRespDtos()) {
                DgLogicWarehouseDto dgLogicWarehouseDto;
                String logicWarehouseCode = outResultOrderDetail.getInLogicWarehouseCode();
                String logicWarehouseName = outResultOrderDetail.getInLogicWarehouseName();
                String physicsWarehouseCode = outResultOrderDetail.getInPhysicsWarehouseCode();
                String physicsWarehouseName = outResultOrderDetail.getInPhysicsWarehouseName();
                if (StringUtils.equals((String)outResultOrderDetail.getOrderType(), (String)OutResultOrderTypeEnum.OUT.getCode())) {
                    logicWarehouseCode = outResultOrderDetail.getOutLogicWarehouseCode();
                    logicWarehouseName = outResultOrderDetail.getOutLogicWarehouseName();
                    physicsWarehouseCode = outResultOrderDetail.getOutPhysicsWarehouseCode();
                    physicsWarehouseName = outResultOrderDetail.getOutPhysicsWarehouseName();
                }
                String finalLogicWarehouseCode = logicWarehouseCode;
                ReconciliationDifferenceEo reconciliationDifferenceEo = new ReconciliationDifferenceEo();
                BeanUtil.copyProperties((Object)outResultOrderDetail, (Object)reconciliationDifferenceEo, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
                reconciliationDifferenceEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                reconciliationDifferenceEo.setLogicWarehouseCode(logicWarehouseCode);
                reconciliationDifferenceEo.setLogicWarehouseName(logicWarehouseName);
                reconciliationDifferenceEo.setPhysicalWarehouseCode(physicsWarehouseCode);
                reconciliationDifferenceEo.setPhysicalWarehouseName(physicsWarehouseName);
                reconciliationDifferenceEo.setReconciliationTime(DateUtil.getDayBegin((Date)reqDto.getReconciliationTime()));
                reconciliationDifferenceEo.setResultOrderNo(outResultOrderDetail.getDocumentNo());
                reconciliationDifferenceEo.setBizType(outResultOrderDetail.getBusinessType());
                reconciliationDifferenceEo.setRelevanceBizNo(outResultOrderDetail.getRelevanceNo());
                reconciliationDifferenceEo.setRelevanceOrderType(outResultOrderDetail.getJumpDocumentType());
                reconciliationDifferenceEo.setRelevanceBizType(outResultOrderDetail.getDisplayBusinessType());
                reconciliationDifferenceEo.setSource(InventoryReconciliationSourceEnum.U9.getCode());
                reconciliationDifferenceEo.setMarkStatus(Integer.valueOf(0));
                KeepAccountsDetailEo keepAccountsDetailEo = (KeepAccountsDetailEo)keepAccountsDetailEoMap.get(outResultOrderDetail.getDocumentNo());
                if (keepAccountsDetailEo != null) {
                    reconciliationDifferenceEo.setBookingNo(keepAccountsDetailEo.getBookingNo());
                    reconciliationDifferenceEo.setBookingType(keepAccountsDetailEo.getBookingType());
                    reconciliationDifferenceEo.setBeforeBookingNo(keepAccountsDetailEo.getResultOrderNo());
                }
                if ((dgLogicWarehouseDto = (DgLogicWarehouseDto)logicWarehouseMap.get(logicWarehouseCode)) != null) {
                    reconciliationDifferenceEo.setCargoRightCode(dgLogicWarehouseDto.getOrganizationCode());
                    reconciliationDifferenceEo.setCargoRightName(dgLogicWarehouseDto.getOrganizationName());
                }
                reconciliationDifferenceEo.setZtQuantity(outResultOrderDetail.getQuantity());
                reconciliationDifferenceEo.setZtBatch(outResultOrderDetail.getBatch());
                reconciliationDifferenceEo.setZtStatus(outResultOrderDetail.getInventoryProperty());
                String oldKey = outResultOrderDetail.getDocumentNo() + outResultOrderDetail.getSkuCode() + outResultOrderDetail.getInventoryProperty() + Optional.ofNullable(outResultOrderDetail.getBookingNo()).orElse("") + Optional.ofNullable(outResultOrderDetail.getBatch()).orElse("");
                this.log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]erp-->oldKey:{}", (Object)oldKey);
                ReconciliationDifferenceEo oldReconciliationDifferenceEo = (ReconciliationDifferenceEo)differenceMap.get(oldKey);
                if (oldReconciliationDifferenceEo != null) {
                    reconciliationDifferenceEo.setMarkRemark(oldReconciliationDifferenceEo.getMarkRemark());
                    List reconciliationDifferenceLogEos = (List)differenceLogMap.get(oldReconciliationDifferenceEo.getId());
                    if (CollectionUtils.isNotEmpty((Collection)reconciliationDifferenceLogEos)) {
                        for (ReconciliationDifferenceLogEo reconciliationDifferenceLogEo : reconciliationDifferenceLogEos) {
                            ReconciliationDifferenceLogEo addLogEo = new ReconciliationDifferenceLogEo();
                            BeanUtil.copyProperties((Object)reconciliationDifferenceLogEo, (Object)addLogEo, (String[])new String[]{"id"});
                            addLogEo.setReconciliationDifferenceId(reconciliationDifferenceEo.getId());
                            differenceLogEos.add(addLogEo);
                        }
                    }
                }
                if (reqDto.getReCreate().booleanValue()) {
                    ReconciliationDifferenceLogEo addLogEo = new ReconciliationDifferenceLogEo();
                    addLogEo.setReconciliationDifferenceId(reconciliationDifferenceEo.getId());
                    addLogEo.setType(Integer.valueOf(2));
                    differenceLogEos.add(addLogEo);
                }
                String key = finalLogicWarehouseCode + outResultOrderDetail.getSkuCode() + Optional.ofNullable(outResultOrderDetail.getDeliveryDocumentNo()).orElse("");
                ErpInventoryPostDetailEo erpInventoryPostDetailEo = (ErpInventoryPostDetailEo)inventoryPostDetailEoMap.get(key);
                this.log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]erp-->key:{},erpInventoryPostDetailEo:{}", (Object)key, (Object)JSON.toJSONString((Object)erpInventoryPostDetailEo));
                if (ObjectUtils.isNotEmpty((Object)erpInventoryPostDetailEo)) {
                    reconciliationDifferenceEo.setOsQuantity(erpInventoryPostDetailEo.getErpQuantity());
                    reconciliationDifferenceEo.setOsBatch(erpInventoryPostDetailEo.getErpBatch());
                    reconciliationDifferenceEo.setOsOrderNo(erpInventoryPostDetailEo.getErpOrderNo());
                    reconciliationDifferenceEo.setOsOrderType(erpInventoryPostDetailEo.getErpOrderType());
                    reconciliationDifferenceEo.setOsWarehouseCode(erpInventoryPostDetailEo.getErpWarehouseCode());
                    reconciliationDifferenceEo.setOsWarehouseName(erpInventoryPostDetailEo.getErpWarehouseName());
                    reconciliationDifferenceEo.setOsStatus(erpInventoryPostDetailEo.getErpStatus());
                    if (BigDecimalUtils.equals((BigDecimal)erpInventoryPostDetailEo.getErpQuantity(), (BigDecimal)outResultOrderDetail.getQuantity()).booleanValue()) {
                        reconciliationDifferenceEo.setResult(ReconiliationDifferenceResultEnum.CONSISTENT.getCode() + "");
                    } else {
                        reconciliationDifferenceEo.setResult(ReconiliationDifferenceResultEnum.INCONSISTENT.getCode() + "");
                        reconciliationDifferenceEo.setDifferenceNum(BigDecimalUtils.subtract((BigDecimal)outResultOrderDetail.getQuantity(), (BigDecimal)erpInventoryPostDetailEo.getErpQuantity()));
                    }
                } else {
                    reconciliationDifferenceEo.setDifferenceNum(outResultOrderDetail.getQuantity());
                    reconciliationDifferenceEo.setResult(ReconiliationDifferenceResultEnum.U9_NO_RECORD.getCode() + "");
                }
                reconciliationDifferenceEo.setCreateTime(new Date());
                reconciliationDifferenceEo.setUpdateTime(new Date());
                reconciliationDifferenceEo.setDr(0);
                reconciliationDifferenceEos.add(reconciliationDifferenceEo);
            }
            ruleRespDto.setDifferenceEos(reconciliationDifferenceEos);
            if (CollectionUtils.isNotEmpty((Collection)differenceLogEos)) {
                ruleRespDto.setDifferenceLogEos(differenceLogEos);
            }
        }
        catch (Exception e2) {
            this.log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]erp--Exception:{}", (Object)e2.getMessage());
            e2.printStackTrace();
        }
        return ruleRespDto;
    }

    ReconciliationDifferenceRuleRespDto buildErp(ReconciliationDifferenceRuleRespDto ruleRespDto, List<String> allErpOrderNos, IErpInventoryPostDetailDomain erpInventoryPostDetailDomain, ReconciliationDifferenceRuleReqDto reqDto) {
        this.log.info("[\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26]erp-->allErpOrderNos:{}", (Object)JSONArray.toJSONString(allErpOrderNos));
        List erpInventoryPostListEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)erpInventoryPostDetailDomain.filter().notIn(CollectionUtil.isNotEmpty(allErpOrderNos), (Object)"erp_order_no", allErpOrderNos)).notIn(CollectionUtil.isNotEmpty(reqDto.getBusinessTypeList()), (Object)"erp_order_type", reqDto.getBusinessTypeList())).notIn(CollectionUtil.isNotEmpty(reqDto.getWarehouseCodeList()), (Object)"erp_warehouse_code", reqDto.getWarehouseCodeList())).ge(Objects.nonNull(reqDto.getReconciliationTimeStart()), (Object)"reconciliation_time", (Object)reqDto.getReconciliationTimeStart())).le(Objects.nonNull(reqDto.getReconciliationTimeEnd()), (Object)"reconciliation_time", (Object)reqDto.getReconciliationTimeEnd())).list();
        if (CollectionUtils.isNotEmpty((Collection)erpInventoryPostListEos)) {
            Map<Object, Object> differenceMap = new HashMap();
            Map<Object, Object> differenceLogMap = new HashMap();
            if (CollectionUtils.isNotEmpty(reqDto.getDifferenceEos())) {
                differenceMap = reqDto.getDifferenceEos().stream().collect(Collectors.toMap(o -> o.getOsOrderNo() + o.getSkuCode() + Optional.ofNullable(o.getOsStatus()).orElse("") + Optional.ofNullable(o.getBookingNo()).orElse("") + Optional.ofNullable(o.getOsBatch()).orElse(""), Function.identity(), (o2, o1) -> o2));
            }
            if (CollectionUtils.isNotEmpty(reqDto.getDifferenceLogEos())) {
                differenceLogMap = reqDto.getDifferenceLogEos().stream().collect(Collectors.groupingBy(ReconciliationDifferenceLogEo::getReconciliationDifferenceId));
            }
            ArrayList reconciliationDifferenceEos = Lists.newArrayList();
            ArrayList differenceLogEos = Lists.newArrayList();
            for (ErpInventoryPostDetailEo inventoryPostListEo : erpInventoryPostListEos) {
                ReconciliationDifferenceEo reconciliationDifferenceEo = new ReconciliationDifferenceEo();
                reconciliationDifferenceEo.setCreateTime(new Date());
                reconciliationDifferenceEo.setUpdateTime(new Date());
                reconciliationDifferenceEo.setDr(0);
                reconciliationDifferenceEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                reconciliationDifferenceEo.setReconciliationTime(DateUtil.getDayBegin((Date)reqDto.getReconciliationTime()));
                reconciliationDifferenceEo.setResult(ReconiliationDifferenceResultEnum.HYX_NO_RECORD.getCode() + "");
                reconciliationDifferenceEo.setSource(InventoryReconciliationSourceEnum.U9.getCode());
                reconciliationDifferenceEo.setBookingType(inventoryPostListEo.getBookingType());
                reconciliationDifferenceEo.setBookingNo(inventoryPostListEo.getBookingNo());
                reconciliationDifferenceEo.setSkuCode(inventoryPostListEo.getSkuCode());
                reconciliationDifferenceEo.setSkuUnit(inventoryPostListEo.getSkuUnit());
                reconciliationDifferenceEo.setSkuName(inventoryPostListEo.getSkuName());
                reconciliationDifferenceEo.setOsQuantity(inventoryPostListEo.getErpQuantity());
                reconciliationDifferenceEo.setOsStatus(inventoryPostListEo.getErpStatus());
                reconciliationDifferenceEo.setOsWarehouseCode(inventoryPostListEo.getErpWarehouseCode());
                reconciliationDifferenceEo.setOsWarehouseName(inventoryPostListEo.getErpWarehouseName());
                reconciliationDifferenceEo.setOsOrderNo(inventoryPostListEo.getErpOrderNo());
                reconciliationDifferenceEo.setOsBatch(inventoryPostListEo.getErpBatch());
                reconciliationDifferenceEo.setOsOrderType(inventoryPostListEo.getErpOrderType());
                reconciliationDifferenceEo.setDifferenceNum(inventoryPostListEo.getErpQuantity().negate());
                String oldKey = inventoryPostListEo.getErpOrderNo() + inventoryPostListEo.getSkuCode() + Optional.ofNullable(inventoryPostListEo.getErpStatus()).orElse("") + Optional.ofNullable(inventoryPostListEo.getBookingNo()).orElse("") + Optional.ofNullable(inventoryPostListEo.getErpBatch()).orElse("");
                ReconciliationDifferenceEo oldReconciliationDifferenceEo = (ReconciliationDifferenceEo)differenceMap.get(oldKey);
                if (oldReconciliationDifferenceEo != null) {
                    reconciliationDifferenceEo.setMarkRemark(oldReconciliationDifferenceEo.getMarkRemark());
                    List reconciliationDifferenceLogEos = (List)differenceLogMap.get(oldReconciliationDifferenceEo.getId());
                    if (CollectionUtils.isNotEmpty((Collection)reconciliationDifferenceLogEos)) {
                        for (ReconciliationDifferenceLogEo reconciliationDifferenceLogEo : reconciliationDifferenceLogEos) {
                            ReconciliationDifferenceLogEo addLogEo = new ReconciliationDifferenceLogEo();
                            BeanUtil.copyProperties((Object)reconciliationDifferenceLogEo, (Object)addLogEo, (String[])new String[]{"id"});
                            addLogEo.setReconciliationDifferenceId(reconciliationDifferenceEo.getId());
                            addLogEo.setCreateTime(new Date());
                            addLogEo.setUpdateTime(new Date());
                            addLogEo.setDr(0);
                            differenceLogEos.add(addLogEo);
                        }
                    }
                }
                if (reqDto.getReCreate().booleanValue()) {
                    ReconciliationDifferenceLogEo addLogEo = new ReconciliationDifferenceLogEo();
                    addLogEo.setReconciliationDifferenceId(reconciliationDifferenceEo.getId());
                    addLogEo.setType(Integer.valueOf(2));
                    addLogEo.setCreateTime(new Date());
                    addLogEo.setUpdateTime(new Date());
                    addLogEo.setDr(0);
                    differenceLogEos.add(addLogEo);
                }
                reconciliationDifferenceEos.add(reconciliationDifferenceEo);
            }
            if (CollectionUtils.isNotEmpty(ruleRespDto.getDifferenceEos())) {
                reconciliationDifferenceEos.addAll(ruleRespDto.getDifferenceEos());
            }
            if (CollectionUtils.isNotEmpty(ruleRespDto.getDifferenceLogEos())) {
                differenceLogEos.addAll(ruleRespDto.getDifferenceLogEos());
            }
            ruleRespDto.setDifferenceEos(reconciliationDifferenceEos);
            ruleRespDto.setDifferenceLogEos(differenceLogEos);
        }
        return ruleRespDto;
    }

    private List<KeepAccountsDetailEo> getKeepAccountsDetailEo(List<String> documentNos) {
        IKeepAccountsDetailDomain keepAccountsDetailDomain = (IKeepAccountsDetailDomain)SpringBeanUtil.getBean(IKeepAccountsDetailDomain.class);
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(documentNos)) {
            List eos;
            int length;
            int i = 0;
            for (length = documentNos.size(); length > 1000; length -= 1000) {
                eos = ((ExtQueryChainWrapper)keepAccountsDetailDomain.filter().in((Object)"result_order_no", documentNos.subList(i, i + 1000))).list();
                keepAccountsDetailEos.addAll(eos);
                i += 1000;
            }
            if (length > 0) {
                eos = ((ExtQueryChainWrapper)keepAccountsDetailDomain.filter().in((Object)"result_order_no", documentNos.subList(i, i + length))).list();
                keepAccountsDetailEos.addAll(eos);
            }
        }
        return keepAccountsDetailEos;
    }
}

