/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.credit.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.dto.customer.request.TransactionRelationStatusCountQueryDto;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgOrgCustomerRelationService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component
public class CustomerRelationHelper {
    @Resource
    private IDgOrgCustomerRelationService dgOrgCustomerRelationService;
    @Resource
    private IDgCsOrgCustomerRelationDomain dgCsOrgCustomerRelationDomain;

    public List<CsOrgCustomerRelationExtDto> getBusinessAreaList(List<Long> regionIdList) {
        List<Long> childByAreaIds;
        if (CollectionUtil.isNotEmpty(regionIdList) && CollectionUtil.isNotEmpty(childByAreaIds = this.dgOrgCustomerRelationService.getChildByAreaIds(regionIdList))) {
            TransactionRelationStatusCountQueryDto relationStatusCountQueryDto = new TransactionRelationStatusCountQueryDto();
            relationStatusCountQueryDto.setAreaIds(childByAreaIds);
            List relationExtDtoList = this.dgCsOrgCustomerRelationDomain.queryBusinessAreaList(relationStatusCountQueryDto);
            return relationExtDtoList;
        }
        return null;
    }

    public List<CsOrgCustomerRelationExtDto> getByCustomerIdAndShopId(Set<Long> shopIds, Set<Long> customerIds) {
        TransactionRelationStatusCountQueryDto relationStatusCountQueryDto = new TransactionRelationStatusCountQueryDto();
        relationStatusCountQueryDto.setCustomerIdList((List)Lists.newArrayList(customerIds));
        relationStatusCountQueryDto.setShopIdList((List)Lists.newArrayList(shopIds));
        return this.dgCsOrgCustomerRelationDomain.queryBusinessAreaList(relationStatusCountQueryDto);
    }

    public Map<Long, List<DgBusinessAreaLevelDto>> getMapAreaLevel(List<CsOrgCustomerRelationExtDto> relationExtDtoList) {
        Set areaIds = relationExtDtoList.stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toSet());
        return this.dgOrgCustomerRelationService.mapAreaLevel(Lists.newArrayList(areaIds));
    }

    public String getRegionName(List<DgBusinessAreaLevelDto> areaLevelDtoList) {
        List nameList = areaLevelDtoList.stream().filter(Objects::nonNull).map(DgBusinessAreaLevelDto::getName).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(nameList)) {
            return String.join((CharSequence)"/", nameList);
        }
        return null;
    }
}

