/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.EnterpriceCrossPurchaseRelationConverter;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossPurchaseRelationDomain;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationCustomerListReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationPurchaseListReqDto;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossPurchaseRelationEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossPurchaseRelationService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriceCrossPurchaseRelationServiceImpl
extends BaseServiceImpl<EnterpriceCrossPurchaseRelationDto, EnterpriceCrossPurchaseRelationEo, IEnterpriceCrossPurchaseRelationDomain>
implements IEnterpriceCrossPurchaseRelationService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossPurchaseRelationServiceImpl.class);
    @Resource
    private IContext context;

    public EnterpriceCrossPurchaseRelationServiceImpl(IEnterpriceCrossPurchaseRelationDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<EnterpriceCrossPurchaseRelationDto, EnterpriceCrossPurchaseRelationEo> converter() {
        return EnterpriceCrossPurchaseRelationConverter.INSTANCE;
    }

    @Override
    public PageInfo<EnterpriceCrossPurchaseRelationDto> queryPage(EnterpriceCrossPurchaseRelationPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IEnterpriceCrossPurchaseRelationDomain)this.domain).queryList(dto));
    }

    @Override
    public RestResponse<Long> insertRelation(EnterpriceCrossPurchaseRelationDto dto) {
        EnterpriceCrossPurchaseRelationEo countEo = new EnterpriceCrossPurchaseRelationEo();
        countEo.setPurchaseEnterpriseId(dto.getPurchaseEnterpriseId());
        countEo.setCustomerId(dto.getCustomerId());
        countEo.setDr(0);
        int count = ((IEnterpriceCrossPurchaseRelationDomain)this.domain).count((BaseEo)countEo);
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u91c7\u8d2d\u65b9\u6240\u5c5e\u5ba2\u6237\u5173\u7cfb\u5df2\u5b58\u5728");
        EnterpriceCrossPurchaseRelationEo eo = (EnterpriceCrossPurchaseRelationEo)this.converter().toEo((BaseDto)dto);
        eo.setTenantId(this.context.tenantId());
        eo.setInstanceId(this.context.instanceId());
        eo.setCreatePerson(this.context.userName());
        eo.setCreateTime(new Date());
        eo.setUpdatePerson(this.context.userName());
        eo.setUpdateTime(new Date());
        ((IEnterpriceCrossPurchaseRelationDomain)this.domain).insert((BaseEo)eo);
        return new RestResponse((Object)eo.getId());
    }

    @Override
    public RestResponse updateRelation(EnterpriceCrossPurchaseRelationDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u7f3a\u5c11id");
        Integer count = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IEnterpriceCrossPurchaseRelationDomain)this.domain).filter().ne((Object)"id", (Object)dto.getId())).eq((Object)"purchase_enterprise_id", (Object)dto.getPurchaseEnterpriseId())).eq((Object)"customer_id", (Object)dto.getCustomerId())).eq((Object)"dr", (Object)0)).count();
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u4f9b\u5e94\u5546\u6240\u5c5e\u4e1a\u52a1\u5b9e\u4f53\u5173\u7cfb\u5df2\u5b58\u5728");
        EnterpriceCrossPurchaseRelationEo eo = (EnterpriceCrossPurchaseRelationEo)this.converter().toEo((BaseDto)dto);
        eo.setTenantId(this.context.tenantId());
        eo.setInstanceId(this.context.instanceId());
        eo.setUpdatePerson(this.context.userName());
        eo.setUpdateTime(new Date());
        ((IEnterpriceCrossPurchaseRelationDomain)this.domain).updateSelective((BaseEo)eo);
        return RestResponse.VOID;
    }

    @Override
    public List<EnterpriceCrossPurchaseRelationDto> list(EnterpriceCrossPurchaseRelationPageReqDto dto) {
        return ((IEnterpriceCrossPurchaseRelationDomain)this.domain).queryList(dto);
    }

    @Override
    public List<EnterpriceCrossPurchaseRelationDto> purchaseEnterpriseList(EnterpriceCrossPurchaseRelationPurchaseListReqDto dto) {
        return ((IEnterpriceCrossPurchaseRelationDomain)this.domain).purchaseEnterpriseList(dto);
    }

    @Override
    public List<EnterpriceCrossPurchaseRelationDto> purchaseCustomerList(EnterpriceCrossPurchaseRelationCustomerListReqDto dto) {
        return ((IEnterpriceCrossPurchaseRelationDomain)this.domain).purchaseCustomerList(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> saveBatch(List<EnterpriceCrossPurchaseRelationDto> dto) {
        log.info("-- {}", (Object)JSONUtil.toJsonStr(dto));
        HashSet<Long> checkSet = new HashSet<Long>();
        for (EnterpriceCrossPurchaseRelationDto d : dto) {
            AssertUtils.isTrue((!checkSet.contains(d.getPurchaseEnterpriseId()) ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            checkSet.add(d.getPurchaseEnterpriseId());
        }
        List updateIds = dto.stream().filter(e -> e.getId() != null).map(BaseDto::getId).collect(Collectors.toList());
        List all = ((ExtQueryChainWrapper)((IEnterpriceCrossPurchaseRelationDomain)this.domain).filter().eq((Object)"dr", (Object)"0")).list();
        List delIds = all.stream().map(BaseEo::getId).filter(e -> !updateIds.contains(e)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(delIds)) {
            log.info("\u3010del \u3011: {}", delIds);
            ((IEnterpriceCrossPurchaseRelationDomain)this.domain).logicDeleteByIds(delIds);
        }
        List updateList = this.converter().toEoList(dto.stream().filter(e -> e.getId() != null).peek(e -> {
            e.setUpdateTime(new Date());
            e.setUpdatePerson(this.context.userName());
            e.setDr(Integer.valueOf(0));
        }).collect(Collectors.toList()));
        List insertList = this.converter().toEoList(dto.stream().filter(e -> e.getId() == null).peek(e -> {
            e.setCreateTime(new Date());
            e.setUpdateTime(new Date());
            e.setCreatePerson(this.context.userName());
            e.setUpdatePerson(this.context.userName());
            e.setInstanceId(this.context.instanceId());
            e.setTenantId(this.context.tenantId());
            e.setDr(Integer.valueOf(0));
        }).collect(Collectors.toList()));
        if (CollUtil.isNotEmpty((Collection)insertList)) {
            log.info("\u3010insertBatch \u3011: {}", (Object)insertList);
            ((IEnterpriceCrossPurchaseRelationDomain)this.domain).insertBatch(insertList);
        }
        if (CollUtil.isNotEmpty((Collection)updateList)) {
            log.info("\u3010updateList \u3011: {}", (Object)updateList);
            updateList.stream().forEach(eo -> ((IEnterpriceCrossPurchaseRelationDomain)this.domain).updateSelective((BaseEo)eo));
        }
        return new RestResponse();
    }
}

