/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl.handler;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterpriseDto;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceInOtherStorageOrderOrgDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationRespDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossTradeRelationService;
import com.yunxi.dg.base.center.report.service.enterprice.impl.handler.EnterpriceCrossAbstractSceneServiceImpl;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EnterpriceFinishedProductReceiveReturnServiceImpl
extends EnterpriceCrossAbstractSceneServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceFinishedProductReceiveReturnServiceImpl.class);
    @Resource
    private IEnterpriceCrossOrderDomain orderDomain;
    @Resource
    private IEnterpriceCrossOrderLineDomain orderLineDomain;
    @Resource
    private IEnterpriceCrossTradeRelationService tradeRelationService;

    @Override
    public Boolean checkEnterpriceOrderAndHandleBusinessType(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        if (context.getResultDto().getRelevanceTableName().equals("in_other_storage_order") && context.getResultDto().getBusinessType().equals(BusinessTypeEnum.OTHER_IN.getType())) {
            context.getResultDto().setBusinessType(BusinessTypeEnum.FINISHED_PRODUCT_RECEIVE_RETURN.getType());
            context.getResultDto().setDisplayBusinessType(DisplayBusinessTypeEnum.FINISHED_PRODUCT_RECEIVE_RETURN.getType());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<Long> createOrder(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        EnterpriceInOtherStorageOrderOrgDto purchaseEnterpriceDto = this.orderDomain.selectInOtherStorageOrderByOrderNo(context.getResultDto().getRelevanceNo());
        EnterpriseDto saleEnterpriseDto = this.orderDomain.getLogicWarehouseEnterprise(context.getResultDto().getReceiveLogicWarehouseCode());
        EnterpriceCrossTradeRelationRespDto tradeRelationRespDto = null;
        if (purchaseEnterpriceDto != null && saleEnterpriseDto != null) {
            tradeRelationRespDto = this.tradeRelationService.getByPurchaseEnterpriseCodeAndEnterpriseCode(purchaseEnterpriceDto.getSaleOrganizationCode(), saleEnterpriseDto.getEnterpriseCode());
        }
        Long purchaseOrderId = this.createPurchaseOrder(context, purchaseEnterpriceDto, tradeRelationRespDto);
        Long saleOrderId = this.createSaleAfterOrder(context, saleEnterpriseDto, tradeRelationRespDto);
        return Arrays.asList(purchaseOrderId, saleOrderId);
    }

    private Long createPurchaseOrder(EnterpriceCrossReceiveDeliveryResultReqDto context, EnterpriceInOtherStorageOrderOrgDto purchaseEnterpriceDto, EnterpriceCrossTradeRelationRespDto tradeRelationRespDto) {
        EnterpriceCrossOrderEo orderEo = this.createEo(context.getResultDto().getBusinessType(), context.getResultDto().getDisplayBusinessType(), context.getResultDto().getId(), CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType());
        if (purchaseEnterpriceDto == null) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u91c7\u8d2d\u65b9\u4fe1\u606f\u5931\u8d25");
        } else {
            orderEo.setPurchaseEnterpriseId(purchaseEnterpriceDto.getPurchaseEnterpriseId());
            orderEo.setPurchaseEnterpriseCode(purchaseEnterpriceDto.getSaleOrganizationCode());
            orderEo.setCalculateCompanyCode(orderEo.getPurchaseEnterpriseCode());
        }
        if (tradeRelationRespDto == null) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        } else {
            orderEo.setSupplierId(tradeRelationRespDto.getSupplierId());
            orderEo.setSupplierCode(tradeRelationRespDto.getSupplierCode());
        }
        this.orderDomain.insert((BaseEo)orderEo);
        Boolean duductResult = this.orderLineDomain.purchaseOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), orderEo);
        this.deductFailSetSyncException(duductResult, orderEo);
        return orderEo.getId();
    }

    private Long createSaleAfterOrder(EnterpriceCrossReceiveDeliveryResultReqDto context, EnterpriseDto saleEnterpriseDto, EnterpriceCrossTradeRelationRespDto tradeRelationRespDto) {
        String saleType = CompanyTradeTypeEnum.AFTERSALE_ORDER.getType();
        EnterpriceCrossOrderEo orderEo = this.createEo(context.getResultDto().getBusinessType(), context.getResultDto().getDisplayBusinessType(), context.getResultDto().getId(), saleType);
        if (saleEnterpriseDto == null) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u9500\u552e\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
        } else {
            orderEo.setSaleEnterpriseId(saleEnterpriseDto.getEnterpriseId());
            orderEo.setSaleEnterpriseCode(saleEnterpriseDto.getEnterpriseCode());
            orderEo.setCalculateCompanyCode(orderEo.getSaleEnterpriseCode());
        }
        if (tradeRelationRespDto == null) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        } else {
            orderEo.setCustomerId(tradeRelationRespDto.getCustomerId());
            orderEo.setCustomerCode(tradeRelationRespDto.getCustomerCode());
        }
        this.orderDomain.insert((BaseEo)orderEo);
        Boolean duductResult = this.orderLineDomain.saleOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), orderEo);
        this.deductFailSetSyncException(duductResult, orderEo);
        return orderEo.getId();
    }
}

