/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.MD5Util;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.CostStatisticalTypeEnum;
import com.yunxi.dg.base.center.report.convert.entity.CostOverviewDetailConverter;
import com.yunxi.dg.base.center.report.dao.das.ICostOverviewDetailDas;
import com.yunxi.dg.base.center.report.dao.das.ICostOverviewDetailOrderDas;
import com.yunxi.dg.base.center.report.dao.das.IOrderSkuCostDetailDas;
import com.yunxi.dg.base.center.report.dao.das.IShopArchiveCostDetailDas;
import com.yunxi.dg.base.center.report.dao.das.IShopSkuCostDetailDas;
import com.yunxi.dg.base.center.report.domain.entity.ICostOverviewDetailDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.dto.entity.CostCostTopDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCostTopReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCostTrendDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCostTrendReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostGrossProfitTopDto;
import com.yunxi.dg.base.center.report.dto.entity.CostGrossProfitTopReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostGrossProfitTrendDto;
import com.yunxi.dg.base.center.report.dto.entity.CostGrossProfitTrendReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostGrossTopReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostGrossTrendReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostOverviewDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.CostOverviewDto;
import com.yunxi.dg.base.center.report.dto.entity.CostOverviewReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostProfitTopDto;
import com.yunxi.dg.base.center.report.dto.entity.CostProfitTrendDto;
import com.yunxi.dg.base.center.report.dto.entity.CostSalesAmountTopDto;
import com.yunxi.dg.base.center.report.dto.entity.CostSalesAmountTopReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostSalesAmountTrendDto;
import com.yunxi.dg.base.center.report.dto.entity.CostSalesAmountTrendReqDto;
import com.yunxi.dg.base.center.report.dto.entity.StepConsumeDto;
import com.yunxi.dg.base.center.report.eo.CostOverviewDetailEo;
import com.yunxi.dg.base.center.report.eo.CostOverviewDetailOrderEo;
import com.yunxi.dg.base.center.report.eo.OrderSkuCostDetailEo;
import com.yunxi.dg.base.center.report.service.entity.ICostOverviewDetailService;
import com.yunxi.dg.base.center.report.service.utils.CostDateUtils;
import com.yunxi.dg.base.center.report.utils.MathUtils;
import com.yunxi.dg.base.center.report.utils.PageQueryUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CostOverviewDetailServiceImpl
extends BaseServiceImpl<CostOverviewDetailDto, CostOverviewDetailEo, ICostOverviewDetailDomain>
implements ICostOverviewDetailService {
    private static final Logger log = LoggerFactory.getLogger(CostOverviewDetailServiceImpl.class);
    private static final String CACHE_KEY_OVERVIEW = "cost_overview:";
    @Resource
    private IOrderSkuCostDetailDas orderSkuCostDetailDas;
    @Resource
    private ICostOverviewDetailDas costOverviewDetailDas;
    @Resource
    private ICostOverviewDetailOrderDas costOverviewDetailOrderDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IShopArchiveCostDetailDas shopArchiveCostDetailDas;
    @Resource
    private IShopSkuCostDetailDas shopSkuCostDetailDas;
    @Resource
    private IDirDgDomain dirDgDomain;

    public CostOverviewDetailServiceImpl(ICostOverviewDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CostOverviewDetailDto, CostOverviewDetailEo> converter() {
        return CostOverviewDetailConverter.INSTANCE;
    }

    @Override
    public void syncWithDates(List<LocalDate> dates) {
        dates = dates.stream().distinct().sorted().collect(Collectors.toList());
        dates.forEach(date -> {
            try {
                this.syncWithDate((LocalDate)date);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65 {} \u7684\u6982\u8981\u8be6\u60c5\u5931\u8d25", date, (Object)e);
            }
        });
        this.syncAfterAllDateOnly(dates);
    }

    @Override
    public List<StepConsumeDto> syncAfterAllDateOnly(List<LocalDate> dates) {
        ArrayList<StepConsumeDto> steps = new ArrayList<StepConsumeDto>(3);
        String reportName = "\u7ecf\u8425\u5206\u6790\u6982\u8981\u8be6\u60c5";
        StepConsumeDto step = StepConsumeDto.newStep((String)"\u6982\u8981-\u6708");
        steps.add(step);
        List lists = CostStatisticalTypeEnum.MONTH.doSyncAndReturn(reportName, dates, this::syncWithRange);
        step.setChildren(lists);
        step.finish();
        step = StepConsumeDto.newStep((String)"\u6982\u8981-\u5b63\u5ea6");
        steps.add(step);
        lists = CostStatisticalTypeEnum.QUARTER.doSyncAndReturn(reportName, dates, this::syncWithRange);
        step.setChildren(lists);
        step.finish();
        step = StepConsumeDto.newStep((String)"\u6982\u8981-\u5e74");
        steps.add(step);
        lists = CostStatisticalTypeEnum.YEAR.doSyncAndReturn(reportName, dates, this::syncWithRange);
        step.setChildren(lists);
        step.finish();
        return steps;
    }

    private StepConsumeDto syncWithRange(CostStatisticalTypeEnum type, Integer currentDate, Integer startDate, Integer endDate) {
        StepConsumeDto parentStep = StepConsumeDto.newStep((String)String.format("%s-%s", type.getName(), currentDate));
        StepConsumeDto step = parentStep.newChildStep("\u67e5\u8be2\u660e\u7ec6");
        List<CostOverviewDetailEo> list = PageQueryUtils.queryAll(1000, () -> this.costOverviewDetailDas.queryByStatisticalDate(startDate, endDate, type.getPrev().getCode()));
        step.finish();
        ArrayList detailIds = new ArrayList();
        HashMap<String, List> group = new HashMap<String, List>();
        list.forEach(k -> {
            detailIds.add(k.getId());
            String key = k.getShopCode() + "_" + k.getShopWebsiteCode() + "_" + k.getDirCode();
            group.computeIfAbsent(key, k1 -> new ArrayList()).add(k);
        });
        step = parentStep.newChildStep("\u67e5\u8be2\u660e\u7ec6\u8ba2\u5355");
        List oldDetailOrders = this.costOverviewDetailOrderDas.queryByDetailIds(detailIds);
        Map<Long, List<CostOverviewDetailOrderEo>> detailOrderGroup = oldDetailOrders.stream().collect(Collectors.groupingBy(CostOverviewDetailOrderEo::getDetailId));
        step.finish();
        step = parentStep.newChildStep("\u904d\u5386");
        ArrayList<CostOverviewDetailEo> details = new ArrayList<CostOverviewDetailEo>();
        ArrayList detailOrders = new ArrayList();
        group.forEach((key, values) -> {
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal saleAmount = BigDecimal.ZERO;
            BigDecimal budgetCostAmount = BigDecimal.ZERO;
            BigDecimal actualCostAmount = BigDecimal.ZERO;
            BigDecimal taxCostAmount = BigDecimal.ZERO;
            int paidNum = 0;
            int refundNum = 0;
            HashMap<String, CostOverviewDetailOrderEo> sourceTypeOrders = new HashMap<String, CostOverviewDetailOrderEo>();
            for (CostOverviewDetailEo value : values) {
                paidAmount = paidAmount.add(Optional.ofNullable(value.getPaidAmount()).orElse(BigDecimal.ZERO));
                refundAmount = refundAmount.add(Optional.ofNullable(value.getRefundAmount()).orElse(BigDecimal.ZERO));
                saleAmount = saleAmount.add(Optional.ofNullable(value.getSaleAmount()).orElse(BigDecimal.ZERO));
                budgetCostAmount = budgetCostAmount.add(Optional.ofNullable(value.getBudgetCostAmount()).orElse(BigDecimal.ZERO));
                actualCostAmount = actualCostAmount.add(Optional.ofNullable(value.getActualCostAmount()).orElse(BigDecimal.ZERO));
                taxCostAmount = taxCostAmount.add(Optional.ofNullable(value.getTaxCostAmount()).orElse(BigDecimal.ZERO));
                paidNum += Optional.ofNullable(value.getPaidNum()).orElse(0).intValue();
                refundNum += Optional.ofNullable(value.getRefundNum()).orElse(0).intValue();
                List<CostOverviewDetailOrderEo> tmpOrders = detailOrderGroup.getOrDefault(value.getId(), Collections.emptyList());
                tmpOrders.forEach(o -> {
                    String k = o.getSourceType() + "_" + o.getSourceId();
                    sourceTypeOrders.put(k, (CostOverviewDetailOrderEo)o);
                });
            }
            CostOverviewDetailEo o2 = (CostOverviewDetailEo)values.get(0);
            CostOverviewDetailEo eo = new CostOverviewDetailEo();
            eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            eo.setType(type.getCode()).setStatisticalDate(currentDate).setShopId(o2.getShopId()).setShopCode(o2.getShopCode()).setShopName(o2.getShopName()).setShopWebsiteId(o2.getShopWebsiteId()).setShopWebsiteCode(o2.getShopWebsiteCode()).setShopWebsiteName(o2.getShopWebsiteName()).setDirId(o2.getDirId()).setDirCode(o2.getDirCode()).setDirName(o2.getDirName()).setPaidNum(Integer.valueOf(paidNum)).setPaidAmount(paidAmount).setRefundNum(Integer.valueOf(refundNum)).setRefundAmount(refundAmount).setSaleNum(Integer.valueOf(eo.getPaidNum() - eo.getRefundNum())).setSaleAmount(saleAmount).setRefundRate(MathUtils.rate(eo.getRefundAmount(), saleAmount)).setBudgetCostAmount(budgetCostAmount).setBudgetCostRate(MathUtils.rate(budgetCostAmount, saleAmount)).setActualCostAmount(actualCostAmount).setActualCostRate(MathUtils.rate(actualCostAmount, saleAmount)).setTaxCostAmount(taxCostAmount).setGrossProfitAmount(saleAmount.subtract(taxCostAmount)).setGrossProfitRate(MathUtils.rate(eo.getGrossProfitAmount(), saleAmount)).setProfitAmount(eo.getGrossProfitAmount().subtract(actualCostAmount)).setProfitRate(MathUtils.rate(eo.getProfitAmount(), saleAmount)).setBudgetActualDiffAmount(eo.getBudgetCostAmount().subtract(eo.getActualCostAmount())).setBudgetActualDiffRate(Optional.ofNullable(eo.getBudgetCostRate()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(eo.getActualCostRate()).orElse(BigDecimal.ZERO)));
            details.add(eo);
            sourceTypeOrders.forEach((k, v) -> {
                CostOverviewDetailOrderEo e = new CostOverviewDetailOrderEo().setDetailId(eo.getId()).setSourceType(v.getSourceType()).setSourceId(v.getSourceId()).setPlatformOrderNo(v.getPlatformOrderNo()).setPlatformRefundOrderSn(v.getPlatformRefundOrderSn());
                detailOrders.add(e);
            });
        });
        step.finish();
        details.sort(Comparator.comparing(CostOverviewDetailEo::getStatisticalDate));
        List ids = this.costOverviewDetailDas.queryIdByDate(currentDate, type.getCode());
        this.costOverviewDetailDas.physicalDeleteByDate(currentDate, type.getCode());
        this.costOverviewDetailOrderDas.physicalDeleteByDetailIds(ids);
        step = parentStep.newChildStep("\u63d2\u5165detail");
        this.costOverviewDetailDas.insertBatch(details);
        step.finish();
        step = parentStep.newChildStep("\u63d2\u5165detail_order");
        this.costOverviewDetailOrderDas.insertBatch(detailOrders);
        step.finish();
        this.deleteAllCache(type, currentDate);
        parentStep.finish();
        return parentStep;
    }

    private String cacheKeyPrefix(CostStatisticalTypeEnum type, Integer date) {
        return CACHE_KEY_OVERVIEW + type.getCode() + "_" + date;
    }

    private String cacheKey(CostOverviewReqDto req) {
        CostStatisticalTypeEnum type = CostStatisticalTypeEnum.fromCode((String)req.getType());
        Integer date = req.getDate();
        String md5 = MD5Util.getMd5ByString((String)JacksonUtil.toJson((Object)req));
        return String.format("%s_%s", this.cacheKeyPrefix(type, date), md5);
    }

    private String cacheKeyAll(CostOverviewReqDto req) {
        CostStatisticalTypeEnum type = CostStatisticalTypeEnum.fromCode((String)req.getType());
        Integer date = req.getDate();
        return this.cacheKeyAll(type, date);
    }

    private String cacheKeyAll(CostStatisticalTypeEnum type, Integer date) {
        return this.cacheKeyPrefix(type, date) + "_all";
    }

    private void syncWithDate(LocalDate date) {
        LocalDateTime startTime = date.atStartOfDay();
        LocalDateTime endTime = date.atTime(23, 59, 59);
        List<OrderSkuCostDetailEo> list = PageQueryUtils.queryAll(1000, () -> this.orderSkuCostDetailDas.queryByBizTime(startTime, endTime));
        this.syncDateOnly(date, list);
    }

    @Override
    public void syncDateOnly(LocalDate date, List<OrderSkuCostDetailEo> list) {
        log.info("\u540c\u6b65\u6982\u8981\u8be6\u60c5\u5f00\u59cb: date={}", (Object)date);
        Map<String, List<OrderSkuCostDetailEo>> group = list.stream().collect(Collectors.groupingBy(k -> k.getShopCode() + "_" + k.getShopWebsiteCode() + "_" + k.getDirCode()));
        ArrayList<CostOverviewDetailEo> details = new ArrayList<CostOverviewDetailEo>();
        ArrayList detailOrders = new ArrayList();
        Integer statisticalDate = Integer.parseInt(date.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        group.forEach((key, values) -> {
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal saleAmount = BigDecimal.ZERO;
            BigDecimal budgetCostAmount = BigDecimal.ZERO;
            BigDecimal actualCostAmount = BigDecimal.ZERO;
            BigDecimal taxCostAmount = BigDecimal.ZERO;
            HashSet<String> paidOrders = new HashSet<String>();
            HashSet<String> refundOrders = new HashSet<String>();
            HashSet<String> uniqueIds = new HashSet<String>();
            HashMap<String, OrderSkuCostDetailEo> sourceTypeOrders = new HashMap<String, OrderSkuCostDetailEo>();
            for (OrderSkuCostDetailEo value : values) {
                String uniqueId = String.format("%s_%s_%s", value.getSourceId(), value.getSourceType(), value.getSkuCode());
                if (!uniqueIds.contains(uniqueId)) {
                    uniqueIds.add(uniqueId);
                    if (value.isSaleOrder()) {
                        paidAmount = paidAmount.add(Optional.ofNullable(value.getSkuRealPayAmount()).orElse(BigDecimal.ZERO));
                        taxCostAmount = taxCostAmount.add(Optional.ofNullable(value.getSkuTaxCostAmount()).orElse(BigDecimal.ZERO));
                    } else {
                        refundAmount = refundAmount.add(Optional.ofNullable(value.getSkuRefundAmount()).orElse(BigDecimal.ZERO));
                    }
                }
                budgetCostAmount = budgetCostAmount.add(Optional.ofNullable(value.getBudgetCostAmount()).orElse(BigDecimal.ZERO));
                actualCostAmount = actualCostAmount.add(Optional.ofNullable(value.getActualCostAmount()).orElse(BigDecimal.ZERO));
                String k2 = value.getSourceType() + "_" + value.getSourceId();
                if (value.isSaleOrder()) {
                    paidOrders.add(k2);
                } else {
                    refundOrders.add(k2);
                }
                sourceTypeOrders.put(k2, value);
            }
            saleAmount = paidAmount.subtract(refundAmount);
            OrderSkuCostDetailEo o = (OrderSkuCostDetailEo)values.get(0);
            CostOverviewDetailEo eo = new CostOverviewDetailEo();
            eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            eo.setType("date").setStatisticalDate(statisticalDate).setShopId(o.getShopId()).setShopCode(o.getShopCode()).setShopName(o.getShopName()).setShopWebsiteId(o.getShopWebsiteId()).setShopWebsiteCode(o.getShopWebsiteCode()).setShopWebsiteName(o.getShopWebsiteName()).setDirId(o.getDirId()).setDirCode(o.getDirCode()).setDirName(o.getDirName()).setPaidNum(Integer.valueOf(paidOrders.size())).setPaidAmount(paidAmount).setRefundNum(Integer.valueOf(refundOrders.size())).setRefundAmount(refundAmount).setSaleNum(Integer.valueOf(eo.getPaidNum() - eo.getRefundNum())).setSaleAmount(saleAmount).setRefundRate(MathUtils.rate(eo.getRefundAmount(), saleAmount)).setBudgetCostAmount(budgetCostAmount).setBudgetCostRate(MathUtils.rate(budgetCostAmount, saleAmount)).setActualCostAmount(actualCostAmount).setActualCostRate(MathUtils.rate(actualCostAmount, saleAmount)).setTaxCostAmount(taxCostAmount).setGrossProfitAmount(saleAmount.subtract(taxCostAmount)).setGrossProfitRate(MathUtils.rate(eo.getGrossProfitAmount(), saleAmount)).setProfitAmount(eo.getGrossProfitAmount().subtract(actualCostAmount)).setProfitRate(MathUtils.rate(eo.getProfitAmount(), saleAmount)).setBudgetActualDiffAmount(eo.getBudgetCostAmount().subtract(eo.getActualCostAmount())).setBudgetActualDiffRate(Optional.ofNullable(eo.getBudgetCostRate()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(eo.getActualCostRate()).orElse(BigDecimal.ZERO)));
            details.add(eo);
            sourceTypeOrders.forEach((k, v) -> {
                CostOverviewDetailOrderEo e = new CostOverviewDetailOrderEo().setDetailId(eo.getId()).setSourceType(v.getSourceType()).setSourceId(v.getSourceId()).setPlatformOrderNo(v.getPlatformOrderNo()).setPlatformRefundOrderSn(v.getPlatformRefundOrderSn());
                detailOrders.add(e);
            });
        });
        details.sort(Comparator.comparing(CostOverviewDetailEo::getStatisticalDate));
        List ids = this.costOverviewDetailDas.queryIdByDate(statisticalDate, "date");
        this.costOverviewDetailDas.physicalDeleteByDate(statisticalDate, "date");
        this.costOverviewDetailOrderDas.physicalDeleteByDetailIds(ids);
        this.costOverviewDetailDas.insertBatch(details);
        this.costOverviewDetailOrderDas.insertBatch(detailOrders);
        this.deleteAllCache(CostStatisticalTypeEnum.DATE, statisticalDate);
        log.info("\u540c\u6b65\u6982\u8981\u8be6\u60c5\u5b8c\u6210: date={}", (Object)date);
    }

    private void deleteAllCache(CostStatisticalTypeEnum type, Integer date) {
        String key = this.cacheKeyAll(type, date);
        Set keys = this.cacheService.smembers(key);
        if (keys == null || keys.isEmpty()) {
            return;
        }
        keys.add(key);
        this.cacheService.delCache(new ArrayList(keys));
    }

    @Override
    public CostOverviewDto getOverview(CostOverviewReqDto dto) {
        this.processDirIds(dto, CostOverviewReqDto::getDirIds, CostOverviewReqDto::setDirIds);
        String cacheKey = this.cacheKey(dto);
        CostOverviewDto result = (CostOverviewDto)this.cacheService.getCache(cacheKey, CostOverviewDto.class);
        if (result != null) {
            log.info("\u4ece\u7f13\u5b58 {} \u4e2d\u83b7\u53d6\u5230\u7ecf\u8425\u5206\u6790\u62a5\u8868-\u6458\u8981\u4fe1\u606f", (Object)cacheKey);
            return result;
        }
        CostOverviewDto overview = this.getOverviewInternal(dto);
        CostOverviewDto momOverview = this.getMomOverview(dto);
        overview.calcMom(momOverview);
        CostOverviewDto yoyOverview = this.getYoyOverview(dto);
        overview.calcYoy(yoyOverview);
        int seconds = 2592000;
        this.cacheService.setCache(cacheKey, (Object)overview, seconds);
        this.cacheService.sadd(this.cacheKeyAll(dto), (List)Lists.newArrayList((Object[])new String[]{cacheKey}), seconds + 10);
        return overview;
    }

    private <T> void processDirIds(T obj, Function<T, List<Long>> dirIdsGetter, BiConsumer<T, List<Long>> dirIdsSetter) {
        List dirIds = dirIdsGetter.apply(obj);
        dirIds = this.dirDgDomain.getDescendantIds(dirIds);
        dirIdsSetter.accept(obj, dirIds);
    }

    private CostOverviewDto getMomOverview(CostOverviewReqDto dto) {
        List<CostOverviewReqDto> requests = this.getRequests("\u73af\u6bd4", dto, (type, date) -> (LocalDate)type.getMomMapper().apply(date));
        return this.getOverviewAndMerge(requests);
    }

    private CostOverviewDto getYoyOverview(CostOverviewReqDto dto) {
        if (dto.getType().equals(CostStatisticalTypeEnum.YEAR.getCode())) {
            return null;
        }
        List<CostOverviewReqDto> requests = this.getRequests("\u540c\u6bd4", dto, (type, date) -> (LocalDate)type.getYoyMapper().apply(date));
        return this.getOverviewAndMerge(requests);
    }

    private CostOverviewDto getOverviewAndMerge(List<CostOverviewReqDto> requests) {
        CostOverviewDto overview = new CostOverviewDto();
        List<CompletableFuture> futures = requests.stream().map(request -> CompletableFuture.supplyAsync(() -> this.getOverviewInternal((CostOverviewReqDto)request))).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        for (CompletableFuture future : futures) {
            try {
                CostOverviewDto v = (CostOverviewDto)future.get();
                overview.merge(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CostOverviewDetailServiceImpl.reCalcRate(overview);
        return overview;
    }

    private static void reCalcRate(CostOverviewDto overview) {
        overview.setBudgetRate(MathUtils.rate(overview.getBudgetAmount(), overview.getSaleAmount()));
        overview.setRefundRate(MathUtils.rate(overview.getRefundAmount(), overview.getSaleAmount()));
        overview.setActualRate(MathUtils.rate(overview.getActualAmount(), overview.getSaleAmount()));
        overview.setGrossProfitRate(MathUtils.rate(overview.getGrossProfitAmount(), overview.getSaleAmount()));
        overview.setProfitRate(MathUtils.rate(overview.getProfitAmount(), overview.getSaleAmount()));
    }

    private List<CostOverviewReqDto> getRequests(String name, CostOverviewReqDto dto, BiFunction<CostStatisticalTypeEnum, LocalDate, LocalDate> prevMapper) {
        CostStatisticalTypeEnum type = CostStatisticalTypeEnum.fromCode((String)dto.getType());
        CostStatisticalTypeEnum.DateRange range = (CostStatisticalTypeEnum.DateRange)type.getDateRangeMapper().apply(dto.getDate());
        LocalDate startDate = prevMapper.apply(type, range.getStartDate());
        LocalDate yesterday = LocalDate.now().plusDays(-1L);
        boolean current = type.format(yesterday).equals(dto.getDate());
        LocalDate endDate = prevMapper.apply(type, current && range.getEndDate().isAfter(yesterday) ? yesterday : range.getEndDate());
        List ranges = type.splitRange(startDate, endDate);
        List<CostOverviewReqDto> requests = ranges.stream().map(r -> {
            CostOverviewReqDto req = CostOverviewDetailConverter.INSTANCE.copy(dto);
            req.setType(r.getType().getCode());
            req.setDateStart(r.getType().format(r.getStartDate()));
            req.setDateEnd(r.getType().format(r.getEndDate()));
            req.setDate(null);
            return req;
        }).collect(Collectors.toList());
        String info = requests.stream().map(k -> String.format("%s[%s~%s]", k.getType(), k.getDateStart(), k.getDateEnd())).collect(Collectors.joining(", "));
        log.info("{} - {} - {} \u62c6\u5206\u67e5\u8be2\u65f6\u95f4\u6bb5\uff1a{}", new Object[]{dto.getType(), dto.getDate(), name, info});
        return requests;
    }

    private CostOverviewDto getOverviewInternal(CostOverviewReqDto dto) {
        CostOverviewDto overview;
        CostOverviewDto num = this.costOverviewDetailOrderDas.countOrderNum(dto);
        if (num == null) {
            num = new CostOverviewDto();
        }
        if ((overview = this.costOverviewDetailDas.getOverview(dto)) == null) {
            overview = new CostOverviewDto();
        }
        overview.setPaidNum(num.getPaidNum());
        overview.setRefundNum(num.getRefundNum());
        overview.setSaleNum(Integer.valueOf(num.getPaidNum() - num.getRefundNum()));
        CostOverviewDetailServiceImpl.reCalcRate(overview);
        return overview;
    }

    @Override
    public List<CostSalesAmountTrendDto> getSalesAmountTrend(CostSalesAmountTrendReqDto dto) {
        this.processDirIds(dto, CostSalesAmountTrendReqDto::getDirIds, CostSalesAmountTrendReqDto::setDirIds);
        List rt = this.costOverviewDetailDas.getSalesAmountTrend(dto);
        rt.forEach(item -> CostDateUtils.formatDate(item, dto.getType(), CostSalesAmountTrendDto::getStatisticalDate, CostSalesAmountTrendDto::setStatisticalDateFormat));
        return rt;
    }

    @Override
    public List<CostSalesAmountTopDto> getSalesAmountTop(CostSalesAmountTopReqDto dto) {
        this.processDirIds(dto, CostSalesAmountTopReqDto::getDirIds, CostSalesAmountTopReqDto::setDirIds);
        dto.validate();
        switch (dto.getSortField()) {
            case "saleAmount": {
                dto.setSortFieldName("sale_amount");
                break;
            }
            case "refundRate": {
                dto.setSortFieldName("refund_rate");
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5b57\u6bb5");
            }
        }
        switch (dto.getTopType()) {
            case "channel": {
                dto.setGroupCodeField("shop_website_code");
                dto.setGroupNameField("shop_website_name");
                break;
            }
            case "shop": {
                dto.setGroupCodeField("shop_code");
                dto.setGroupNameField("shop_name");
                break;
            }
            case "dir": {
                dto.setGroupCodeField("dir_code");
                dto.setGroupNameField("dir_name");
                break;
            }
            case "sku": {
                dto.setGroupCodeField("sku_code");
                dto.setGroupNameField("sku_name");
                return this.shopSkuCostDetailDas.getSalesAmountTop(dto);
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u884c\u7c7b\u578b");
            }
        }
        return this.costOverviewDetailDas.getSalesAmountTop(dto);
    }

    @Override
    public List<CostCostTrendDto> getCostTrend(CostCostTrendReqDto dto) {
        List list = this.shopArchiveCostDetailDas.getCostTrend(dto);
        list.forEach(item -> CostDateUtils.formatDate(item, dto.getType(), CostCostTrendDto::getStatisticalDate, CostCostTrendDto::setStatisticalDateFormat));
        return list;
    }

    @Override
    public List<CostCostTopDto> getCostTop(CostCostTopReqDto dto) {
        dto.validate();
        switch (dto.getSortField()) {
            case "budgetCostRate": {
                dto.setSortFieldName("budget_cost_rate");
                break;
            }
            case "actualCostRate": {
                dto.setSortFieldName("actual_cost_rate");
                break;
            }
            case "budgetActualDiffRate": {
                dto.setSortFieldName("budget_actual_diff_rate");
                break;
            }
            case "saleAmount": {
                dto.setSortFieldName("sale_amount");
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5b57\u6bb5");
            }
        }
        switch (dto.getTopType()) {
            case "archive": {
                dto.setGroupCodeField("archive_code");
                dto.setGroupNameField("archive_name");
                break;
            }
            case "category": {
                dto.setGroupCodeField("category_code");
                dto.setGroupNameField("category_name");
                break;
            }
            case "channel": {
                dto.setGroupCodeField("shop_website_code");
                dto.setGroupNameField("shop_website_name");
                break;
            }
            case "shop": {
                dto.setGroupCodeField("shop_code");
                dto.setGroupNameField("shop_name");
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u884c\u7c7b\u578b");
            }
        }
        return this.shopArchiveCostDetailDas.getCostTop(dto);
    }

    @Override
    public List<CostGrossProfitTrendDto> getGrossProfitTrend(CostGrossProfitTrendReqDto dto) {
        this.processDirIds(dto, CostGrossProfitTrendReqDto::getDirIds, CostGrossProfitTrendReqDto::setDirIds);
        List list = this.costOverviewDetailDas.getGrossProfitTrend(dto);
        list.forEach(item -> CostDateUtils.formatDate(item, dto.getType(), CostGrossProfitTrendDto::getStatisticalDate, CostGrossProfitTrendDto::setStatisticalDateFormat));
        return list;
    }

    @Override
    public List<CostGrossProfitTopDto> getGrossProfitTop(CostGrossProfitTopReqDto dto) {
        this.processDirIds(dto, CostGrossProfitTopReqDto::getDirIds, CostGrossProfitTopReqDto::setDirIds);
        dto.validate();
        switch (dto.getSortField()) {
            case "grossProfitAmount": {
                dto.setSortFieldName("gross_profit_amount");
                break;
            }
            case "grossProfitRate": {
                dto.setSortFieldName("gross_profit_rate");
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5b57\u6bb5");
            }
        }
        switch (dto.getTopType()) {
            case "channel": {
                dto.setGroupCodeField("shop_website_code");
                dto.setGroupNameField("shop_website_name");
                break;
            }
            case "shop": {
                dto.setGroupCodeField("shop_code");
                dto.setGroupNameField("shop_name");
                break;
            }
            case "dir": {
                dto.setGroupCodeField("dir_code");
                dto.setGroupNameField("dir_name");
                break;
            }
            case "sku": {
                dto.setGroupCodeField("sku_code");
                dto.setGroupNameField("sku_name");
                return this.shopSkuCostDetailDas.getGrossProfitTop(dto);
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u884c\u7c7b\u578b");
            }
        }
        return this.costOverviewDetailDas.getGrossProfitTop(dto);
    }

    @Override
    public List<CostProfitTrendDto> getProfitTrend(CostGrossTrendReqDto dto) {
        this.processDirIds(dto, CostGrossTrendReqDto::getDirIds, CostGrossTrendReqDto::setDirIds);
        List list = this.costOverviewDetailDas.getProfitTrend(dto);
        list.forEach(item -> CostDateUtils.formatDate(item, dto.getType(), CostProfitTrendDto::getStatisticalDate, CostProfitTrendDto::setStatisticalDateFormat));
        return list;
    }

    @Override
    public List<CostProfitTopDto> getProfitTop(CostGrossTopReqDto dto) {
        this.processDirIds(dto, CostGrossTopReqDto::getDirIds, CostGrossTopReqDto::setDirIds);
        dto.validate();
        switch (dto.getSortField()) {
            case "profitAmount": {
                dto.setSortFieldName("profit_amount");
                break;
            }
            case "profitRate": {
                dto.setSortFieldName("profit_rate");
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5b57\u6bb5");
            }
        }
        switch (dto.getTopType()) {
            case "channel": {
                dto.setGroupCodeField("shop_website_code");
                dto.setGroupNameField("shop_website_name");
                break;
            }
            case "shop": {
                dto.setGroupCodeField("shop_code");
                dto.setGroupNameField("shop_name");
                break;
            }
            case "dir": {
                dto.setGroupCodeField("dir_code");
                dto.setGroupNameField("dir_name");
                break;
            }
            case "sku": {
                dto.setGroupCodeField("sku_code");
                dto.setGroupNameField("sku_name");
                return this.shopSkuCostDetailDas.getProfitTop(dto);
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u6392\u884c\u7c7b\u578b");
            }
        }
        return this.costOverviewDetailDas.getProfitTop(dto);
    }
}

