/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.report.convert.entity.LogisticsInfoConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgLogisticsInfoDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgLogisticsInfoDto;
import com.yunxi.dg.base.center.report.eo.DgLogisticsInfoEo;
import com.yunxi.dg.base.center.report.service.entity.IDgLogisticsInfoService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgLogisticsInfoServiceImpl
extends BaseServiceImpl<DgLogisticsInfoDto, DgLogisticsInfoEo, IDgLogisticsInfoDomain>
implements IDgLogisticsInfoService {
    public DgLogisticsInfoServiceImpl(IDgLogisticsInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgLogisticsInfoDto, DgLogisticsInfoEo> converter() {
        return LogisticsInfoConverter.INSTANCE;
    }

    @Override
    public Map<String, Date> getLogisticsSignTimeMap(List<String> businessNos) {
        if (CollectionUtils.isEmpty(businessNos)) {
            return Collections.emptyMap();
        }
        List list = ((ExtQueryChainWrapper)((IDgLogisticsInfoDomain)this.domain).filter().in((Object)"business_order_no", businessNos)).select(new String[]{"business_order_no", "sign_time"}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Date> map = new HashMap<String, Date>();
        list.forEach(e -> {
            if (e.getSignTime() == null) {
                return;
            }
            Date date = map.computeIfAbsent(e.getBusinessOrderNo(), k -> e.getSignTime());
            if (e.getSignTime().after(date)) {
                map.put(e.getBusinessOrderNo(), e.getSignTime());
            }
        });
        return map;
    }
}

