/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.json.JSONUtil;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.PurchaseSaleStockCountConverter;
import com.yunxi.dg.base.center.report.convert.entity.PurchaseSaleStockReportConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDictDomain;
import com.yunxi.dg.base.center.report.domain.entity.IPurchaseSaleStockCountDomain;
import com.yunxi.dg.base.center.report.domain.entity.IPurchaseSaleStockDetailReportDomain;
import com.yunxi.dg.base.center.report.domain.entity.IPurchaseSaleStockReportDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.ILogicInventorySnapshotDomain;
import com.yunxi.dg.base.center.report.dto.entity.CodeAndNameDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockCountDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockReportDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockTypeDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuRelevantInfoDto;
import com.yunxi.dg.base.center.report.eo.LogicInventorySnapshotEo;
import com.yunxi.dg.base.center.report.eo.PurchaseSaleStockCountEo;
import com.yunxi.dg.base.center.report.eo.PurchaseSaleStockReportEo;
import com.yunxi.dg.base.center.report.service.entity.IPurchaseSaleStockDetailReportService;
import com.yunxi.dg.base.center.report.service.entity.IPurchaseSaleStockReportService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import com.yunxi.dg.base.poi.dto.ExportFileParams;
import com.yunxi.dg.base.poi.dto.ExportSolFileParams;
import com.yunxi.dg.base.poi.service.FileOperationCommonService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PurchaseSaleStockReportServiceImpl
extends BaseServiceImpl<PurchaseSaleStockReportDto, PurchaseSaleStockReportEo, IPurchaseSaleStockReportDomain>
implements IPurchaseSaleStockReportService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSaleStockReportServiceImpl.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ILogicInventorySnapshotDomain logicInventorySnapshotDomain;
    @Resource
    private IDictDomain dictDomain;
    @Resource
    private IPurchaseSaleStockDetailReportDomain purchaseSaleStockDetailReportDomain;
    @Resource
    private IPurchaseSaleStockCountDomain purchaseSaleStockCountDomain;
    @Resource
    private IPurchaseSaleStockDetailReportService purchaseSaleStockDetailReportService;
    @Resource
    private FileOperationCommonService fileOperationCommonService;

    public PurchaseSaleStockReportServiceImpl(IPurchaseSaleStockReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PurchaseSaleStockReportDto, PurchaseSaleStockReportEo> converter() {
        return PurchaseSaleStockReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> this.purchaseSaleStockDetailReportDomain.getMinBusinessDate());
        dto.syncByStep("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868", (startTime, endTime) -> this.doSyncInternal(startTime.toLocalDate()));
    }

    private void doSyncInternal(LocalDate businessDate) {
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e {}", (Object)businessDate);
        ((IPurchaseSaleStockReportDomain)this.domain).physicsDeleteByBusinessDate(businessDate);
        this.purchaseSaleStockCountDomain.physicsDeleteByBusinessDate(businessDate);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        List detailCountList = this.purchaseSaleStockDetailReportDomain.getCountListByBusinessDate(businessDate);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65: {} \u67e5\u8be2\u5230 {} \u6761\u6570\u636e", (Object)businessDate.format(this.formatter), (Object)detailCountList.size());
        if (detailCountList.isEmpty()) {
            return;
        }
        this.purchaseSaleStockDetailReportService.processRelevantInfo(detailCountList);
        Set warehouseCodes = detailCountList.stream().map(PurchaseSaleStockDetailReportDto::getWarehouseCode).collect(Collectors.toSet());
        List snapshots = this.logicInventorySnapshotDomain.queryByWarehouseCodes(businessDate, businessDate.plusDays(1L), warehouseCodes);
        Map<String, LogicInventorySnapshotEo> snapshotMap = snapshots.stream().collect(Collectors.toMap(k -> k.getSkuCode() + "___" + k.getWarehouseCode(), v -> v, (a, b) -> b));
        ArrayList primaryList = new ArrayList();
        ArrayList countList = new ArrayList();
        Map<String, List<PurchaseSaleStockDetailReportDto>> group = detailCountList.stream().collect(Collectors.groupingBy(k -> k.getSkuCode() + "___" + k.getWarehouseCode()));
        group.forEach((k, values) -> {
            PurchaseSaleStockReportEo primary = PurchaseSaleStockReportConverter.INSTANCE.detailDtoToReportEo((PurchaseSaleStockDetailReportDto)values.get(0));
            primary.setId(Long.valueOf(IdGenrator.getDistributedId()));
            AtomicReference<BigDecimal> inTotalQty = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> outTotalQty = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            values.forEach(value -> {
                if ("in".equals(value.getOrderType())) {
                    inTotalQty.updateAndGet(v -> v.add(value.getQuantity()));
                }
                if ("out".equals(value.getOrderType())) {
                    outTotalQty.updateAndGet(v -> v.add(value.getQuantity()));
                }
                PurchaseSaleStockCountEo eo = PurchaseSaleStockCountConverter.INSTANCE.detailDtoToCountEo((PurchaseSaleStockDetailReportDto)value);
                eo.setReportId(primary.getId());
                countList.add(eo);
            });
            primary.setInTotalQty(inTotalQty.get());
            primary.setOutTotalQty(outTotalQty.get());
            LogicInventorySnapshotEo snapshot = (LogicInventorySnapshotEo)snapshotMap.get(primary.getSkuCode() + "___" + primary.getWarehouseCode());
            if (snapshot != null) {
                primary.setOpeningStorageQty(snapshot.getBalance());
                primary.setEndStorageQty(snapshot.getBalance());
            }
            primaryList.add(primary);
        });
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} - {} \u6761\u6570\u636e", (Object)primaryList.size(), (Object)countList.size());
        ((IPurchaseSaleStockReportDomain)this.domain).insertBatch(primaryList);
        this.purchaseSaleStockCountDomain.insertBatch(countList);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} - {} \u6761\u6570\u636e\u5b8c\u6210", (Object)primaryList.size(), (Object)countList.size());
    }

    @Override
    public PageInfo<PurchaseSaleStockReportDto> page(PurchaseSaleStockReportPageReqDto dto) {
        PageInfo<PurchaseSaleStockReportDto> page = this.pageWithoutAlign(dto);
        this.alignTypes(page.getList());
        return page;
    }

    @Override
    public PageInfo<PurchaseSaleStockReportDto> pageWithoutAlign(PurchaseSaleStockReportPageReqDto dto) {
        if (dto.getBusinessDateFrom() == null) {
            dto.setBusinessDateFrom(LocalDate.now().plusDays(-1L).plusMonths(-1L));
            dto.setBusinessDateTo(LocalDate.now().plusDays(-1L));
        }
        PageInfo page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((IPurchaseSaleStockReportDomain)this.domain).queryList(dto));
        HashSet<String> skuCodes = new HashSet<String>();
        HashSet<String> warehouseCodes = new HashSet<String>();
        for (PurchaseSaleStockReportDto r2 : page.getList()) {
            skuCodes.add(r2.getSkuCode());
            warehouseCodes.add(r2.getWarehouseCode());
        }
        dto.setSkuCodes(skuCodes);
        dto.setWarehouseCodes(warehouseCodes);
        List countList = this.purchaseSaleStockCountDomain.queryList(dto);
        Map<String, Map<String, List<PurchaseSaleStockCountDto>>> reportGroup = countList.stream().collect(Collectors.groupingBy(k -> k.getSkuCode() + "___" + k.getWarehouseCode(), Collectors.groupingBy(k -> Optional.ofNullable(k.getOrderType()).orElse(""))));
        String businessDateRange = this.formatter.format(dto.getBusinessDateFrom()) + "-" + this.formatter.format(dto.getBusinessDateTo());
        page.getList().forEach(r -> {
            r.setBusinessDateRange(businessDateRange);
            Map typeGroup = reportGroup.getOrDefault(r.getSkuCode() + "___" + r.getWarehouseCode(), Collections.emptyMap());
            r.setInList(typeGroup.getOrDefault("in", Collections.emptyList()));
            r.setOutList(typeGroup.getOrDefault("out", Collections.emptyList()));
        });
        this.processRelevantInfo(page.getList());
        return page;
    }

    private void processRelevantInfo(List<PurchaseSaleStockReportDto> list) {
        HashSet<String> skuCodes = new HashSet<String>();
        HashSet warehouseCodes = new HashSet();
        list.forEach(r -> {
            skuCodes.add(r.getSkuCode());
            warehouseCodes.add(r.getWarehouseCode());
        });
        Map<String, SkuRelevantInfoDto> skuMap = this.itemSkuDgService.querySkuRelevantInfoMap(skuCodes);
        Map salesCompanyMap = this.logicWarehouseDomain.querySalesCompanyMap(warehouseCodes);
        list.forEach(r -> {
            SkuRelevantInfoDto sku;
            CodeAndNameDto company = (CodeAndNameDto)salesCompanyMap.get(r.getWarehouseCode());
            if (company != null) {
                r.setSalesCompanyCode(company.getCode());
                r.setSalesCompanyName(company.getName());
                r.setWarehouseName(company.getOtherName());
            }
            if ((sku = (SkuRelevantInfoDto)skuMap.get(r.getSkuCode())) != null) {
                r.setSkuName(sku.getSkuName());
                r.setSerialCode(sku.getSerialCode());
                r.setSerialName(sku.getSerialName());
                r.setItemClassCode(sku.getItemClassCode());
                r.setItemClassName(sku.getItemClassName());
                r.setRetailPrice(sku.getFactoryPrice());
                if (sku.getFactoryPrice() != null) {
                    if (r.getOpeningStorageQty() != null) {
                        r.setOpeningStorageAmt(r.getOpeningStorageQty().multiply(sku.getFactoryPrice()));
                    }
                    if (r.getEndStorageQty() != null) {
                        r.setEndStorageAmt(r.getEndStorageQty().multiply(sku.getFactoryPrice()));
                    }
                }
            }
        });
    }

    @Override
    public void alignTypes(List<PurchaseSaleStockReportDto> list) {
        List<PurchaseSaleStockTypeDto> typeList = this.getPurchaseSaleStockTypeList();
        Map<String, List<PurchaseSaleStockTypeDto>> group = typeList.stream().collect(Collectors.groupingBy(PurchaseSaleStockTypeDto::getOrderType));
        list.forEach(report -> {
            List<PurchaseSaleStockCountDto> inList = this.alignTypes((PurchaseSaleStockReportDto)report, group, report.getInList(), "in");
            List<PurchaseSaleStockCountDto> outList = this.alignTypes((PurchaseSaleStockReportDto)report, group, report.getOutList(), "out");
            report.setInList(inList);
            report.setOutList(outList);
        });
    }

    private List<PurchaseSaleStockCountDto> alignTypes(PurchaseSaleStockReportDto report, Map<String, List<PurchaseSaleStockTypeDto>> group, List<PurchaseSaleStockCountDto> inList, String key) {
        List ws = Optional.ofNullable(inList).orElse(Collections.emptyList());
        List values = group.getOrDefault(key, new ArrayList(0));
        Map<String, PurchaseSaleStockCountDto> map = ws.stream().collect(Collectors.groupingBy(k -> k.getType() == null ? "" : k.getType(), Collectors.collectingAndThen(Collectors.toList(), list -> {
            PurchaseSaleStockCountDto w = (PurchaseSaleStockCountDto)list.get(0);
            BigDecimal quantity = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            for (PurchaseSaleStockCountDto d : list) {
                quantity = quantity.add(Optional.ofNullable(d.getQuantity()).orElse(BigDecimal.ZERO));
                amount = amount.add(Optional.ofNullable(d.getAmount()).orElse(BigDecimal.ZERO));
            }
            w.setQuantity(quantity);
            w.setAmount(amount);
            return w;
        })));
        return values.stream().map(k -> {
            PurchaseSaleStockCountDto w = (PurchaseSaleStockCountDto)map.get(k.getCode());
            if (w != null) {
                w.setTypeName(k.getName());
                return w;
            }
            w = new PurchaseSaleStockCountDto();
            w.setReportId(report.getId());
            w.setSkuCode(report.getSkuCode());
            w.setSkuName(report.getSkuName());
            w.setWarehouseCode(report.getWarehouseCode());
            w.setWarehouseName(report.getWarehouseName());
            w.setOrderType(key);
            w.setType(k.getCode());
            w.setTypeName(k.getName());
            w.setQuantity(BigDecimal.ZERO);
            w.setRetailPrice(report.getRetailPrice());
            w.setAmount(BigDecimal.ZERO);
            return w;
        }).collect(Collectors.toList());
    }

    @Override
    public LocalDate getLastBusinessDate() {
        return ((IPurchaseSaleStockReportDomain)this.domain).getLastBusinessDate();
    }

    @Override
    public List<PurchaseSaleStockTypeDto> getPurchaseSaleStockTypeList() {
        List values = this.dictDomain.queryValues("yunxi-dg-base-center-report", "purchase_sale_stock_type");
        return values.stream().map(value -> {
            PurchaseSaleStockTypeDto type = PurchaseSaleStockTypeDto.builder().code(value.getValue()).name(value.getLabel()).businessTypes(new ArrayList(0)).build();
            if (!StringUtils.hasText((String)value.getExtension())) {
                return type;
            }
            try {
                type = (PurchaseSaleStockTypeDto)JacksonUtil.readValue((String)value.getExtension(), PurchaseSaleStockTypeDto.class);
                type.setCode(value.getValue());
                type.setName(value.getLabel());
                return type;
            }
            catch (Exception e) {
                log.warn("\u89e3\u6790JSON\u5931\u8d25\uff1a{}", (Object)JacksonUtil.toJson((Object)value), (Object)e);
                return type;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void export(PurchaseSaleStockReportPageReqDto dto) {
        ExportSolFileParams params = new ExportSolFileParams();
        params.setKey("purchase_sale_stock_report");
        params.setFilter(JSONUtil.toJsonStr((Object)dto));
        params.setMenuModuleName("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868");
        params.setExportFunctionName("\u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u5bfc\u51fa");
        this.fileOperationCommonService.exportFileOperationCommonAsync((ExportFileParams)params);
    }
}

