/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.domain.customer.IDgEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgREnterpriseOrganizationDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsEnterpriseInventoryOrgRelationOrgRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsEnterpriseInventoryOrgRelationPageRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsEnterpriseInventoryOrgRelationQueryReqDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsEnterpriseRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.eo.customer.DgEnterpriseEo;
import com.yunxi.dg.base.center.report.eo.customer.DgREnterpriseOrganizationEo;
import com.yunxi.dg.base.center.report.eo.user.OrganizationEo;
import com.yunxi.dg.base.center.report.service.customer.IDgEnterpriseOrgRelationService;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgEnterpriseOrgRelationServiceImpl
implements IDgEnterpriseOrgRelationService {
    @Resource
    private IDgREnterpriseOrganizationDomain iDgREnterpriseOrganizationDomain;
    @Resource
    private IUsOrganizationDomain iUsOrganizationDomain;
    @Resource
    private IDgEnterpriseDomain iDgEnterpriseDomain;

    @Override
    public PageInfo<CsEnterpriseInventoryOrgRelationPageRespDto> queryInventoryRelationPage(CsEnterpriseInventoryOrgRelationQueryReqDto reqDto) {
        Map<Object, Object> orgMap;
        PageInfo resPageInfo;
        List enterprise;
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInventoryOrgCodeList()) || StringUtils.isNotBlank((CharSequence)reqDto.getInventoryOrgCode()) || StringUtils.isNotBlank((CharSequence)reqDto.getInventoryOrgName())) {
            CsOrganizationPageQueryDto orgReqDto = new CsOrganizationPageQueryDto();
            orgReqDto.setCode(reqDto.getInventoryOrgCode());
            orgReqDto.setCodeList(reqDto.getInventoryOrgCodeList());
            orgReqDto.setIdList(reqDto.getInventoryOrgIdList());
            orgReqDto.setName(reqDto.getInventoryOrgName());
            List csOrganizationPageRespDtos = this.iUsOrganizationDomain.queryList(orgReqDto);
            if (CollectionUtils.isNotEmpty((Collection)csOrganizationPageRespDtos)) {
                reqDto.setInventoryOrgIdList(csOrganizationPageRespDtos.stream().map(CsOrganizationPageRespDto::getId).collect(Collectors.toList()));
            } else {
                return DgEnterpriseOrgRelationServiceImpl.emptyPageInfo(reqDto.getPageSize(), reqDto.getPageNum());
            }
        }
        if (reqDto.getRootOrganizationId() != null && StrUtil.isNotBlank((CharSequence)RequestUtil.getHeader("Root-Organization-Id"))) {
            String rootOrgId = RequestUtil.getHeader("Root-Organization-Id");
            reqDto.setRootOrganizationId(Long.valueOf(rootOrgId));
        }
        if (CollectionUtils.isEmpty((Collection)(enterprise = (resPageInfo = this.iDgREnterpriseOrganizationDomain.queryEnterpriseInfoByPage(reqDto)).getList()))) {
            return DgEnterpriseOrgRelationServiceImpl.emptyPageInfo(reqDto.getPageSize(), reqDto.getPageNum());
        }
        List enterpriseIds = enterprise.stream().map(CsEnterpriseInventoryOrgRelationPageRespDto::getEnterpriseId).collect(Collectors.toList());
        List dgREnterpriseOrganizationEos = this.iDgREnterpriseOrganizationDomain.listRelationByEnterpriseIds(enterpriseIds, Integer.valueOf(2));
        Map<Long, List<DgREnterpriseOrganizationEo>> enterpriseIdRelationMap = dgREnterpriseOrganizationEos.stream().collect(Collectors.groupingBy(DgREnterpriseOrganizationEo::getEnterpriseId));
        List orgIds = dgREnterpriseOrganizationEos.stream().map(DgREnterpriseOrganizationEo::getOrganizationId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)) {
            CsOrganizationPageQueryDto orgReqDto = new CsOrganizationPageQueryDto();
            orgReqDto.setIdList(reqDto.getInventoryOrgIdList());
            List orgEos = this.iUsOrganizationDomain.queryList(orgReqDto);
            orgMap = orgEos.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getId, Function.identity(), (a, b) -> a));
        } else {
            orgMap = Maps.newHashMap();
        }
        enterprise.forEach(dto -> {
            List relationEos = (List)enterpriseIdRelationMap.get(dto.getEnterpriseId());
            if (CollectionUtils.isNotEmpty((Collection)relationEos)) {
                DgREnterpriseOrganizationEo sampleEo = (DgREnterpriseOrganizationEo)relationEos.get(0);
                dto.setRemark(sampleEo.getRemark());
                dto.setCreatePerson(sampleEo.getCreatePerson());
                dto.setUpdatePerson(sampleEo.getUpdatePerson());
                dto.setCreateTime(sampleEo.getCreateTime());
                dto.setUpdateTime(sampleEo.getUpdateTime());
                ArrayList orgList = new ArrayList();
                dto.setOrgList(orgList);
                relationEos.forEach(relationEo -> {
                    CsEnterpriseInventoryOrgRelationOrgRespDto orgDto = new CsEnterpriseInventoryOrgRelationOrgRespDto();
                    orgList.add(orgDto);
                    orgDto.setOrgId(relationEo.getOrganizationId());
                    orgDto.setIsDefault(relationEo.getIsDefault());
                    CsOrganizationPageRespDto csOrganizationPageRespDto = (CsOrganizationPageRespDto)orgMap.get(relationEo.getOrganizationId());
                    if (csOrganizationPageRespDto != null) {
                        orgDto.setOrgCode(csOrganizationPageRespDto.getCode());
                        orgDto.setOrgName(csOrganizationPageRespDto.getName());
                    }
                });
                dto.setOrgCodeStr(orgList.stream().map(CsEnterpriseInventoryOrgRelationOrgRespDto::getOrgCode).filter(StringUtils::isNotBlank).collect(Collectors.joining(",")));
                dto.setOrgNameStr(orgList.stream().map(CsEnterpriseInventoryOrgRelationOrgRespDto::getOrgName).filter(StringUtils::isNotBlank).collect(Collectors.joining(",")));
            }
        });
        List list = resPageInfo.getList();
        return resPageInfo;
    }

    @Override
    public List<CsEnterpriseRespDto> querySaleCompanyBySaleOrgId(List<Long> saleOrgIdList, Long rootOrganizationId) {
        if (Objects.isNull(rootOrganizationId)) {
            return new ArrayList<CsEnterpriseRespDto>();
        }
        ArrayList parentOrgIdList = new ArrayList();
        if (CollectionUtils.isNotEmpty(saleOrgIdList)) {
            parentOrgIdList.addAll(((List)Optional.ofNullable(this.iUsOrganizationDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(OrganizationEo.class).in(OrganizationEo::getId, saleOrgIdList))).orElse(new ArrayList())).stream().map(OrganizationEo::getParentId).collect(Collectors.toList()));
        }
        List enterpriseEoList = Optional.ofNullable(this.iDgEnterpriseDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgEnterpriseEo.class).in(CollectionUtils.isNotEmpty(parentOrgIdList), DgEnterpriseEo::getOrganizationId, parentOrgIdList)).eq(DgEnterpriseEo::getRootOrganizationId, (Object)rootOrganizationId))).orElse(new ArrayList());
        List orgIds = enterpriseEoList.stream().map(DgEnterpriseEo::getOrganizationId).collect(Collectors.toList());
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            map.putAll(((List)Optional.ofNullable(this.iUsOrganizationDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(OrganizationEo.class).in(OrganizationEo::getId, orgIds))).orElse(new ArrayList())).stream().collect(Collectors.toMap(OrganizationEo::getId, Function.identity(), (o1, o2) -> o1)));
        }
        return enterpriseEoList.stream().map(o -> {
            CsEnterpriseRespDto respDto = (CsEnterpriseRespDto)BeanUtil.toBean((Object)o, CsEnterpriseRespDto.class);
            OrganizationEo organizationEo = (OrganizationEo)map.get(o.getOrganizationId());
            respDto.setOrganizationId(o.getOrganizationId());
            respDto.setOrganizationCode(Objects.isNull(organizationEo) ? null : organizationEo.getCode());
            respDto.setOrganizationName(Objects.isNull(organizationEo) ? null : organizationEo.getName());
            respDto.setEnterpriseId(o.getId());
            respDto.setEnterpriseCode(o.getCode());
            respDto.setEnterpriseName(o.getName());
            return respDto;
        }).collect(Collectors.toList());
    }

    private static <T> PageInfo<T> emptyPageInfo(Integer pageSize, Integer pageNum) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(0L);
        pageInfo.setPages(0);
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPageNum(pageNum.intValue());
        return pageInfo;
    }
}

