/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgInspectionPassConverter;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgInspectionPassDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassRecordDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionRecordDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgReleaseAssociatedDocumentPageReqDto;
import com.yunxi.dg.base.center.report.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgInspectionPassEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.DgOutNoticeOrderServiceImpl;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgInspectionPassService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.enums.InventoryInOutEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgInspectionPassServiceImpl
extends BaseServiceImpl<DgInspectionPassDto, DgInspectionPassEo, IDgInspectionPassDomain>
implements IDgInspectionPassService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgInspectionPassServiceImpl.class);
    String inspectionPassTableName = "inspection_pass";
    String inspectionPassRecordTableName = "inspection_pass_record";
    private static final String[] ORDER_NOS = new String[]{"inspectionNo", "relevanceNo", "erpOrderNo", "inspectionPassRecordNo"};
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private DgOutNoticeOrderServiceImpl dgOutNoticeOrderService;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Autowired
    protected IOpenSearchService openSearchService;

    public DgInspectionPassServiceImpl(IDgInspectionPassDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgInspectionPassDto, DgInspectionPassEo> converter() {
        return DgInspectionPassConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgInspectionPassDto>> queryPage(DgInspectionPassPageReqDto dto) {
        if (CollectionUtil.isNotEmpty((Collection)dto.getMoreThan7DaysList()) && dto.getMoreThan7DaysList().size() == 2) {
            dto.setMoreThan7DaysList(null);
        }
        PageInfo inspectionPassDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            if (dto.getTypeStatus() == 1) {
                dto.setPassStatus("wait_pass");
                dto.setWaitQuantity("0.0000000001");
            } else if (dto.getTypeStatus() == 2) {
                dto.setPassStatus("wait_pass");
                dto.setAuditQuantity("0.0000000001");
            } else if (dto.getTypeStatus() == 3) {
                dto.setPassStatus("wait_pass");
                dto.setExecutionQuantity("0.0000000001");
            } else if (dto.getTypeStatus() == 4) {
                dto.setPassStatus("part_pass");
            } else if (dto.getTypeStatus() == 5) {
                dto.setPassStatus("pass");
            } else if (dto.getTypeStatus() == 6) {
                dto.setPassStatus("disqualification");
            } else if (dto.getTypeStatus() == 7) {
                dto.setPassStatus("exemption");
            }
            inspectionPassDtoPageInfo = this.getDgInspectionPassDtoPageEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            inspectionPassDtoPageInfo = new PageInfo(((IDgInspectionPassDomain)this.domain).queryList(dto));
        }
        if (CollectionUtil.isEmpty((Collection)inspectionPassDtoPageInfo.getList())) {
            return new RestResponse((Object)new PageInfo());
        }
        List dgInspectionPassDtos = inspectionPassDtoPageInfo.getList();
        long now = System.currentTimeMillis();
        dgInspectionPassDtos.forEach(o -> {
            long firstInTime = o.getFirstInTime().getTime();
            if (now - firstInTime > 604800000L) {
                o.setMoreThan7Days(YesNoEnum.YES.getValue());
            } else {
                o.setMoreThan7Days(YesNoEnum.NO.getValue());
            }
        });
        this.setOrderType(dgInspectionPassDtos);
        List relevanceNoList = dgInspectionPassDtos.stream().map(DgInspectionPassDto::getRelevanceNo).collect(Collectors.toList());
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(relevanceNoList), (Object)"document_code", relevanceNoList)).list();
        Map unitConversionRecordMap = unitConversionRecordEos.stream().collect(Collectors.toMap(r -> r.getDocumentCode() + r.getSkuCode() + r.getUnit(), Function.identity(), (o1, o2) -> o1));
        dgInspectionPassDtos.forEach(o -> {
            if (unitConversionRecordMap.containsKey(o.getRelevanceNo() + o.getSkuCode() + o.getUnit())) {
                OrderUnitConversionRecordEo unitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionRecordMap.get(o.getRelevanceNo() + o.getSkuCode() + o.getUnit());
                o.setUnit(unitConversionRecordEo.getToUnit());
            }
        });
        return new RestResponse((Object)inspectionPassDtoPageInfo);
    }

    private PageInfo<DgInspectionPassDto> getDgInspectionPassDtoPageEsList(DgInspectionPassPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inspectionPassTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgInspectionPassDtoList = searchResultVo.getDocValues(docValue -> {
                DgInspectionPassDto dgInspectionPassDto = (DgInspectionPassDto)BeanUtil.copyProperties((Object)docValue, DgInspectionPassDto.class, (String[])new String[0]);
                return dgInspectionPassDto;
            });
            pageInfo.setList(dgInspectionPassDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgInspectionPassPageReqDto dto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u67e5\u8d28\u68c0\u653e\u884c\u8bb0\u5f55\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)dto);
        if (Objects.nonNull(dto.getPassStatus())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"passStatus", (String)dto.getPassStatus(), (LogicalSymbol)LogicalSymbol.AND)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getWaitQuantity())) {
            queryVo.addRangeFilter("waitQuantity", dto.getWaitQuantity(), "9223372036854775807");
        }
        if (Objects.nonNull(dto.getAuditQuantity())) {
            queryVo.addRangeFilter("auditQuantity", dto.getAuditQuantity(), "9223372036854775807");
        }
        if (Objects.nonNull(dto.getExecutionQuantity())) {
            queryVo.addRangeFilter("executionQuantity", dto.getExecutionQuantity(), "9223372036854775807");
        }
        if (Objects.nonNull(dto.getInspectionNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)orderNo, (String)dto.getInspectionNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getInspectionNoList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)orderNo, (List)dto.getInspectionNoList(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getMoreThan7DaysList())) {
            String toValue;
            String fromValue;
            if (dto.getMoreThan7DaysList().get(0) == YesNoEnum.YES.getValue()) {
                fromValue = "0";
                toValue = System.currentTimeMillis() - 604800000L + "";
                queryVo.addRangeFilter("firstInTime", fromValue, toValue);
            } else {
                fromValue = System.currentTimeMillis() - 604800000L + "";
                toValue = DateUtil.parseDate((String)"9999-12-31 23:59:59", (String)"yyyy-MM-dd HH:mm:ss").getTime() + "";
                queryVo.addRangeFilter("firstInTime", fromValue, toValue);
            }
        }
        return queryVo;
    }

    public void setOrderType(List<DgInspectionPassDto> dgInspectionPassDtos) {
        List relevanceNoList = dgInspectionPassDtos.stream().map(DgInspectionPassDto::getRelevanceNo).collect(Collectors.toList());
        DgOutNoticeOrderPageReqDto outNoticeOrderPageReqDto = new DgOutNoticeOrderPageReqDto();
        outNoticeOrderPageReqDto.setOrderType(InventoryInOutEnum.IN.getCode());
        outNoticeOrderPageReqDto.setRelevanceNoList(relevanceNoList);
        List outNoticeOrderDtos = Optional.ofNullable(this.dgOutNoticeOrderService.queryList(outNoticeOrderPageReqDto).getData()).orElse(new ArrayList());
        Map noticeOrderDtoMap = outNoticeOrderDtos.stream().collect(Collectors.toMap(DgOutNoticeOrderDto::getRelevanceNo, Function.identity(), (o1, o2) -> o1));
        dgInspectionPassDtos.forEach(o -> {
            if (noticeOrderDtoMap.containsKey(o.getRelevanceNo())) {
                DgOutNoticeOrderDto dgOutNoticeOrderDto = (DgOutNoticeOrderDto)noticeOrderDtoMap.get(o.getRelevanceNo());
                o.setOrderType(dgOutNoticeOrderDto.getJumpDocumentType());
            }
        });
    }

    @Override
    public RestResponse<List<DgInspectionPassDto>> queryList(DgInspectionPassPageReqDto dto) {
        List dgInspectionPassDtos;
        if (CollectionUtil.isNotEmpty((Collection)dto.getMoreThan7DaysList()) && dto.getMoreThan7DaysList().size() == 2) {
            dto.setMoreThan7DaysList(null);
        }
        if (CollectionUtil.isEmpty((Collection)(dgInspectionPassDtos = ((IDgInspectionPassDomain)this.domain).queryList(dto)))) {
            return new RestResponse();
        }
        long now = System.currentTimeMillis();
        dgInspectionPassDtos.forEach(o -> {
            long firstInTime = o.getFirstInTime().getTime();
            if (now - firstInTime > 604800000L) {
                o.setMoreThan7Days(YesNoEnum.YES.getValue());
            } else {
                o.setMoreThan7Days(YesNoEnum.NO.getValue());
            }
        });
        this.setOrderType(dgInspectionPassDtos);
        List relevanceNoList = dgInspectionPassDtos.stream().map(DgInspectionPassDto::getRelevanceNo).collect(Collectors.toList());
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(relevanceNoList), (Object)"document_code", relevanceNoList)).list();
        Map unitConversionRecordMap = unitConversionRecordEos.stream().collect(Collectors.toMap(r -> r.getDocumentCode() + r.getSkuCode() + r.getUnit(), Function.identity(), (o1, o2) -> o1));
        dgInspectionPassDtos.forEach(o -> {
            if (unitConversionRecordMap.containsKey(o.getRelevanceNo() + o.getSkuCode() + o.getUnit())) {
                OrderUnitConversionRecordEo unitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionRecordMap.get(o.getRelevanceNo() + o.getSkuCode() + o.getUnit());
                o.setUnit(unitConversionRecordEo.getToUnit());
            }
        });
        return new RestResponse((Object)dgInspectionPassDtos);
    }

    @Override
    public RestResponse<PageInfo<DgInspectionRecordDto>> releaseAssociatedDocuments(DgReleaseAssociatedDocumentPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)dto.getInspectionNoList()), (String)"\u8d28\u68c0\u8bb0\u5f55\u7f16\u53f7\u4e3a\u7a7a!");
        List dgInspectionRecordDtos = ((IDgInspectionPassDomain)this.domain).releaseAssociatedDocuments(dto);
        List relevanceNoList = dgInspectionRecordDtos.stream().map(DgInspectionRecordDto::getRelevanceNo).distinct().collect(Collectors.toList());
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(relevanceNoList), (Object)"document_code", relevanceNoList)).list();
        Map unitConversionMap = unitConversionRecordEos.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getUnit(), Function.identity(), (o1, o2) -> o1));
        dgInspectionRecordDtos.forEach(o -> {
            if (unitConversionMap.containsKey(o.getRelevanceNo() + o.getSkuCode() + o.getUnit())) {
                OrderUnitConversionRecordEo unitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionMap.get(o.getRelevanceNo() + o.getSkuCode() + o.getUnit());
                if (o.getUnit().equals(unitConversionRecordEo.getToUnit())) {
                    o.setBasicUnit(o.getUnit());
                    o.setBasicQuantity(o.getQuantity());
                } else {
                    this.unitConversion((DgInspectionRecordDto)o, unitConversionRecordEo);
                }
            }
        });
        return new RestResponse((Object)new PageInfo(dgInspectionRecordDtos));
    }

    @Override
    public RestResponse<PageInfo<DgInspectionPassRecordDto>> queryInspectionPassRecord(DgInspectionPassRecordPageReqDto dto) {
        PageInfo inspectionPassRecordDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            if (dto.getTypeStatus() == 1) {
                dto.setPassStatus("wait_audit");
            } else if (dto.getTypeStatus() == 2) {
                dto.setPassStatus("passing");
            } else if (dto.getTypeStatus() == 3) {
                dto.setPassStatus("pass_success");
            } else if (dto.getTypeStatus() == 4) {
                dto.setPassStatus("pass_fail");
            }
            inspectionPassRecordDtoPageInfo = this.getInspectionPassRecordEsList(dto);
        } else {
            if (CollectionUtil.isNotEmpty((Collection)dto.getOrderTypeList())) {
                dto.setOrderType((String)dto.getOrderTypeList().get(0));
            }
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            inspectionPassRecordDtoPageInfo = new PageInfo(((IDgInspectionPassDomain)this.domain).queryInspectionPassRecord(dto));
        }
        return new RestResponse(inspectionPassRecordDtoPageInfo);
    }

    private PageInfo<DgInspectionPassRecordDto> getInspectionPassRecordEsList(DgInspectionPassRecordPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inspectionPassRecordTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initPassRecordSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List inspectionPassRecordDtoList = searchResultVo.getDocValues(docValue -> {
                DgInspectionPassRecordDto inspectionPassRecordDto = (DgInspectionPassRecordDto)BeanUtil.copyProperties((Object)docValue, DgInspectionPassRecordDto.class, (String[])new String[0]);
                return inspectionPassRecordDto;
            });
            pageInfo.setList(inspectionPassRecordDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initPassRecordSearchVo(DgInspectionPassRecordPageReqDto dto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u67e5\u8be2\u653e\u884c\u8bb0\u5f55\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)dto);
        if (Objects.nonNull(dto.getPassStatus())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"passStatus", (String)dto.getPassStatus())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getDocumentNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)orderNo, (String)dto.getDocumentNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        return queryVo;
    }

    private void unitConversion(DgInspectionRecordDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        dto.setBasicUnit(unitConversionEo.getToUnit());
        BigDecimal rate = unitConversionEo.getToNum().divide(unitConversionEo.getNum(), 6, RoundingMode.HALF_UP);
        BigDecimal quantity = null != dto.getQuantity() ? dto.getQuantity().multiply(rate) : null;
        dto.setBasicQuantity(quantity);
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

