/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgInspectionRecordConverter;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgInspectionRecordDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionRecordDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionRecordPageReqDto;
import com.yunxi.dg.base.center.report.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgInspectionRecordEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgInspectionRecordService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgInspectionRecordServiceImpl
extends BaseServiceImpl<DgInspectionRecordDto, DgInspectionRecordEo, IDgInspectionRecordDomain>
implements IDgInspectionRecordService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgInspectionRecordServiceImpl.class);
    String tableName = "unqualified_batch_order";
    private static final String[] ORDER_NOS = new String[]{"outDocumentNo", "orderNo"};
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Autowired
    protected IOpenSearchService openSearchService;

    public DgInspectionRecordServiceImpl(IDgInspectionRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgInspectionRecordDto, DgInspectionRecordEo> converter() {
        return DgInspectionRecordConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgInspectionRecordDto>> queryPage(DgInspectionRecordPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List dgInspectionRecordDtos = ((IDgInspectionRecordDomain)this.domain).queryList(dto);
        return new RestResponse((Object)new PageInfo(dgInspectionRecordDtos));
    }

    @Override
    public RestResponse<List<DgInspectionRecordDto>> queryList(DgInspectionRecordPageReqDto dto) {
        return new RestResponse((Object)((IDgInspectionRecordDomain)this.domain).queryList(dto));
    }

    @Override
    public RestResponse<PageInfo<DgInspectionPassDto>> queryUnqualifiedBatchOrder(DgInspectionPassPageReqDto dto) {
        PageInfo unqualifiedBatchOrderPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            unqualifiedBatchOrderPageInfo = this.getUnqualifiedBatchOrderEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            unqualifiedBatchOrderPageInfo = new PageInfo(((IDgInspectionRecordDomain)this.domain).queryUnqualifiedBatchOrder(dto));
        }
        List dgInspectionPassDtos = unqualifiedBatchOrderPageInfo.getList();
        if (CollectionUtil.isEmpty((Collection)dgInspectionPassDtos)) {
            return new RestResponse((Object)new PageInfo());
        }
        List orderNoList = dgInspectionPassDtos.stream().map(DgInspectionPassDto::getOrderNo).collect(Collectors.toList());
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(orderNoList), (Object)"document_code", orderNoList)).list();
        Map unitConversionMap = unitConversionRecordEos.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getToUnit(), Function.identity(), (o2, o1) -> o2));
        dgInspectionPassDtos.forEach(o -> {
            if (unitConversionMap.containsKey(o.getOrderNo() + o.getSkuCode() + o.getUnit())) {
                OrderUnitConversionRecordEo unitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionMap.get(o.getOrderNo() + o.getSkuCode() + o.getUnit());
                this.unitConversion((DgInspectionPassDto)o, unitConversionRecordEo);
            }
        });
        return new RestResponse((Object)new PageInfo(dgInspectionPassDtos));
    }

    private PageInfo<DgInspectionPassDto> getUnqualifiedBatchOrderEsList(DgInspectionPassPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List unqualifiedBatchOrderList = searchResultVo.getDocValues(docValue -> {
                DgInspectionPassDto unqualifiedBatchOrder = (DgInspectionPassDto)BeanUtil.copyProperties((Object)docValue, DgInspectionPassDto.class, (String[])new String[0]);
                return unqualifiedBatchOrder;
            });
            pageInfo.setList(unqualifiedBatchOrderList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgInspectionPassPageReqDto dto) throws Exception {
        log.info("ES\u67e5\u8be2\u4e0d\u5408\u683c\u6279\u6b21\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)dto);
        if (Objects.nonNull(dto.getInspectionNo())) {
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)orderNo, (String)dto.getInspectionNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        return queryVo;
    }

    private void unitConversion(DgInspectionPassDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        dto.setUnit(unitConversionEo.getUnit());
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal quantity = null != dto.getQuantity() ? dto.getQuantity().multiply(rate) : null;
        dto.setQuantity(quantity);
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

