/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgOutNoticeOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.dto.entity.OutNoticeOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutNoticeOrderEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgOutNoticeOrderService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgOutNoticeOrderServiceImpl
extends BaseServiceImpl<DgOutNoticeOrderDto, DgOutNoticeOrderEo, IDgOutNoticeOrderDomain>
implements IDgOutNoticeOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgOutNoticeOrderServiceImpl.class);
    String tableName = "cs_out_notice_order";
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;

    public DgOutNoticeOrderServiceImpl(IDgOutNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOutNoticeOrderDto, DgOutNoticeOrderEo> converter() {
        return DgOutNoticeOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgOutNoticeOrderDto>> queryList(DgOutNoticeOrderPageReqDto dto) {
        return new RestResponse((Object)((IDgOutNoticeOrderDomain)this.domain).queryList(dto));
    }

    @Override
    public RestResponse<PageInfo<DgOutNoticeOrderDto>> queryPage(DgOutNoticeOrderPageReqDto dto) {
        PageInfo dgOutNoticeOrderDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            dgOutNoticeOrderDtoPageInfo = this.getOutNoticeOrderEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            List relevanceNoList = dto.getRelevanceNoList();
            if (CollectionUtils.isNotEmpty((Collection)relevanceNoList)) {
                relevanceNoList.add(StringUtils.join((Iterable)relevanceNoList, (String)","));
                dto.setRelevanceNoList(relevanceNoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(dgOutNoticeOrderDtoPageInfo = new PageInfo(((IDgOutNoticeOrderDomain)this.domain).queryList(dto))).getList())) {
                this.setExtension(dgOutNoticeOrderDtoPageInfo.getList());
            }
        }
        return new RestResponse(dgOutNoticeOrderDtoPageInfo);
    }

    private void setExtension(List<DgOutNoticeOrderDto> list) {
        List ids = list.stream().map(p -> p.getId()).collect(Collectors.toList());
        List eoList = ((ExtQueryChainWrapper)((IDgOutNoticeOrderDomain)this.domain).filter().select(new String[]{"id", "extension"}).in((Object)"id", ids)).list();
        Map<Long, String> extensionMap = this.getExtensionMap(eoList);
        for (DgOutNoticeOrderDto noticeOrderDto : list) {
            String extension = extensionMap.get(noticeOrderDto.getId());
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                noticeOrderDto.setExtension(extension);
                JSONObject jsonObject = JSONObject.parseObject((String)extension);
                if (Objects.nonNull(jsonObject)) {
                    noticeOrderDto.setCarrierName(jsonObject.getString("carrierName"));
                    noticeOrderDto.setCustomerName(jsonObject.getString("customerName"));
                    noticeOrderDto.setReceiveAddress(jsonObject.getString("receiveAddress"));
                }
            }
            if (!StrUtil.isEmpty((CharSequence)noticeOrderDto.getWmsOrderNo())) continue;
            noticeOrderDto.setWmsOrderNo(noticeOrderDto.getWmsReturnId());
        }
    }

    private Map<Long, String> getExtensionMap(List<DgOutNoticeOrderEo> eoList) {
        if (CollectionUtils.isEmpty(eoList)) {
            return Maps.newHashMap();
        }
        return eoList.stream().collect(Collectors.toMap(BaseEo::getId, CubeBaseEo::getExtension, (k1, k2) -> k2));
    }

    @Override
    public RestResponse<DgOutNoticeOrderDto> queryByDocumentNo(String documentNo) {
        DgOutNoticeOrderDto dgOutNoticeOrderDto = ((IDgOutNoticeOrderDomain)this.domain).queryDocumentNoDetail(documentNo);
        List dgAfterSaleOrderLogisticsWarehouseEos = ((ExtQueryChainWrapper)this.dgAfterSaleOrderLogisticsWarehouseDomain.filter().eq((Object)"after_sale_order_no", (Object)dgOutNoticeOrderDto.getRelevanceNo())).list();
        if (CollectionUtils.isNotEmpty((Collection)dgAfterSaleOrderLogisticsWarehouseEos)) {
            DgAfterSaleOrderLogisticsWarehouseEo dgAfterSaleOrderLogisticsWarehouseEo = (DgAfterSaleOrderLogisticsWarehouseEo)dgAfterSaleOrderLogisticsWarehouseEos.get(0);
            dgOutNoticeOrderDto.setReturnShippingCode(dgAfterSaleOrderLogisticsWarehouseEo.getShippingCode());
            dgOutNoticeOrderDto.setReturnShippingName(dgAfterSaleOrderLogisticsWarehouseEo.getShippingName());
            dgOutNoticeOrderDto.setReturnShippingSn(dgAfterSaleOrderLogisticsWarehouseEo.getReturnShippingSn());
        }
        return new RestResponse((Object)dgOutNoticeOrderDto);
    }

    @Override
    public RestResponse<List<OutNoticeOrderDetailDto>> queryDetailList(DgOutNoticeOrderPageReqDto dto) {
        return new RestResponse((Object)((IDgOutNoticeOrderDomain)this.domain).queryDetailList(dto));
    }

    @Override
    public RestResponse<DgOutNoticeOrderDto> queryByRelevanceNo(String relevanceNo) {
        DgOutNoticeOrderEo outNoticeOrderEo = (DgOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgOutNoticeOrderDomain)this.domain).filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)"out")).last(" limit 1")).one();
        DgOutNoticeOrderDto dgOutNoticeOrderDto = new DgOutNoticeOrderDto();
        CubeBeanUtils.copyProperties((Object)dgOutNoticeOrderDto, (Object)outNoticeOrderEo, (String[])new String[0]);
        return new RestResponse((Object)dgOutNoticeOrderDto);
    }

    private PageInfo<DgOutNoticeOrderDto> getOutNoticeOrderEsList(DgOutNoticeOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgOutNoticeOrderDto orderItemPageDto = (DgOutNoticeOrderDto)BeanUtil.copyProperties((Object)docValue, DgOutNoticeOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgOutNoticeOrderPageReqDto reqDto) throws Exception {
        log.info("ES\u51fa\u5165\u5e93\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u51fa\u5165\u5e93\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

