/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.constants.DgWarehouseClassifyEnum;
import com.yunxi.dg.base.center.report.convert.entity.DgPhysicsInventoryConverter;
import com.yunxi.dg.base.center.report.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.report.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgPhysicsInventoryDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsAvailableInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsInventoryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.RelInventoryBatchTagDto;
import com.yunxi.dg.base.center.report.dto.item.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgPhysicsInventoryEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicInventoryService;
import com.yunxi.dg.base.center.report.service.inventory.IDgPhysicsInventoryService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DgPhysicsInventoryServiceImpl
extends BaseServiceImpl<DgPhysicsInventoryDto, DgPhysicsInventoryEo, IDgPhysicsInventoryDomain>
implements IDgPhysicsInventoryService {
    @Resource
    private IDgPhysicsInventoryDomain dgPhysicsInventoryDomain;
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IDgLogicInventoryService logicInventoryService;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;

    public DgPhysicsInventoryServiceImpl(IDgPhysicsInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPhysicsInventoryDto, DgPhysicsInventoryEo> converter() {
        return DgPhysicsInventoryConverter.INSTANCE;
    }

    @Override
    public PageInfo<DgPhysicsInventoryDto> queryByPage(DgPhysicsInventoryPageReqDto filter) {
        List dgPhysicsInventoryDtos;
        if (StringUtils.isNotEmpty((CharSequence)filter.getSpecModel())) {
            ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
            itemDgReqDto.setSpecModel(filter.getSpecModel());
            List skuItemList = this.itemSkuDgDomain.queryList(itemDgReqDto);
            if (CollectionUtils.isEmpty((Collection)skuItemList)) {
                return new PageInfo();
            }
            List<String> querySkuCodes = Optional.ofNullable(skuItemList.stream().map(DgItemSkuRespVo::getSkuCode).collect(Collectors.toList())).orElse(Arrays.asList(new String[0]));
            if (CollectionUtils.isEmpty((Collection)filter.getSkuCodeList())) {
                filter.setSkuCodeList(querySkuCodes);
            } else {
                List queryList = filter.getSkuCodeList();
                queryList.addAll(querySkuCodes);
                filter.setSkuCodeList(queryList);
            }
        }
        PageHelper.startPage((int)filter.getPageNum(), (int)filter.getPageSize());
        if (Objects.equals(filter.getBatchType(), Boolean.FALSE)) {
            dgPhysicsInventoryDtos = this.dgPhysicsInventoryDomain.queryNoBatchList(filter);
            return new PageInfo(dgPhysicsInventoryDtos);
        }
        if (Objects.equals("summary", filter.getType())) {
            dgPhysicsInventoryDtos = this.dgPhysicsInventoryDomain.querySummaryList(filter);
            return new PageInfo(dgPhysicsInventoryDtos);
        }
        dgPhysicsInventoryDtos = this.dgPhysicsInventoryDomain.queryList(filter);
        PageInfo respDtoPageInfo = new PageInfo(dgPhysicsInventoryDtos);
        List<Long> inventoryBatchIdList = Optional.ofNullable(respDtoPageInfo.getList().stream().map(DgPhysicsInventoryDto::getInventoryBatchId).collect(Collectors.toList())).orElse(Arrays.asList(new Long[0]));
        List relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().in(CollectionUtils.isNotEmpty(inventoryBatchIdList), (Object)"inventory_batch_id", inventoryBatchIdList)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        List relInventoryBatchTagDtoList = BeanUtil.copyToList((Collection)relInventoryBatchTagEoList, RelInventoryBatchTagDto.class);
        Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
        List<Object> respDto = Lists.newArrayList();
        List<String> skuCodeList = Optional.ofNullable(dgPhysicsInventoryDtos.stream().map(DgPhysicsInventoryDto::getSkuCode).collect(Collectors.toList())).orElse(Arrays.asList(new String[0]));
        ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
        itemDgReqDto.setSkuCodes(skuCodeList);
        List skuDgEos = this.itemSkuDgDomain.queryList(itemDgReqDto);
        Map<String, DgItemSkuRespVo> itemSkuDgEoMap = this.getItemSkuMap(skuDgEos);
        if (CollectionUtils.isNotEmpty((Collection)dgPhysicsInventoryDtos)) {
            respDto = dgPhysicsInventoryDtos.stream().map(o -> {
                DgItemSkuRespVo itemSkuRespVo;
                DgPhysicsInventoryDto dgPhysicsInventoryDto = new DgPhysicsInventoryDto();
                BeanUtils.copyProperties((Object)o, (Object)dgPhysicsInventoryDto);
                if (relInventoryBatchTagEoMap.containsKey(o.getInventoryBatchId())) {
                    dgPhysicsInventoryDto.setExpiryDateTagList((List)relInventoryBatchTagEoMap.get(o.getInventoryBatchId()));
                }
                if ((itemSkuRespVo = (DgItemSkuRespVo)itemSkuDgEoMap.get(o.getSkuCode())) != null) {
                    o.setSpecModel(itemSkuRespVo.getSpecModel());
                }
                dgPhysicsInventoryDto.setExpired(DgPhysicsInventoryServiceImpl.expiredDay(o.getExpireTime()));
                return dgPhysicsInventoryDto;
            }).collect(Collectors.toList());
        }
        respDtoPageInfo.setList((List)respDto);
        return respDtoPageInfo;
    }

    private Map<String, DgItemSkuRespVo> getItemSkuMap(List<DgItemSkuRespVo> skuDgEos) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(skuDgEos)) {
            return map;
        }
        return skuDgEos.stream().collect(Collectors.toMap(DgItemSkuRespVo::getSkuCode, Function.identity(), (k1, k2) -> k2));
    }

    @Override
    public List<DgPhysicsInventoryDto> queryByList(DgPhysicsInventoryPageReqDto dto) {
        return ((IDgPhysicsInventoryDomain)this.domain).queryList(dto);
    }

    @Override
    public PageInfo<DgLogicInventoryDto> queryAvailableInventoryPage(DgPhysicsInventoryPageReqDto dto) {
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) ? 1 : 0) != 0, (String)"SKU\u7f16\u7801\u548c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        DgPhysicsAvailableInventoryDto availableInventoryDto = ((IDgPhysicsInventoryDomain)this.domain).queryAvailableInventory(dto);
        if (Objects.isNull(availableInventoryDto)) {
            return new PageInfo();
        }
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setPhysicsWarehouseCodes(Arrays.asList(availableInventoryDto.getPhysicsWarehouseCode()));
        logicWarehousePageReqDto.setWarehouseStatus("enable");
        List logicWarehouseDtos = Optional.ofNullable(this.logicWarehouseDomain.queryList(logicWarehousePageReqDto)).orElse(new ArrayList());
        List logicWarehouseCodeList = logicWarehouseDtos.stream().map(DgLogicWarehouseDto::getWarehouseCode).distinct().collect(Collectors.toList());
        DgLogicInventoryListReqDto filter = new DgLogicInventoryListReqDto();
        filter.setLogicWarehouseCodeList(logicWarehouseCodeList);
        filter.setSkuCodeList(Arrays.asList(availableInventoryDto.getSkuCode()));
        filter.setBatchType(Boolean.valueOf(true));
        filter.setPageNum(dto.getPageNum());
        filter.setPageSize(dto.getPageSize());
        PageInfo logicInventoryDtoPageInfo = (PageInfo)Optional.ofNullable(this.logicInventoryService.queryPage(filter).getData()).orElse(new PageInfo());
        List list = logicInventoryDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> o.setWarehouseType(DgWarehouseClassifyEnum.LOGIC.getCode()));
            BigDecimal available = list.stream().map(DgLogicInventoryDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            availableInventoryDto.setAvailable(available);
        }
        return logicInventoryDtoPageInfo;
    }

    @Override
    public DgPhysicsAvailableInventoryDto queryAvailableInventoryList(DgPhysicsInventoryPageReqDto dto) {
        return null;
    }

    private static Integer expiredDay(Date expireTime) {
        if (Objects.isNull(expireTime)) {
            return null;
        }
        int day = DateUtil.getDifferDay((String)DateUtil.format((Date)expireTime), (String)DateUtil.format((Date)new Date()));
        if (day > 0) {
            return 1;
        }
        return 0;
    }
}

