/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.LogicInventorySummaryConverter;
import com.yunxi.dg.base.center.report.dao.mapper.inventory.LogicInventorySummaryMapper;
import com.yunxi.dg.base.center.report.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.report.domain.inventory.ILogicInventorySummaryDomain;
import com.yunxi.dg.base.center.report.dto.inventory.LogicInventorySummaryDto;
import com.yunxi.dg.base.center.report.dto.inventory.LogicInventorySummaryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.RelInventoryBatchTagDto;
import com.yunxi.dg.base.center.report.eo.RelInventoryBatchTagEo;
import com.yunxi.dg.base.center.report.eo.inventory.LogicInventorySummaryEo;
import com.yunxi.dg.base.center.report.service.inventory.ILogicInventorySummaryService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogicInventorySummaryServiceImpl
extends BaseServiceImpl<LogicInventorySummaryDto, LogicInventorySummaryEo, ILogicInventorySummaryDomain>
implements ILogicInventorySummaryService {
    private Logger logger = LoggerFactory.getLogger(LogicInventorySummaryServiceImpl.class);
    @Resource
    private LogicInventorySummaryMapper logicInventorySummaryMapper;
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;

    public LogicInventorySummaryServiceImpl(ILogicInventorySummaryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogicInventorySummaryDto, LogicInventorySummaryEo> converter() {
        return LogicInventorySummaryConverter.INSTANCE;
    }

    @Override
    public void addLogicInventorySummaryData() {
        ((ILogicInventorySummaryDomain)this.domain).deleteAll();
        ((ILogicInventorySummaryDomain)this.domain).insertLogicInventorySummaryList();
    }

    @Override
    public RestResponse<PageInfo<LogicInventorySummaryDto>> page(LogicInventorySummaryPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (Objects.equals(dto.getBatchType(), Boolean.FALSE)) {
            List summaryDtoList = ((ILogicInventorySummaryDomain)this.domain).queryNoBatch(dto);
            return new RestResponse((Object)new PageInfo(summaryDtoList));
        }
        List summaryDtoList = ((ILogicInventorySummaryDomain)this.domain).page(dto);
        if (CollectionUtils.isEmpty((Collection)summaryDtoList)) {
            return new RestResponse((Object)new PageInfo());
        }
        List inventoryBatchIdList = summaryDtoList.stream().map(LogicInventorySummaryDto::getInventoryBatchId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inventoryBatchIdList)) {
            return new RestResponse((Object)new PageInfo(summaryDtoList));
        }
        List relInventoryBatchTagEos = this.iRelInventoryBatchTagDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelInventoryBatchTagEo.class).in(RelInventoryBatchTagEo::getInventoryBatchId, inventoryBatchIdList)).lt(RelInventoryBatchTagEo::getEffectiveTime, (Object)new Date())).ge(RelInventoryBatchTagEo::getFailureTime, (Object)new Date()));
        HashMap<Long, List<RelInventoryBatchTagDto>> map = new HashMap<Long, List<RelInventoryBatchTagDto>>();
        if (CollectionUtils.isNotEmpty((Collection)relInventoryBatchTagEos)) {
            List relInventoryBatchTagDtoList = BeanUtil.copyToList((Collection)relInventoryBatchTagEos, RelInventoryBatchTagDto.class);
            Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
            map.putAll(relInventoryBatchTagEoMap);
        }
        summaryDtoList.forEach(o -> {
            if (map.containsKey(o.getInventoryBatchId())) {
                o.setExpiryDateTagList((List)map.get(o.getInventoryBatchId()));
            }
        });
        return new RestResponse((Object)new PageInfo(summaryDtoList));
    }

    @Override
    public RestResponse<List<LogicInventorySummaryDto>> queryList(LogicInventorySummaryPageReqDto dto) {
        return new RestResponse((Object)((ILogicInventorySummaryDomain)this.domain).page(dto));
    }
}

