/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.entity.TransferOrderConverter;
import com.yunxi.dg.base.center.report.dao.das.IStorageAuditRecordDas;
import com.yunxi.dg.base.center.report.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IInventoryOperateLogDomain;
import com.yunxi.dg.base.center.report.domain.inventory.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.ITransferOrderDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgSimpleAuditRecordDto;
import com.yunxi.dg.base.center.report.dto.inventory.TransferOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.TransferOrderPageDto;
import com.yunxi.dg.base.center.report.dto.inventory.TransferOrderSearchDto;
import com.yunxi.dg.base.center.report.dto.item.ItDirDto;
import com.yunxi.dg.base.center.report.enums.CodeGenEnum;
import com.yunxi.dg.base.center.report.enums.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.report.enums.TransferOrderStatus;
import com.yunxi.dg.base.center.report.enums.TypeOfDocumentEnum;
import com.yunxi.dg.base.center.report.eo.StorageAuditRecordEo;
import com.yunxi.dg.base.center.report.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgInventoryOperateLogEo;
import com.yunxi.dg.base.center.report.eo.inventory.TransferOrderEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.IReportDataSearchService;
import com.yunxi.dg.base.center.report.service.inventory.ITransferOrderService;
import com.yunxi.dg.base.center.report.service.item.IItDirService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TransferOrderServiceImpl
extends BaseServiceImpl<TransferOrderDto, TransferOrderEo, ITransferOrderDomain>
implements ITransferOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderServiceImpl.class);
    String tableName = "cs_transfer_order";
    String tableNameWithDetail = "cs_transfer_order_detail";
    private static final String[] ORDER_NOS = new String[]{"transferOrderNo", "platformOrderNo", "saleOrderNo", "inventoryLogisticsNo", "deliveryNoticeNo"};
    @Resource
    private SearchConfigVo searchConfigVo;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private IStorageAuditRecordDas storageAuditRecordDas;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Resource(name="transferReportDataSearchService")
    private IReportDataSearchService reportDataSearchService;
    @Resource
    private IInventoryOperateLogDomain inventoryOperateLogDomain;
    @Resource
    private IDgDeliveryResultOrderDomain deliveryResultOrderDomain;
    @Resource
    private IDgDeliveryNoticeOrderDomain deliveryNoticeOrderDomain;
    @Resource
    private IItDirService dirService;

    public TransferOrderServiceImpl(ITransferOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<TransferOrderDto, TransferOrderEo> converter() {
        return TransferOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<TransferOrderItemPageDto>> pageByItem(TransferOrderSearchDto dto) {
        PageInfo transferOrderItemPageDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            transferOrderItemPageDtoPageInfo = this.getTransferOrderItemPageDtoEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            transferOrderItemPageDtoPageInfo = new PageInfo(this.transferOrderDetailDomain.selectPageList(dto));
        }
        List itemPageDtoList = transferOrderItemPageDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)itemPageDtoList)) {
            List outPhysicsWarehouseCodeList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getOutPhysicsWarehouseCode).collect(Collectors.toList());
            List inPhysicsWarehouseCodeList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getInPhysicsWarehouseCode).collect(Collectors.toList());
            List outPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(outPhysicsWarehouseCodeList, "physics");
            Map<String, WarehouseAddressEo> outWarehouseEoMap = outPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
            List inPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(inPhysicsWarehouseCodeList, "physics");
            List transferNoList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getTransferOrderNo).collect(Collectors.toList());
            List storageAuditRecordEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.storageAuditRecordDas.filter().in((Object)"order_src_no", transferNoList)).orderByDesc((Object)"create_time")).list();
            Map storageAuditRecordEoMap = storageAuditRecordEoList.stream().collect(Collectors.toMap(StorageAuditRecordEo::getOrderSrcNo, Function.identity(), (o, o1) -> o));
            Map<String, WarehouseAddressEo> inWarehouseEoMap = inPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
            itemPageDtoList.forEach(item -> {
                StorageAuditRecordEo storageAuditRecordEo;
                WarehouseAddressEo in;
                item.setPreOrderNoType(this.getPreOrderNoType(item.getPreOrderNo()));
                this.settingButton((TransferOrderItemPageDto)item);
                WarehouseAddressEo out = (WarehouseAddressEo)outWarehouseEoMap.get(item.getOutPhysicsWarehouseCode());
                if (out != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(out.getProvince());
                    sb.append(out.getCity());
                    sb.append(out.getDistrict());
                    sb.append(out.getDetailAddress());
                    item.setOutPhysicsWarehouseDetailAddress(sb.toString());
                }
                if ((in = (WarehouseAddressEo)inWarehouseEoMap.get(item.getInPhysicsWarehouseCode())) != null) {
                    String sb = in.getProvince() + in.getCity() + in.getDistrict() + in.getDetailAddress();
                    item.setInPhysicsWarehouseDetailAddress(sb);
                }
                if ((storageAuditRecordEo = (StorageAuditRecordEo)storageAuditRecordEoMap.get(item.getTransferOrderNo())) != null) {
                    item.setAuditRemark(storageAuditRecordEo.getRemark());
                }
                BigDecimal inTransitQuantity = BigDecimalUtils.subtract((BigDecimal)item.getDoneOutQuantity(), (BigDecimal)item.getDoneInQuantity());
                item.setInTransitQuantity(inTransitQuantity);
                if (item.getDispatcherLessQuantity() != null && item.getDispatcherLessQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    item.setDispatcherLessQuantity(null);
                }
                if (item.getReceiveDeliveryDifferenceQuantity() != null && item.getReceiveDeliveryDifferenceQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    item.setReceiveDeliveryDifferenceQuantity(null);
                }
            });
        }
        transferOrderItemPageDtoPageInfo.setList(itemPageDtoList);
        return new RestResponse((Object)transferOrderItemPageDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<TransferOrderPageDto>> queryPage(TransferOrderSearchDto dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getOrderNo())) {
            String[] orderNoArr = dto.getOrderNo().split("[ ,\uff0c]");
            if (orderNoArr.length == 1) {
                dto.setOrderNo(dto.getOrderNo().trim());
            } else if (orderNoArr.length > 1) {
                dto.setOrderNo(null);
                dto.setOrderNoList(Arrays.asList(orderNoArr));
            }
        }
        PageInfo transferOrderPageDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            transferOrderPageDtoPageInfo = this.getTransferOrderPageDtoEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            transferOrderPageDtoPageInfo = new PageInfo(((ITransferOrderDomain)this.domain).selectPageList(dto));
        }
        List pageDtoList = transferOrderPageDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)pageDtoList)) {
            ArrayList transferOrderNos = new ArrayList();
            ArrayList physicsWarehouseCodeList = new ArrayList();
            pageDtoList.forEach(e -> {
                physicsWarehouseCodeList.add(e.getOutPhysicsWarehouseCode());
                physicsWarehouseCodeList.add(e.getInPhysicsWarehouseCode());
                transferOrderNos.add(e.getTransferOrderNo());
            });
            List physicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(physicsWarehouseCodeList, "physics");
            Map<String, WarehouseAddressEo> warehouseEoMap = physicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
            List inventoryOperateLogEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryOperateLogDomain.filter().in((Object)"source_no", transferOrderNos)).eq((Object)"change_type", (Object)"intransit")).isNull((Object)"batch")).list();
            Map<String, List<DgInventoryOperateLogEo>> transferOrderMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(DgInventoryOperateLogEo::getSourceNo));
            List auditRecordDtoList = Optional.ofNullable(this.storageAuditRecordDas.selectLastRemarkByOrderNos(transferOrderNos)).orElse(new ArrayList());
            Map<String, String> auditRecordMap = auditRecordDtoList.stream().collect(Collectors.toMap(DgSimpleAuditRecordDto::getOrderSrcNo, e -> Optional.ofNullable(e.getRemark()).orElse(""), (k1, k2) -> k1));
            DgDeliveryResultOrderPageReqDto dgDeliveryResultOrderPageReqDto = new DgDeliveryResultOrderPageReqDto();
            dgDeliveryResultOrderPageReqDto.setRelevanceNoList(transferOrderNos);
            List dgDeliveryResultOrderDtos = Optional.ofNullable(this.deliveryResultOrderDomain.queryList(dgDeliveryResultOrderPageReqDto)).orElse(new ArrayList());
            Map<String, List<DgDeliveryResultOrderDto>> deliverMap = dgDeliveryResultOrderDtos.stream().collect(Collectors.groupingBy(DgDeliveryResultOrderDto::getRelevanceNo));
            DgDeliveryNoticeOrderPageReqDto noticeOrderPageReqDto = new DgDeliveryNoticeOrderPageReqDto();
            noticeOrderPageReqDto.setRelevanceNoList(transferOrderNos);
            noticeOrderPageReqDto.setOrderType("delivery");
            List dgDeliveryNoticeOrderDtos = Optional.ofNullable(this.deliveryNoticeOrderDomain.queryList(noticeOrderPageReqDto)).orElse(new ArrayList());
            Map<String, List<DgDeliveryNoticeOrderDto>> deliveryNoticeMap = dgDeliveryNoticeOrderDtos.stream().collect(Collectors.groupingBy(DgDeliveryNoticeOrderDto::getRelevanceNo));
            pageDtoList.forEach(item -> {
                List deliveryNoticeOrderDtos;
                List deliveryResultOrderDtos;
                WarehouseAddressEo in;
                item.setPreOrderNoType(this.getPreOrderNoType(item.getPreOrderNo()));
                this.settingButton((TransferOrderPageDto)item);
                WarehouseAddressEo out = (WarehouseAddressEo)warehouseEoMap.get(item.getOutPhysicsWarehouseCode());
                if (out != null) {
                    String sb = out.getProvince() + out.getCity() + out.getDistrict() + out.getDetailAddress();
                    item.setOutPhysicsWarehouseDetailAddress(sb);
                }
                if ((in = (WarehouseAddressEo)warehouseEoMap.get(item.getInPhysicsWarehouseCode())) != null) {
                    String sb = in.getProvince() + in.getCity() + in.getDistrict() + in.getDetailAddress();
                    item.setInPhysicsWarehouseDetailAddress(sb);
                }
                String auditRemark = (String)auditRecordMap.get(item.getTransferOrderNo());
                item.setAuditRemark(auditRemark);
                List inventoryOperateLogEos = (List)transferOrderMap.get(item.getTransferOrderNo());
                if (CollectionUtils.isNotEmpty((Collection)inventoryOperateLogEos)) {
                    BigDecimal inTransitQuantity = inventoryOperateLogEos.stream().map(DgInventoryOperateLogEo::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                    item.setInTransitQuantity(inTransitQuantity);
                }
                if (CollectionUtils.isNotEmpty((Collection)(deliveryResultOrderDtos = (List)deliverMap.get(item.getTransferOrderNo())))) {
                    Map<String, String> u9NoMap = deliveryResultOrderDtos.stream().filter(resultOrderDto -> resultOrderDto.getOrderType() != null && resultOrderDto.getU9No() != null).collect(Collectors.toMap(DgDeliveryResultOrderDto::getOrderType, DgDeliveryResultOrderDto::getU9No, (a, b) -> b));
                    item.setInU9No(u9NoMap.get("receive"));
                    item.setOutU9No(u9NoMap.get("delivery"));
                }
                if (CollectionUtils.isNotEmpty((Collection)(deliveryNoticeOrderDtos = (List)deliveryNoticeMap.get(item.getTransferOrderNo())))) {
                    item.setLogisticsOrderNo(deliveryNoticeOrderDtos.stream().map(DgDeliveryNoticeOrderDto::getLogisticsOrderNo).filter(StringUtils::isNotBlank).collect(Collectors.joining(",")));
                }
            });
        }
        transferOrderPageDtoPageInfo.setList(pageDtoList);
        return new RestResponse((Object)transferOrderPageDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<TransferOrderItemPageDto>> queryPageByItem(TransferOrderSearchDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (CollectionUtils.isNotEmpty((Collection)dto.getLastDirIdList())) {
            List<String> skuCodes = this.dirService.querySkuCodeListByDirList(dto.getLastDirIdList());
            if (CollectionUtils.isEmpty(skuCodes)) {
                return new RestResponse();
            }
            List skuCodeList = Optional.ofNullable(dto.getSkuCodeList()).orElse(new ArrayList());
            skuCodeList.addAll(skuCodes);
            dto.setSkuCodeList(skuCodeList);
        }
        PageInfo pageInfo = this.reportDataSearchService.queryList(dto);
        this.wrap(pageInfo.getList());
        return new RestResponse(pageInfo);
    }

    public void wrap(List<TransferOrderItemPageDto> itemPageDtoList) {
        if (CollectionUtils.isEmpty(itemPageDtoList)) {
            return;
        }
        HashSet physicsWarehouseCodeList = new HashSet();
        HashSet orderNos = new HashSet();
        HashSet types = new HashSet();
        HashSet skuCodes = new HashSet();
        itemPageDtoList.forEach(x -> {
            physicsWarehouseCodeList.add(x.getOutPhysicsWarehouseCode());
            physicsWarehouseCodeList.add(x.getInPhysicsWarehouseCode());
            orderNos.add(x.getTransferOrderNo());
            types.add(x.getType());
            skuCodes.add(x.getSkuCode());
        });
        List inPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(new ArrayList(physicsWarehouseCodeList), "physics");
        Map<String, WarehouseAddressEo> warehouseEoMap = inPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
        DgDeliveryResultOrderPageReqDto dgDeliveryResultOrderPageReqDto = new DgDeliveryResultOrderPageReqDto();
        dgDeliveryResultOrderPageReqDto.setRelevanceNoList(new ArrayList(orderNos));
        List dgDeliveryResultOrderDtos = Optional.ofNullable(this.deliveryResultOrderDomain.queryList(dgDeliveryResultOrderPageReqDto)).orElse(new ArrayList());
        Map<String, List<DgDeliveryResultOrderDto>> deliverMap = dgDeliveryResultOrderDtos.stream().collect(Collectors.groupingBy(DgDeliveryResultOrderDto::getRelevanceNo));
        DgDeliveryNoticeOrderPageReqDto noticeOrderPageReqDto = new DgDeliveryNoticeOrderPageReqDto();
        noticeOrderPageReqDto.setRelevanceNoList(new ArrayList(orderNos));
        noticeOrderPageReqDto.setOrderType("delivery");
        List dgDeliveryNoticeOrderDtos = Optional.ofNullable(this.deliveryNoticeOrderDomain.queryList(noticeOrderPageReqDto)).orElse(new ArrayList());
        Map<String, List<DgDeliveryNoticeOrderDto>> deliveryNoticeMap = dgDeliveryNoticeOrderDtos.stream().collect(Collectors.groupingBy(DgDeliveryNoticeOrderDto::getRelevanceNo));
        List storageAuditRecordEos = this.storageAuditRecordDas.latestStorageAuditRecord(new ArrayList(orderNos), new ArrayList(types));
        Map<String, String> key2RemarkMap = storageAuditRecordEos.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getRemark())).collect(Collectors.toMap(x -> x.getOrderSrcNo() + x.getType(), StorageAuditRecordEo::getRemark, (x1, x2) -> x2));
        Map lastDirMap = Optional.ofNullable(this.dirService.queryLastDirBySkuCodes(new ArrayList<String>(skuCodes))).orElse(new HashMap());
        itemPageDtoList.forEach(item -> {
            ItDirDto dirDto;
            List deliveryNoticeOrderDtos;
            List deliveryResultOrderDtos;
            WarehouseAddressEo in;
            item.setPreOrderNoType(this.getPreOrderNoType(item.getPreOrderNo()));
            this.settingButton((TransferOrderItemPageDto)item);
            WarehouseAddressEo out = (WarehouseAddressEo)warehouseEoMap.get(item.getOutPhysicsWarehouseCode());
            if (out != null) {
                String sb = out.getProvince() + out.getCity() + out.getDistrict() + out.getDetailAddress();
                item.setOutPhysicsWarehouseDetailAddress(sb);
            }
            if ((in = (WarehouseAddressEo)warehouseEoMap.get(item.getInPhysicsWarehouseCode())) != null) {
                String sb = in.getProvince() + in.getCity() + in.getDistrict() + in.getDetailAddress();
                item.setInPhysicsWarehouseDetailAddress(sb);
            }
            item.setAuditRemark((String)key2RemarkMap.get(item.getTransferOrderNo() + item.getType()));
            BigDecimal inTransitQuantity = BigDecimalUtils.subtract((BigDecimal)item.getDoneOutQuantity(), (BigDecimal)item.getDoneInQuantity());
            item.setInTransitQuantity(inTransitQuantity);
            if (item.getDispatcherLessQuantity() != null && item.getDispatcherLessQuantity().compareTo(BigDecimal.ZERO) == 0) {
                item.setDispatcherLessQuantity(null);
            }
            if (item.getReceiveDeliveryDifferenceQuantity() != null && item.getReceiveDeliveryDifferenceQuantity().compareTo(BigDecimal.ZERO) == 0) {
                item.setReceiveDeliveryDifferenceQuantity(null);
            }
            if (CollectionUtils.isNotEmpty((Collection)(deliveryResultOrderDtos = (List)deliverMap.get(item.getTransferOrderNo())))) {
                Map<String, String> u9NoMap = deliveryResultOrderDtos.stream().filter(resultOrderDto -> resultOrderDto.getOrderType() != null && resultOrderDto.getU9No() != null).collect(Collectors.toMap(DgDeliveryResultOrderDto::getOrderType, DgDeliveryResultOrderDto::getU9No, (a, b) -> b));
                item.setInU9No(u9NoMap.get("receive"));
                item.setOutU9No(u9NoMap.get("delivery"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(deliveryNoticeOrderDtos = (List)deliveryNoticeMap.get(item.getTransferOrderNo())))) {
                item.setLogisticsOrderNo(deliveryNoticeOrderDtos.stream().map(DgDeliveryNoticeOrderDto::getLogisticsOrderNo).filter(StringUtils::isNotBlank).collect(Collectors.joining(",")));
            }
            if (Objects.nonNull(dirDto = (ItDirDto)lastDirMap.get(item.getSkuCode()))) {
                item.setLastDirId(dirDto.getId());
                item.setLastDirName(dirDto.getName());
            }
        });
    }

    @Nullable
    private String getPreOrderNoType(String preOrderNo) {
        return StringUtils.isNotBlank((CharSequence)preOrderNo) && preOrderNo.contains(CodeGenEnum.DISPATCHER_ORDER.getPrefix()) ? TypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode() : null;
    }

    private void settingButton(TransferOrderPageDto item) {
        if (TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(item.getDeliveryStatus().equals(TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode()) ? 2 : 1));
        } else if (TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(2));
        } else {
            item.setButtonFlag(Integer.valueOf(3));
        }
    }

    private void settingButton(TransferOrderItemPageDto item) {
        if (TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(item.getDeliveryStatus().equals(TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode()) ? 2 : 1));
        } else if (TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(2));
        } else {
            item.setButtonFlag(Integer.valueOf(3));
        }
    }

    private PageInfo<TransferOrderPageDto> getTransferOrderPageDtoEsList(TransferOrderSearchDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List transferOrderPageDtoList = searchResultVo.getDocValues(docValue -> {
                TransferOrderPageDto transferOrderPageDto = (TransferOrderPageDto)BeanUtil.copyProperties((Object)docValue, TransferOrderPageDto.class, (String[])new String[0]);
                return transferOrderPageDto;
            });
            pageInfo.setList(transferOrderPageDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private PageInfo<TransferOrderItemPageDto> getTransferOrderItemPageDtoEsList(TransferOrderSearchDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableNameWithDetail;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initDetailSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List transferOrderItemPageDtoList = searchResultVo.getDocValues(docValue -> {
                TransferOrderItemPageDto orderItemPageDto = (TransferOrderItemPageDto)BeanUtil.copyProperties((Object)docValue, TransferOrderItemPageDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(transferOrderItemPageDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(TransferOrderSearchDto reqDto) throws Exception {
        FilterFieldVo filter;
        FilterFieldVo filter2;
        log.info("ES\u67e5\u8c03\u62e8\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (Objects.nonNull(reqDto.getOrderNo())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCodeList", (List)reqDto.getSkuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSpuCodeList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCodeList", (List)reqDto.getSpuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBatchList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batchList", (List)reqDto.getBatchList())});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (Objects.nonNull(reqDto.getSkuDisplayName())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayNameList", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOutOrganizationIdList())) {
            List outOrganizationIdList = reqDto.getOutOrganizationIdList().stream().map(String::valueOf).collect(Collectors.toList());
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"outOrganizationId", outOrganizationIdList)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInOrganizationIdList())) {
            List inOrganizationIdList = reqDto.getInOrganizationIdList().stream().map(String::valueOf).collect(Collectors.toList());
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"inOrganizationId", inOrganizationIdList)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNoList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)o, (List)reqDto.getBatchList())});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u53c2\u6570\u5c01\u88c5\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private OSSearchVo initDetailSearchVo(TransferOrderSearchDto reqDto) throws Exception {
        FilterFieldVo filter;
        FilterFieldVo filter2;
        log.info("ES\u67e5\u8c03\u62e8\u5355\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (Objects.nonNull(reqDto.getOrderNo())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCode", (List)reqDto.getSkuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSpuCodeList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCode", (List)reqDto.getSpuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBatchList())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batch", (List)reqDto.getBatchList())});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (Objects.nonNull(reqDto.getSkuDisplayName())) {
            filter2 = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter2.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayName", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter2});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOutOrganizationIdList())) {
            List outOrganizationIdList = reqDto.getOutOrganizationIdList().stream().map(String::valueOf).collect(Collectors.toList());
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"outOrganizationId", outOrganizationIdList)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInOrganizationIdList())) {
            List inOrganizationIdList = reqDto.getInOrganizationIdList().stream().map(String::valueOf).collect(Collectors.toList());
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"inOrganizationId", inOrganizationIdList)});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u53c2\u6570\u5c01\u88c5\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

