/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.share;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.share.DgInventoryShareOperateLogConverter;
import com.yunxi.dg.base.center.report.domain.share.IDgInventoryShareOperateLogDomain;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryDictDto;
import com.yunxi.dg.base.center.report.dto.share.DgInventoryShareOperateLogDto;
import com.yunxi.dg.base.center.report.dto.share.DgInventoryShareOperateLogPageReqDto;
import com.yunxi.dg.base.center.report.eo.share.DgInventoryShareOperateLogEo;
import com.yunxi.dg.base.center.report.service.share.IDgInventoryShareOperateLogService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgInventoryShareOperateLogServiceImpl
extends BaseServiceImpl<DgInventoryShareOperateLogDto, DgInventoryShareOperateLogEo, IDgInventoryShareOperateLogDomain>
implements IDgInventoryShareOperateLogService {
    public DgInventoryShareOperateLogServiceImpl(IDgInventoryShareOperateLogDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgInventoryShareOperateLogDto, DgInventoryShareOperateLogEo> converter() {
        return DgInventoryShareOperateLogConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgInventoryShareOperateLogDto>> queryPage(DgInventoryShareOperateLogPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (dto.getInventoryType() == null) {
            dto.setInventoryType(Integer.valueOf(0));
        }
        PageInfo dgInventoryShareOperateLogPage = new PageInfo(((IDgInventoryShareOperateLogDomain)this.domain).queryList(dto));
        Optional.ofNullable(dgInventoryShareOperateLogPage.getList()).filter(CollectionUtils::isNotEmpty).ifPresent(logs -> {
            List types = logs.stream().map(DgInventoryShareOperateLogDto::getBusinessType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            types.addAll(logs.stream().map(DgInventoryShareOperateLogDto::getSourceType).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            InventoryDictDto inventoryDictDto = new InventoryDictDto();
            inventoryDictDto.setBusinessTypeList(types);
            List inventoryDictList = ((IDgInventoryShareOperateLogDomain)this.domain).loadDict(inventoryDictDto);
            Map typeMap = inventoryDictList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBusinessType())).collect(Collectors.toMap(InventoryDictDto::getBusinessType, Function.identity(), (o, o1) -> o));
            Map typeDocumentMap = inventoryDictList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBusinessType())).collect(Collectors.toMap(k -> String.join((CharSequence)"__", k.getDocumentCode(), k.getBusinessType()), Function.identity(), (o, o1) -> o));
            logs.forEach(log -> Optional.ofNullable(typeDocumentMap.getOrDefault(String.join((CharSequence)"__", log.getDocumentCode(), log.getBusinessType()), typeMap.get(ObjectUtils.defaultIfNull((Object)log.getBusinessType(), (Object)log.getSourceType())))).ifPresent(dict -> {
                log.setBusinessType(dict.getBusinessType());
                log.setBusinessTypeName(dict.getBusinessTypeName());
                log.setDocumentCode(dict.getDocumentCode());
                log.setDocumentName(dict.getDocumentName());
            }));
        });
        return new RestResponse((Object)dgInventoryShareOperateLogPage);
    }

    @Override
    public RestResponse<List<DgInventoryShareOperateLogDto>> queryList(DgInventoryShareOperateLogPageReqDto dto) {
        return new RestResponse((Object)((IDgInventoryShareOperateLogDomain)this.domain).queryList(dto));
    }
}

