/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.share;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.share.DgVirtualInventoryConverter;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualInventoryDomain;
import com.yunxi.dg.base.center.report.dto.share.DgInventoryQueryReqDto;
import com.yunxi.dg.base.center.report.dto.share.DgInventorySummaryRespDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryPageReqDto;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualInventoryEo;
import com.yunxi.dg.base.center.report.service.share.IDgVirtualInventoryService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class DgVirtualInventoryServiceImpl
extends BaseServiceImpl<DgVirtualInventoryDto, DgVirtualInventoryEo, IDgVirtualInventoryDomain>
implements IDgVirtualInventoryService {
    public DgVirtualInventoryServiceImpl(IDgVirtualInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgVirtualInventoryDto, DgVirtualInventoryEo> converter() {
        return DgVirtualInventoryConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgVirtualInventoryDto>> queryPage(DgVirtualInventoryPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (dto.getInventoryType() == null) {
            dto.setInventoryType(Integer.valueOf(0));
        }
        PageInfo pageInfo = new PageInfo(((IDgVirtualInventoryDomain)this.domain).queryList(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgVirtualInventoryDto>> queryList(DgVirtualInventoryPageReqDto dto) {
        if (dto.getInventoryType() == null) {
            dto.setInventoryType(Integer.valueOf(0));
        }
        return new RestResponse((Object)((IDgVirtualInventoryDomain)this.domain).queryList(dto));
    }

    @Override
    public DgInventorySummaryRespDto querySummary(DgInventoryQueryReqDto virtualInventoryQueryReqDto) {
        return ((IDgVirtualInventoryDomain)this.domain).querySummary(virtualInventoryQueryReqDto);
    }

    private static Integer expiredDay(Date expireTime) {
        if (Objects.isNull(expireTime)) {
            return null;
        }
        int day = DateUtil.getDifferDay((String)DateUtil.format((Date)expireTime), (String)DateUtil.format((Date)new Date()));
        if (day > 0) {
            return 1;
        }
        return 0;
    }
}

