/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.item.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.report.domain.item.IItDirDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.dto.item.ItDirDto;
import com.yunxi.dg.base.center.report.eo.item.ItDirEo;
import com.yunxi.dg.base.center.report.service.item.IItDirService;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItDirServiceImpl
extends BaseServiceImpl<ItDirDto, ItDirEo, IItDirDomain>
implements IItDirService {
    private static final Logger log = LoggerFactory.getLogger(ItDirServiceImpl.class);
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;

    public ItDirServiceImpl(IItDirDomain domain) {
        super((IBaseDomain)domain);
    }

    @Override
    public Map<String, ItDirDto> queryLastDirBySkuCodes(List<String> skuCodes) {
        HashMap<String, ItDirDto> map = new HashMap<String, ItDirDto>();
        if (CollectionUtils.isEmpty(skuCodes)) {
            return map;
        }
        List skuDgEos = this.itemSkuDgDomain.selectByCodes(skuCodes);
        if (CollectionUtils.isEmpty((Collection)skuDgEos)) {
            return map;
        }
        HashSet ids = new HashSet();
        HashMap lastDirIdMap = new HashMap();
        skuDgEos.forEach(e -> {
            Long id = null;
            if (Objects.nonNull(e.getDirId3())) {
                id = e.getDirId3();
            }
            if (Objects.isNull(id) && Objects.nonNull(e.getDirId2())) {
                id = e.getDirId2();
            }
            if (Objects.isNull(id) && Objects.nonNull(e.getDirId())) {
                id = e.getDirId();
            }
            ids.add(id);
            List skuCodeList = Optional.ofNullable(lastDirIdMap.get(id)).orElse(new ArrayList());
            skuCodeList.add(e.getCode());
            lastDirIdMap.put(id, skuCodeList);
        });
        List itDirEos = ((ExtQueryChainWrapper)((IItDirDomain)this.domain).filter().in((Object)"id", ids)).list();
        if (CollectionUtils.isNotEmpty((Collection)itDirEos)) {
            itDirEos.forEach(e -> {
                List skuCodeList = (List)lastDirIdMap.get(e.getId());
                if (CollectionUtils.isNotEmpty((Collection)skuCodeList)) {
                    ItDirDto dto = new ItDirDto();
                    CubeBeanUtils.copyProperties((Object)dto, (Object)e, (String[])new String[0]);
                    skuCodeList.forEach(skuCode -> map.put((String)skuCode, dto));
                }
            });
        }
        return map;
    }

    @Override
    public List<String> querySkuCodeListByDirList(List<Long> dirList) {
        List<String> skuCodeList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(dirList)) {
            return skuCodeList;
        }
        List skuDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"dir_id", dirList)).or()).in((Object)"dir_id2", dirList)).or()).in((Object)"dir_id3", dirList)).list(Integer.valueOf(2000));
        if (CollectionUtils.isNotEmpty((Collection)skuDgEos)) {
            skuCodeList = skuDgEos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCode())).map(e -> e.getCode()).distinct().collect(Collectors.toList());
        }
        return skuCodeList;
    }
}

