/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.utils;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.report.annotations.ItemSkuCodeFlagAnnotation;
import com.yunxi.dg.base.center.report.constants.ItemSkuCodeFlagAnnotationType;
import com.yunxi.dg.base.center.report.dao.das.IUnitDgDas;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgLogicInventoryDas;
import com.yunxi.dg.base.center.report.dto.item.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.report.dto.item.DgItemSkuRespDto;
import com.yunxi.dg.base.center.report.dto.item.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.report.dto.item.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.report.dto.item.ItemUnitConversionDto;
import com.yunxi.dg.base.center.report.eo.UnitDgEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicInventoryEo;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgReportService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItemUnitConversionUtils {
    @Resource
    private IUnitDgDas unitDgDas;
    @Resource
    private IItemSkuDgReportService itemSkuDgReportService;
    @Resource
    private IDgLogicInventoryDas logicInventoryDas;

    public void queryItemUnitConversion(List<? extends ItemUnitConversionDto> list, Class<?> targetClazz) {
        Field[] fields = targetClazz.getDeclaredFields();
        String skuCode = "skuCode";
        String warehouseCode = "warehouseCode";
        String batch = "batch";
        String inventoryProperty = "inventoryProperty";
        String saleUnit = "saleUnit";
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ItemSkuCodeFlagAnnotation.class)) continue;
            ItemSkuCodeFlagAnnotation annotation = field.getAnnotation(ItemSkuCodeFlagAnnotation.class);
            String vale = annotation.vale();
            if (vale.equals(ItemSkuCodeFlagAnnotationType.SKU_CODE.getType())) {
                skuCode = field.getName();
                continue;
            }
            if (vale.equals(ItemSkuCodeFlagAnnotationType.WAREHOUSE_CODE.getType())) {
                warehouseCode = field.getName();
                continue;
            }
            if (vale.equals(ItemSkuCodeFlagAnnotationType.BATCH.getType())) {
                batch = field.getName();
                continue;
            }
            if (vale.equals(ItemSkuCodeFlagAnnotationType.INVENTORY_PROPERTY.getType())) {
                inventoryProperty = field.getName();
                continue;
            }
            if (!vale.equals(ItemSkuCodeFlagAnnotationType.SALE_UNIT.getType())) continue;
            saleUnit = field.getName();
        }
        HashSet skuCodeSet = new HashSet();
        HashSet warehouseCodeSet = new HashSet();
        HashSet batchSet = new HashSet();
        HashSet inventoryPropertySet = new HashSet();
        HashSet saleUnitSet = new HashSet();
        String finalSkuCode = skuCode;
        String finalWarehouseCode = warehouseCode;
        String finalBatch = batch;
        String finalInventoryProperty = inventoryProperty;
        String finalSaleUnit = saleUnit;
        list.forEach(info -> {
            String string = JSON.toJSONString((Object)info);
            JSONObject jsonObject = JSON.parseObject((String)string);
            String skuCodeStr = jsonObject.getOrDefault((Object)finalSkuCode, (Object)"").toString();
            String warehouseCodeStr = jsonObject.getOrDefault((Object)finalWarehouseCode, (Object)"").toString();
            String batchStr = jsonObject.getOrDefault((Object)finalBatch, (Object)"").toString();
            String finalInventoryPropertyStr = jsonObject.getOrDefault((Object)finalInventoryProperty, (Object)"").toString();
            String saleUnitStr = jsonObject.getOrDefault((Object)finalSaleUnit, (Object)"").toString();
            if (StringUtils.isNotBlank((CharSequence)skuCodeStr)) {
                skuCodeSet.add(skuCodeStr);
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseCodeStr)) {
                warehouseCodeSet.add(warehouseCodeStr);
            }
            if (StringUtils.isNotBlank((CharSequence)batchStr)) {
                batchSet.add(batchStr);
            }
            if (StringUtils.isNotBlank((CharSequence)finalInventoryPropertyStr)) {
                inventoryPropertySet.add(finalInventoryPropertyStr);
            }
            if (StringUtils.isNotBlank((CharSequence)saleUnitStr)) {
                saleUnitSet.add(saleUnitStr);
            }
        });
        ArrayList<String> skuCodeList = new ArrayList<String>(skuCodeSet);
        ArrayList<String> warehouseCodeList = new ArrayList<String>(warehouseCodeSet);
        ArrayList<String> batchList = new ArrayList<String>(batchSet);
        ArrayList<String> inventoryPropertyList = new ArrayList<String>(inventoryPropertySet);
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
            itemQueryDgReqDto.setSkuCodes(skuCodeList);
            List<DgItemSkuDetailRespDto> itemSkuDetailList = this.itemSkuDgReportService.querySkuList(itemQueryDgReqDto);
            Map<String, DgItemSkuDetailRespDto> skuMap = ((List)Optional.ofNullable(itemSkuDetailList).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v1));
            List basicUnitList = ((List)Optional.ofNullable(itemSkuDetailList).orElse(new ArrayList())).stream().map(DgItemSkuRespDto::getUnit).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            List saleUnitList = ((List)Optional.ofNullable(itemSkuDetailList).orElse(new ArrayList())).stream().map(DgItemSkuRespDto::getSaleUnit).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            saleUnitSet.addAll(basicUnitList);
            saleUnitSet.addAll(saleUnitList);
            Map<String, UnitDgEo> unitMap = this.queryUnitInfo(new ArrayList<String>(saleUnitSet));
            Map<String, DgLogicInventoryEo> logicInventoryEoMap = this.queryItemInventory(skuCodeList, warehouseCodeList, batchList, inventoryPropertyList);
            this.pageInitItemInfo(finalSkuCode, finalWarehouseCode, finalBatch, finalInventoryProperty, saleUnit, list, skuMap, unitMap, logicInventoryEoMap);
        }
    }

    public Map<String, UnitDgEo> queryUnitInfo(List<String> unitList) {
        if (CollectionUtils.isNotEmpty(unitList)) {
            List code = ((ExtQueryChainWrapper)this.unitDgDas.filter().in((Object)"code", unitList)).list();
            return ((List)Optional.ofNullable(code).orElse(new ArrayList())).stream().collect(Collectors.toMap(UnitDgEo::getCode, Function.identity(), (v1, v2) -> v2));
        }
        return new HashMap<String, UnitDgEo>();
    }

    public void pageInitItemInfo(String finalSkuCode, String finalWarehouseCode, String finalBatch, String finalInventoryProperty, String finalSaleUnit, List<? extends ItemUnitConversionDto> list, Map<String, DgItemSkuDetailRespDto> skuMap, Map<String, UnitDgEo> unitMap, Map<String, DgLogicInventoryEo> logicInventoryEoMap) {
        list.forEach(info -> {
            String string = JSON.toJSONString((Object)info);
            JSONObject jsonObject = JSON.parseObject((String)string);
            String skuCodeStr = jsonObject.getOrDefault((Object)finalSkuCode, (Object)"").toString();
            String warehouseCodeStr = jsonObject.getOrDefault((Object)finalWarehouseCode, (Object)"").toString();
            String batchStr = jsonObject.getOrDefault((Object)finalBatch, (Object)"").toString();
            String inventoryPropertyStr = jsonObject.getOrDefault((Object)finalInventoryProperty, (Object)"").toString();
            String finalSaleUnitStr = jsonObject.getOrDefault((Object)finalSaleUnit, (Object)"").toString();
            if (StringUtils.isNotBlank((CharSequence)skuCodeStr) && skuMap.containsKey(skuCodeStr)) {
                String key;
                UnitDgEo unitDgEo;
                DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)skuMap.get(skuCodeStr);
                info.setItemCode(dgItemSkuDetailRespDto.getItemCode());
                info.setItemName(dgItemSkuDetailRespDto.getItemName());
                info.setSpecification(null != dgItemSkuDetailRespDto.getSpecOne() ? dgItemSkuDetailRespDto.getSpecOne() : dgItemSkuDetailRespDto.getSpecTwo());
                info.setSpuCode(dgItemSkuDetailRespDto.getItemCode());
                info.setSpuName(dgItemSkuDetailRespDto.getItemName());
                info.setSkuDisplayName(dgItemSkuDetailRespDto.getSkuDisplayName());
                info.setStorageCondition(dgItemSkuDetailRespDto.getStorage());
                if (unitMap.containsKey(dgItemSkuDetailRespDto.getUnit())) {
                    unitDgEo = (UnitDgEo)unitMap.get(dgItemSkuDetailRespDto.getUnit());
                    info.setBasicDecimalLimit(unitDgEo.getDecimalLimit());
                    info.setBasicUnitName(unitDgEo.getName());
                }
                info.setBasicUnit(dgItemSkuDetailRespDto.getUnit());
                info.setBasicVolume(this.volumeConvert(dgItemSkuDetailRespDto.getVolume(), dgItemSkuDetailRespDto.getVolumeUnit()));
                info.setBasicWeight(this.weightConvert(dgItemSkuDetailRespDto.getGrossWeight(), dgItemSkuDetailRespDto.getGrossWeightUnit()));
                if (StringUtils.isNotBlank((CharSequence)finalSaleUnitStr)) {
                    info.setSaleUnit(finalSaleUnitStr);
                } else {
                    info.setSaleUnit(null != dgItemSkuDetailRespDto.getSaleUnit() ? dgItemSkuDetailRespDto.getSaleUnit() : dgItemSkuDetailRespDto.getUnit());
                }
                if (unitMap.containsKey(info.getSaleUnit())) {
                    unitDgEo = (UnitDgEo)unitMap.get(info.getSaleUnit());
                    info.setSaleUnitName(unitDgEo.getName());
                    info.setSaleUnitDecimalLimit(unitDgEo.getDecimalLimit());
                }
                List unitConvertList = dgItemSkuDetailRespDto.getUnitConvertList();
                Map conversionMap = ((List)Optional.ofNullable(unitConvertList).orElse(new ArrayList())).stream().collect(Collectors.toMap(x -> x.getBaseUnit() + "_" + x.getConversionUnit(), Function.identity(), (v1, v2) -> v1));
                if (null != info.getBasicUnit() && info.getBasicUnit().equals(info.getSaleUnit())) {
                    info.setSaleUnitExchangeRatio(BigDecimal.ONE);
                    info.setSaleUnitVolume(info.getBasicVolume());
                    info.setSaleUnitWeight(info.getBasicWeight());
                } else if (conversionMap.containsKey(info.getBasicUnit() + "_" + info.getSaleUnit())) {
                    ItemUnitConversionDgDto itemUnitConversionDgDto = (ItemUnitConversionDgDto)conversionMap.get(info.getBasicUnit() + "_" + info.getSaleUnit());
                    if (null != itemUnitConversionDgDto.getBaseUnitNum() && null != itemUnitConversionDgDto.getConversionNum()) {
                        info.setSaleUnitExchangeRatio(new BigDecimal(itemUnitConversionDgDto.getConversionNum()).divide(new BigDecimal(itemUnitConversionDgDto.getBaseUnitNum()), 2, RoundingMode.HALF_UP));
                    }
                    info.setSaleUnitVolume(this.volumeConvert(itemUnitConversionDgDto.getVolume(), itemUnitConversionDgDto.getVolumeUnit()));
                    info.setSaleUnitWeight(this.weightConvert(itemUnitConversionDgDto.getGrossWeight(), itemUnitConversionDgDto.getWeightUnit()));
                }
                info.setQuality(dgItemSkuDetailRespDto.getQuality());
                info.setQualityUnit(dgItemSkuDetailRespDto.getQualityUnit());
                if (StringUtils.isNotBlank((CharSequence)finalWarehouseCode) && StringUtils.isNotBlank((CharSequence)finalBatch) && logicInventoryEoMap.containsKey(key = skuCodeStr + "_" + warehouseCodeStr + "_" + batchStr + "_" + inventoryPropertyStr)) {
                    DgLogicInventoryEo dgLogicInventoryEo = (DgLogicInventoryEo)logicInventoryEoMap.get(key);
                    info.setSaleUnitAvailable(null != dgLogicInventoryEo.getAvailable() && null != info.getSaleUnitExchangeRatio() ? dgLogicInventoryEo.getAvailable().divide(info.getSaleUnitExchangeRatio(), 6, 4) : dgLogicInventoryEo.getAvailable());
                    info.setSaleUnitBalance(null != dgLogicInventoryEo.getBalance() && null != info.getSaleUnitExchangeRatio() ? dgLogicInventoryEo.getBalance().divide(info.getSaleUnitExchangeRatio(), 6, 4) : dgLogicInventoryEo.getBalance());
                    info.setRowId(dgLogicInventoryEo.getSkuCode() + dgLogicInventoryEo.getBatch() + dgLogicInventoryEo.getInventoryProperty());
                }
            }
        });
    }

    public Map<String, DgLogicInventoryEo> queryItemInventory(List<String> skuCodeList, List<String> warehouseCodeList, List<String> batchList, List<String> inventoryPropertyList) {
        if (CollectionUtils.isNotEmpty(warehouseCodeList) && CollectionUtils.isNotEmpty(batchList)) {
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDas.filter().in((Object)"sku_code", skuCodeList)).in((Object)"warehouse_code", warehouseCodeList)).in((Object)"batch", batchList)).in((Object)"inventory_property", inventoryPropertyList)).list();
            return ((List)Optional.ofNullable(list).orElse(new ArrayList())).stream().collect(Collectors.toMap(x -> x.getSkuCode() + "_" + x.getWarehouseCode() + "_" + x.getBatch() + "_" + x.getInventoryProperty(), Function.identity(), (v1, v2) -> v1));
        }
        return new HashMap<String, DgLogicInventoryEo>();
    }

    public BigDecimal volumeConvert(BigDecimal volume, String volumeUnit) {
        if (null != volume && null != volumeUnit) {
            BigDecimal volumeValue = BigDecimal.ZERO;
            switch (volumeUnit) {
                case "mm3": {
                    volumeValue = volume.movePointLeft(9);
                    break;
                }
                case "cm3": {
                    volumeValue = volume.movePointLeft(6);
                    break;
                }
                case "dm3": {
                    volumeValue = volume.movePointLeft(3);
                    break;
                }
                case "m3": {
                    volumeValue = volume;
                    break;
                }
                case "km3": {
                    volumeValue = volume.movePointRight(3);
                    break;
                }
                default: {
                    volumeValue = volume;
                }
            }
            return volumeValue;
        }
        return volume;
    }

    public BigDecimal weightConvert(BigDecimal weight, String weightUnit) {
        if (null != weight && null != weightUnit) {
            BigDecimal weightValue = BigDecimal.ZERO;
            switch (weightUnit) {
                case "mg": {
                    weightValue = weight.movePointLeft(6);
                    break;
                }
                case "g": {
                    weightValue = weight.movePointLeft(3);
                    break;
                }
                case "kg": {
                    weightValue = weight;
                    break;
                }
                case "t": {
                    weightValue = weight.movePointRight(3);
                    break;
                }
                default: {
                    weightValue = weight;
                }
            }
            return weightValue;
        }
        return weight;
    }
}

