/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.account.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.AccountTransferConverter;
import com.yunxi.dg.base.center.report.dao.das.account.IAccountTransferDas;
import com.yunxi.dg.base.center.report.domain.account.IAccountTransferDomain;
import com.yunxi.dg.base.center.report.dto.account.constant.AccountTransferDto;
import com.yunxi.dg.base.center.report.dto.account.constant.AccountTransferPageReqDto;
import com.yunxi.dg.base.center.report.dto.account.constant.AccountTransferStatusEnum;
import com.yunxi.dg.base.center.report.eo.account.AccountTransferEo;
import com.yunxi.dg.base.center.report.service.account.IAccountTransferService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AccountTransferServiceImpl
extends BaseServiceImpl<AccountTransferDto, AccountTransferEo, IAccountTransferDomain>
implements IAccountTransferService {
    @Resource
    private IAccountTransferDas das;

    public AccountTransferServiceImpl(IAccountTransferDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AccountTransferDto, AccountTransferEo> converter() {
        return AccountTransferConverter.INSTANCE;
    }

    @Override
    public PageInfo<AccountTransferDto> queryPage(AccountTransferPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo resPageInfo = new PageInfo(this.das.queryAccountTransferList(dto));
        PageHelper.clearPage();
        if (Objects.nonNull(resPageInfo) && CollectionUtils.isNotEmpty((Collection)resPageInfo.getList())) {
            resPageInfo.getList().forEach(b -> b.setStatusName(AccountTransferStatusEnum.getNameByCode((Integer)b.getStatus())));
        }
        return resPageInfo;
    }

    @Override
    public BigDecimal queryTransferAccountTotal(AccountTransferPageReqDto dto) {
        return this.das.queryTransferAccountTotal(dto);
    }
}

