/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.erp.dto.erp.ErpSyncItemPriceDto;
import com.yunxi.dg.base.center.erp.dto.item.ErpItemPriceRequestDto;
import com.yunxi.dg.base.center.erp.proxy.IExternalItemErpApiProxy;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.report.convert.entity.EnterpriceCrossPriceConverter;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossPriceDomain;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPriceDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPricePageReqDto;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossPriceEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossPriceService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EnterpriceCrossPriceServiceImpl
extends BaseServiceImpl<EnterpriceCrossPriceDto, EnterpriceCrossPriceEo, IEnterpriceCrossPriceDomain>
implements IEnterpriceCrossPriceService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossPriceServiceImpl.class);
    @Resource
    private IExternalItemErpApiProxy externalItemErpApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private IContext context;

    public EnterpriceCrossPriceServiceImpl(IEnterpriceCrossPriceDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<EnterpriceCrossPriceDto, EnterpriceCrossPriceEo> converter() {
        return EnterpriceCrossPriceConverter.INSTANCE;
    }

    @Override
    public PageInfo<EnterpriceCrossPriceDto> queryPage(EnterpriceCrossPricePageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IEnterpriceCrossPriceDomain)this.domain).queryList(dto));
    }

    @Override
    public void syncPrice() {
        ErpItemPriceRequestDto dto = new ErpItemPriceRequestDto();
        dto.setItemCode("");
        RestResponse resp = this.externalItemErpApiProxy.syncItemPrice(dto);
        if (!resp.isSuccess() || CollUtil.isEmpty((Collection)((Collection)resp.getData()))) {
            log.info("=========\u83b7\u53d6\u516c\u53f8\u95f4\u4ea4\u6613\u4ef7\u683c\u8868\u5931\u8d25\uff0c {}", (Object)JSONUtil.toJsonStr((Object)resp));
            return;
        }
        List skuCodes = ((List)resp.getData()).stream().map(ErpSyncItemPriceDto::getItemCode).collect(Collectors.toList());
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2sku\u4fe1\u606f json {}", (Object)JSONUtil.toJsonStr(skuCodes));
        RestResponse queryBySkuCodeRsp = this.iItemSkuDgQueryApiProxy.queryBySkuCode(skuCodes);
        if (!queryBySkuCodeRsp.isSuccess() || CollUtil.isEmpty((Collection)((Collection)queryBySkuCodeRsp.getData()))) {
            log.info("=========\u83b7\u53d6\u516c\u53f8\u95f4\u4ea4\u6613\u4ef7\u683c\u8868\u5931\u8d25\uff0c\u4ece\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6sku\u4fe1\u606f\u5931\u8d25 {}", (Object)JSONUtil.toJsonStr((Object)queryBySkuCodeRsp));
            return;
        }
        Map<String, Long> codeToIdMap = ((List)queryBySkuCodeRsp.getData()).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getId));
        ((IEnterpriceCrossPriceDomain)this.domain).logicDelete((BaseEo)new EnterpriceCrossPriceEo());
        ArrayList<EnterpriceCrossPriceEo> insertList = new ArrayList<EnterpriceCrossPriceEo>();
        for (ErpSyncItemPriceDto datum : (List)resp.getData()) {
            EnterpriceCrossPriceEo eo = new EnterpriceCrossPriceEo();
            eo.setSkuId(codeToIdMap.get(datum.getItemCode()));
            eo.setSkuCode(datum.getItemCode());
            eo.setPrice(new BigDecimal(datum.getPriceIncluTax()));
            eo.setEffectiveTime(datum.getEffectiveDateFrom());
            eo.setExpirationTime(datum.getEffectiveDateTo());
            eo.setTenantId(this.context.tenantId());
            eo.setInstanceId(this.context.instanceId());
            eo.setCreatePerson(this.context.userName());
            eo.setCreateTime(new Date());
            eo.setUpdatePerson(this.context.userName());
            eo.setUpdateTime(new Date());
            insertList.add(eo);
        }
        ((IEnterpriceCrossPriceDomain)this.domain).insertBatch(insertList);
    }
}

